/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.operations.GetOperationContext;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ObjectPartList651;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.Request;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;

public class GetAll651
extends BaseCommand {
    private static final GetAll651 singleton = new GetAll651();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keysPart = null;
        String regionName = null;
        Object[] keys = null;
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        regionNamePart = clientMessage.getPart(0);
        regionName = regionNamePart.getString();
        keysPart = clientMessage.getPart(1);
        try {
            keys = (Object[])keysPart.getObject();
        }
        catch (Exception e) {
            GetAll651.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(serverConnection.getName()).append(": Received getAll request (").append(clientMessage.getPayloadLength()).append(" bytes) from ").append(serverConnection.getSocketString()).append(" for region ").append(regionName).append(" keys ");
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    buffer.append(keys[i]).append(" ");
                }
            } else {
                buffer.append("NULL");
            }
            logger.debug(buffer.toString());
        }
        if (regionName == null) {
            String message = null;
            message = LocalizedStrings.GetAll_THE_INPUT_REGION_NAME_FOR_THE_GETALL_REQUEST_IS_NULL.toLocalizedString();
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            GetAll651.writeChunkedErrorResponse(clientMessage, 58, message, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = " was not found during getAll request";
            GetAll651.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        chunkedResponseMsg.setMessageType(1);
        chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
        chunkedResponseMsg.sendHeader();
        try {
            this.fillAndSendGetAllResponseChunks(region, regionName, keys, serverConnection, securityService);
            serverConnection.setAsTrue(1);
        }
        catch (Exception e) {
            GetAll651.checkForInterrupt(serverConnection, e);
            GetAll651.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
    }

    private void fillAndSendGetAllResponseChunks(Region region, String regionName, Object[] keys, ServerConnection servConn, SecurityService securityService) throws IOException {
        int numKeys;
        Iterator allKeysIter;
        if (keys != null) {
            allKeysIter = null;
            numKeys = keys.length;
        } else {
            Set allKeys = region.keySet();
            allKeysIter = allKeys.iterator();
            numKeys = allKeys.size();
        }
        ObjectPartList651 values = this.getObjectPartsList(keys == null);
        AuthorizeRequest authzRequest = servConn.getAuthzRequest();
        AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
        Request request = (Request)Request.getCommand();
        Object[] valueAndIsObject = new Object[3];
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (int i = 0; i < numKeys; ++i) {
            boolean isObject;
            Object value;
            Object key;
            boolean keyNotPresent;
            block18: {
                GetOperationContext getContext;
                block17: {
                    if (values.size() == MAXIMUM_CHUNK_SIZE) {
                        GetAll651.sendGetAllResponseChunk(region, values, false, servConn);
                        values.clear();
                    }
                    keyNotPresent = false;
                    key = keys != null ? keys[i] : allKeysIter.next();
                    if (isDebugEnabled) {
                        logger.debug("{}: Getting value for key={}", (Object)servConn.getName(), key);
                    }
                    getContext = null;
                    if (authzRequest != null) {
                        try {
                            getContext = authzRequest.getAuthorize(regionName, key, null);
                            if (!isDebugEnabled) break block17;
                            logger.debug("{}: Passed GET pre-authorization for key={}", (Object)servConn.getName(), key);
                        }
                        catch (NotAuthorizedException ex) {
                            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GetAll_0_CAUGHT_THE_FOLLOWING_EXCEPTION_ATTEMPTING_TO_GET_VALUE_FOR_KEY_1, new Object[]{servConn.getName(), key}), (Throwable)ex);
                            values.addExceptionPart(key, ex);
                            continue;
                        }
                    }
                }
                try {
                    securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key.toString());
                }
                catch (NotAuthorizedException ex) {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GetAll_0_CAUGHT_THE_FOLLOWING_EXCEPTION_ATTEMPTING_TO_GET_VALUE_FOR_KEY_1, new Object[]{servConn.getName(), key}), (Throwable)ex);
                    values.addExceptionPart(key, ex);
                    continue;
                }
                request.getValueAndIsObject(region, key, null, servConn, valueAndIsObject);
                value = valueAndIsObject[0];
                isObject = (Boolean)valueAndIsObject[1];
                keyNotPresent = (Boolean)valueAndIsObject[2];
                if (isDebugEnabled) {
                    logger.debug("{}: Retrieved value for key={}: {}", (Object)servConn.getName(), key, value);
                }
                if (postAuthzRequest != null) {
                    try {
                        getContext = postAuthzRequest.getAuthorize(regionName, key, value, isObject, getContext);
                        byte[] serializedValue = getContext.getSerializedValue();
                        value = serializedValue == null ? getContext.getObject() : (Object)serializedValue;
                        isObject = getContext.isObject();
                        if (!isDebugEnabled) break block18;
                        logger.debug("{}: Passed GET post-authorization for key={}: {}", (Object)servConn.getName(), key, value);
                    }
                    catch (NotAuthorizedException ex) {
                        logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GetAll_0_CAUGHT_THE_FOLLOWING_EXCEPTION_ATTEMPTING_TO_GET_VALUE_FOR_KEY_1, new Object[]{servConn.getName(), key}), (Throwable)ex);
                        values.addExceptionPart(key, ex);
                        continue;
                    }
                }
            }
            value = securityService.postProcess(regionName, key, value, isObject);
            if (isDebugEnabled) {
                logger.debug("{}: Returning value for key={}: {}", (Object)servConn.getName(), key, value);
            }
            if (keyNotPresent) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: key={} is not present on server.", (Object)servConn.getName(), key);
                }
                values.addObjectPartForAbsentKey(key, value);
                continue;
            }
            values.addObjectPart(key, value, isObject, null);
        }
        GetAll651.sendGetAllResponseChunk(region, values, true, servConn);
        servConn.setAsTrue(1);
    }

    protected ObjectPartList651 getObjectPartsList(boolean includeKeys) {
        ObjectPartList651 values = new ObjectPartList651(MAXIMUM_CHUNK_SIZE, includeKeys);
        return values;
    }

    private static void sendGetAllResponseChunk(Region region, ObjectPartList651 list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} getAll response chunk for region={} values={} chunk=<{}>", (Object)servConn.getName(), (Object)(lastChunk ? " last " : " "), (Object)region.getFullPath(), (Object)list, (Object)chunkedResponseMsg);
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

