/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.operations.DestroyOperationContext;
import org.apache.geode.cache.operations.RegionDestroyOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.ResourcePermission;

public class Destroy
extends BaseCommand {
    private static final Destroy singleton = new Destroy();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long startparam) throws IOException, InterruptedException {
        long start = startparam;
        Part regionNamePart = null;
        Part keyPart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key = null;
        Part eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadDestroyRequestTime(start - oldStart);
        regionNamePart = clientMessage.getPart(0);
        keyPart = clientMessage.getPart(1);
        eventPart = clientMessage.getPart(2);
        if (clientMessage.getNumberOfParts() > 3) {
            callbackArgPart = clientMessage.getPart(3);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Destroy.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Destroy.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received destroy request ({} bytes) from {} for region {} key {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key);
        }
        if (key == null || regionName == null) {
            if (key == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL, serverConnection.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            if (regionName == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL, serverConnection.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            Destroy.writeErrorResponse(clientMessage, 10, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = LocalizedStrings.Destroy__0_WAS_NOT_FOUND_DURING_DESTROY_REQUEST.toLocalizedString(regionName);
            Destroy.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key.toString());
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    RegionDestroyOperationContext destroyContext = authzRequest.destroyRegionAuthorize((String)key, callbackArg);
                    callbackArg = destroyContext.getCallbackArg();
                } else {
                    DestroyOperationContext destroyContext = authzRequest.destroyAuthorize(regionName, key, callbackArg);
                    callbackArg = destroyContext.getCallbackArg();
                }
            }
            region.basicBridgeDestroy(key, callbackArg, serverConnection.getProxyID(), true, new EventIDHolder(eventId));
            serverConnection.setModificationInfo(true, regionName, key);
        }
        catch (EntryNotFoundException e) {
            logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Destroy_0_DURING_ENTRY_DESTROY_NO_ENTRY_WAS_FOUND_FOR_KEY_1, new Object[]{serverConnection.getName(), key}));
        }
        catch (RegionDestroyedException rde) {
            Destroy.writeException(clientMessage, rde, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        catch (Exception e) {
            Destroy.checkForInterrupt(serverConnection, e);
            Destroy.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            if (e instanceof GemFireSecurityException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Unexpected Security exception", (Object)serverConnection.getName(), (Object)e);
                }
            } else {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Destroy_0_UNEXPECTED_EXCEPTION, serverConnection.getName()), (Throwable)e);
            }
            return;
        }
        long oldStart2 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessDestroyTime(start - oldStart2);
        if (region instanceof PartitionedRegion) {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(clientMessage, serverConnection, pr, pr.getNetworkHopType());
                pr.clearNetworkHopData();
            } else {
                this.writeReply(clientMessage, serverConnection);
            }
        } else {
            this.writeReply(clientMessage, serverConnection);
        }
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent destroy response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
        }
        stats.incWriteDestroyResponseTime(DistributionStats.getStatTime() - start);
    }
}

