/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.AuthIds;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUserAuths;
import org.apache.geode.internal.cache.tier.sockets.CommandInitializer;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageIdExtractor;
import org.apache.geode.internal.cache.tier.sockets.MessageStats;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnectionCollection;
import org.apache.geode.internal.cache.tier.sockets.ServerSideHandshakeFactory;
import org.apache.geode.internal.cache.tier.sockets.UserAuthAttributes;
import org.apache.geode.internal.cache.tier.sockets.command.Default;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadState;

public abstract class ServerConnection
implements Runnable {
    protected static final Logger logger = LogService.getLogger();
    private static final int TIMEOUT_BUFFER_FOR_CONNECTION_CLEANUP_MS = 5000;
    private static final String DISALLOW_INTERNAL_MESSAGES_WITHOUT_CREDENTIALS_NAME = "geode.disallow-internal-messages-without-credentials";
    public static boolean allowInternalMessagesWithoutCredentials = !Boolean.getBoolean("geode.disallow-internal-messages-without-credentials");
    private Map commands;
    protected final SecurityService securityService;
    protected final CacheServerStats stats;
    private final ServerSideHandshakeFactory handshakeFactory;
    private static final ConcurrentHashMap<Integer, LinkedBlockingQueue<ByteBuffer>> commBufferMap = new ConcurrentHashMap(4, 0.75f, 1);
    private ServerConnectionCollection serverConnectionCollection;
    Socket theSocket;
    private ByteBuffer commBuffer;
    protected final CachedRegionHelper crHelper;
    protected String name;
    private Message requestMessage;
    private Message replyMessage;
    private Message responseMessage;
    private Message errorMessage;
    private ChunkedMessage queryResponseMessage;
    private ChunkedMessage chunkedResponseMessage;
    private ChunkedMessage executeFunctionResponseMessage;
    private ChunkedMessage registerInterestResponseMessage;
    private ChunkedMessage keySetResponseMessage;
    private final InternalLogWriter logWriter;
    private final InternalLogWriter securityLogWriter;
    final AcceptorImpl acceptor;
    private Thread owner;
    protected ServerSideHandshake handshake;
    private int handshakeTimeout;
    private final Object handshakeMonitor;
    private volatile int requestSpecificTimeout;
    private int latestBatchIdReplied;
    ClientProxyMembershipID proxyId;
    private byte[] memberIdByteArray;
    private AuthorizeRequestPP postAuthzRequest;
    protected final CommunicationMode communicationMode;
    private long processingMessageStartTime;
    private Object processingMessageLock;
    private static ConcurrentHashMap<ClientProxyMembershipID, ClientUserAuths> proxyIdVsClientUserAuths = new ConcurrentHashMap();
    private ClientUserAuths clientUserAuths;
    private long connectionId;
    private Random randomConnectionIdGen;
    private Part securePart;
    protected Principal principal;
    private MessageIdExtractor messageIdExtractor;
    private static boolean TEST_VERSION_AFTER_HANDSHAKE_FLAG = false;
    private static final ThreadLocal<Byte> executeFunctionOnLocalNodeOnly = ThreadLocal.withInitial(() -> (byte)0);
    private boolean incedCleanupTableRef;
    private boolean incedCleanupProxyIdTableRef;
    private final Object chmLock;
    private boolean chmRegistered;
    private boolean clientDisconnectedCleanly;
    private Throwable clientDisconnectedException;
    private int failureCount;
    boolean processMessages;
    private final Object terminationLock;
    private boolean terminated;
    private static boolean forceClientCrashEvent = false;
    private final Object ownerLock;
    private boolean requiresResponse;
    private boolean requiresChunkedResponse;
    private boolean potentialModification;
    private boolean responded;
    private Object modKey;
    private String modRegion;
    private long userAuthId;

    public static ByteBuffer allocateCommBuffer(int size, Socket sock) {
        if (sock.getChannel() == null) {
            return ByteBuffer.allocate(size);
        }
        LinkedBlockingQueue<ByteBuffer> q = commBufferMap.get(size);
        ByteBuffer result = null;
        if (q != null) {
            result = q.poll();
        }
        if (result == null) {
            result = ByteBuffer.allocateDirect(size);
        } else {
            result.position(0);
            result.limit(result.capacity());
        }
        return result;
    }

    public static void releaseCommBuffer(ByteBuffer bb) {
        if (bb != null && bb.isDirect()) {
            LinkedBlockingQueue<ByteBuffer> q = commBufferMap.get(bb.capacity());
            if (q == null) {
                q = new LinkedBlockingQueue();
                LinkedBlockingQueue<ByteBuffer> oldQ = commBufferMap.putIfAbsent(bb.capacity(), q);
                if (oldQ != null) {
                    q = oldQ;
                }
            }
            q.offer(bb);
        }
    }

    public static void emptyCommBufferPool() {
        for (LinkedBlockingQueue<ByteBuffer> q : commBufferMap.values()) {
            q.clear();
        }
    }

    public ServerConnection(Socket socket, InternalCache internalCache, CachedRegionHelper helper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor, SecurityService securityService) {
        block5: {
            this.handshakeFactory = new ServerSideHandshakeFactory();
            this.requestMessage = new Message(2, Version.CURRENT);
            this.replyMessage = new Message(1, Version.CURRENT);
            this.responseMessage = new Message(1, Version.CURRENT);
            this.errorMessage = new Message(1, Version.CURRENT);
            this.queryResponseMessage = new ChunkedMessage(2, Version.CURRENT);
            this.chunkedResponseMessage = new ChunkedMessage(1, Version.CURRENT);
            this.executeFunctionResponseMessage = new ChunkedMessage(1, Version.CURRENT);
            this.registerInterestResponseMessage = new ChunkedMessage(1, Version.CURRENT);
            this.keySetResponseMessage = new ChunkedMessage(1, Version.CURRENT);
            this.handshakeMonitor = new Object();
            this.requestSpecificTimeout = -1;
            this.latestBatchIdReplied = -1;
            this.processingMessageStartTime = -1L;
            this.processingMessageLock = new Object();
            this.connectionId = 26739L;
            this.securePart = null;
            this.messageIdExtractor = new MessageIdExtractor();
            this.incedCleanupTableRef = false;
            this.incedCleanupProxyIdTableRef = false;
            this.chmLock = new Object();
            this.chmRegistered = false;
            this.clientDisconnectedCleanly = false;
            this.failureCount = 0;
            this.processMessages = true;
            this.terminationLock = new Object();
            this.terminated = false;
            this.ownerLock = new Object();
            this.modKey = null;
            this.modRegion = null;
            StringBuilder buffer = new StringBuilder(100);
            if (((AcceptorImpl)acceptor).isGatewayReceiver()) {
                buffer.append("GatewayReceiver connection from [");
            } else {
                buffer.append("Server connection from [");
            }
            buffer.append(communicationModeStr).append(" host address=").append(socket.getInetAddress().getHostAddress()).append("; ").append(communicationModeStr).append(" port=").append(socket.getPort()).append("]");
            this.name = buffer.toString();
            this.stats = stats;
            this.acceptor = (AcceptorImpl)acceptor;
            this.crHelper = helper;
            this.logWriter = (InternalLogWriter)internalCache.getLoggerI18n();
            this.securityLogWriter = (InternalLogWriter)internalCache.getSecurityLoggerI18n();
            this.communicationMode = CommunicationMode.fromModeNumber(communicationMode);
            this.principal = null;
            this.postAuthzRequest = null;
            this.randomConnectionIdGen = new Random(this.hashCode());
            this.securityService = securityService;
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                this.theSocket = socket;
                this.theSocket.setSendBufferSize(socketBufferSize);
                this.theSocket.setReceiveBufferSize(socketBufferSize);
                if (isDebugEnabled) {
                    logger.debug("{}: Accepted client connection from {}[client host name={}; client host address={}; client port={}]", (Object)this.getName(), (Object)communicationModeStr, (Object)socket.getInetAddress().getCanonicalHostName(), (Object)socket.getInetAddress().getHostAddress(), (Object)socket.getPort());
                }
                this.handshakeTimeout = hsTimeout;
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block5;
                logger.debug("While creating server connection", (Throwable)e);
            }
        }
    }

    public AcceptorImpl getAcceptor() {
        return this.acceptor;
    }

    public static void executeFunctionOnLocalNodeOnly(Byte value) {
        byte b = value;
        executeFunctionOnLocalNodeOnly.set(b);
    }

    public static Byte isExecuteFunctionOnLocalNodeOnly() {
        return executeFunctionOnLocalNodeOnly.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyClientConnection() {
        Object object = this.handshakeMonitor;
        synchronized (object) {
            if (this.handshake == null) {
                ServerSideHandshake readHandshake;
                try {
                    readHandshake = this.handshakeFactory.readHandshake(this.getSocket(), this.getHandShakeTimeout(), this.getCommunicationMode(), this.getDistributedSystem(), this.getSecurityService());
                }
                catch (SocketTimeoutException timeout) {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ServerHandShakeProcessor_0_HANDSHAKE_REPLY_CODE_TIMEOUT_NOT_RECEIVED_WITH_IN_1_MS, new Object[]{this.getName(), this.handshakeTimeout}));
                    this.failConnectionAttempt();
                    return false;
                }
                catch (EOFException | SocketException e) {
                    logger.info("{} {}", (Object)this.getName(), (Object)e);
                    this.failConnectionAttempt();
                    return false;
                }
                catch (IOException e) {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ServerHandShakeProcessor_0_RECEIVED_NO_HANDSHAKE_REPLY_CODE, this.getName()), (Throwable)e);
                    this.failConnectionAttempt();
                    return false;
                }
                catch (AuthenticationFailedException | AuthenticationRequiredException ex) {
                    this.handleHandshakeAuthenticationException(ex);
                    return false;
                }
                catch (UnsupportedVersionException uve) {
                    logger.warn("{} {}", (Object)this.getName(), (Object)uve.getMessage(), (Object)uve);
                    this.handleHandshakeException(uve);
                    return false;
                }
                catch (Exception ex) {
                    logger.warn("{} {}", (Object)this.getName(), (Object)ex.getLocalizedMessage());
                    this.handleHandshakeException(ex);
                    return false;
                }
                this.setHandshake(readHandshake);
                this.setProxyId(readHandshake.getMembershipId());
                if (readHandshake.getVersion().compareTo(Version.GFE_65) < 0 || this.getCommunicationMode().isWAN()) {
                    try {
                        this.setAuthAttributes();
                    }
                    catch (AuthenticationFailedException | AuthenticationRequiredException ex) {
                        this.handleHandshakeAuthenticationException(ex);
                        return false;
                    }
                    catch (Exception ex) {
                        logger.warn("{} {}", (Object)this.getName(), (Object)ex.getLocalizedMessage());
                        this.handleHandshakeException(ex);
                        return false;
                    }
                }
                if (this.handshake.isOK()) {
                    try {
                        return this.processHandShake();
                    }
                    catch (CancelException e) {
                        if (!this.crHelper.isShutdown()) {
                            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ServerConnection_0_UNEXPECTED_CANCELLATION, this.getName()), (Throwable)e);
                        }
                        this.cleanup();
                        return false;
                    }
                }
                this.crHelper.checkCancelInProgress(null);
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ServerConnection_RECEIVED_UNKNOWN_HANDSHAKE_REPLY_CODE));
                this.refuseHandshake(LocalizedStrings.ServerConnection_RECEIVED_UNKNOWN_HANDSHAKE_REPLY_CODE.toLocalizedString(), (byte)61);
                return false;
            }
        }
        return true;
    }

    private void failConnectionAttempt() {
        this.stats.incFailedConnectionAttempts();
        this.cleanup();
    }

    private void handleHandshakeException(Exception ex) {
        this.refuseHandshake(ex.getMessage(), (byte)60);
        this.failConnectionAttempt();
    }

    private void handleHandshakeAuthenticationException(Exception ex) {
        if (ex instanceof AuthenticationRequiredException) {
            AuthenticationRequiredException noauth = (AuthenticationRequiredException)ex;
            String exStr = noauth.getLocalizedMessage();
            if (noauth.getCause() != null) {
                exStr = exStr + " : " + noauth.getCause().getLocalizedMessage();
            }
            if (this.securityLogWriter.warningEnabled()) {
                this.securityLogWriter.warning(LocalizedStrings.ONE_ARG, this.getName() + ": Security exception: " + exStr);
            }
            this.refuseHandshake(noauth.getMessage(), (byte)62);
            this.failConnectionAttempt();
        } else if (ex instanceof AuthenticationFailedException) {
            AuthenticationFailedException failed = (AuthenticationFailedException)ex;
            String exStr = failed.getLocalizedMessage();
            if (failed.getCause() != null) {
                exStr = exStr + " : " + failed.getCause().getLocalizedMessage();
            }
            if (this.securityLogWriter.warningEnabled()) {
                this.securityLogWriter.warning(LocalizedStrings.ONE_ARG, this.getName() + ": Security exception: " + exStr);
            }
            this.refuseHandshake(failed.getMessage(), (byte)63);
            this.failConnectionAttempt();
        } else {
            logger.warn("Unexpected exception type in ServerConnection handleHandshakeAuthenticationException");
            throw new RuntimeException("Invalid exception type, must be either AuthenticationRequiredException or AuthenticationFailedException", ex);
        }
    }

    protected Map getCommands() {
        return this.commands;
    }

    protected Socket getSocket() {
        return this.theSocket;
    }

    private int getHandShakeTimeout() {
        return this.handshakeTimeout;
    }

    protected DistributedSystem getDistributedSystem() {
        return this.getCache().getDistributedSystem();
    }

    public InternalCache getCache() {
        return this.crHelper.getCache();
    }

    public ServerSideHandshake getHandshake() {
        return this.handshake;
    }

    public void setHandshake(ServerSideHandshake handshake) {
        this.handshake = handshake;
        Version v = handshake.getVersion();
        this.replyMessage.setVersion(v);
        this.requestMessage.setVersion(v);
        this.responseMessage.setVersion(v);
        this.errorMessage.setVersion(v);
        this.queryResponseMessage.setVersion(v);
        this.chunkedResponseMessage.setVersion(v);
        this.executeFunctionResponseMessage.setVersion(v);
        this.registerInterestResponseMessage.setVersion(v);
        this.keySetResponseMessage.setVersion(v);
    }

    void setRequestMessage(Message requestMessage) {
        this.requestMessage = requestMessage;
    }

    public Version getClientVersion() {
        return this.handshake.getVersion();
    }

    protected void setProxyId(ClientProxyMembershipID proxyId) {
        this.proxyId = proxyId;
        this.memberIdByteArray = EventID.getMembershipId(proxyId);
        this.name = "Server connection from [" + proxyId + "; port=" + this.theSocket.getPort() + "]";
    }

    protected void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    private long setUserAuthorizeAndPostAuthorizeRequest(AuthorizeRequest authzRequest, AuthorizeRequestPP postAuthzRequest) throws IOException {
        UserAuthAttributes userAuthAttr = new UserAuthAttributes(authzRequest, postAuthzRequest);
        if (this.clientUserAuths == null) {
            this.initializeClientUserAuths();
        }
        try {
            return this.clientUserAuths.putUserAuth(userAuthAttr);
        }
        catch (NullPointerException exception) {
            if (this.isTerminated()) {
                throw new IOException("Server connection is terminated.");
            }
            throw exception;
        }
    }

    public InternalLogWriter getSecurityLogWriter() {
        return this.securityLogWriter;
    }

    private SecurityService getSecurityService() {
        return this.securityService;
    }

    private Map<ServerSideHandshake, MutableInt> getCleanupTable() {
        return this.acceptor.getClientHealthMonitor().getCleanupTable();
    }

    private Map<ClientProxyMembershipID, MutableInt> getCleanupProxyIdTable() {
        return this.acceptor.getClientHealthMonitor().getCleanupProxyIdTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean processHandShake() {
        int queueSize;
        int endpointType;
        MutableInt numRefs;
        boolean isDebugEnabled;
        boolean registerClient;
        boolean clientJoined;
        boolean result;
        block56: {
            boolean bl;
            result = false;
            clientJoined = false;
            registerClient = false;
            isDebugEnabled = logger.isDebugEnabled();
            try {
                CacheClientProxy proxy;
                Map<ServerSideHandshake, MutableInt> map = this.getCleanupTable();
                // MONITORENTER : map
                numRefs = this.getCleanupTable().get(this.handshake);
                endpointType = 0;
                queueSize = 0;
                if (!this.proxyId.isDurable()) break block56;
                if (isDebugEnabled) {
                    logger.debug("looking if the Proxy existed for this durable client or not :{}", (Object)this.proxyId);
                }
                if ((proxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.proxyId)) != null && proxy.waitRemoval()) {
                    proxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.proxyId);
                }
                if (proxy != null) {
                    if (isDebugEnabled) {
                        logger.debug("Proxy existed for this durable client :{} and proxy : {}", (Object)this.proxyId, (Object)proxy);
                    }
                    if (proxy.isPrimary()) {
                        endpointType = 2;
                        queueSize = proxy.getQueueSize();
                    } else {
                        endpointType = 1;
                        queueSize = proxy.getQueueSize();
                    }
                }
                if (numRefs != null || proxy == null || proxy.isPaused()) break block56;
                String handshakeRefusalMessage = LocalizedStrings.ServerConnection_DUPLICATE_DURABLE_CLIENTID_0.toLocalizedString(this.proxyId.getDurableId());
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.TWO_ARG_COLON, new Object[]{this.name, handshakeRefusalMessage}));
                this.refuseHandshake(handshakeRefusalMessage, (byte)64);
                bl = result;
                // MONITOREXIT : map
                if (this.isTerminated()) return false;
                if (!result) {
                    return false;
                }
                Map<ClientProxyMembershipID, MutableInt> map2 = this.getCleanupProxyIdTable();
            }
            catch (Throwable throwable) {
                if (this.isTerminated()) return false;
                if (!result) {
                    return false;
                }
                Map<ClientProxyMembershipID, MutableInt> map = this.getCleanupProxyIdTable();
                // MONITORENTER : map
                MutableInt numRefs2 = this.getCleanupProxyIdTable().get(this.proxyId);
                if (numRefs2 != null) {
                    numRefs2.increment();
                } else {
                    registerClient = true;
                    this.getCleanupProxyIdTable().put(this.proxyId, new MutableInt(1));
                }
                this.incedCleanupProxyIdTableRef = true;
                // MONITOREXIT : map
                if (isDebugEnabled) {
                    logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
                }
                this.crHelper.checkCancelInProgress(null);
                if (clientJoined && this.isFiringMembershipEvents()) {
                    InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
                }
                ClientHealthMonitor chm = this.acceptor.getClientHealthMonitor();
                Object object = this.chmLock;
                // MONITORENTER : object
                this.chmRegistered = true;
                // MONITOREXIT : object
                if (registerClient) {
                    chm.registerClient(this.proxyId);
                }
                this.serverConnectionCollection = chm.addConnection(this.proxyId, this);
                this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
                throw throwable;
            }
            MutableInt numRefs3 = this.getCleanupProxyIdTable().get(this.proxyId);
            if (numRefs3 != null) {
                numRefs3.increment();
            } else {
                registerClient = true;
                this.getCleanupProxyIdTable().put(this.proxyId, new MutableInt(1));
            }
            this.incedCleanupProxyIdTableRef = true;
            // MONITOREXIT : map2
            if (isDebugEnabled) {
                logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
            }
            this.crHelper.checkCancelInProgress(null);
            if (clientJoined && this.isFiringMembershipEvents()) {
                InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
            }
            ClientHealthMonitor chm = this.acceptor.getClientHealthMonitor();
            Object object = this.chmLock;
            // MONITORENTER : object
            this.chmRegistered = true;
            // MONITOREXIT : object
            if (registerClient) {
                chm.registerClient(this.proxyId);
            }
            this.serverConnectionCollection = chm.addConnection(this.proxyId, this);
            this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
            return bl;
        }
        if (numRefs != null) {
            if (this.acceptHandShake((byte)endpointType, queueSize)) {
                numRefs.increment();
                this.incedCleanupTableRef = true;
                result = true;
            }
            boolean bl = result;
            // MONITOREXIT : map
            if (this.isTerminated()) return false;
            if (!result) {
                return false;
            }
            Map<ClientProxyMembershipID, MutableInt> handshakeRefusalMessage = this.getCleanupProxyIdTable();
            // MONITORENTER : handshakeRefusalMessage
            Object numRefs4 = this.getCleanupProxyIdTable().get(this.proxyId);
            if (numRefs4 != null) {
                numRefs4.increment();
            } else {
                registerClient = true;
                this.getCleanupProxyIdTable().put(this.proxyId, new MutableInt(1));
            }
            this.incedCleanupProxyIdTableRef = true;
            // MONITOREXIT : handshakeRefusalMessage
            if (isDebugEnabled) {
                logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
            }
            this.crHelper.checkCancelInProgress(null);
            if (clientJoined && this.isFiringMembershipEvents()) {
                InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
            }
            ClientHealthMonitor chm = this.acceptor.getClientHealthMonitor();
            numRefs4 = this.chmLock;
            // MONITORENTER : numRefs4
            this.chmRegistered = true;
            // MONITOREXIT : numRefs4
            if (registerClient) {
                chm.registerClient(this.proxyId);
            }
            this.serverConnectionCollection = chm.addConnection(this.proxyId, this);
            this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
            return bl;
        }
        if (this.acceptHandShake((byte)endpointType, queueSize)) {
            clientJoined = true;
            this.getCleanupTable().put(this.handshake, new MutableInt(1));
            this.incedCleanupTableRef = true;
            this.stats.incCurrentClients();
            result = true;
        }
        boolean bl = result;
        // MONITOREXIT : map
        if (this.isTerminated()) return false;
        if (!result) {
            return false;
        }
        Object chm = this.getCleanupProxyIdTable();
        // MONITORENTER : chm
        MutableInt numRefs5 = this.getCleanupProxyIdTable().get(this.proxyId);
        if (numRefs5 != null) {
            numRefs5.increment();
        } else {
            registerClient = true;
            this.getCleanupProxyIdTable().put(this.proxyId, new MutableInt(1));
        }
        this.incedCleanupProxyIdTableRef = true;
        // MONITOREXIT : chm
        if (isDebugEnabled) {
            logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
        }
        this.crHelper.checkCancelInProgress(null);
        if (clientJoined && this.isFiringMembershipEvents()) {
            InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
        }
        chm = this.acceptor.getClientHealthMonitor();
        Object object = this.chmLock;
        // MONITORENTER : object
        this.chmRegistered = true;
        // MONITOREXIT : object
        if (registerClient) {
            ((ClientHealthMonitor)chm).registerClient(this.proxyId);
        }
        this.serverConnectionCollection = ((ClientHealthMonitor)chm).addConnection(this.proxyId, this);
        this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
        return bl;
    }

    private boolean isFiringMembershipEvents() {
        return this.acceptor.isRunning() && !this.acceptor.getCachedRegionHelper().getCache().isClosed() && !this.acceptor.getCachedRegionHelper().getCache().getCancelCriterion().isCancelInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refuseHandshake(String message, byte exception) {
        try {
            this.acceptor.refuseHandshake(this.theSocket.getOutputStream(), message, exception);
        }
        catch (IOException iOException) {
        }
        finally {
            this.stats.incFailedConnectionAttempts();
            this.cleanup();
        }
    }

    private boolean acceptHandShake(byte endpointType, int queueSize) {
        return this.doHandShake(endpointType, queueSize) && this.handshakeAccepted();
    }

    protected abstract boolean doHandShake(byte var1, int var2);

    private boolean handshakeAccepted() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Accepted handshake", (Object)this.name);
        }
        if (this.communicationMode == CommunicationMode.ClientToServerForQueue) {
            this.stats.incCurrentQueueConnections();
        } else {
            this.stats.incCurrentClientConnections();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCq(String cqName, boolean isDurable) throws Exception {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.requestMessage.isSecureMode()) {
            if (isDebugEnabled) {
                logger.debug("setCq() security header found registering CQname = {}", (Object)cqName);
            }
            try {
                byte[] secureBytes = this.requestMessage.getSecureBytes();
                secureBytes = this.handshake.getEncryptor().decryptBytes(secureBytes);
                AuthIds aIds = new AuthIds(secureBytes);
                long uniqueId = aIds.getUniqueId();
                CacheClientProxy proxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.proxyId);
                if (proxy == null) return;
                proxy.setCQVsUserAuth(cqName, uniqueId, isDurable);
                return;
            }
            catch (Exception ex) {
                if (!isDebugEnabled) throw ex;
                logger.debug("While setting cq got exception ", (Throwable)ex);
                throw ex;
            }
        } else {
            if (!isDebugEnabled) return;
            logger.debug("setCq() security header is not found ");
        }
    }

    public void removeCq(String cqName, boolean isDurable) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.requestMessage.isSecureMode()) {
            if (isDebugEnabled) {
                logger.debug("removeCq() security header found registering CQname = {}", (Object)cqName);
            }
            try {
                this.clientUserAuths.removeUserAuthAttributesForCq(cqName, isDurable);
            }
            catch (Exception ex) {
                if (isDebugEnabled) {
                    logger.debug("While setting cq got exception ", (Throwable)ex);
                }
            }
        } else if (isDebugEnabled) {
            logger.debug("removeCq() security header is not found");
        }
    }

    public boolean isClientServerConnection() {
        return this.communicationMode.isClientToServerOrSubscriptionFeed();
    }

    protected void doHandshake() {
        if (this.verifyClientConnection()) {
            this.initializeCommands();
            if (!this.getCommunicationMode().isWAN()) {
                this.initializeClientUserAuths();
            }
        }
        if (TEST_VERSION_AFTER_HANDSHAKE_FLAG) {
            short testVersionAfterHandshake = 4;
            Assert.assertTrue(this.handshake.getVersion().ordinal() == testVersionAfterHandshake, "Found different version after handshake");
            TEST_VERSION_AFTER_HANDSHAKE_FLAG = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doNormalMessage() {
        if (this.serverConnectionCollection == null) {
            logger.warn("Continued processing ServerConnection after handshake failed");
            this.processMessages = false;
            return;
        }
        Message message = BaseCommand.readRequest(this);
        ServerConnectionCollection serverConnectionCollection = this.serverConnectionCollection;
        synchronized (serverConnectionCollection) {
            if (this.serverConnectionCollection.isTerminating) {
                this.processMessages = false;
                return;
            }
            this.serverConnectionCollection.connectionsProcessing.incrementAndGet();
        }
        ThreadState threadState = null;
        try {
            if (message != null) {
                Command command;
                if (!this.processMessages || this.crHelper.isShutdown()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} ignoring message of type {} from client {} due to shutdown.", (Object)this.getName(), (Object)MessageType.getString(message.getMessageType()), (Object)this.proxyId);
                    }
                    return;
                }
                if (message.getMessageType() != 5 && message.getNumberOfParts() <= 0) {
                    ++this.failureCount;
                    if (this.failureCount > 3) {
                        this.processMessages = false;
                        return;
                    }
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("{} received {} with txid {}", (Object)this.getName(), (Object)MessageType.getString(message.getMessageType()), (Object)message.getTransactionId());
                    if (message.getTransactionId() < -1) {
                        message.setTransactionId(-1);
                    }
                }
                if (message.getMessageType() != 5) {
                    this.acceptor.getClientHealthMonitor().receivedPing(this.proxyId);
                }
                if ((command = this.getCommand(message.getMessageType())) == null) {
                    command = Default.getCommand();
                }
                if (this.securityService.isIntegratedSecurity() && !this.isInternalMessage(this.requestMessage, allowInternalMessagesWithoutCredentials) && !this.communicationMode.isWAN()) {
                    long uniqueId = this.getUniqueId();
                    String messageType2 = MessageType.getString(this.requestMessage.getMessageType());
                    Subject subject = this.clientUserAuths.getSubject(uniqueId);
                    if (subject != null) {
                        threadState = this.securityService.bindSubject(subject);
                        logger.debug("Bound {} with uniqueId {} for message {} with {}", subject.getPrincipal(), (Object)uniqueId, (Object)messageType2, (Object)this.getName());
                    } else if (uniqueId == 0L) {
                        logger.debug("No unique ID yet. {}, {}", (Object)messageType2, (Object)this.getName());
                    } else {
                        logger.error("Failed to bind the subject of uniqueId {} for message {} with {}", (Object)uniqueId, (Object)messageType2, (Object)this.getName());
                        throw new AuthenticationRequiredException("Failed to find the authenticated user.");
                    }
                }
                command.execute(message, this, this.securityService);
            }
        }
        finally {
            this.serverConnectionCollection.connectionsProcessing.decrementAndGet();
            this.setNotProcessingMessage();
            this.clearRequestMessage();
            if (threadState != null) {
                threadState.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.terminationLock;
        synchronized (object) {
            return this.terminated;
        }
    }

    private void cleanClientAuths() {
        if (this.clientUserAuths != null) {
            this.clientUserAuths.cleanup(false);
        }
    }

    void handleTermination() {
        if (this.crHelper.isShutdown()) {
            this.setClientDisconnectCleanly();
        }
        this.handleTermination(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTermination(boolean timedOut) {
        MutableInt numRefs;
        boolean cleanupStats = false;
        Object object = this.terminationLock;
        synchronized (object) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        boolean clientDeparted = false;
        boolean unregisterClient = false;
        this.setNotProcessingMessage();
        Map<Object, MutableInt> map = this.getCleanupTable();
        synchronized (map) {
            if (this.incedCleanupTableRef) {
                this.incedCleanupTableRef = false;
                cleanupStats = true;
                numRefs = this.getCleanupTable().get(this.handshake);
                if (numRefs != null) {
                    numRefs.decrement();
                    if (numRefs.toInteger() <= 0) {
                        clientDeparted = true;
                        this.getCleanupTable().remove(this.handshake);
                        this.stats.decCurrentClients();
                    }
                }
                if (this.communicationMode == CommunicationMode.ClientToServerForQueue) {
                    this.stats.decCurrentQueueConnections();
                } else {
                    this.stats.decCurrentClientConnections();
                }
            }
        }
        map = this.getCleanupProxyIdTable();
        synchronized (map) {
            if (this.incedCleanupProxyIdTableRef) {
                this.incedCleanupProxyIdTableRef = false;
                numRefs = this.getCleanupProxyIdTable().get(this.proxyId);
                if (numRefs != null) {
                    numRefs.decrement();
                    if (numRefs.toInteger() <= 0) {
                        unregisterClient = true;
                        this.getCleanupProxyIdTable().remove(this.proxyId);
                        proxyIdVsClientUserAuths.remove(this.proxyId);
                    }
                }
            }
        }
        this.cleanup(timedOut);
        if (this.getAcceptor().isRunning() && clientDeparted && this.isFiringMembershipEvents()) {
            if (this.clientDisconnectedCleanly && !forceClientCrashEvent) {
                InternalClientMembership.notifyClientLeft(this.proxyId.getDistributedMember());
            } else {
                InternalClientMembership.notifyClientCrashed(this.proxyId.getDistributedMember());
            }
        }
        boolean needsUnregister = false;
        Object object2 = this.chmLock;
        synchronized (object2) {
            if (this.chmRegistered) {
                needsUnregister = true;
                this.chmRegistered = false;
            }
        }
        if (unregisterClient) {
            this.cleanClientAuths();
        }
        this.clientUserAuths = null;
        if (needsUnregister) {
            this.acceptor.getClientHealthMonitor().removeConnection(this.proxyId, this);
            if (unregisterClient) {
                this.acceptor.getClientHealthMonitor().unregisterClient(this.proxyId, this.getAcceptor(), this.clientDisconnectedCleanly, this.clientDisconnectedException);
            }
        }
        if (cleanupStats) {
            this.acceptor.getConnectionListener().connectionClosed(clientDeparted, this.communicationMode);
        }
    }

    protected abstract void doOneMessage();

    private void initializeClientUserAuths() {
        this.clientUserAuths = ServerConnection.getClientUserAuths(this.proxyId);
    }

    static ClientUserAuths getClientUserAuths(ClientProxyMembershipID proxyId) {
        ClientUserAuths clientUserAuths = new ClientUserAuths(proxyId.hashCode());
        ClientUserAuths returnedClientUserAuths = proxyIdVsClientUserAuths.putIfAbsent(proxyId, clientUserAuths);
        if (returnedClientUserAuths == null) {
            return clientUserAuths;
        }
        return returnedClientUserAuths;
    }

    void initializeCommands() {
        this.commands = CommandInitializer.getCommands(this);
    }

    private Command getCommand(Integer messageType2) {
        return (Command)this.commands.get(messageType2);
    }

    public void removeUserAuth(Message message, boolean keepAlive) {
        try {
            byte[] secureBytes = message.getSecureBytes();
            secureBytes = this.handshake.getEncryptor().decryptBytes(secureBytes);
            AuthIds aIds = new AuthIds(secureBytes);
            long connId = aIds.getConnectionId();
            if (connId != this.connectionId) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            try {
                boolean removed = this.clientUserAuths.removeSubject(aIds.getUniqueId());
                if (!removed) {
                    this.clientUserAuths.removeUserId(aIds.getUniqueId(), keepAlive);
                }
            }
            catch (NullPointerException exception) {
                logger.debug("Exception {}", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            throw new AuthenticationFailedException("Authentication failed", exception);
        }
    }

    public byte[] setCredentials(Message message) {
        try {
            long uniqueId;
            if (!AcceptorImpl.isAuthenticationRequired() && message.isSecureMode()) {
                return new byte[0];
            }
            if (!message.isSecureMode()) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            byte[] secureBytes = message.getSecureBytes();
            secureBytes = this.handshake.getEncryptor().decryptBytes(secureBytes);
            AuthIds aIds = new AuthIds(secureBytes);
            long connId = aIds.getConnectionId();
            if (connId != this.connectionId) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            byte[] credBytes = message.getPart(0).getSerializedForm();
            credBytes = this.handshake.getEncryptor().decryptBytes(credBytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(credBytes);
            DataInputStream dinp = new DataInputStream(bis);
            Properties credentials = DataSerializer.readProperties(dinp);
            DistributedSystem system = this.getDistributedSystem();
            String methodName = system.getProperties().getProperty("security-client-authenticator");
            Object principal = Handshake.verifyCredentials(methodName, credentials, system.getSecurityProperties(), (InternalLogWriter)system.getLogWriter(), (InternalLogWriter)system.getSecurityLogWriter(), this.proxyId.getDistributedMember(), this.securityService);
            if (principal instanceof Subject) {
                Subject subject = (Subject)principal;
                uniqueId = this.clientUserAuths.putSubject(subject);
            } else {
                uniqueId = this.getUniqueId((Principal)principal);
            }
            return this.encryptId(uniqueId);
        }
        catch (AuthenticationFailedException | AuthenticationRequiredException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new AuthenticationFailedException("REPLY_REFUSED", exception);
        }
    }

    private void setSecurityPart() {
        try {
            this.connectionId = this.randomConnectionIdGen.nextLong();
            this.securePart = new Part();
            byte[] id = this.encryptId(this.connectionId);
            this.securePart.setPartState(id, false);
        }
        catch (Exception ex) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ServerConnection_SERVER_FAILED_TO_ENCRYPT_DATA_0, ex));
            throw new GemFireSecurityException("Server failed to encrypt response message.");
        }
    }

    public Part updateAndGetSecurityPart() {
        if (AcceptorImpl.isAuthenticationRequired() && this.handshake.getVersion().compareTo(Version.GFE_65) >= 0 && !this.communicationMode.isWAN() && !this.requestMessage.getAndResetIsMetaRegion() && !this.isInternalMessage(this.requestMessage, allowInternalMessagesWithoutCredentials)) {
            this.setSecurityPart();
            return this.securePart;
        }
        if (AcceptorImpl.isAuthenticationRequired() && logger.isDebugEnabled()) {
            logger.debug("ServerConnection.updateAndGetSecurityPart() not adding security part for message type {}", (Object)MessageType.getString(this.requestMessage.messageType));
        }
        return null;
    }

    public boolean isInternalMessage(Message message, boolean allowOldInternalMessages) {
        boolean isInternalMessage;
        int messageType2 = message.getMessageType();
        boolean bl = isInternalMessage = messageType2 == 5 || messageType2 == 68 || messageType2 == 31 || messageType2 == 78 || messageType2 == 53 || messageType2 == 81 || messageType2 == 88 || messageType2 == 90 || messageType2 == 85 || messageType2 == 87 || messageType2 == 18 || messageType2 == -1 || messageType2 == 52 || messageType2 == 71 || messageType2 == 73;
        if (!isInternalMessage && allowOldInternalMessages) {
            isInternalMessage = messageType2 == 48 || messageType2 == 49 || messageType2 == 67 || messageType2 == 51 || messageType2 == 94 || messageType2 == 93 || messageType2 == 92 || messageType2 == 91 || messageType2 == 96 || messageType2 == 97 || messageType2 == 98 || messageType2 == 101 || messageType2 == 102;
        }
        return isInternalMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.setOwner();
        if (this.getAcceptor().isSelector()) {
            boolean finishedMessage = false;
            try {
                this.stats.decThreadQueueSize();
                if (this.isTerminated()) return;
                this.getAcceptor().setTLCommBuffer();
                this.doOneMessage();
                if (!this.processMessages || this.crHelper.isShutdown()) return;
                this.registerWithSelector();
                finishedMessage = true;
                return;
            }
            catch (ClosedChannelException | CancelException exception) {
                return;
            }
            catch (IOException ex) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ServerConnection_0__UNEXPECTED_EXCEPTION, ex));
                this.setClientDisconnectedException(ex);
                return;
            }
            finally {
                this.getAcceptor().releaseTLCommBuffer();
                this.unsetOwner();
                this.setNotProcessingMessage();
                this.unsetRequestSpecificTimeout();
                if (!finishedMessage) {
                    try {
                        this.handleTermination();
                    }
                    catch (CancelException cancelException) {}
                }
            }
        }
        try {
            while (this.processMessages && !this.crHelper.isShutdown()) {
                try {
                    this.doOneMessage();
                }
                catch (CancelException cancelException) {}
                continue;
                finally {
                    this.unsetRequestSpecificTimeout();
                    Breadcrumbs.clearBreadcrumb();
                }
            }
            return;
        }
        finally {
            try {
                this.unsetRequestSpecificTimeout();
                this.handleTermination();
                DistributedSystem.releaseThreadsSockets();
            }
            catch (CancelException cancelException) {}
        }
    }

    void registerWithSelector() throws IOException {
        this.getSelectableChannel().configureBlocking(false);
        this.getAcceptor().registerSC(this);
    }

    SelectableChannel getSelectableChannel() {
        return this.theSocket.getChannel();
    }

    void registerWithSelector2(Selector s) throws IOException {
        this.getSelectableChannel().register(s, 1, this);
    }

    void makeBlocking() throws IOException {
        SocketChannel c = this.theSocket.getChannel();
        ((SelectableChannel)c).configureBlocking(true);
    }

    public static void setForceClientCrashEvent(boolean value) {
        forceClientCrashEvent = value;
    }

    public String getMembershipID() {
        return this.proxyId.getDSMembership();
    }

    public int getSocketPort() {
        return this.theSocket.getPort();
    }

    public String getSocketHost() {
        return this.theSocket.getInetAddress().getHostAddress();
    }

    protected CommunicationMode getCommunicationMode() {
        return this.communicationMode;
    }

    InetAddress getSocketAddress() {
        return this.theSocket.getInetAddress();
    }

    public void setRequestSpecificTimeout(int requestSpecificTimeout) {
        this.requestSpecificTimeout = requestSpecificTimeout;
    }

    private void unsetRequestSpecificTimeout() {
        this.requestSpecificTimeout = -1;
    }

    protected int getClientReadTimeout() {
        if (this.requestSpecificTimeout == -1) {
            return this.handshake.getClientReadTimeout();
        }
        return this.requestSpecificTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProcessingMessage() {
        Object object = this.processingMessageLock;
        synchronized (object) {
            this.processingMessageStartTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProcessingMessage() {
        Object object = this.processingMessageLock;
        synchronized (object) {
            if (this.processingMessageStartTime != -1L) {
                this.processingMessageStartTime = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNotProcessingMessage() {
        Object object = this.processingMessageLock;
        synchronized (object) {
            this.processingMessageStartTime = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCurrentMessageProcessingTime() {
        long result;
        Object object = this.processingMessageLock;
        synchronized (object) {
            result = this.processingMessageStartTime;
        }
        if (result != -1L) {
            result = System.currentTimeMillis() - result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasBeenTimedOutOnClient() {
        int timeout = this.getClientReadTimeout();
        if (timeout > 0) {
            timeout += 5000;
            Object object = this.processingMessageLock;
            synchronized (object) {
                if (this.getCurrentMessageProcessingTime() > (long)timeout) {
                    return true;
                }
            }
        }
        return false;
    }

    public String getSocketString() {
        try {
            return String.valueOf(this.theSocket.getInetAddress()) + ':' + this.theSocket.getPort() + " timeout: " + this.theSocket.getSoTimeout();
        }
        catch (Exception e) {
            return LocalizedStrings.ServerConnection_ERROR_IN_GETSOCKETSTRING_0.toLocalizedString(e.getLocalizedMessage());
        }
    }

    private void clearRequestMessage() {
        this.requestMessage.clear();
    }

    public void incrementLatestBatchIdReplied(int justProcessed) {
        if (justProcessed - this.latestBatchIdReplied != 1) {
            this.stats.incOutOfOrderBatchIds();
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ServerConnection_BATCH_IDS_ARE_OUT_OF_ORDER_SETTING_LATESTBATCHID_TO_0_IT_WAS_1, new Object[]{justProcessed, this.latestBatchIdReplied}));
        }
        this.latestBatchIdReplied = justProcessed;
    }

    public int getLatestBatchIdReplied() {
        return this.latestBatchIdReplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOwner() {
        Object object = this.ownerLock;
        synchronized (object) {
            this.owner = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetOwner() {
        Object object = this.ownerLock;
        synchronized (object) {
            this.owner = null;
            Thread.interrupted();
        }
    }

    void initStreams(Socket s, int socketBufferSize, MessageStats messageStats) {
        try {
            this.commBuffer = this.getAcceptor().isSelector() ? null : ServerConnection.allocateCommBuffer(socketBufferSize, s);
            this.requestMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.replyMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.responseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.errorMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.chunkedResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.queryResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.executeFunctionResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.registerInterestResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
            this.keySetResponseMessage.setComms(this, this.theSocket, this.commBuffer, messageStats);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            logger.fatal(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public boolean isClosed() {
        return this.theSocket == null || !this.theSocket.isConnected() || this.theSocket.isClosed();
    }

    public void cleanup(boolean timedOut) {
        if (this.cleanup() && timedOut) {
            this.stats.incConnectionsTimedOut();
        }
    }

    public boolean cleanup() {
        block8: {
            if (this.isClosed()) {
                return false;
            }
            if (this.communicationMode.isWAN() || this.communicationMode.isCountedAsClientServerConnection()) {
                this.getAcceptor().decClientServerCnxCount();
            }
            try {
                this.theSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.postAuthzRequest != null) {
                    this.postAuthzRequest.close();
                    this.postAuthzRequest = null;
                }
            }
            catch (Exception ex) {
                if (!this.securityLogWriter.warningEnabled()) break block8;
                this.securityLogWriter.warning(LocalizedStrings.ServerConnection_0_AN_EXCEPTION_WAS_THROWN_WHILE_CLOSING_CLIENT_POSTPROCESS_AUTHORIZATION_CALLBACK_1, new Object[]{this.name, ex});
            }
        }
        this.getAcceptor().unregisterSC(this);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Closed connection", (Object)this.name);
        }
        this.releaseCommBuffer();
        this.processMessages = false;
        return true;
    }

    private void releaseCommBuffer() {
        ByteBuffer byteBuffer = this.commBuffer;
        if (byteBuffer != null) {
            this.commBuffer = null;
            ServerConnection.releaseCommBuffer(byteBuffer);
        }
    }

    public static void loadEmergencyClasses() {
    }

    public void emergencyClose() {
        this.terminated = true;
        Socket s = this.theSocket;
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ClientProxyMembershipID getProxyID() {
        return this.proxyId;
    }

    public CachedRegionHelper getCachedRegionHelper() {
        return this.crHelper;
    }

    public CacheServerStats getCacheServerStats() {
        return this.stats;
    }

    public Message getReplyMessage() {
        return this.replyMessage;
    }

    public ChunkedMessage getChunkedResponseMessage() {
        return this.chunkedResponseMessage;
    }

    public Message getErrorResponseMessage() {
        return this.errorMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    Message getRequestMessage() {
        return this.requestMessage;
    }

    ChunkedMessage getQueryResponseMessage() {
        return this.queryResponseMessage;
    }

    public ChunkedMessage getFunctionResponseMessage() {
        return this.executeFunctionResponseMessage;
    }

    ChunkedMessage getKeySetResponseMessage() {
        return this.keySetResponseMessage;
    }

    public ChunkedMessage getRegisterInterestResponseMessage() {
        return this.registerInterestResponseMessage;
    }

    void resetTransientData() {
        this.potentialModification = false;
        this.requiresResponse = false;
        this.responded = false;
        this.requiresChunkedResponse = false;
        this.modKey = null;
        this.modRegion = null;
        this.queryResponseMessage.setNumberOfParts(2);
        this.chunkedResponseMessage.setNumberOfParts(1);
        this.executeFunctionResponseMessage.setNumberOfParts(1);
        this.registerInterestResponseMessage.setNumberOfParts(1);
        this.keySetResponseMessage.setNumberOfParts(1);
    }

    String getModRegion() {
        return this.modRegion;
    }

    Object getModKey() {
        return this.modKey;
    }

    boolean getPotentialModification() {
        return this.potentialModification;
    }

    public void setModificationInfo(boolean potentialModification, String modRegion, Object modKey) {
        this.potentialModification = potentialModification;
        this.modRegion = modRegion;
        this.modKey = modKey;
    }

    public void setAsTrue(int boolID) {
        switch (boolID) {
            case 1: {
                this.responded = true;
                break;
            }
            case 2: {
                this.requiresResponse = true;
                break;
            }
            case 3: {
                this.requiresChunkedResponse = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalizedStrings.ServerConnection_THE_ID_PASSED_IS_0_WHICH_DOES_NOT_CORRESPOND_WITH_ANY_TRANSIENT_DATA.toLocalizedString(boolID));
            }
        }
    }

    public boolean getTransientFlag(int boolID) {
        boolean retVal;
        switch (boolID) {
            case 1: {
                retVal = this.responded;
                break;
            }
            case 2: {
                retVal = this.requiresResponse;
                break;
            }
            case 3: {
                retVal = this.requiresChunkedResponse;
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalizedStrings.ServerConnection_THE_ID_PASSED_IS_0_WHICH_DOES_NOT_CORRESPOND_WITH_ANY_TRANSIENT_DATA.toLocalizedString(boolID));
            }
        }
        return retVal;
    }

    public void setFlagProcessMessagesAsFalse() {
        this.processMessages = false;
    }

    public InternalLogWriter getLogWriter() {
        return this.logWriter;
    }

    void setUserAuthId(long uniqueId) {
        this.userAuthId = uniqueId;
    }

    private byte[] encryptId(long id) throws Exception {
        try (HeapDataOutputStream heapDataOutputStream = new HeapDataOutputStream(Version.CURRENT);){
            heapDataOutputStream.writeLong(id);
            byte[] byArray = this.handshake.getEncryptor().encryptBytes(heapDataOutputStream.toByteArray());
            return byArray;
        }
    }

    public long getUniqueId() {
        long uniqueId;
        if (this.handshake.getVersion().isPre65() || this.communicationMode.isWAN()) {
            uniqueId = this.userAuthId;
        } else if (this.requestMessage.isSecureMode()) {
            uniqueId = this.messageIdExtractor.getUniqueIdFromMessage(this.requestMessage, this.handshake.getEncryptor(), this.connectionId);
        } else {
            throw new AuthenticationRequiredException(LocalizedStrings.HandShake_NO_SECURITY_CREDENTIALS_ARE_PROVIDED.toLocalizedString());
        }
        return uniqueId;
    }

    public AuthorizeRequest getAuthzRequest() throws AuthenticationRequiredException, IOException {
        if (!AcceptorImpl.isAuthenticationRequired()) {
            return null;
        }
        if (this.securityService.isIntegratedSecurity()) {
            return null;
        }
        long uniqueId = this.getUniqueId();
        UserAuthAttributes uaa = null;
        try {
            uaa = this.clientUserAuths.getUserAuthAttributes(uniqueId);
        }
        catch (NullPointerException npe) {
            if (this.isTerminated()) {
                throw new IOException("Server connection is terminated.");
            }
            logger.debug("Unexpected exception {}", (Throwable)npe);
        }
        if (uaa == null) {
            throw new AuthenticationRequiredException("User authorization attributes not found.");
        }
        AuthorizeRequest authReq = uaa.getAuthzRequest();
        if (logger.isDebugEnabled()) {
            logger.debug("getAuthzRequest() authrequest: {}", (Object)(authReq == null ? "NULL (only authentication is required)" : "not null"));
        }
        return authReq;
    }

    public AuthorizeRequestPP getPostAuthzRequest() throws AuthenticationRequiredException, IOException {
        if (!AcceptorImpl.isAuthenticationRequired()) {
            return null;
        }
        if (this.securityService.isIntegratedSecurity()) {
            return null;
        }
        long uniqueId = this.getUniqueId();
        UserAuthAttributes uaa = null;
        try {
            uaa = this.clientUserAuths.getUserAuthAttributes(uniqueId);
        }
        catch (NullPointerException npe) {
            if (this.isTerminated()) {
                throw new IOException("Server connection is terminated.");
            }
            logger.debug("Unexpected exception {}", (Throwable)npe);
        }
        if (uaa == null) {
            throw new AuthenticationRequiredException("User authorization attributes not found.");
        }
        return uaa.getPostAuthzRequest();
    }

    public byte[] getEventMemberIDByteArray() {
        return this.memberIdByteArray;
    }

    public void setClientDisconnectCleanly() {
        this.clientDisconnectedCleanly = true;
    }

    public void setClientDisconnectedException(Throwable e) {
        this.clientDisconnectedException = e;
    }

    void setMessageIdExtractor(MessageIdExtractor messageIdExtractor) {
        this.messageIdExtractor = messageIdExtractor;
    }

    private void setAuthAttributes() throws Exception {
        long uniqueId;
        logger.debug("setAttributes()");
        Object principal = this.getHandshake().verifyCredentials();
        if (principal instanceof Subject) {
            uniqueId = ServerConnection.getClientUserAuths(this.getProxyID()).putSubject((Subject)principal);
        } else {
            uniqueId = this.getUniqueId((Principal)principal);
            this.setPrincipal((Principal)principal);
        }
        this.setUserAuthId(uniqueId);
    }

    private long getUniqueId(Principal principal) throws Exception {
        InternalLogWriter securityLogWriter = this.getSecurityLogWriter();
        DistributedSystem system = this.getDistributedSystem();
        Properties systemProperties = system.getProperties();
        String authzFactoryName = systemProperties.getProperty("security-client-accessor");
        String postAuthzFactoryName = systemProperties.getProperty("security-client-accessor-pp");
        AuthorizeRequest authzRequest = null;
        AuthorizeRequestPP postAuthzRequest = null;
        if (authzFactoryName != null && authzFactoryName.length() > 0) {
            if (securityLogWriter.fineEnabled()) {
                securityLogWriter.fine(this.getName() + ": Setting pre-process authorization callback to: " + authzFactoryName);
            }
            if (principal == null && securityLogWriter.warningEnabled()) {
                securityLogWriter.warning(LocalizedStrings.ServerHandShakeProcessor_0_AUTHORIZATION_ENABLED_BUT_AUTHENTICATION_CALLBACK_1_RETURNED_WITH_NULL_CREDENTIALS_FOR_PROXYID_2, new Object[]{this.getName(), "security-client-authenticator", this.getProxyID()});
            }
            authzRequest = new AuthorizeRequest(authzFactoryName, this.getProxyID(), principal, (Cache)this.getCache());
        }
        if (postAuthzFactoryName != null && postAuthzFactoryName.length() > 0) {
            if (securityLogWriter.fineEnabled()) {
                securityLogWriter.fine(this.getName() + ": Setting post-process authorization callback to: " + postAuthzFactoryName);
            }
            if (principal == null && securityLogWriter.warningEnabled()) {
                securityLogWriter.warning(LocalizedStrings.ServerHandShakeProcessor_0_POSTPROCESS_AUTHORIZATION_ENABLED_BUT_NO_AUTHENTICATION_CALLBACK_2_IS_CONFIGURED, new Object[]{this.getName(), "security-client-authenticator"});
            }
            postAuthzRequest = new AuthorizeRequestPP(postAuthzFactoryName, this.getProxyID(), principal, this.getCache());
        }
        return this.setUserAuthorizeAndPostAuthorizeRequest(authzRequest, postAuthzRequest);
    }
}

