/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PrepareNewPersistentMemberMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private String regionPath;
    private PersistentMemberID oldId;
    private PersistentMemberID newId;
    private int processorId;

    public PrepareNewPersistentMemberMessage() {
    }

    public PrepareNewPersistentMemberMessage(String regionPath, PersistentMemberID oldId, PersistentMemberID newId, int processorId) {
        this.regionPath = regionPath;
        this.newId = newId;
        this.oldId = oldId;
        this.processorId = processorId;
    }

    public static void send(Set<InternalDistributedMember> members, DistributionManager dm, String regionPath, PersistentMemberID oldId, PersistentMemberID newId) throws ReplyException {
        ReplyProcessor21 processor = new ReplyProcessor21(dm, members);
        PrepareNewPersistentMemberMessage msg = new PrepareNewPersistentMemberMessage(regionPath, oldId, newId, processor.getProcessorId());
        msg.setRecipients(members);
        dm.putOutgoing(msg);
        processor.waitForRepliesUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        Object state = null;
        Object myId = null;
        ReplyException exception = null;
        try {
            Bucket proxy;
            InternalCache cache = dm.getExistingCache();
            Region region = cache.getRegion(this.regionPath);
            PersistenceAdvisor persistenceAdvisor = null;
            if (region instanceof DistributedRegion) {
                persistenceAdvisor = ((DistributedRegion)region).getPersistenceAdvisor();
            } else if (region == null && (proxy = PartitionedRegionHelper.getProxyBucketRegion(dm.getCache(), this.regionPath, false)) != null) {
                persistenceAdvisor = proxy.getPersistenceAdvisor();
            }
            if (persistenceAdvisor != null) {
                persistenceAdvisor.prepareNewMember(this.getSender(), this.oldId, this.newId);
            }
        }
        catch (RegionDestroyedException e) {
            logger.debug("<RegionDestroyed> {}", (Object)this);
        }
        catch (CancelException e) {
            logger.debug("<CancelException> {}", (Object)this);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            exception = new ReplyException(t);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
            ReplyMessage replyMsg = new ReplyMessage();
            replyMsg.setRecipient(this.getSender());
            replyMsg.setProcessorId(this.processorId);
            if (exception != null) {
                replyMsg.setException(exception);
            }
            dm.putOutgoing(replyMsg);
        }
    }

    @Override
    public int getDSFID() {
        return 2104;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regionPath = DataSerializer.readString(in);
        this.processorId = in.readInt();
        boolean hasOldId = in.readBoolean();
        if (hasOldId) {
            this.oldId = new PersistentMemberID();
            InternalDataSerializer.invokeFromData(this.oldId, in);
        }
        this.newId = new PersistentMemberID();
        InternalDataSerializer.invokeFromData(this.newId, in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.regionPath, out);
        out.writeInt(this.processorId);
        out.writeBoolean(this.oldId != null);
        if (this.oldId != null) {
            InternalDataSerializer.invokeToData(this.oldId, out);
        }
        InternalDataSerializer.invokeToData(this.newId, out);
    }
}

