/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.util.HashSet;
import java.util.Set;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.persistence.InternalPersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.MembershipChangeListener;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PersistenceInitialImageAdvisor {
    private static final Logger logger = LogService.getLogger();
    private final InternalPersistenceAdvisor persistenceAdvisor;
    private final String shortDiskStoreID;
    private final String regionPath;
    private final CacheDistributionAdvisor cacheDistributionAdvisor;
    private final boolean hasDiskImageToRecoverFrom;

    public PersistenceInitialImageAdvisor(InternalPersistenceAdvisor persistenceAdvisor, String shortDiskStoreID, String regionPath, CacheDistributionAdvisor cacheDistributionAdvisor, boolean hasDiskImageToRecoverFrom) {
        this.persistenceAdvisor = persistenceAdvisor;
        this.shortDiskStoreID = shortDiskStoreID;
        this.regionPath = regionPath;
        this.cacheDistributionAdvisor = cacheDistributionAdvisor;
        this.hasDiskImageToRecoverFrom = hasDiskImageToRecoverFrom;
    }

    /*
     * Unable to fully structure code
     */
    public CacheDistributionAdvisor.InitialImageAdvice getAdvice(CacheDistributionAdvisor.InitialImageAdvice previousAdvice) {
        isPersistAdvisorDebugEnabled = PersistenceInitialImageAdvisor.logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE);
        listener = new MembershipChangeListener(this.persistenceAdvisor);
        this.cacheDistributionAdvisor.addMembershipAndProxyListener(listener);
        this.persistenceAdvisor.addListener(listener);
        while (true) {
            block17: {
                block16: {
                    block15: {
                        this.cacheDistributionAdvisor.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
                        advice = this.cacheDistributionAdvisor.adviseInitialImage(previousAdvice, true);
                        if (!this.hasReplicates(advice)) break block15;
                        if (this.hasDiskImageToRecoverFrom) {
                            this.removeReplicatesIfWeAreEqualToAnyOrElseClearEqualMembers(advice.getReplicates());
                        }
                        var5_6 = advice;
                        this.persistenceAdvisor.setWaitingOnMembers(null, null);
                        this.cacheDistributionAdvisor.removeMembershipAndProxyListener(listener);
                        this.persistenceAdvisor.removeListener(listener);
                        return var5_6;
                    }
                    if (this.hasNonPersistentMember(advice)) {
                        this.updateMembershipViewFromAnyPeer(advice.getNonPersistent(), this.hasDiskImageToRecoverFrom);
                    }
                    if (this.hasReplicates(previousAdvice)) {
                        PersistenceInitialImageAdvisor.logger.info((Message)LocalizedMessage.create(LocalizedStrings.PersistenceAdvisorImpl_RETRYING_GII));
                        previousAdvice = null;
                        continue;
                    }
                    previouslyOnlineMembers = this.persistenceAdvisor.getPersistedOnlineOrEqualMembers();
                    if (!previouslyOnlineMembers.isEmpty()) break block16;
                    if (this.isPersistAdvisorDebugEnabled()) {
                        PersistenceInitialImageAdvisor.logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: No previously online members. Recovering with the data from the local disk", (Object)this.shortDiskStoreID, (Object)this.regionPath);
                    }
                    var6_7 = advice;
                    this.persistenceAdvisor.setWaitingOnMembers(null, null);
                    this.cacheDistributionAdvisor.removeMembershipAndProxyListener(listener);
                    this.persistenceAdvisor.removeListener(listener);
                    return var6_7;
                }
                offlineMembers = new HashSet<PersistentMemberID>();
                membersToWaitFor = this.persistenceAdvisor.getMembersToWaitFor(previouslyOnlineMembers, offlineMembers);
                if (!membersToWaitFor.isEmpty()) break block17;
                if (this.isPersistAdvisorDebugEnabled()) {
                    PersistenceInitialImageAdvisor.logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: All of the previously online members are now online and waiting for us. Acquiring tie lock. Previously online members {}", (Object)this.shortDiskStoreID, (Object)this.regionPath, advice.getReplicates());
                }
                if (!this.persistenceAdvisor.acquireTieLock()) ** GOTO lbl53
                var8_9 = this.refreshInitialImageAdviceAndThenCheckMyStateWithReplicates(previousAdvice);
                this.persistenceAdvisor.setWaitingOnMembers(null, null);
                this.cacheDistributionAdvisor.removeMembershipAndProxyListener(listener);
                this.persistenceAdvisor.removeListener(listener);
                return var8_9;
            }
            if (isPersistAdvisorDebugEnabled) {
                PersistenceInitialImageAdvisor.logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Going to wait for these member ids: {}", (Object)this.shortDiskStoreID, (Object)this.regionPath, membersToWaitFor);
            }
lbl53:
            // 4 sources

            this.waitForMembershipChangeForMissingDiskStores(listener, offlineMembers, membersToWaitFor);
            {
                catch (InterruptedException e) {
                    PersistenceInitialImageAdvisor.logger.debug("Interrupted while trying to determine latest persisted copy", (Throwable)e);
                }
            }
            continue;
            break;
        }
        catch (Throwable var9_10) {
            this.persistenceAdvisor.setWaitingOnMembers(null, null);
            this.cacheDistributionAdvisor.removeMembershipAndProxyListener(listener);
            this.persistenceAdvisor.removeListener(listener);
            throw var9_10;
        }
    }

    private void updateMembershipViewFromAnyPeer(Set<InternalDistributedMember> peers, boolean recoverFromDisk) {
        for (InternalDistributedMember peer : peers) {
            try {
                this.persistenceAdvisor.updateMembershipView(peer, recoverFromDisk);
                return;
            }
            catch (ReplyException e) {
                if (!logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) continue;
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "Failed to update membership view", (Throwable)e);
            }
        }
    }

    private CacheDistributionAdvisor.InitialImageAdvice refreshInitialImageAdviceAndThenCheckMyStateWithReplicates(CacheDistributionAdvisor.InitialImageAdvice previousAdvice) {
        CacheDistributionAdvisor.InitialImageAdvice advice;
        if (this.isPersistAdvisorDebugEnabled()) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Acquired the lock. This member will initialize", (Object)this.shortDiskStoreID, (Object)this.regionPath);
        }
        if (this.hasReplicates(advice = this.cacheDistributionAdvisor.adviseInitialImage(previousAdvice, true))) {
            if (this.isPersistAdvisorDebugEnabled()) {
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: Another member has initialized while we were getting the lock. We will initialize from that member", (Object)this.shortDiskStoreID, (Object)this.regionPath);
            }
            this.persistenceAdvisor.checkMyStateOnMembers(advice.getReplicates());
        }
        return advice;
    }

    private boolean hasNonPersistentMember(CacheDistributionAdvisor.InitialImageAdvice advice) {
        return !advice.getNonPersistent().isEmpty();
    }

    private void removeReplicatesIfWeAreEqualToAnyOrElseClearEqualMembers(Set<InternalDistributedMember> replicates) {
        boolean weAreEqualToAReplicate;
        if (this.isPersistAdvisorDebugEnabled()) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: There are members currently online. Checking for our state on those members and then initializing", (Object)this.shortDiskStoreID, (Object)this.regionPath);
        }
        if (weAreEqualToAReplicate = this.persistenceAdvisor.checkMyStateOnMembers(replicates)) {
            this.removeReplicates(replicates);
        } else {
            this.persistenceAdvisor.clearEqualMembers();
        }
    }

    private boolean hasReplicates(CacheDistributionAdvisor.InitialImageAdvice advice) {
        return advice != null && !advice.getReplicates().isEmpty();
    }

    private void removeReplicates(Set<InternalDistributedMember> replicates) {
        if (this.isPersistAdvisorDebugEnabled()) {
            logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: We have the same data on disk as one of {} recovering gracefully", (Object)this.shortDiskStoreID, (Object)this.regionPath, replicates);
        }
        replicates.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMembershipChangeForMissingDiskStores(MembershipChangeListener listener, Set<PersistentMemberID> offlineMembers, Set<PersistentMemberID> membersToWaitFor) throws InterruptedException {
        this.persistenceAdvisor.beginWaitingForMembershipChange(membersToWaitFor);
        try {
            this.persistenceAdvisor.setWaitingOnMembers(membersToWaitFor, offlineMembers);
            listener.waitForChange();
        }
        finally {
            this.persistenceAdvisor.endWaitingForMembershipChange();
        }
    }

    private boolean isPersistAdvisorDebugEnabled() {
        return logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE);
    }
}

