/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import org.apache.geode.internal.cache.partitioned.rebalance.model.BucketRollup;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Member;
import org.apache.geode.internal.cache.partitioned.rebalance.model.MemberRollup;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Move;
import org.apache.geode.internal.cache.partitioned.rebalance.model.PartitionedRegionLoadModel;
import org.apache.geode.internal.cache.partitioned.rebalance.model.RefusalReason;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ExplicitMoveDirector
extends RebalanceDirectorAdapter {
    private PartitionedRegionLoadModel model;
    private final int bucketId;
    private final InternalDistributedMember source;
    private final InternalDistributedMember target;
    private final Object key;
    private InternalDistributedSystem ds;

    public ExplicitMoveDirector(Object key, int bucketId, DistributedMember source, DistributedMember target, DistributedSystem distributedSystem) {
        this.key = key;
        this.bucketId = bucketId;
        this.source = (InternalDistributedMember)source;
        this.target = (InternalDistributedMember)target;
        this.ds = (InternalDistributedSystem)distributedSystem;
    }

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        BucketRollup bucket = this.model.getBuckets()[this.bucketId];
        MemberRollup sourceMember = this.model.getMember(this.source);
        MemberRollup targetMember = this.model.getMember(this.target);
        if (sourceMember == null) {
            throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_SOURCE_NOT_DATA_STORE.toLocalizedString(this.model.getName(), this.source));
        }
        if (targetMember == null) {
            throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_TARGET_NOT_DATA_STORE.toLocalizedString(this.model.getName(), this.target));
        }
        if (bucket == null) {
            throw new IllegalStateException("The bucket for key " + this.key + ", bucket " + this.bucketId + ", region " + this.model.getName() + " does not exist");
        }
        if (!bucket.getMembersHosting().contains(sourceMember)) {
            throw new IllegalStateException("The bucket for key " + this.key + ", bucket " + this.bucketId + ", region " + this.model.getName() + " is not hosted by " + this.source + ". Members hosting: " + bucket.getMembersHosting());
        }
        RefusalReason reason = ((Member)targetMember).willAcceptBucket(bucket, sourceMember, this.model.enforceUniqueZones());
        if (reason.willAccept()) {
            if (!this.model.moveBucket(new Move(sourceMember, targetMember, bucket))) {
                Set<InternalDistributedMember> allMembers = this.ds.getDistributionManager().getDistributionManagerIdsIncludingAdmin();
                if (!allMembers.contains(sourceMember)) {
                    throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_SOURCE_NOT_DATA_STORE.toLocalizedString(this.model.getName(), this.source));
                }
                if (!allMembers.contains(targetMember)) {
                    throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_TARGET_NOT_DATA_STORE.toLocalizedString(this.model.getName(), this.target));
                }
                throw new IllegalStateException("Unable to move bucket " + bucket + " from " + sourceMember + " to " + targetMember);
            }
        } else {
            throw new IllegalStateException("Unable to move bucket for " + this.model.getName() + ". " + reason.formatMessage(targetMember, bucket));
        }
        return false;
    }
}

