/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.map;

import java.util.List;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXRmtEvent;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.map.AbstractRegionMapPut;
import org.apache.geode.internal.cache.map.FocusedRegionMap;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.logging.log4j.Logger;

public class RegionMapCommitPut
extends AbstractRegionMapPut {
    private static final Logger logger = LogService.getLogger();
    private final boolean onlyExisting;
    private final boolean didDestroy;
    private final TXRmtEvent txEvent;
    private final List<EntryEventImpl> pendingCallbacks;
    private final TXEntryState txEntryState;
    private final boolean remoteOrigin;
    private final boolean invokeCallbacks;
    private boolean callbackEventInPending;
    private Operation putOp;

    public RegionMapCommitPut(FocusedRegionMap focusedRegionMap, InternalRegion owner, EntryEventImpl callbackEvent, Operation putOp, boolean didDestroy, TransactionId txId, TXRmtEvent txEvent, List<EntryEventImpl> pendingCallbacks, TXEntryState txEntryState) {
        super(focusedRegionMap, owner, callbackEvent);
        this.putOp = putOp;
        this.didDestroy = didDestroy;
        this.txEvent = txEvent;
        this.pendingCallbacks = pendingCallbacks;
        this.txEntryState = txEntryState;
        this.remoteOrigin = !txId.getMemberId().equals(owner.getMyId());
        this.invokeCallbacks = this.shouldInvokeCallbacks();
        boolean isTXHost = txEntryState != null;
        this.onlyExisting = this.remoteOrigin && !isTXHost && (!owner.isAllEvents() || !putOp.isCreate() && this.isOwnerInitialized());
    }

    boolean isRemoteOrigin() {
        return this.remoteOrigin;
    }

    boolean isInvokeCallbacks() {
        return this.invokeCallbacks;
    }

    private Operation getPutOp() {
        return this.putOp;
    }

    private boolean isPutOpCreate() {
        return this.getPutOp().isCreate();
    }

    private boolean shouldInvokeCallbacks() {
        InternalRegion owner = this.getOwner();
        boolean isPartitioned = owner.isUsedForPartitionedRegionBucket();
        if (isPartitioned) {
            owner = owner.getPartitionedRegion();
        }
        return !(!isPartitioned && !this.isOwnerInitialized() || !owner.shouldDispatchListenerEvent() && !owner.shouldNotifyBridgeClients() && !owner.getConcurrencyChecksEnabled());
    }

    private void setCallbackEventInPending(boolean v) {
        this.callbackEventInPending = v;
    }

    boolean isCallbackEventInPending() {
        return this.callbackEventInPending;
    }

    private void makePutOpCreate() {
        this.putOp = this.putOp.getCorrespondingCreateOp();
    }

    private void makePutOpUpdate() {
        this.putOp = this.putOp.getCorrespondingUpdateOp();
    }

    @Override
    protected boolean isOnlyExisting() {
        return this.onlyExisting;
    }

    @Override
    protected boolean entryExists(RegionEntry regionEntry) {
        return regionEntry != null && !regionEntry.isDestroyedOrRemoved();
    }

    @Override
    protected void serializeNewValueIfNeeded() {
    }

    @Override
    protected void runWhileLockedForCacheModification(Runnable r) {
        r.run();
    }

    @Override
    protected void setOldValueForDelta() {
    }

    @Override
    protected void setOldValueInEvent() {
        if (this.isCreate()) {
            this.makePutOpCreate();
        } else if (!this.getRegionEntry().isDestroyedOrRemoved()) {
            this.makePutOpUpdate();
        } else {
            this.makePutOpCreate();
        }
        if (this.isPutOpCreate()) {
            this.getEvent().makeCreate();
            this.getEvent().setOldValue(null);
        } else {
            this.getEvent().makeUpdate();
            Object oldValue = this.getRegionEntry().getValueInVM(this.getOwner());
            this.getEvent().setOldValue(oldValue);
        }
    }

    @Override
    protected void unsetOldValueForDelta() {
    }

    @Override
    protected boolean checkPreconditions() {
        return !this.isOnlyExisting() || !this.isPutOpCreate();
    }

    @Override
    protected void invokeCacheWriter() {
    }

    @Override
    protected void createOrUpdateEntry() {
        RegionEntry regionEntry = this.getRegionEntry();
        EntryEventImpl callbackEvent = this.getEvent();
        InternalRegion owner = this.getOwner();
        FocusedRegionMap regionMap = this.getRegionMap();
        Object key = callbackEvent.getKey();
        Object newValue = RegionMapCommitPut.computeNewValue(callbackEvent);
        int oldSize = this.isPutOpCreate() ? 0 : owner.calculateRegionEntryValueSize(regionEntry);
        callbackEvent.setRegionEntry(regionEntry);
        regionMap.txRemoveOldIndexEntry(this.getPutOp(), regionEntry);
        this.setLastModifiedTime(owner.cacheTimeMillis());
        if (this.didDestroy) {
            regionEntry.txDidDestroy(this.getLastModifiedTime());
        }
        if (this.txEvent != null) {
            this.txEvent.addPut(this.getPutOp(), owner, regionEntry, key, newValue, callbackEvent.getCallbackArgument());
        }
        regionEntry.setValueResultOfSearch(this.getPutOp().isNetSearch());
        try {
            regionMap.processAndGenerateTXVersionTag(callbackEvent, regionEntry, this.txEntryState);
            this.setNewValueOnRegionEntry(newValue);
            int newSize = owner.calculateRegionEntryValueSize(regionEntry);
            if (this.isPutOpCreate()) {
                owner.updateSizeOnCreate(key, newSize);
            } else {
                owner.updateSizeOnPut(key, oldSize, newSize);
            }
        }
        catch (RegionClearedException rce) {
            this.setClearOccurred(true);
        }
        EntryLogger.logTXPut(owner, key, newValue);
    }

    private void setNewValueOnRegionEntry(Object newValue) throws RegionClearedException {
        RegionEntry regionEntry = this.getRegionEntry();
        InternalRegion owner = this.getOwner();
        boolean wasTombstone = regionEntry.isTombstone();
        Object preparedValue = regionEntry.prepareValueForCache(owner, newValue, this.getEvent(), !this.isPutOpCreate());
        regionEntry.setValue(owner, preparedValue);
        if (wasTombstone) {
            owner.unscheduleTombstone(regionEntry);
        }
    }

    private static Object computeNewValue(EntryEventImpl callbackEvent) {
        Object newValue = callbackEvent.getRawNewValueAsHeapObject();
        if (newValue == null) {
            newValue = callbackEvent.isLocalInvalid() ? Token.LOCAL_INVALID : Token.INVALID;
        }
        return newValue;
    }

    @Override
    protected boolean shouldCreatedEntryBeRemoved() {
        return !this.isCompleted();
    }

    @Override
    protected void doBeforeCompletionActions() {
        RegionEntry regionEntry = this.getRegionEntry();
        EntryEventImpl callbackEvent = this.getEvent();
        InternalRegion owner = this.getOwner();
        FocusedRegionMap regionMap = this.getRegionMap();
        Object key = callbackEvent.getKey();
        regionEntry.updateStatsForPut(this.getLastModifiedTime(), this.getLastModifiedTime());
        owner.txApplyPutPart2(regionEntry, key, this.getLastModifiedTime(), this.isPutOpCreate(), this.didDestroy, this.isClearOccurred());
        if (this.isInvokeCallbacks()) {
            callbackEvent.changeRegionToBucketsOwner();
            callbackEvent.setOriginRemote(this.isRemoteOrigin());
            this.pendingCallbacks.add(callbackEvent);
            this.setCallbackEventInPending(true);
        }
        if (!this.isClearOccurred()) {
            if (this.isCreate()) {
                regionMap.lruEntryCreate(regionEntry);
                regionMap.incEntryCount(1);
            } else {
                regionMap.lruEntryUpdate(regionEntry);
            }
        }
    }

    @Override
    protected void doAfterCompletionActions() {
        if (this.isOnlyExisting() && !this.isCompleted()) {
            if (this.didDestroy) {
                this.getOwner().txApplyPutHandleDidDestroy(this.getEvent().getKey());
            }
            if (this.isInvokeCallbacks()) {
                this.getEvent().makeUpdate();
                this.getOwner().invokeTXCallbacks(EnumListenerEvent.AFTER_UPDATE, this.getEvent(), false);
            }
        }
        if (this.getOwner().getConcurrencyChecksEnabled() && this.txEntryState != null) {
            this.txEntryState.setVersionTag(this.getEvent().getVersionTag());
        }
        if (!this.isCallbackEventInPending()) {
            this.getEvent().release();
        }
    }
}

