/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.map;

import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.map.FocusedRegionMap;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRegionMapPut {
    private static final Logger logger = LogService.getLogger();
    private final InternalRegion owner;
    private final FocusedRegionMap focusedRegionMap;
    private final EntryEventImpl event;
    private final boolean ownerInitialized;
    private boolean clearOccurred;
    private long lastModifiedTime;
    private RegionEntry regionEntry;
    private boolean create;
    private boolean completed;

    public AbstractRegionMapPut(FocusedRegionMap focusedRegionMap, InternalRegion owner, EntryEventImpl event) {
        this.focusedRegionMap = focusedRegionMap;
        this.owner = owner;
        this.event = event;
        this.ownerInitialized = owner.isInitialized();
    }

    protected boolean isOwnerInitialized() {
        return this.ownerInitialized;
    }

    protected boolean isClearOccurred() {
        return this.clearOccurred;
    }

    protected void setClearOccurred(boolean v) {
        this.clearOccurred = v;
    }

    protected long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    protected void setLastModifiedTime(long v) {
        this.lastModifiedTime = v;
    }

    protected RegionEntry getRegionEntry() {
        return this.regionEntry;
    }

    private void setRegionEntry(RegionEntry v) {
        this.regionEntry = v;
    }

    protected boolean isCreate() {
        return this.create;
    }

    private void setCreate(boolean v) {
        this.create = v;
    }

    protected EntryEventImpl getEvent() {
        return this.event;
    }

    protected boolean isCompleted() {
        return this.completed;
    }

    private void setCompleted(boolean b) {
        this.completed = b;
    }

    protected InternalRegion getOwner() {
        return this.owner;
    }

    protected FocusedRegionMap getRegionMap() {
        return this.focusedRegionMap;
    }

    protected abstract boolean isOnlyExisting();

    protected abstract boolean entryExists(RegionEntry var1);

    protected abstract void serializeNewValueIfNeeded();

    protected abstract void runWhileLockedForCacheModification(Runnable var1);

    protected abstract void setOldValueForDelta();

    protected abstract void setOldValueInEvent();

    protected abstract void unsetOldValueForDelta();

    protected abstract boolean checkPreconditions();

    protected abstract void invokeCacheWriter();

    protected abstract void createOrUpdateEntry();

    protected abstract boolean shouldCreatedEntryBeRemoved();

    protected abstract void doBeforeCompletionActions();

    protected abstract void doAfterCompletionActions();

    public RegionEntry put() {
        this.serializeNewValueIfNeeded();
        this.runWhileLockedForCacheModification(this::doPut);
        if (this.isCompleted()) {
            return this.getRegionEntry();
        }
        return null;
    }

    private void doPut() {
        try {
            this.doWithIndexInUpdateMode(this::doPutRetryingIfNeeded);
        }
        catch (DiskAccessException dae) {
            this.getOwner().handleDiskAccessException(dae);
            throw dae;
        }
        finally {
            this.doAfterCompletionActions();
        }
    }

    private void doWithIndexInUpdateMode(Runnable r) {
        IndexManager oqlIndexManager = this.getInitializedIndexManager();
        if (oqlIndexManager != null) {
            try {
                r.run();
            }
            finally {
                oqlIndexManager.countDownIndexUpdaters();
            }
        } else {
            r.run();
        }
    }

    private IndexManager getInitializedIndexManager() {
        IndexManager oqlIndexManager = this.getOwner().getIndexManager();
        if (oqlIndexManager != null) {
            oqlIndexManager.waitForIndexInit();
        }
        return oqlIndexManager;
    }

    private void doPutRetryingIfNeeded() {
        do {
            if (!this.findAndSaveExistingEntry()) {
                return;
            }
            this.createNewEntryIfNeeded();
        } while (!this.addRegionEntryToMapAndDoPut());
    }

    private boolean findAndSaveExistingEntry() {
        RegionEntry re = this.getRegionMap().getEntry(this.getEvent());
        if (this.isOnlyExisting() && !this.entryExists(re)) {
            this.setRegionEntry(null);
            return false;
        }
        this.setRegionEntry(re);
        return true;
    }

    private void createNewEntryIfNeeded() {
        this.setCreate(this.getRegionEntry() == null);
        if (this.isCreate()) {
            Object key = this.getEvent().getKey();
            RegionEntry newEntry = this.getRegionMap().getEntryFactory().createEntry(this.getOwner(), key, Token.REMOVED_PHASE1);
            this.setRegionEntry(newEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addRegionEntryToMapAndDoPut() {
        RegionEntry regionEntry = this.getRegionEntry();
        synchronized (regionEntry) {
            this.putIfAbsentNewEntry();
            return this.doPutOnRegionEntryInMap();
        }
    }

    private void putIfAbsentNewEntry() {
        RegionEntry oldRe;
        if (this.isCreate() && (oldRe = this.getRegionMap().putEntryIfAbsent(this.getEvent().getKey(), this.getRegionEntry())) != null) {
            this.setCreate(false);
            this.setRegionEntry(oldRe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPutOnRegionEntryInMap() {
        RegionEntry regionEntry = this.getRegionEntry();
        synchronized (regionEntry) {
            if (this.isRegionEntryRemoved()) {
                return false;
            }
            this.doPutOnSynchronizedRegionEntry();
            return true;
        }
    }

    private void doPutOnSynchronizedRegionEntry() {
        this.setOldValueForDelta();
        try {
            this.setOldValueInEvent();
            this.doPutIfPreconditionsSatisified();
        }
        finally {
            this.unsetOldValueForDelta();
            if (this.isCreate() && this.shouldCreatedEntryBeRemoved()) {
                this.getRegionMap().removeEntry(this.getEvent().getKey(), this.getRegionEntry(), false);
            }
        }
    }

    private void doPutIfPreconditionsSatisified() {
        if (!this.checkPreconditions()) {
            return;
        }
        this.invokeCacheWriter();
        this.runWithIndexUpdatingInProgress(this::doPutAndDeliverEvent);
    }

    private void doPutAndDeliverEvent() {
        this.createOrUpdateEntry();
        this.doBeforeCompletionActions();
        this.setCompleted(true);
    }

    private void runWithIndexUpdatingInProgress(Runnable r) {
        this.notifyIndex(true);
        try {
            r.run();
        }
        finally {
            this.notifyIndex(false);
        }
    }

    private void notifyIndex(boolean isUpdating) {
        if (this.getOwner().getIndexMaintenanceSynchronous()) {
            this.getRegionEntry().setUpdateInProgress(isUpdating);
        }
    }

    private boolean isRegionEntryRemoved() {
        RegionEntry re = this.getRegionEntry();
        if (re.isRemovedPhase2()) {
            this.getOwner().getCachePerfStats().incRetries();
            this.getRegionMap().getEntryMap().remove(this.getEvent().getKey(), re);
            return true;
        }
        return false;
    }
}

