/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.ha;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class HARegionQueueStats {
    private static final StatisticsType _type;
    protected static final String EVENTS_QUEUED = "eventsQueued";
    protected static final String EVENTS_CONFLATED = "eventsConflated";
    protected static final String MARKER_EVENTS_CONFLATED = "markerEventsConflated";
    protected static final String EVENTS_REMOVED = "eventsRemoved";
    protected static final String EVENTS_TAKEN = "eventsTaken";
    protected static final String EVENTS_EXPIRED = "eventsExpired";
    protected static final String EVENTS_REMOVED_BY_QRM = "eventsRemovedByQrm";
    protected static final String THREAD_IDENTIFIERS = "threadIdentifiers";
    protected static final String EVENTS_DISPATCHED = "eventsDispatched";
    protected static final String NUM_VOID_REMOVALS = "numVoidRemovals";
    protected static final String NUM_SEQUENCE_VIOLATED = "numSequenceViolated";
    private static final int _eventsQueuedId;
    private static final int _eventsConflatedId;
    private static final int _markerEventsConflatedId;
    private static final int _eventsRemovedId;
    private static final int _eventsTakenId;
    private static final int _eventsExpiredId;
    private static final int _eventsRemovedByQrmId;
    private static final int _threadIdentifiersId;
    private static final int _eventsDispatched;
    private static final int _numVoidRemovals;
    private static final int _numSequenceViolated;
    private final Statistics _stats;

    public HARegionQueueStats(StatisticsFactory factory, String name) {
        this._stats = factory.createAtomicStatistics(_type, "ClientSubscriptionStats-" + name);
    }

    public void close() {
        this._stats.close();
    }

    public long getEventsEnqued() {
        return this._stats.getLong(_eventsQueuedId);
    }

    public void incEventsEnqued() {
        this._stats.incLong(_eventsQueuedId, 1L);
    }

    public long getEventsConflated() {
        return this._stats.getLong(_eventsConflatedId);
    }

    public void incEventsConflated() {
        this._stats.incLong(_eventsConflatedId, 1L);
    }

    public long getMarkerEventsConflated() {
        return this._stats.getLong(_markerEventsConflatedId);
    }

    public void incMarkerEventsConflated() {
        this._stats.incLong(_markerEventsConflatedId, 1L);
    }

    public long getEventsRemoved() {
        return this._stats.getLong(_eventsRemovedId);
    }

    public void incEventsRemoved() {
        this._stats.incLong(_eventsRemovedId, 1L);
    }

    public long getEventsTaken() {
        return this._stats.getLong(_eventsTakenId);
    }

    public void incEventsTaken() {
        this._stats.incLong(_eventsTakenId, 1L);
    }

    public long getEventsExpired() {
        return this._stats.getLong(_eventsExpiredId);
    }

    public void incEventsExpired() {
        this._stats.incLong(_eventsExpiredId, 1L);
    }

    public long getEventsRemovedByQrm() {
        return this._stats.getLong(_eventsRemovedByQrmId);
    }

    public void incEventsRemovedByQrm() {
        this._stats.incLong(_eventsRemovedByQrmId, 1L);
    }

    public int getThreadIdentiferCount() {
        return this._stats.getInt(_threadIdentifiersId);
    }

    public void incThreadIdentifiers() {
        this._stats.incInt(_threadIdentifiersId, 1);
    }

    public void decThreadIdentifiers() {
        this._stats.incInt(_threadIdentifiersId, -1);
    }

    public long getEventsDispatched() {
        return this._stats.getLong(_eventsDispatched);
    }

    public void incEventsDispatched() {
        this._stats.incLong(_eventsDispatched, 1L);
    }

    public long getNumVoidRemovals() {
        return this._stats.getLong(_numVoidRemovals);
    }

    public void incNumVoidRemovals() {
        this._stats.incLong(_numVoidRemovals, 1L);
    }

    public long getNumSequenceViolated() {
        return this._stats.getLong(_numSequenceViolated);
    }

    public void incNumSequenceViolated() {
        this._stats.incLong(_numSequenceViolated, 1L);
    }

    public boolean isClosed() {
        return this._stats.isClosed();
    }

    static {
        String statName = "ClientSubscriptionStats";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        _type = f.createType(statName, statName, new StatisticDescriptor[]{f.createLongCounter(EVENTS_QUEUED, "Number of events added to queue.", "operations"), f.createLongCounter(EVENTS_CONFLATED, "Number of events conflated for the queue.", "operations"), f.createLongCounter(MARKER_EVENTS_CONFLATED, "Number of marker events conflated for the queue.", "operations"), f.createLongCounter(EVENTS_REMOVED, "Number of events removed from the queue.", "operations"), f.createLongCounter(EVENTS_TAKEN, "Number of events taken from the queue.", "operations"), f.createLongCounter(EVENTS_EXPIRED, "Number of events expired from the queue.", "operations"), f.createLongCounter(EVENTS_REMOVED_BY_QRM, "Number of events removed by QRM message.", "operations"), f.createIntCounter(THREAD_IDENTIFIERS, "Number of ThreadIdenfier objects for the queue.", "units"), f.createLongCounter(EVENTS_DISPATCHED, "Number of events that have been dispatched.", "operations"), f.createLongCounter(NUM_VOID_REMOVALS, "Number of void removals from the queue.", "operations"), f.createLongCounter(NUM_SEQUENCE_VIOLATED, "Number of events that has violated sequence.", "operations")});
        _eventsQueuedId = _type.nameToId(EVENTS_QUEUED);
        _eventsConflatedId = _type.nameToId(EVENTS_CONFLATED);
        _markerEventsConflatedId = _type.nameToId(MARKER_EVENTS_CONFLATED);
        _eventsRemovedId = _type.nameToId(EVENTS_REMOVED);
        _eventsTakenId = _type.nameToId(EVENTS_TAKEN);
        _eventsExpiredId = _type.nameToId(EVENTS_EXPIRED);
        _eventsRemovedByQrmId = _type.nameToId(EVENTS_REMOVED_BY_QRM);
        _threadIdentifiersId = _type.nameToId(THREAD_IDENTIFIERS);
        _eventsDispatched = _type.nameToId(EVENTS_DISPATCHED);
        _numVoidRemovals = _type.nameToId(NUM_VOID_REMOVALS);
        _numSequenceViolated = _type.nameToId(NUM_SEQUENCE_VIOLATED);
    }
}

