/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ServerToClientFunctionResultSender65
extends ServerToClientFunctionResultSender {
    private static final Logger logger = LogService.getLogger();

    public ServerToClientFunctionResultSender65(ChunkedMessage msg, int messageType2, ServerConnection sc, Function function, ExecuteFunctionOperationContext authzContext) {
        super(msg, messageType2, sc, function, authzContext);
    }

    @Override
    public synchronized void lastResult(Object oneResult) {
        block11: {
            if (this.lastResultReceived) {
                return;
            }
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 not sending lastResult {} as the server has shutdown", oneResult);
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 sending lastResult {}", oneResult);
                }
                InternalDistributedMember memberID = InternalDistributedSystem.getAnyInstance().getDistributionManager().getId();
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(oneResult);
                result.add(memberID);
                this.setBuffer();
                this.msg.setServerConnection(this.sc);
                if (oneResult instanceof InternalFunctionException) {
                    this.msg.setNumberOfParts(2);
                    this.msg.setLastChunkAndNumParts(true, 2);
                } else {
                    this.msg.setNumberOfParts(1);
                    this.msg.setLastChunkAndNumParts(true, 1);
                }
                this.msg.addObjPart(result);
                if (oneResult instanceof InternalFunctionException) {
                    ArrayList<Object> result2 = new ArrayList<Object>();
                    result2.add(BaseCommand.getExceptionTrace((Throwable)oneResult));
                    result2.add(memberID);
                    this.msg.addObjPart(result2);
                }
                this.msg.sendChunk(this.sc);
                this.lastResultReceived = true;
                this.sc.setAsTrue(1);
                FunctionStats.getFunctionStats(this.fn.getId()).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block11;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_LAST_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    @Override
    public synchronized void lastResult(Object oneResult, DistributedMember memberID) {
        block12: {
            if (this.lastResultReceived) {
                return;
            }
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 not sending lastResult {} as the server has shutdown", oneResult);
                }
                return;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender sending last result2 {} " + oneResult);
                }
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 sending lastResult {}", oneResult);
                }
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(oneResult);
                result.add(memberID);
                this.setBuffer();
                this.msg.setServerConnection(this.sc);
                if (oneResult instanceof InternalFunctionException) {
                    this.msg.setNumberOfParts(2);
                    this.msg.setLastChunkAndNumParts(true, 2);
                } else {
                    this.msg.setNumberOfParts(1);
                    this.msg.setLastChunkAndNumParts(true, 1);
                }
                this.msg.addObjPart(result);
                if (oneResult instanceof InternalFunctionException) {
                    ArrayList<Object> result2 = new ArrayList<Object>();
                    result2.add(BaseCommand.getExceptionTrace((Throwable)oneResult));
                    result2.add(memberID);
                    this.msg.addObjPart(result2);
                }
                this.msg.sendChunk(this.sc);
                this.lastResultReceived = true;
                this.sc.setAsTrue(1);
                FunctionStats.getFunctionStats(this.fn.getId()).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block12;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_LAST_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    @Override
    public synchronized void sendResult(Object oneResult) {
        block8: {
            if (this.lastResultReceived) {
                return;
            }
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 not sending result {}  as the server has shutdown", oneResult);
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 sending result {}", oneResult);
                }
                InternalDistributedMember memberID = InternalDistributedSystem.getAnyInstance().getDistributionManager().getId();
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(oneResult);
                result.add(memberID);
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(result);
                this.msg.sendChunk(this.sc);
                FunctionStats.getFunctionStats(this.fn.getId()).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block8;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_RESULT_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    @Override
    public synchronized void sendResult(Object oneResult, DistributedMember memberID) {
        block8: {
            if (this.lastResultReceived) {
                return;
            }
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 not sending result {}  as the server has shutdown", oneResult);
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 sending result {}", oneResult);
                }
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(oneResult);
                result.add(memberID);
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(result);
                this.msg.sendChunk(this.sc);
                FunctionStats.getFunctionStats(this.fn.getId()).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block8;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_RESULT_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    @Override
    protected void writeFunctionExceptionResponse(ChunkedMessage message, String errormessage, Throwable e) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug(" ServerToClientFunctionResultSender sending Function Error Response : {}", (Object)errormessage);
        }
        int numParts = 0;
        message.clear();
        if (e instanceof FunctionException && e.getCause() instanceof InternalFunctionInvocationTargetException) {
            message.setNumberOfParts(3);
            message.addObjPart(e);
            message.addStringPart(BaseCommand.getExceptionTrace(e));
            InternalFunctionInvocationTargetException fe = (InternalFunctionInvocationTargetException)e.getCause();
            message.addObjPart(fe.getFailedNodeSet());
            numParts = 3;
        } else {
            if (e instanceof FunctionException && e.getCause() instanceof QueryInvalidException) {
                e = new FunctionException(e.getLocalizedMessage());
            }
            message.setNumberOfParts(2);
            message.addObjPart(e);
            message.addStringPart(BaseCommand.getExceptionTrace(e));
            numParts = 2;
        }
        message.setServerConnection(this.sc);
        message.setLastChunkAndNumParts(true, numParts);
        message.sendChunk(this.sc);
        this.sc.setAsTrue(1);
    }
}

