/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ServerToClientFunctionResultSender
implements ResultSender {
    private static final Logger logger = LogService.getLogger();
    protected ChunkedMessage msg = null;
    protected ServerConnection sc = null;
    protected int messageType = -1;
    protected volatile boolean headerSent = false;
    protected Function fn;
    protected ExecuteFunctionOperationContext authContext;
    protected InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
    protected AtomicBoolean alreadySendException = new AtomicBoolean(false);
    protected boolean lastResultReceived;
    protected ByteBuffer commBuffer;
    protected boolean isSelector;

    public synchronized void setLastResultReceived(boolean lastResultReceived) {
        this.lastResultReceived = lastResultReceived;
    }

    public boolean isLastResultReceived() {
        return this.lastResultReceived;
    }

    public ServerToClientFunctionResultSender(ChunkedMessage msg, int messageType2, ServerConnection sc, Function function, ExecuteFunctionOperationContext authzContext) {
        this.msg = msg;
        this.msg.setVersion(sc.getClientVersion());
        this.messageType = messageType2;
        this.sc = sc;
        this.fn = function;
        this.authContext = authzContext;
        this.isSelector = sc.getAcceptor().isSelector();
        if (this.isSelector) {
            this.commBuffer = msg.getCommBuffer();
        }
    }

    public synchronized void lastResult(Object oneResult) {
        block9: {
            if (this.lastResultReceived) {
                return;
            }
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender not sending lastResult {} as the server has shutdown", oneResult);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ServerToClientFunctionResultSender sending last result1 {} " + oneResult);
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender sending lastResult {}", oneResult);
                }
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(oneResult);
                this.msg.setLastChunk(true);
                this.msg.sendChunk(this.sc);
                this.lastResultReceived = true;
                this.sc.setAsTrue(1);
                FunctionStats.getFunctionStats(this.fn.getId()).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block9;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_LAST_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    public synchronized void lastResult(Object oneResult, DistributedMember memberID) {
        block9: {
            if (this.lastResultReceived) {
                return;
            }
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender not sending lastResult {} as the server has shutdown", oneResult);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ServerToClientFunctionResultSender sending last result2 {} " + oneResult);
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender sending lastResult {}", oneResult);
                }
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(oneResult);
                this.msg.setLastChunk(true);
                this.msg.sendChunk(this.sc);
                this.lastResultReceived = true;
                this.sc.setAsTrue(1);
                FunctionStats.getFunctionStats(this.fn.getId()).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block9;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_LAST_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    public synchronized void sendResult(Object oneResult) {
        block9: {
            if (this.lastResultReceived) {
                return;
            }
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender not sending result {} as the server has shutdown", oneResult);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ServerToClientFunctionResultSender sending result1 {} " + oneResult);
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender sending result {}", oneResult);
                }
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(oneResult);
                this.msg.sendChunk(this.sc);
                FunctionStats.getFunctionStats(this.fn.getId()).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block9;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_RESULT_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    public synchronized void sendResult(Object oneResult, DistributedMember memberID) {
        block9: {
            if (this.lastResultReceived) {
                return;
            }
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender not sending result {} as the server has shutdown", oneResult);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ServerToClientFunctionResultSender sending result2 {} " + oneResult);
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender sending result {}", oneResult);
                }
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(oneResult);
                this.msg.sendChunk(this.sc);
                FunctionStats.getFunctionStats(this.fn.getId()).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block9;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_RESULT_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    protected void authorizeResult(Object oneResult) throws IOException {
        AuthorizeRequestPP authzRequestPP = this.sc.getPostAuthzRequest();
        if (authzRequestPP != null) {
            this.authContext.setIsPostOperation(true);
            this.authContext = authzRequestPP.executeFunctionAuthorize(oneResult, this.authContext);
        }
    }

    protected void writeFunctionExceptionResponse(ChunkedMessage message, String errormessage, Throwable e) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("ServerToClientFunctionResultSender sending Function Error Response: {}", (Object)errormessage);
        }
        message.clear();
        message.setLastChunk(true);
        message.addObjPart(e);
        message.sendChunk(this.sc);
        this.sc.setAsTrue(1);
    }

    protected void sendHeader() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("ServerToClientFunctionResultSender sending header");
        }
        this.setBuffer();
        this.msg.setMessageType(this.messageType);
        this.msg.setLastChunk(false);
        this.msg.setNumberOfParts(1);
        this.msg.sendHeader();
        this.headerSent = true;
    }

    @Override
    public void sendException(Throwable exception) {
        InternalFunctionException iFunxtionException = new InternalFunctionException(exception);
        this.lastResult(iFunxtionException);
        this.lastResultReceived = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setException(Throwable exception) {
        if (this.lastResultReceived) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ServerToClientFunctionResultSender setting exception {} ", exception);
        }
        ChunkedMessage chunkedMessage = this.msg;
        synchronized (chunkedMessage) {
            if (!this.sc.getTransientFlag(1)) {
                this.alreadySendException.set(true);
                try {
                    if (!this.headerSent) {
                        this.sendHeader();
                    }
                    String exceptionMessage = exception.getMessage() != null ? exception.getMessage() : "Exception occurred during function execution";
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, this.fn), exception);
                    if (logger.isDebugEnabled()) {
                        logger.debug("ServerToClientFunctionResultSender sending Function Exception : ");
                    }
                    this.writeFunctionExceptionResponse(this.msg, exceptionMessage, exception);
                    this.lastResultReceived = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isOkayToSendResult() {
        return this.sc.getAcceptor().isRunning() && !this.ids.isDisconnecting() && !this.sc.getCachedRegionHelper().getCache().isClosed() && !this.alreadySendException.get();
    }

    protected void setBuffer() {
        if (this.isSelector) {
            org.apache.geode.internal.cache.tier.sockets.Message.setTLCommBuffer(this.commBuffer);
        }
    }
}

