/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Set;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.internal.ExecuteFunctionNoAckOp;
import org.apache.geode.cache.client.internal.ExecuteFunctionOp;
import org.apache.geode.cache.client.internal.GetFunctionAttributeOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DefaultResultCollector;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.NoResult;
import org.apache.geode.internal.cache.execute.util.SynchronizedResultCollector;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ServerFunctionExecutor
extends AbstractExecution {
    private PoolImpl pool;
    private final boolean allServers;
    private String[] groups;

    public ServerFunctionExecutor(Pool p, boolean allServers, String ... groups) {
        this.pool = (PoolImpl)p;
        this.allServers = allServers;
        this.groups = groups;
    }

    public ServerFunctionExecutor(Pool p, boolean allServers, ProxyCache proxyCache, String ... groups) {
        this.pool = (PoolImpl)p;
        this.allServers = allServers;
        this.proxyCache = proxyCache;
        this.groups = groups;
    }

    public ServerFunctionExecutor(ServerFunctionExecutor sfe) {
        super(sfe);
        if (sfe.pool != null) {
            this.pool = sfe.pool;
        }
        this.allServers = sfe.allServers;
        this.groups = sfe.groups;
    }

    private ServerFunctionExecutor(ServerFunctionExecutor sfe, Object args) {
        this(sfe);
        this.args = args;
    }

    private ServerFunctionExecutor(ServerFunctionExecutor sfe, ResultCollector collector) {
        this(sfe);
        this.rc = collector != null ? new SynchronizedResultCollector(collector) : collector;
    }

    private ServerFunctionExecutor(ServerFunctionExecutor sfe, MemberMappedArgument argument) {
        this(sfe);
        this.memberMappedArg = argument;
        this.isMemberMappedArgument = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultCollector executeFunction(String functionId, boolean result, boolean isHA, boolean optimizeForWrite) {
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            byte hasResult = 0;
            if (result) {
                hasResult = 1;
                if (this.rc == null) {
                    DefaultResultCollector defaultCollector = new DefaultResultCollector();
                    ResultCollector resultCollector = this.executeOnServer(functionId, defaultCollector, hasResult, isHA, optimizeForWrite);
                    return resultCollector;
                }
                ResultCollector resultCollector = this.executeOnServer(functionId, this.rc, hasResult, isHA, optimizeForWrite);
                return resultCollector;
            }
            this.executeOnServerNoAck(functionId, hasResult, isHA, optimizeForWrite);
            NoResult noResult = new NoResult();
            return noResult;
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResultCollector executeFunction(Function function) {
        byte hasResult = 0;
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            if (function.hasResult()) {
                hasResult = 1;
                if (this.rc == null) {
                    DefaultResultCollector defaultCollector = new DefaultResultCollector();
                    ResultCollector resultCollector = this.executeOnServer(function, defaultCollector, hasResult);
                    return resultCollector;
                }
                ResultCollector resultCollector = this.executeOnServer(function, this.rc, hasResult);
                return resultCollector;
            }
            this.executeOnServerNoAck(function, hasResult);
            NoResult noResult = new NoResult();
            return noResult;
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
    }

    private ResultCollector executeOnServer(Function function, ResultCollector rc, byte hasResult) {
        FunctionStats stats = FunctionStats.getFunctionStats(function.getId());
        try {
            this.validateExecution(function, null);
            long start = stats.startTime();
            stats.startFunctionExecution(true);
            ExecuteFunctionOp.execute(this.pool, function, this, this.args, this.memberMappedArg, this.allServers, hasResult, rc, this.isFnSerializationReqd, UserAttributes.userAttributes.get(), this.groups);
            stats.endFunctionExecution(start, true);
            rc.endResults();
            return rc;
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(true);
            throw functionException;
        }
        catch (ServerConnectivityException exception) {
            throw exception;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(true);
            throw new FunctionException(exception);
        }
    }

    private ResultCollector executeOnServer(String functionId, ResultCollector rc, byte hasResult, boolean isHA, boolean optimizeForWrite) {
        FunctionStats stats = FunctionStats.getFunctionStats(functionId);
        try {
            this.validateExecution(null, null);
            long start = stats.startTime();
            stats.startFunctionExecution(true);
            ExecuteFunctionOp.execute(this.pool, functionId, this, this.args, this.memberMappedArg, this.allServers, hasResult, rc, this.isFnSerializationReqd, isHA, optimizeForWrite, UserAttributes.userAttributes.get(), this.groups);
            stats.endFunctionExecution(start, true);
            rc.endResults();
            return rc;
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(true);
            throw functionException;
        }
        catch (ServerConnectivityException exception) {
            throw exception;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(true);
            throw new FunctionException(exception);
        }
    }

    private void executeOnServerNoAck(Function function, byte hasResult) {
        FunctionStats stats = FunctionStats.getFunctionStats(function.getId());
        try {
            this.validateExecution(function, null);
            long start = stats.startTime();
            stats.startFunctionExecution(false);
            ExecuteFunctionNoAckOp.execute(this.pool, function, this.args, this.memberMappedArg, this.allServers, hasResult, this.isFnSerializationReqd, this.groups);
            stats.endFunctionExecution(start, false);
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(false);
            throw functionException;
        }
        catch (ServerConnectivityException exception) {
            throw exception;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(false);
            throw new FunctionException(exception);
        }
    }

    private void executeOnServerNoAck(String functionId, byte hasResult, boolean isHA, boolean optimizeForWrite) {
        FunctionStats stats = FunctionStats.getFunctionStats(functionId);
        try {
            this.validateExecution(null, null);
            long start = stats.startTime();
            stats.startFunctionExecution(false);
            ExecuteFunctionNoAckOp.execute(this.pool, functionId, this.args, this.memberMappedArg, this.allServers, hasResult, this.isFnSerializationReqd, isHA, optimizeForWrite, this.groups);
            stats.endFunctionExecution(start, false);
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(false);
            throw functionException;
        }
        catch (ServerConnectivityException exception) {
            throw exception;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(false);
            throw new FunctionException(exception);
        }
    }

    public Pool getPool() {
        return this.pool;
    }

    public Execution withFilter(Set filter) {
        throw new FunctionException(LocalizedStrings.ExecuteFunction_CANNOT_SPECIFY_0_FOR_DATA_INDEPENDENT_FUNCTIONS.toLocalizedString("filter"));
    }

    @Override
    public InternalExecution withBucketFilter(Set<Integer> bucketIDs) {
        throw new FunctionException(LocalizedStrings.ExecuteFunction_CANNOT_SPECIFY_0_FOR_DATA_INDEPENDENT_FUNCTIONS.toLocalizedString("buckets as filter"));
    }

    public Execution setArguments(Object args) {
        if (args == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("args"));
        }
        return new ServerFunctionExecutor(this, args);
    }

    public Execution withArgs(Object args) {
        return this.setArguments(args);
    }

    public Execution withCollector(ResultCollector rs) {
        if (rs == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("Result Collector"));
        }
        return new ServerFunctionExecutor(this, rs);
    }

    @Override
    public InternalExecution withMemberMappedArgument(MemberMappedArgument argument) {
        if (argument == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("MemberMapped Args"));
        }
        return new ServerFunctionExecutor(this, argument);
    }

    @Override
    public void validateExecution(Function function, Set targetMembers) {
        if (TXManagerImpl.getCurrentTXUniqueId() != -1) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCollector execute(String functionName) {
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        this.isFnSerializationReqd = false;
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            byte[] functionAttributes = this.getFunctionAttributes(functionName);
            if (functionAttributes == null) {
                try {
                    if (this.proxyCache != null) {
                        if (this.proxyCache.isClosed()) {
                            throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                        }
                        UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
                    }
                    Object obj = GetFunctionAttributeOp.execute(this.pool, functionName);
                    functionAttributes = (byte[])obj;
                    this.addFunctionAttributes(functionName, functionAttributes);
                }
                finally {
                    UserAttributes.userAttributes.set(null);
                }
            }
            boolean isHA = functionAttributes[1] == 1;
            boolean hasResult = functionAttributes[0] == 1;
            boolean optimizeForWrite = functionAttributes[2] == 1;
            return this.executeFunction(functionName, hasResult, isHA, optimizeForWrite);
        }
        return this.executeFunction(functionObject);
    }
}

