/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.MemberFunctionStreamingMessage;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalResultSender;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class MemberFunctionResultSender
implements InternalResultSender {
    private static final Logger logger = LogService.getLogger();
    MemberFunctionStreamingMessage msg = null;
    private final DistributionManager dm;
    private ResultCollector rc;
    private final Function function;
    private boolean localLastResultReceived = false;
    private boolean onlyLocal = false;
    private boolean onlyRemote = false;
    private boolean completelyDoneFromRemote = false;
    private boolean enableOrderedResultStreming;
    private ServerToClientFunctionResultSender serverSender;

    public MemberFunctionResultSender(DistributionManager dm, MemberFunctionStreamingMessage msg, Function function) {
        this.msg = msg;
        this.dm = dm;
        this.function = function;
    }

    public MemberFunctionResultSender(DistributionManager dm, ResultCollector rc, Function function, boolean onlyLocal, boolean onlyRemote, ServerToClientFunctionResultSender sender) {
        this.dm = dm;
        this.rc = rc;
        this.function = function;
        this.onlyLocal = onlyLocal;
        this.onlyRemote = onlyRemote;
        this.serverSender = sender;
    }

    @Override
    public void lastResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.serverSender != null) {
            if (this.localLastResultReceived) {
                return;
            }
            if (this.onlyLocal) {
                this.serverSender.lastResult(oneResult);
                this.rc.endResults();
                this.localLastResultReceived = true;
            } else {
                this.lastResult(oneResult, this.rc, false, true, this.dm.getId());
            }
        } else if (this.msg != null) {
            try {
                this.msg.sendReplyForOneResult(this.dm, oneResult, true, this.enableOrderedResultStreming);
            }
            catch (QueryException e) {
                throw new FunctionException(e);
            }
            catch (ForceReattemptException e) {
                throw new FunctionException(e);
            }
            catch (InterruptedException e) {
                throw new FunctionException(e);
            }
        } else {
            if (this.localLastResultReceived) {
                return;
            }
            if (this.onlyLocal) {
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                this.rc.endResults();
                this.localLastResultReceived = true;
            } else {
                this.lastResult(oneResult, this.rc, false, true, this.dm.getDistributionManagerId());
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
        }
        FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
    }

    private synchronized void lastResult(Object oneResult, ResultCollector collector, boolean lastRemoteResult, boolean lastLocalResult, DistributedMember memberID) {
        if (lastRemoteResult) {
            this.completelyDoneFromRemote = true;
        }
        if (lastLocalResult) {
            this.localLastResultReceived = true;
        }
        if (this.serverSender != null) {
            if (this.completelyDoneFromRemote && this.localLastResultReceived) {
                this.serverSender.lastResult(oneResult, memberID);
                collector.endResults();
            } else {
                this.serverSender.sendResult(oneResult, memberID);
            }
        } else if (this.completelyDoneFromRemote && this.localLastResultReceived) {
            collector.addResult(memberID, oneResult);
            collector.endResults();
        } else {
            collector.addResult(memberID, oneResult);
        }
    }

    public void lastResult(Object oneResult, boolean completelyDone, ResultCollector reply, DistributedMember memberID) {
        if (this.serverSender != null) {
            if (completelyDone) {
                if (this.onlyRemote) {
                    this.serverSender.lastResult(oneResult, memberID);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                this.serverSender.sendResult(oneResult, memberID);
            }
        } else {
            if (completelyDone) {
                if (this.onlyRemote) {
                    reply.addResult(memberID, oneResult);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                reply.addResult(memberID, oneResult);
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
        }
        FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
    }

    @Override
    public void sendResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.serverSender != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("MemberFunctionResultSender sending result from local node to client {}", oneResult);
            }
            this.serverSender.sendResult(oneResult);
        } else {
            if (this.msg != null) {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, false, this.enableOrderedResultStreming);
                }
                catch (QueryException e) {
                    throw new FunctionException(e);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            } else {
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    @Override
    public void sendException(Throwable exception) {
        InternalFunctionException iFunxtionException = new InternalFunctionException(exception);
        this.lastResult(iFunxtionException);
        this.localLastResultReceived = true;
    }

    @Override
    public void setException(Throwable exception) {
        ((LocalResultCollector)this.rc).setException(exception);
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.MemberResultSender_UNEXPECTED_EXCEPTION_DURING_FUNCTION_EXECUTION_ON_LOCAL_NODE), exception);
        this.rc.endResults();
        this.localLastResultReceived = true;
    }

    @Override
    public void enableOrderedResultStreming(boolean enable) {
        this.enableOrderedResultStreming = enable;
    }

    @Override
    public boolean isLocallyExecuted() {
        return this.msg == null;
    }

    @Override
    public boolean isLastResultReceived() {
        return this.localLastResultReceived;
    }
}

