/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;

public class FunctionRemoteContext
implements DataSerializable {
    private Set filter;
    private Object args;
    private Set<Integer> bucketSet;
    private boolean isReExecute;
    private boolean isFnSerializationReqd;
    private String functionId;
    private Function function;

    public FunctionRemoteContext() {
    }

    public FunctionRemoteContext(Function function, Object object, Set filter, Set<Integer> bucketSet, boolean isReExecute, boolean isFnSerializationReqd) {
        this.function = function;
        this.args = object;
        this.filter = filter;
        this.bucketSet = bucketSet;
        this.isReExecute = isReExecute;
        this.isFnSerializationReqd = isFnSerializationReqd;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        Object object = DataSerializer.readObject(in);
        if (object instanceof String) {
            this.isFnSerializationReqd = false;
            this.function = FunctionService.getFunction((String)object);
            if (this.function == null) {
                this.functionId = (String)object;
            }
        } else {
            this.function = (Function)object;
            this.isFnSerializationReqd = true;
        }
        this.args = DataSerializer.readObject(in);
        this.filter = DataSerializer.readHashSet(in);
        this.bucketSet = DataSerializer.readHashSet(in);
        this.isReExecute = DataSerializer.readBoolean(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (this.isFnSerializationReqd) {
            DataSerializer.writeObject(this.function, out);
        } else {
            DataSerializer.writeObject(this.function.getId(), out);
        }
        DataSerializer.writeObject(this.args, out);
        DataSerializer.writeHashSet((HashSet)this.filter, out);
        DataSerializer.writeHashSet((HashSet)this.bucketSet, out);
        DataSerializer.writeBoolean(this.isReExecute, out);
    }

    public Set getFilter() {
        return this.filter;
    }

    public Object getArgs() {
        return this.args;
    }

    public Set<Integer> getBucketSet() {
        return this.bucketSet;
    }

    public boolean isReExecute() {
        return this.isReExecute;
    }

    public Function getFunction() {
        return this.function;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("{FunctionRemoteContext ");
        buff.append("functionId=" + this.functionId);
        buff.append(" args=" + this.args);
        buff.append(" isReExecute=" + this.isReExecute);
        buff.append(" filter=" + this.filter);
        buff.append(" bucketSet=" + this.bucketSet + "}");
        return buff.toString();
    }
}

