/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import java.util.Optional;
import org.apache.geode.internal.cache.eviction.AbstractEvictionList;
import org.apache.geode.internal.cache.eviction.EvictableEntry;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionNode;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class LRUListWithSyncSorting
extends AbstractEvictionList {
    private static final Logger logger = LogService.getLogger();
    private final int maxEntries = this.readMaxEntriesProperty();

    public LRUListWithSyncSorting(EvictionController controller) {
        super(controller);
    }

    private int readMaxEntriesProperty() {
        int result = -1;
        Optional<Integer> optionalMaxEntries = SystemPropertyHelper.getProductIntegerProperty("lru.maxSearchEntries");
        if (optionalMaxEntries.isPresent()) {
            result = optionalMaxEntries.get();
        }
        return result;
    }

    @Override
    public EvictableEntry getEvictableEntry() {
        EvictionNode aNode;
        long numEvals;
        block7: {
            numEvals = 0L;
            while (true) {
                aNode = this.unlinkHeadEntry();
                if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
                    logger.trace(LogMarker.LRU_CLOCK_VERBOSE, "lru considering {}", (Object)aNode);
                }
                if (aNode == null) {
                    this.getStatistics().incEvaluations(numEvals);
                    return null;
                }
                ++numEvals;
                if (!this.isEvictable(aNode)) continue;
                if (this.maxEntries > 0 && numEvals > (long)this.maxEntries) {
                    if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
                        logger.trace(LogMarker.LRU_CLOCK_VERBOSE, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_GREEDILY_PICKING_AN_AVAILABLE_ENTRY));
                    }
                    this.getStatistics().incGreedyReturns(1L);
                    break block7;
                }
                if (!aNode.isRecentlyUsed()) break;
                if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
                    logger.trace(LogMarker.LRU_CLOCK_VERBOSE, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_SKIPPING_RECENTLY_USED_ENTRY, aNode));
                }
                aNode.unsetRecentlyUsed();
                this.appendEntry(aNode);
            }
            if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
                logger.trace(LogMarker.LRU_CLOCK_VERBOSE, (Message)LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_RETURNING_UNUSED_ENTRY, aNode));
            }
        }
        this.getStatistics().incEvaluations(numEvals);
        return (EvictableEntry)aNode;
    }

    @Override
    public void incrementRecentlyUsed() {
    }
}

