/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.eviction.AbstractEvictionController;
import org.apache.geode.internal.cache.eviction.EvictionCounters;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CountLRUEviction
extends AbstractEvictionController {
    private volatile int maximumEntries;

    public CountLRUEviction(EvictionCounters evictionCounters, int maximumEntries, EvictionAction evictionAction, EvictionAlgorithm algorithm) {
        super(evictionCounters, evictionAction, algorithm);
        this.setMaximumEntries(maximumEntries);
    }

    private void setMaximumEntries(int maximumEntries) {
        if (maximumEntries <= 0) {
            throw new IllegalArgumentException(LocalizedStrings.LRUCapacityController_MAXIMUM_ENTRIES_MUST_BE_POSITIVE.toLocalizedString());
        }
        this.maximumEntries = maximumEntries;
        this.getCounters().setLimit(maximumEntries);
    }

    @Override
    public void setLimit(int max) {
        this.setMaximumEntries(max);
    }

    @Override
    public long getLimit() {
        return this.maximumEntries;
    }

    @Override
    public int entrySize(Object key, Object value) {
        if (Token.isRemoved(value)) {
            return 0;
        }
        if ((value == null || value == Token.INVALID || value == Token.LOCAL_INVALID) && this.getEvictionAction().isOverflowToDisk()) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean mustEvict(EvictionCounters stats, InternalRegion region, int delta) {
        return stats.getCounter() + (long)delta > stats.getLimit();
    }

    @Override
    public boolean lruLimitExceeded(EvictionCounters stats, DiskRegionView diskRegionView) {
        return stats.getCounter() > stats.getLimit();
    }

    @Override
    public String toString() {
        return LocalizedStrings.LRUCapacityController_LRUCAPACITYCONTROLLER_WITH_A_CAPACITY_OF_0_ENTRIES_AND_EVICTION_ACTION_1.toLocalizedString(this.getLimit(), this.getEvictionAction());
    }
}

