/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedThinDiskLRURegionEntry;
import org.apache.geode.internal.cache.entries.VersionedThinDiskLRURegionEntryHeap;
import org.apache.geode.internal.cache.entries.VersionedThinDiskLRURegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedThinDiskLRURegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedThinDiskLRURegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedThinDiskLRURegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedThinDiskLRURegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedThinDiskLRURegionEntryOffHeapUUIDKey;

public abstract class VersionedThinDiskLRURegionEntryOffHeap
extends VersionedThinDiskLRURegionEntry
implements OffHeapRegionEntry {
    private static final VersionedThinDiskLRURegionEntryOffHeapFactory factory = new VersionedThinDiskLRURegionEntryOffHeapFactory();

    public VersionedThinDiskLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinDiskLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedThinDiskLRURegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinDiskLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinDiskLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinDiskLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinDiskLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinDiskLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinDiskLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedThinDiskLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedThinDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

