/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.CancelException;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.util.GatewayConflictHelper;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.ImageState;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TimestampedEntryEventImpl;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.TombstoneService;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.entries.HashRegionEntry;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.eviction.EvictionList;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.Releasable;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.internal.util.Versionable;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxSerializable;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.internal.ConvertableToBytes;
import org.apache.geode.pdx.internal.PdxInstanceImpl;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractRegionEntry
implements HashRegionEntry<Object, Object> {
    private static final Logger logger = LogService.getLogger();
    protected static final boolean DISABLE_ACCESS_TIME_UPDATE_ON_PUT = Boolean.getBoolean("gemfire.disableAccessTimeUpdateOnPut");
    private static final long VALUE_RESULT_OF_SEARCH = 0x100000000000000L;
    private static final long UPDATE_IN_PROGRESS = 0x200000000000000L;
    private static final long LISTENER_INVOCATION_IN_PROGRESS = 0x800000000000000L;
    protected static final long RECENTLY_USED = 0x1000000000000000L;
    protected static final long EVICTED = 0x2000000000000000L;
    private static final long IN_USE_BY_TX = 0x4000000000000000L;
    private static final long LAST_MODIFIED_MASK = 0xFFFFFFFFFFFFFFL;

    protected AbstractRegionEntry(RegionEntryContext context, Object value) {
        this.setValue(context, this.prepareValueForCache(context, value, false), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatchListenerEvents(EntryEventImpl event) throws InterruptedException {
        InternalRegion rgn = event.getRegion();
        if (event.callbacksInvoked()) {
            return true;
        }
        event.setCallbacksInvokedByCurrentThread();
        if (logger.isDebugEnabled()) {
            logger.debug("{} dispatching event {}", (Object)this, (Object)event);
        }
        try {
            event.invokeCallbacks(rgn, event.inhibitCacheListenerNotification(), false);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.isRemoved() && !this.isTombstone() && !event.isEvicted()) {
                this.removePhase2();
                ((DiskRecoveryStore)((Object)rgn)).getRegionMap().removeEntry(event.getKey(), this, true, event, rgn);
            }
        }
    }

    @Override
    public long getLastAccessed() throws InternalStatisticsDisabledException {
        throw new InternalStatisticsDisabledException();
    }

    @Override
    public long getHitCount() throws InternalStatisticsDisabledException {
        throw new InternalStatisticsDisabledException();
    }

    @Override
    public long getMissCount() throws InternalStatisticsDisabledException {
        throw new InternalStatisticsDisabledException();
    }

    public void setLastModified(long lastModified) {
        this.setLastModifiedAndAccessedTimes(lastModified, lastModified);
    }

    protected void setLastModifiedAndAccessedTimes(long lastModified, long lastAccessed) {
        this._setLastModified(lastModified);
    }

    @Override
    public void txDidDestroy(long currentTime) {
        this.setLastModifiedAndAccessedTimes(currentTime, currentTime);
    }

    @Override
    public void updateStatsForPut(long lastModifiedTime, long lastAccessedTime) {
        this.setLastModifiedAndAccessedTimes(lastModifiedTime, lastAccessedTime);
    }

    @Override
    public void setRecentlyUsed(RegionEntryContext context) {
    }

    @Override
    public void updateStatsForGet(boolean hit, long time) {
    }

    @Override
    public void resetCounts() throws InternalStatisticsDisabledException {
        throw new InternalStatisticsDisabledException();
    }

    void _removePhase1() {
        this._setValue(Token.REMOVED_PHASE1);
    }

    @Override
    public void removePhase1(InternalRegion region, boolean clear) throws RegionClearedException {
        this._removePhase1();
    }

    @Override
    public void removePhase2() {
        this._setValue(Token.REMOVED_PHASE2);
    }

    @Override
    public void makeTombstone(InternalRegion region, VersionTag version) throws RegionClearedException {
        assert (region.getVersionVector() != null);
        assert (version != null);
        if (region.getServerProxy() == null && region.getVersionVector().isTombstoneTooOld(version.getMemberID(), version.getRegionVersion())) {
            if (!this.isTombstone()) {
                this.basicMakeTombstone(region);
                region.getCachePerfStats().incTombstoneCount(1);
            }
            ((DiskRecoveryStore)((Object)region)).getRegionMap().removeTombstone(this, version, false, true);
        } else {
            if (this.isTombstone()) {
                region.unscheduleTombstone(this);
            }
            this.setRecentlyUsed(region);
            boolean newEntry = this.getValueAsToken() == Token.REMOVED_PHASE1;
            this.basicMakeTombstone(region);
            region.scheduleTombstone(this, version);
            if (newEntry) {
                region.getCachePerfStats().incEntryCount(1);
            }
        }
    }

    private void basicMakeTombstone(InternalRegion region) throws RegionClearedException {
        boolean setValueCompleted = false;
        try {
            this.setValue(region, Token.TOMBSTONE);
            setValueCompleted = true;
        }
        finally {
            if (!setValueCompleted && this.isTombstone()) {
                this.removePhase2();
            }
        }
    }

    @Override
    public void setValueWithTombstoneCheck(Object v, EntryEvent e) throws RegionClearedException {
        if (v == Token.TOMBSTONE) {
            this.makeTombstone((InternalRegion)e.getRegion(), ((InternalCacheEvent)((Object)e)).getVersionTag());
        } else {
            this.setValue((RegionEntryContext)((Object)e.getRegion()), v, (EntryEventImpl)e);
        }
    }

    @Override
    public boolean isRemoved() {
        Token o = this.getValueAsToken();
        return o == Token.REMOVED_PHASE1 || o == Token.REMOVED_PHASE2 || o == Token.TOMBSTONE;
    }

    @Override
    public boolean isDestroyedOrRemoved() {
        return Token.isRemoved(this.getValueAsToken());
    }

    @Override
    public boolean isDestroyedOrRemovedButNotTombstone() {
        Token o = this.getValueAsToken();
        return o == Token.DESTROYED || o == Token.REMOVED_PHASE1 || o == Token.REMOVED_PHASE2;
    }

    @Override
    public boolean isTombstone() {
        return this.getValueAsToken() == Token.TOMBSTONE;
    }

    @Override
    public boolean isRemovedPhase2() {
        return this.getValueAsToken() == Token.REMOVED_PHASE2;
    }

    @Override
    public boolean fillInValue(InternalRegion region, InitialImageOperation.Entry entry, ByteArrayDataInput in, DistributionManager mgr, Version version) {
        Object v;
        entry.setSerialized(false);
        if (this.isTombstone()) {
            v = Token.TOMBSTONE;
        } else {
            v = this.getValue(region);
            if (v == null) {
                return false;
            }
        }
        entry.setLastModified(mgr, this.getLastModified());
        if (v == Token.INVALID) {
            entry.setInvalid();
        } else if (v == Token.LOCAL_INVALID) {
            entry.setLocalInvalid();
        } else if (v == Token.TOMBSTONE) {
            entry.setTombstone();
        } else if (v instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)v;
            if (!cd.isSerialized()) {
                entry.setValue(cd.getDeserializedForReading());
            } else {
                Object tmp = cd.getValue();
                if (tmp instanceof byte[]) {
                    entry.setValue(tmp);
                } else {
                    try {
                        HeapDataOutputStream hdos = new HeapDataOutputStream(version);
                        BlobHelper.serializeTo(tmp, hdos);
                        hdos.trim();
                        entry.setValue(hdos);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(LocalizedStrings.AbstractRegionEntry_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString(), e);
                    }
                }
                entry.setSerialized(true);
            }
        } else if (v instanceof byte[]) {
            entry.setValue(v);
        } else {
            Object preparedValue = v;
            if (preparedValue != null && (preparedValue = AbstractRegionEntry.prepareValueForGII(preparedValue)) == null) {
                return false;
            }
            try {
                HeapDataOutputStream hdos = new HeapDataOutputStream(version);
                BlobHelper.serializeTo(preparedValue, hdos);
                hdos.trim();
                entry.setValue(hdos);
                entry.setSerialized(true);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(LocalizedStrings.AbstractRegionEntry_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString(), e);
            }
        }
        return true;
    }

    static Object prepareValueForGII(Object v) {
        assert (v != null);
        if (v instanceof GatewaySenderEventImpl) {
            return ((GatewaySenderEventImpl)v).makeHeapCopyIfOffHeap();
        }
        return v;
    }

    @Override
    public boolean isOverflowedToDisk(InternalRegion region, DistributedRegion.DiskPosition diskPosition) {
        return false;
    }

    @Override
    public Object getValue(RegionEntryContext context) {
        ReferenceCountHelper.createReferenceCountOwner();
        Object result = this.getValueRetain(context, true);
        if (Token.isRemoved(result)) {
            ReferenceCountHelper.setReferenceCountOwner(null);
            return null;
        }
        result = OffHeapHelper.copyAndReleaseIfNeeded(result, context.getCache());
        ReferenceCountHelper.setReferenceCountOwner(null);
        this.setRecentlyUsed(context);
        return result;
    }

    @Override
    public Object getValueRetain(RegionEntryContext context) {
        Object result = this.getValueRetain(context, true);
        if (Token.isRemoved(result)) {
            return null;
        }
        this.setRecentlyUsed(context);
        return result;
    }

    @Override
    public void setValue(RegionEntryContext context, Object value) throws RegionClearedException {
        this.setValue(context, value, true);
    }

    @Override
    public void setValue(RegionEntryContext context, Object value, EntryEventImpl event) throws RegionClearedException {
        this.setValue(context, value);
    }

    protected void setValue(RegionEntryContext context, Object value, boolean recentlyUsed) {
        this._setValue(value);
        this.releaseOffHeapRefIfRegionBeingClosedOrDestroyed(context, value);
        if (recentlyUsed) {
            this.setRecentlyUsed(context);
        }
    }

    void releaseOffHeapRefIfRegionBeingClosedOrDestroyed(RegionEntryContext context, Object ref) {
        if (this.isOffHeapReference(ref) && this.isThisRegionBeingClosedOrDestroyed(context)) {
            ((Releasable)((Object)this)).release();
        }
    }

    private boolean isThisRegionBeingClosedOrDestroyed(RegionEntryContext context) {
        return context instanceof InternalRegion && ((InternalRegion)context).isThisRegionBeingClosedOrDestroyed();
    }

    private boolean isOffHeapReference(Object ref) {
        return ref != Token.REMOVED_PHASE1 && this instanceof OffHeapRegionEntry && ref instanceof StoredObject && ((StoredObject)ref).hasRefCount();
    }

    static Object decompress(RegionEntryContext context, Object value) {
        if (AbstractRegionEntry.isCompressible(context, value)) {
            long time = context.getCachePerfStats().startDecompression();
            value = EntryEventImpl.deserialize(context.getCompressor().decompress((byte[])value));
            context.getCachePerfStats().endDecompression(time);
        }
        return value;
    }

    protected static Object compress(RegionEntryContext context, Object value) {
        return AbstractRegionEntry.compress(context, value, null);
    }

    protected static Object compress(RegionEntryContext context, Object value, EntryEventImpl event) {
        if (AbstractRegionEntry.isCompressible(context, value)) {
            byte[] serializedValue;
            long time = context.getCachePerfStats().startCompression();
            if (event != null && event.getCachedSerializedNewValue() != null) {
                serializedValue = event.getCachedSerializedNewValue();
                if (value instanceof CachedDeserializable) {
                    CachedDeserializable cd = (CachedDeserializable)value;
                    serializedValue = !(cd.getValue() instanceof byte[]) ? EntryEventImpl.serialize(CachedDeserializableFactory.create(serializedValue, context.getCache())) : EntryEventImpl.serialize(cd);
                }
            } else {
                serializedValue = EntryEventImpl.serialize(value);
                if (event != null && !(value instanceof byte[])) {
                    if (value instanceof CachedDeserializable) {
                        CachedDeserializable cd = (CachedDeserializable)value;
                        Object cdVal = cd.getValue();
                        if (cdVal instanceof byte[]) {
                            event.setCachedSerializedNewValue((byte[])cdVal);
                        }
                    } else {
                        event.setCachedSerializedNewValue(serializedValue);
                    }
                }
            }
            value = context.getCompressor().compress(serializedValue);
            context.getCachePerfStats().endCompression(time, serializedValue.length, ((byte[])value).length);
        }
        return value;
    }

    private static byte[] compressBytes(RegionEntryContext context, byte[] uncompressedBytes) {
        byte[] result = uncompressedBytes;
        if (AbstractRegionEntry.isCompressible(context, uncompressedBytes)) {
            long time = context.getCachePerfStats().startCompression();
            result = context.getCompressor().compress(uncompressedBytes);
            context.getCachePerfStats().endCompression(time, uncompressedBytes.length, result.length);
        }
        return result;
    }

    @Override
    public Object getValueInVM(RegionEntryContext context) {
        ReferenceCountHelper.createReferenceCountOwner();
        Object v = this.getValueRetain(context, true);
        if (v == null) {
            v = Token.NOT_AVAILABLE;
        }
        Object result = OffHeapHelper.copyAndReleaseIfNeeded(v, context.getCache());
        ReferenceCountHelper.setReferenceCountOwner(null);
        return result;
    }

    @Override
    public Object getValueInVMOrDiskWithoutFaultIn(InternalRegion region) {
        return this.getValueInVM(region);
    }

    @Override
    public Object getValueOffHeapOrDiskWithoutFaultIn(InternalRegion region) {
        Object result = this.getValueRetain(region, true);
        return result;
    }

    @Override
    public Object getValueOnDisk(InternalRegion region) throws EntryNotFoundException {
        throw new IllegalStateException(LocalizedStrings.AbstractRegionEntry_CANNOT_GET_VALUE_ON_DISK_FOR_A_REGION_THAT_DOES_NOT_ACCESS_THE_DISK.toLocalizedString());
    }

    @Override
    public Object getSerializedValueOnDisk(InternalRegion region) throws EntryNotFoundException {
        throw new IllegalStateException(LocalizedStrings.AbstractRegionEntry_CANNOT_GET_VALUE_ON_DISK_FOR_A_REGION_THAT_DOES_NOT_ACCESS_THE_DISK.toLocalizedString());
    }

    @Override
    public Object getValueOnDiskOrBuffer(InternalRegion region) throws EntryNotFoundException {
        throw new IllegalStateException(LocalizedStrings.AbstractRegionEntry_CANNOT_GET_VALUE_ON_DISK_FOR_A_REGION_THAT_DOES_NOT_ACCESS_THE_DISK.toLocalizedString());
    }

    @Override
    public boolean initialImagePut(InternalRegion region, long lastModified, Object newValue, boolean wasRecovered, boolean acceptedVersionTag) throws RegionClearedException {
        return this.initialImageInit(region, lastModified, newValue, this.isTombstone(), wasRecovered, acceptedVersionTag);
    }

    @Override
    public boolean initialImageInit(InternalRegion region, long lastModified, Object newValue, boolean create, boolean wasRecovered, boolean acceptedVersionTag) throws RegionClearedException {
        boolean result = false;
        Token vTok = this.getValueAsToken();
        if (acceptedVersionTag || create || vTok != Token.DESTROYED || vTok != Token.TOMBSTONE) {
            boolean putValue;
            Object newValueToWrite = newValue;
            boolean bl = putValue = acceptedVersionTag || create || newValueToWrite != Token.LOCAL_INVALID && (wasRecovered || vTok == Token.LOCAL_INVALID);
            if (region.isUsedForPartitionedRegionAdmin() && newValueToWrite instanceof CachedDeserializable) {
                newValueToWrite = ((CachedDeserializable)newValueToWrite).getDeserializedValue(region, null);
                if (!create && newValueToWrite instanceof Versionable) {
                    Object oldValue = this.getValueInVM(region);
                    if (oldValue == null) {
                        putValue = true;
                    } else if (oldValue instanceof Versionable) {
                        Versionable nv = (Versionable)newValueToWrite;
                        Versionable ov = (Versionable)oldValue;
                        putValue = nv.isNewerThan(ov);
                    }
                }
            }
            if (putValue) {
                if (create || acceptedVersionTag) {
                    ImageState imageState = region.getImageState();
                    if (imageState.getRegionInvalidated()) {
                        if (newValueToWrite != Token.TOMBSTONE) {
                            newValueToWrite = Token.INVALID;
                        }
                    } else if (imageState.getClearRegionFlag()) {
                        boolean entryOK = false;
                        RegionVersionVector rvv = imageState.getClearRegionVersionVector();
                        if (rvv != null) {
                            Object id = this.getVersionStamp().getMemberID();
                            if (id == null) {
                                id = region.getVersionMember();
                            }
                            if (!rvv.contains(id, this.getVersionStamp().getRegionVersion())) {
                                entryOK = true;
                            }
                        }
                        if (!entryOK) {
                            newValueToWrite = Token.DESTROYED;
                            imageState.addDestroyedEntry(this.getKey());
                            throw new RegionClearedException(LocalizedStrings.AbstractRegionEntry_DURING_THE_GII_PUT_OF_ENTRY_THE_REGION_GOT_CLEARED_SO_ABORTING_THE_OPERATION.toLocalizedString());
                        }
                    }
                }
                this.setValue(region, this.prepareValueForCache(region, newValueToWrite, false));
                result = true;
                if (newValueToWrite != Token.TOMBSTONE) {
                    if (create) {
                        region.getCachePerfStats().incCreates();
                    }
                    region.updateStatsForPut(this, lastModified, false);
                }
                if (logger.isTraceEnabled()) {
                    if (newValueToWrite instanceof CachedDeserializable) {
                        logger.trace("ProcessChunk: region={}; put a CachedDeserializable ({},{})", (Object)region.getFullPath(), this.getKey(), (Object)((CachedDeserializable)newValueToWrite).getStringForm());
                    } else {
                        logger.trace("ProcessChunk: region={}; put({},{})", (Object)region.getFullPath(), this.getKey(), (Object)StringUtils.forceToString(newValueToWrite));
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy(InternalRegion region, EntryEventImpl event, boolean inTokenMode, boolean cacheWrite, Object expectedOldValue, boolean forceDestroy, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException, RegionClearedException {
        boolean proceed;
        ReferenceCountHelper.skipRefCountTracking();
        Object curValue = this.getValueRetain(region, true);
        ReferenceCountHelper.unskipRefCountTracking();
        try {
            if (curValue == null) {
                curValue = Token.NOT_AVAILABLE;
            }
            if (curValue == Token.NOT_AVAILABLE) {
                if (event.getCallbackArgument() != null && event.getCallbackArgument().equals("WAN_QUEUE_TOKEN") && event.isOriginRemote()) {
                    curValue = this.getValueOnDiskOrBuffer(region);
                } else {
                    FilterProfile fp = region.getFilterProfile();
                    if (fp != null && (fp.getCqCount() > 0 || expectedOldValue != null)) {
                        curValue = this.getValueOnDiskOrBuffer(region);
                    }
                }
            }
            if (expectedOldValue != null && !AbstractRegionEntry.checkExpectedOldValue(expectedOldValue, curValue, region)) {
                throw new EntryNotFoundException(LocalizedStrings.AbstractRegionEntry_THE_CURRENT_VALUE_WAS_NOT_EQUAL_TO_EXPECTED_VALUE.toLocalizedString());
            }
            if (inTokenMode && event.hasOldValue()) {
                proceed = true;
            } else {
                event.setOldValue(curValue, curValue instanceof GatewaySenderEventImpl);
                proceed = region.getConcurrencyChecksEnabled() || removeRecoveredEntry || forceDestroy || AbstractRegionEntry.destroyShouldProceedBasedOnCurrentValue(curValue) || event.getOperation() == Operation.REMOVE && (curValue == null || curValue == Token.LOCAL_INVALID || curValue == Token.INVALID);
            }
        }
        finally {
            OffHeapHelper.releaseWithNoTracking(curValue);
        }
        if (proceed) {
            if (!removeRecoveredEntry) {
                region.generateAndSetVersionTag(event, this);
            }
            if (cacheWrite) {
                VersionStamp stamp;
                region.cacheWriteBeforeDestroy(event, expectedOldValue);
                if (event.getRegion().getServerProxy() != null && (stamp = this.getVersionStamp()) != null) {
                    stamp.processVersionTag(event);
                }
            }
            region.recordEvent(event);
            this.updateIndexOnDestroyOperation(region);
            boolean removeEntry = false;
            VersionTag v = event.getVersionTag();
            if (region.getConcurrencyChecksEnabled() && !removeRecoveredEntry && !event.isFromRILocalDestroy()) {
                VersionStamp stamp;
                if (!(v != null && v.hasValidVersion() || (stamp = this.getVersionStamp()) == null)) {
                    v = stamp.asVersionTag();
                    event.setVersionTag(v);
                }
                removeEntry = v == null || !v.hasValidVersion();
            } else {
                removeEntry = true;
            }
            if (removeEntry) {
                boolean isThisTombstone = this.isTombstone();
                if (inTokenMode && !event.getOperation().isEviction()) {
                    this.setValue(region, Token.DESTROYED);
                } else {
                    this.removePhase1(region, false);
                }
                if (isThisTombstone) {
                    region.unscheduleTombstone(this);
                }
            } else {
                this.makeTombstone(region, v);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndexOnDestroyOperation(InternalRegion region) {
        IndexManager indexManager;
        if (!(this.isTombstone() || region.isProxy() || this.isInvalid() || (indexManager = region.getIndexManager()) == null)) {
            try {
                if (this.isValueNull()) {
                    Object value = this.getValueOffHeapOrDiskWithoutFaultIn(region);
                    try {
                        Object preparedValue = this.prepareValueForCache(region, value, false);
                        this._setValue(preparedValue);
                        this.releaseOffHeapRefIfRegionBeingClosedOrDestroyed(region, preparedValue);
                    }
                    finally {
                        OffHeapHelper.release(value);
                    }
                }
                indexManager.updateIndexes(this, 3, 0);
            }
            catch (QueryException e) {
                throw new IndexMaintenanceException(e);
            }
        }
    }

    private static boolean destroyShouldProceedBasedOnCurrentValue(Object curValue) {
        if (curValue == null) {
            return false;
        }
        return !Token.isRemoved(curValue);
    }

    public static boolean checkExpectedOldValue(Object expectedOldValue, Object actualValue, InternalRegion region) {
        if (Token.isInvalid(expectedOldValue)) {
            return actualValue == null || Token.isInvalid(actualValue);
        }
        boolean isCompressedOffHeap = region.getAttributes().getOffHeap() && region.getAttributes().getCompressor() != null;
        return AbstractRegionEntry.checkEquals(expectedOldValue, actualValue, isCompressedOffHeap, (InternalCache)region.getCache());
    }

    private static boolean basicEquals(Object v1, Object v2) {
        if (v2 != null) {
            if (v2.getClass().isArray()) {
                if (v2 instanceof byte[]) {
                    if (v1 instanceof byte[]) {
                        return Arrays.equals((byte[])v2, (byte[])v1);
                    }
                    return false;
                }
                if (v2 instanceof Object[]) {
                    if (v1 instanceof Object[]) {
                        return Arrays.deepEquals((Object[])v2, (Object[])v1);
                    }
                    return false;
                }
                if (v2 instanceof int[]) {
                    if (v1 instanceof int[]) {
                        return Arrays.equals((int[])v2, (int[])v1);
                    }
                    return false;
                }
                if (v2 instanceof long[]) {
                    if (v1 instanceof long[]) {
                        return Arrays.equals((long[])v2, (long[])v1);
                    }
                    return false;
                }
                if (v2 instanceof boolean[]) {
                    if (v1 instanceof boolean[]) {
                        return Arrays.equals((boolean[])v2, (boolean[])v1);
                    }
                    return false;
                }
                if (v2 instanceof short[]) {
                    if (v1 instanceof short[]) {
                        return Arrays.equals((short[])v2, (short[])v1);
                    }
                    return false;
                }
                if (v2 instanceof char[]) {
                    if (v1 instanceof char[]) {
                        return Arrays.equals((char[])v2, (char[])v1);
                    }
                    return false;
                }
                if (v2 instanceof float[]) {
                    if (v1 instanceof float[]) {
                        return Arrays.equals((float[])v2, (float[])v1);
                    }
                    return false;
                }
                if (v2 instanceof double[]) {
                    if (v1 instanceof double[]) {
                        return Arrays.equals((double[])v2, (double[])v1);
                    }
                    return false;
                }
            }
            return v2.equals(v1);
        }
        return v1 == null;
    }

    private static boolean checkEquals(Object v1, Object v2, boolean isCompressedOffHeap, InternalCache cache) {
        if (v1 instanceof PdxInstance) {
            return AbstractRegionEntry.checkPdxEquals((PdxInstance)v1, v2, cache);
        }
        if (v2 instanceof PdxInstance) {
            return AbstractRegionEntry.checkPdxEquals((PdxInstance)v2, v1, cache);
        }
        if (v1 instanceof StoredObject) {
            return AbstractRegionEntry.checkOffHeapEquals((StoredObject)v1, v2, cache);
        }
        if (v2 instanceof StoredObject) {
            return AbstractRegionEntry.checkOffHeapEquals((StoredObject)v2, v1, cache);
        }
        if (v1 instanceof CachedDeserializable) {
            return AbstractRegionEntry.checkCDEquals((CachedDeserializable)v1, v2, isCompressedOffHeap, cache);
        }
        if (v2 instanceof CachedDeserializable) {
            return AbstractRegionEntry.checkCDEquals((CachedDeserializable)v2, v1, isCompressedOffHeap, cache);
        }
        return AbstractRegionEntry.basicEquals(v1, v2);
    }

    private static boolean checkOffHeapEquals(StoredObject ohVal, Object obj, InternalCache cache) {
        byte[] serializedObj;
        if (ohVal.isSerializedPdxInstance()) {
            PdxInstance pi = InternalDataSerializer.readPdxInstance(ohVal.getSerializedValue(), cache);
            return AbstractRegionEntry.checkPdxEquals(pi, obj, cache);
        }
        if (obj instanceof StoredObject) {
            return ohVal.checkDataEquals((StoredObject)obj);
        }
        if (obj instanceof CachedDeserializable) {
            CachedDeserializable cdObj = (CachedDeserializable)obj;
            if (!ohVal.isSerialized()) {
                assert (cdObj.isSerialized());
                return false;
            }
            serializedObj = cdObj.getSerializedValue();
        } else if (obj instanceof byte[]) {
            if (ohVal.isSerialized()) {
                return false;
            }
            serializedObj = (byte[])obj;
        } else {
            if (!ohVal.isSerialized()) {
                return false;
            }
            if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
                return false;
            }
            serializedObj = EntryEventImpl.serialize(obj);
        }
        return ohVal.checkDataEquals(serializedObj);
    }

    private static boolean checkCDEquals(CachedDeserializable cd, Object obj, boolean isCompressedOffHeap, InternalCache cache) {
        if (!cd.isSerialized()) {
            byte[] ba2;
            if (obj instanceof CachedDeserializable) {
                CachedDeserializable cdObj = (CachedDeserializable)obj;
                if (!cdObj.isSerialized()) {
                    return false;
                }
                ba2 = (byte[])cdObj.getDeserializedForReading();
            } else if (obj instanceof byte[]) {
                ba2 = (byte[])obj;
            } else {
                return false;
            }
            byte[] ba1 = (byte[])cd.getDeserializedForReading();
            return Arrays.equals(ba1, ba2);
        }
        Object cdVal = cd.getValue();
        if (cdVal instanceof byte[]) {
            Object deserializedObj;
            byte[] cdValBytes = (byte[])cdVal;
            PdxInstance pi = InternalDataSerializer.readPdxInstance(cdValBytes, cache);
            if (pi != null) {
                return AbstractRegionEntry.checkPdxEquals(pi, obj, cache);
            }
            if (isCompressedOffHeap) {
                byte[] serializedObj = obj instanceof CachedDeserializable ? ((CachedDeserializable)obj).getSerializedValue() : EntryEventImpl.serialize(obj);
                return Arrays.equals(cdValBytes, serializedObj);
            }
            if (obj instanceof CachedDeserializable) {
                deserializedObj = ((CachedDeserializable)obj).getDeserializedForReading();
            } else {
                if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
                    return false;
                }
                deserializedObj = obj;
            }
            return AbstractRegionEntry.basicEquals(deserializedObj, cd.getDeserializedForReading());
        }
        if (obj instanceof CachedDeserializable) {
            obj = ((CachedDeserializable)obj).getDeserializedForReading();
        }
        return AbstractRegionEntry.basicEquals(cdVal, obj);
    }

    private static boolean checkPdxEquals(PdxInstance pdx, Object obj, InternalCache cache) {
        if (!(obj instanceof PdxInstance)) {
            PdxSerializer pdxSerializer;
            if (obj instanceof CachedDeserializable) {
                CachedDeserializable cdObj = (CachedDeserializable)obj;
                if (!cdObj.isSerialized()) {
                    return false;
                }
                Object cdVal = cdObj.getValue();
                if (cdVal instanceof byte[]) {
                    byte[] cdValBytes = (byte[])cdVal;
                    PdxInstance pi = InternalDataSerializer.readPdxInstance(cdValBytes, cache);
                    if (pi != null) {
                        return pi.equals(pdx);
                    }
                    return false;
                }
                obj = cdVal;
            }
            if (obj != null && obj.getClass().getName().equals(pdx.getClassName()) && ((pdxSerializer = obj instanceof PdxSerializable ? null : cache.getPdxSerializer()) != null || obj instanceof PdxSerializable)) {
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                try {
                    PdxInstance pi;
                    if ((InternalDataSerializer.autoSerialized(obj, hdos) || InternalDataSerializer.writePdx(hdos, cache, obj, pdxSerializer)) && (pi = InternalDataSerializer.readPdxInstance(hdos.toByteArray(), cache)) != null) {
                        obj = pi;
                    }
                }
                catch (IOException | PdxSerializationException exception) {
                    // empty catch block
                }
            }
        }
        return AbstractRegionEntry.basicEquals(obj, pdx);
    }

    @Override
    public abstract Object getKey();

    private static boolean okToStoreOffHeap(Object v, AbstractRegionEntry e) {
        if (v == null) {
            return false;
        }
        if (Token.isInvalidOrRemoved(v)) {
            return false;
        }
        if (v == Token.NOT_AVAILABLE) {
            return false;
        }
        if (v instanceof DiskEntry.RecoveredEntry) {
            return false;
        }
        return e instanceof OffHeapRegionEntry;
    }

    @Override
    public boolean isKeyEqual(Object k) {
        return k.equals(this.getKey());
    }

    protected void _setLastModified(long lastModifiedTime) {
        long storedValue;
        if (lastModifiedTime < 0L || lastModifiedTime > 0xFFFFFFFFFFFFFFL) {
            throw new IllegalStateException("Expected lastModifiedTime " + lastModifiedTime + " to be >= 0 and <= " + 0xFFFFFFFFFFFFFFL);
        }
        do {
            storedValue = this.getLastModifiedField();
            long newValue = storedValue & 0xFF00000000000000L;
        } while (!this.compareAndSetLastModifiedField(storedValue, newValue |= lastModifiedTime));
    }

    protected abstract long getLastModifiedField();

    protected abstract boolean compareAndSetLastModifiedField(long var1, long var3);

    @Override
    public long getLastModified() {
        return this.getLastModifiedField() & 0xFFFFFFFFFFFFFFL;
    }

    protected boolean areAnyBitsSet(long bitMask) {
        return (this.getLastModifiedField() & bitMask) != 0L;
    }

    protected void setBits(long bitMask) {
        long newBits;
        long bits;
        boolean done;
        do {
            if ((bits = this.getLastModifiedField()) != (newBits = bits | bitMask)) continue;
            return;
        } while (!(done = this.compareAndSetLastModifiedField(bits, newBits)));
    }

    protected void clearBits(long bitMask) {
        long newBits;
        long bits;
        boolean done;
        do {
            if ((bits = this.getLastModifiedField()) != (newBits = bits & bitMask)) continue;
            return;
        } while (!(done = this.compareAndSetLastModifiedField(bits, newBits)));
    }

    @Override
    public Object prepareValueForCache(RegionEntryContext r, Object val, boolean isEntryUpdate) {
        return this.prepareValueForCache(r, val, null, isEntryUpdate);
    }

    @Override
    public Object prepareValueForCache(RegionEntryContext r, Object val, EntryEventImpl event, boolean isEntryUpdate) {
        byte[] data;
        if (r != null && r.getOffHeap() && AbstractRegionEntry.okToStoreOffHeap(val, this)) {
            if (val instanceof StoredObject) {
                StoredObject soVal = (StoredObject)val;
                assert (!soVal.isCompressed());
                if (r.getCompressor() != null) {
                    byte[] valAsBytes = soVal.getValueAsHeapByteArray();
                    Object heapValue = soVal.isSerialized() ? (Object)CachedDeserializableFactory.create(valAsBytes, r.getCache()) : valAsBytes;
                    return this.prepareValueForCache(r, heapValue, event, isEntryUpdate);
                }
                if (soVal.hasRefCount() && !soVal.retain()) {
                    throw new IllegalStateException("Could not use an off heap value because it was freed");
                }
            } else {
                byte[] data2;
                boolean isSerialized;
                boolean bl = isSerialized = !(val instanceof byte[]);
                if (isSerialized) {
                    if (event != null && event.getCachedSerializedNewValue() != null) {
                        data2 = event.getCachedSerializedNewValue();
                    } else {
                        if (val instanceof CachedDeserializable) {
                            data2 = ((CachedDeserializable)val).getSerializedValue();
                        } else if (val instanceof PdxInstance) {
                            try {
                                data2 = ((ConvertableToBytes)val).toBytes();
                            }
                            catch (IOException e) {
                                throw new PdxSerializationException("Could not convert " + val + " to bytes", e);
                            }
                        } else {
                            data2 = EntryEventImpl.serialize(val);
                        }
                        if (event != null) {
                            event.setCachedSerializedNewValue(data2);
                        }
                    }
                } else {
                    data2 = (byte[])val;
                }
                byte[] compressedData = AbstractRegionEntry.compressBytes(r, data2);
                boolean isCompressed = compressedData != data2;
                ReferenceCountHelper.setReferenceCountOwner(this);
                MemoryAllocatorImpl ma = MemoryAllocatorImpl.getAllocator();
                val = ma.allocateAndInitialize(compressedData, isSerialized, isCompressed, data2);
                ReferenceCountHelper.setReferenceCountOwner(null);
            }
            return val;
        }
        Object nv = val;
        if (nv instanceof StoredObject) {
            data = ((StoredObject)nv).getSerializedValue();
            nv = CachedDeserializableFactory.create(data, r.getCache());
        }
        if (nv instanceof PdxInstanceImpl) {
            try {
                data = ((ConvertableToBytes)nv).toBytes();
                byte[] compressedData = AbstractRegionEntry.compressBytes(r, data);
                if (data == compressedData) {
                    nv = CachedDeserializableFactory.create(data, r.getCache());
                }
                nv = compressedData;
            }
            catch (IOException e) {
                throw new PdxSerializationException("Could not convert " + nv + " to bytes", e);
            }
        } else {
            nv = AbstractRegionEntry.compress(r, nv, event);
        }
        return nv;
    }

    @Override
    public Object getValue() {
        return this.getValueField();
    }

    @Override
    public boolean isUpdateInProgress() {
        return this.areAnyBitsSet(0x200000000000000L);
    }

    @Override
    public void setUpdateInProgress(boolean underUpdate) {
        if (underUpdate) {
            this.setBits(0x200000000000000L);
        } else {
            this.clearBits(-144115188075855873L);
        }
    }

    @Override
    public boolean isCacheListenerInvocationInProgress() {
        return this.areAnyBitsSet(0x800000000000000L);
    }

    @Override
    public void setCacheListenerInvocationInProgress(boolean isListenerInvoked) {
        if (isListenerInvoked) {
            this.setBits(0x800000000000000L);
        } else {
            this.clearBits(-576460752303423489L);
        }
    }

    @Override
    public synchronized boolean isInUseByTransaction() {
        return this.areAnyBitsSet(0x4000000000000000L);
    }

    private void setInUseByTransaction(boolean v) {
        if (v) {
            this.setBits(0x4000000000000000L);
        } else {
            this.clearBits(-4611686018427387905L);
        }
    }

    @Override
    public synchronized void incRefCount() {
        TXManagerImpl.incRefCount(this);
        this.setInUseByTransaction(true);
    }

    @Override
    public synchronized void decRefCount(EvictionList evictionList, InternalRegion region) {
        if (TXManagerImpl.decRefCount(this) && this.isInUseByTransaction()) {
            this.setInUseByTransaction(false);
            if (!this.isDestroyedOrRemoved()) {
                this.appendToEvictionList(evictionList);
                if (region != null && region.isEntryExpiryPossible()) {
                    region.addExpiryTaskIfAbsent(this);
                }
            }
        }
    }

    @Override
    public synchronized void resetRefCount(EvictionList evictionList) {
        if (this.isInUseByTransaction()) {
            this.setInUseByTransaction(false);
            this.appendToEvictionList(evictionList);
        }
    }

    protected void appendToEvictionList(EvictionList evictionList) {
    }

    void _setValue(Object val) {
        this.setValueField(val);
    }

    @Override
    public Token getValueAsToken() {
        Object v = this.getValueField();
        if (v == null || v instanceof Token) {
            return (Token)v;
        }
        return Token.NOT_A_TOKEN;
    }

    protected abstract Object getValueField();

    protected abstract void setValueField(Object var1);

    @Override
    public Object getTransformedValue() {
        return this.getValueRetain(null, false);
    }

    @Override
    public boolean getValueWasResultOfSearch() {
        return this.areAnyBitsSet(0x100000000000000L);
    }

    @Override
    public void setValueResultOfSearch(boolean v) {
        if (v) {
            this.setBits(0x100000000000000L);
        } else {
            this.clearBits(-72057594037927937L);
        }
    }

    public boolean hasValidVersion() {
        VersionStamp stamp = (VersionStamp)((Object)this);
        return stamp.getRegionVersion() != 0L || stamp.getEntryVersion() != 0;
    }

    @Override
    public boolean hasStats() {
        return false;
    }

    @Override
    public Object getMapValue() {
        return this;
    }

    @Override
    public void setMapValue(Object newValue) {
        if (this != newValue) {
            Assert.fail("AbstractRegionEntry#setMapValue: unexpected setMapValue with newValue=" + newValue + ", this=" + this);
        }
    }

    protected abstract void setEntryHash(int var1);

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append(" (");
        return this.appendFieldsToString(sb).append(')').toString();
    }

    protected StringBuilder appendFieldsToString(StringBuilder sb) {
        sb.append("key=").append(this.getKey()).append("; rawValue=").append(this.getValue());
        VersionStamp stamp = this.getVersionStamp();
        if (stamp != null) {
            sb.append("; version=").append(stamp.asVersionTag()).append(";member=").append(stamp.getMemberID());
        }
        return sb;
    }

    @Override
    public VersionTag generateVersionTag(VersionSource member, boolean withDelta, InternalRegion region, EntryEventImpl event) {
        VersionStamp stamp = this.getVersionStamp();
        if (stamp != null && region.getServerProxy() == null) {
            VersionTag remoteTag;
            VersionSource regionMember;
            int v = stamp.getEntryVersion() + 1;
            if (v > 0xFFFFFF) {
                v -= 0x1000000;
            }
            Object previous = stamp.getMemberID();
            if (member == null && (regionMember = region.getVersionMember()) instanceof DiskStoreID) {
                member = regionMember;
            }
            VersionTag tag = VersionTag.create(member);
            tag.setEntryVersion(v);
            if (region.getVersionVector() != null) {
                long nextRegionVersion = event.getNextRegionVersion();
                if (nextRegionVersion != -1L) {
                    tag.setRegionVersion(nextRegionVersion);
                    RegionVersionVector rvv = region.getVersionVector();
                    rvv.recordVersion(rvv.getOwnerId(), nextRegionVersion);
                    if (logger.isDebugEnabled()) {
                        logger.debug("recorded region version {}; region={}", (Object)nextRegionVersion, (Object)region.getFullPath());
                    }
                } else {
                    tag.setRegionVersion(region.getVersionVector().getNextVersion());
                }
            }
            if (withDelta) {
                tag.setPreviousMemberID(previous);
            }
            if ((remoteTag = event.getVersionTag()) != null && remoteTag.isGatewayTag()) {
                tag.setVersionTimeStamp(remoteTag.getVersionTimeStamp());
                tag.setDistributedSystemId(remoteTag.getDistributedSystemId());
                tag.setAllowedByResolver(remoteTag.isAllowedByResolver());
            } else {
                long time = region.cacheTimeMillis();
                int dsid = region.getDistributionManager().getDistributedSystemId();
                if (time <= stamp.getVersionTimeStamp() && dsid != tag.getDistributedSystemId()) {
                    time = stamp.getVersionTimeStamp() + 1L;
                }
                tag.setVersionTimeStamp(time);
                tag.setDistributedSystemId(dsid);
            }
            stamp.setVersions(tag);
            stamp.setMemberID(member);
            event.setVersionTag(tag);
            if (logger.isDebugEnabled()) {
                logger.debug("generated tag {}; key={}; oldvalue={} newvalue={} client={} region={}; rvv={}", (Object)tag, event.getKey(), (Object)event.getOldValueStringForm(), (Object)event.getNewValueStringForm(), (Object)(event.getContext() == null ? "none" : event.getContext().getDistributedMember().getName()), (Object)region.getFullPath(), (Object)region.getVersionVector());
            }
            return tag;
        }
        return null;
    }

    public void processVersionTag(EntryEvent cacheEvent) {
        this.processVersionTag(cacheEvent, true);
    }

    protected void processVersionTag(EntryEvent cacheEvent, boolean conflictCheck) {
        EntryEventImpl event = (EntryEventImpl)cacheEvent;
        VersionTag tag = event.getVersionTag();
        if (tag == null) {
            return;
        }
        try {
            if (tag.isGatewayTag()) {
                if (this.processGatewayTag(cacheEvent)) {
                    return;
                }
                assert (false) : "processGatewayTag failure - returned false";
            }
            if (!tag.isFromOtherMember() && !event.getOperation().isNetSearch()) {
                return;
            }
            InternalDistributedMember originator = (InternalDistributedMember)event.getDistributedMember();
            VersionSource dmId = event.getRegion().getVersionMember();
            InternalRegion r = event.getRegion();
            boolean eventHasDelta = event.getDeltaBytes() != null && event.getRawNewValue() == null;
            VersionStamp stamp = this.getVersionStamp();
            if (stamp != null && !tag.isAllowedByResolver()) {
                int stampDsId = stamp.getDistributedSystemId();
                int tagDsId = tag.getDistributedSystemId();
                if (stampDsId != 0 && stampDsId != tagDsId && stampDsId != -1) {
                    StringBuilder verbose = null;
                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE)) {
                        verbose = new StringBuilder();
                        verbose.append("processing tag for key ").append(this.getKey()).append(", stamp=").append(stamp.asVersionTag()).append(", tag=").append(tag);
                    }
                    long stampTime = stamp.getVersionTimeStamp();
                    long tagTime = tag.getVersionTimeStamp();
                    if (stampTime > 0L && (tagTime > stampTime || tagTime == stampTime && tag.getDistributedSystemId() >= stamp.getDistributedSystemId())) {
                        if (verbose != null) {
                            verbose.append(" - allowing event");
                            logger.trace(LogMarker.TOMBSTONE_VERBOSE, (CharSequence)verbose);
                        }
                        this.applyVersionTag(r, stamp, tag, originator);
                        return;
                    }
                    if (stampTime > 0L) {
                        if (verbose != null) {
                            verbose.append(" - disallowing event");
                            logger.trace(LogMarker.TOMBSTONE_VERBOSE, (CharSequence)verbose);
                        }
                        r.getCachePerfStats().incConflatedEventsCount();
                        this.persistConflictingTag(r, tag);
                        throw new ConcurrentCacheModificationException("conflicting event detected");
                    }
                }
            }
            if (r.getVersionVector() != null && r.getServerProxy() == null && (r.getDataPolicy().withPersistence() || !r.getScope().isLocal())) {
                Object who = tag.getMemberID();
                if (who == null) {
                    who = originator;
                }
                r.getVersionVector().recordVersion(who, tag);
            }
            assert (!tag.isFromOtherMember() || tag.getMemberID() != null) : "remote tag is missing memberID";
            this.basicProcessVersionTag(r, tag, false, eventHasDelta, dmId, originator, conflictCheck);
        }
        catch (ConcurrentCacheModificationException ex) {
            event.isConcurrencyConflict(true);
            throw ex;
        }
    }

    protected void basicProcessVersionTag(InternalRegion region, VersionTag tag, boolean isTombstoneFromGII, boolean deltaCheck, VersionSource dmId, InternalDistributedMember sender, boolean checkForConflict) {
        if (tag != null) {
            VersionTag stampTag;
            VersionStamp stamp = this.getVersionStamp();
            StringBuilder verbose = null;
            if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE) && (stampTag = stamp.asVersionTag()).hasValidVersion() && checkForConflict) {
                verbose = new StringBuilder();
                verbose.append("processing tag for key ").append(this.getKey()).append(", stamp=").append(stamp.asVersionTag()).append(", tag=").append(tag).append(", checkForConflict=").append(checkForConflict);
            }
            if (stamp == null) {
                throw new IllegalStateException("message contained a version tag but this region has no version storage");
            }
            boolean apply = true;
            try {
                if (checkForConflict) {
                    apply = this.checkForConflict(region, stamp, tag, isTombstoneFromGII, deltaCheck, dmId, sender, verbose);
                }
            }
            catch (ConcurrentCacheModificationException e) {
                if (!tag.isGatewayTag() && stamp.getDistributedSystemId() == tag.getDistributedSystemId() && tag.getVersionTimeStamp() > stamp.getVersionTimeStamp()) {
                    stamp.setVersionTimeStamp(tag.getVersionTimeStamp());
                    tag.setTimeStampApplied(true);
                    if (verbose != null) {
                        verbose.append("\nThough in conflict the tag timestamp was more recent and was recorded.");
                    }
                }
                throw e;
            }
            finally {
                if (verbose != null) {
                    logger.trace(LogMarker.TOMBSTONE_VERBOSE, (CharSequence)verbose);
                }
            }
            if (apply) {
                this.applyVersionTag(region, stamp, tag, sender);
            }
        }
    }

    private void applyVersionTag(InternalRegion region, VersionStamp stamp, VersionTag tag, InternalDistributedMember sender) {
        Object mbr = tag.getMemberID();
        if (mbr == null) {
            mbr = sender;
        }
        mbr = region.getVersionVector().getCanonicalId(mbr);
        tag.setMemberID(mbr);
        stamp.setVersions(tag);
        if (tag.hasPreviousMemberID()) {
            if (tag.getPreviousMemberID() == null) {
                tag.setPreviousMemberID(stamp.getMemberID());
            } else {
                tag.setPreviousMemberID(region.getVersionVector().getCanonicalId(tag.getPreviousMemberID()));
            }
        }
    }

    private boolean checkForConflict(InternalRegion region, VersionStamp stamp, VersionTag tag, boolean isTombstoneFromGII, boolean deltaCheck, VersionSource dmId, InternalDistributedMember sender, StringBuilder verbose) {
        long difference;
        int stampVersion = stamp.getEntryVersion();
        int tagVersion = tag.getEntryVersion();
        if (stamp.getVersionTimeStamp() != 0L && (65536L < (difference = (long)(tagVersion - stampVersion)) || difference < -65536L)) {
            if (verbose != null) {
                verbose.append("\nversion rollover detected: tag=").append(tagVersion).append(" stamp=").append(stampVersion);
            }
            if (difference < 0L) {
                tagVersion = (int)((long)tagVersion + 0x1000000L);
            } else {
                stampVersion = (int)((long)stampVersion + 0x1000000L);
            }
        }
        if (verbose != null) {
            verbose.append("\nstamp=v").append(stampVersion).append(" tag=v").append(tagVersion);
        }
        if (deltaCheck) {
            this.checkForDeltaConflict(region, stampVersion, tagVersion, stamp, tag, dmId, sender, verbose);
        }
        boolean throwex = false;
        boolean apply = false;
        if (stampVersion == 0 || stampVersion < tagVersion) {
            if (verbose != null) {
                verbose.append(" - applying change");
            }
            apply = true;
        } else if (stampVersion > tagVersion) {
            if (this.overwritingOldTombstone(region, stamp, tag, verbose) && tag.getVersionTimeStamp() > stamp.getVersionTimeStamp()) {
                apply = true;
            } else if (tagVersion > 0 && this.isExpiredTombstone(region, tag.getVersionTimeStamp(), isTombstoneFromGII) && tag.getVersionTimeStamp() > stamp.getVersionTimeStamp()) {
                if (verbose != null) {
                    verbose.append(" - applying change in Delta GII");
                }
                apply = true;
            } else {
                if (verbose != null) {
                    verbose.append(" - disallowing");
                }
                throwex = true;
            }
        } else if (this.overwritingOldTombstone(region, stamp, tag, verbose)) {
            apply = true;
        } else {
            int compare;
            Object tagID;
            Object stampID = stamp.getMemberID();
            if (stampID == null) {
                stampID = dmId;
            }
            if ((tagID = tag.getMemberID()) == null) {
                tagID = sender;
            }
            if (verbose != null) {
                verbose.append("\ncomparing IDs");
            }
            if ((compare = stampID.compareTo(tagID)) < 0) {
                if (verbose != null) {
                    verbose.append(" - applying change");
                }
                apply = true;
            } else if (compare > 0) {
                if (verbose != null) {
                    verbose.append(" - disallowing");
                }
                throwex = true;
            } else if (tag.isPosDup()) {
                if (verbose != null) {
                    verbose.append(" - disallowing duplicate marked with posdup");
                }
                throwex = true;
            } else if (verbose != null) {
                verbose.append(" - allowing duplicate");
            }
        }
        if (!apply && throwex) {
            region.getCachePerfStats().incConflatedEventsCount();
            this.persistConflictingTag(region, tag);
            throw new ConcurrentCacheModificationException();
        }
        return apply;
    }

    private boolean isExpiredTombstone(InternalRegion region, long timestamp, boolean isTombstone) {
        return isTombstone && timestamp + TombstoneService.REPLICATE_TOMBSTONE_TIMEOUT <= region.cacheTimeMillis();
    }

    private boolean overwritingOldTombstone(InternalRegion region, VersionStamp stamp, VersionTag tag, StringBuilder verbose) {
        long stampTime = stamp.getVersionTimeStamp();
        if (this.isExpiredTombstone(region, stampTime, this.isTombstone())) {
            if (verbose != null) {
                verbose.append(" - accepting because local timestamp is old");
            }
            return true;
        }
        return false;
    }

    protected void persistConflictingTag(InternalRegion region, VersionTag tag) {
    }

    private void checkForDeltaConflict(InternalRegion region, long stampVersion, long tagVersion, VersionStamp stamp, VersionTag tag, VersionSource dmId, InternalDistributedMember sender, StringBuilder verbose) {
        Object tagID;
        if (tagVersion != stampVersion + 1L) {
            if (verbose != null) {
                verbose.append("\ndelta requires full value due to version mismatch");
            }
            region.getCachePerfStats().incDeltaFailedUpdates();
            throw new InvalidDeltaException("delta cannot be applied due to version mismatch");
        }
        Object stampID = stamp.getMemberID();
        if (stampID == null) {
            stampID = dmId;
        }
        if ((tagID = tag.getPreviousMemberID()) == null) {
            tagID = sender;
        }
        if (!tagID.equals(stampID)) {
            if (verbose != null) {
                verbose.append("\ndelta requires full value.  tag.previous=").append(tagID).append(" but stamp.current=").append(stampID);
            }
            region.getCachePerfStats().incDeltaFailedUpdates();
            throw new InvalidDeltaException("delta cannot be applied due to version ID mismatch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processGatewayTag(EntryEvent cacheEvent) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.isRemoved() && !this.isTombstone()) {
            return true;
        }
        EntryEventImpl event = (EntryEventImpl)cacheEvent;
        VersionTag tag = event.getVersionTag();
        long stampTime = this.getVersionStamp().getVersionTimeStamp();
        long tagTime = tag.getVersionTimeStamp();
        int stampDsid = this.getVersionStamp().getDistributedSystemId();
        int tagDsid = tag.getDistributedSystemId();
        if (isDebugEnabled) {
            logger.debug("processing gateway version information for {}.  Stamp dsid={} time={} Tag dsid={} time={}", event.getKey(), (Object)stampDsid, (Object)stampTime, (Object)tagDsid, (Object)tagTime);
        }
        if (tagTime == Long.MIN_VALUE) {
            return true;
        }
        if (tagDsid == stampDsid || stampDsid == -1) {
            return true;
        }
        GatewayConflictResolver resolver = event.getRegion().getCache().getGatewayConflictResolver();
        if (resolver != null) {
            if (isDebugEnabled) {
                logger.debug("invoking gateway conflict resolver");
            }
            final boolean[] disallow = new boolean[1];
            final Object[] newValue = new Object[]{this};
            GatewayConflictHelper helper = new GatewayConflictHelper(){

                @Override
                public void disallowEvent() {
                    disallow[0] = true;
                }

                @Override
                public void changeEventValue(Object value) {
                    newValue[0] = value;
                }
            };
            TimestampedEntryEventImpl timestampedEvent = (TimestampedEntryEventImpl)event.getTimestampedEvent(tagDsid, stampDsid, tagTime, stampTime);
            if (!timestampedEvent.hasOldValue() && this.isRemoved()) {
                timestampedEvent.setOldValue(this.getValue(timestampedEvent.getRegion()));
            }
            Throwable thr = null;
            try {
                resolver.onEvent(timestampedEvent, helper);
            }
            catch (CancelException cancelled) {
                throw cancelled;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_EXCEPTION_OCCURRED_IN_CONFLICTRESOLVER), t);
                thr = t;
            }
            finally {
                timestampedEvent.release();
            }
            if (isDebugEnabled) {
                logger.debug("done invoking resolver", thr);
            }
            if (thr == null) {
                if (disallow[0]) {
                    if (isDebugEnabled) {
                        logger.debug("conflict resolver rejected the event for {}", event.getKey());
                    }
                    throw new ConcurrentCacheModificationException("WAN conflict resolver rejected the operation");
                }
                tag.setAllowedByResolver(true);
                if (newValue[0] != this) {
                    if (isDebugEnabled) {
                        logger.debug("conflict resolver changed the value of the event for {}", event.getKey());
                    }
                    event.setNewValue(newValue[0]);
                }
                if (isDebugEnabled) {
                    logger.debug("change was allowed by conflict resolver: {}", (Object)tag);
                }
                return true;
            }
        }
        if (isDebugEnabled) {
            logger.debug("performing normal WAN conflict check");
        }
        if (tagTime > stampTime || tagTime == stampTime && tagDsid >= stampDsid) {
            if (isDebugEnabled) {
                logger.debug("allowing event");
            }
            return true;
        }
        if (isDebugEnabled) {
            logger.debug("disallowing event for {}", event.getKey());
        }
        throw new ConcurrentCacheModificationException("conflicting WAN event detected");
    }

    static boolean isCompressible(RegionEntryContext context, Object value) {
        return value != null && context != null && context.getCompressor() != null && !Token.isInvalidOrRemoved(value);
    }

    @Override
    public VersionStamp getVersionStamp() {
        return null;
    }

    @Override
    public boolean isValueNull() {
        return null == this.getValueAsToken();
    }

    @Override
    public boolean isInvalid() {
        return Token.isInvalid(this.getValueAsToken());
    }

    @Override
    public boolean isDestroyed() {
        return Token.isDestroyed(this.getValueAsToken());
    }

    @Override
    public void setValueToNull() {
        this._setValue(null);
    }

    @Override
    public boolean isInvalidOrRemoved() {
        return Token.isInvalidOrRemoved(this.getValueAsToken());
    }

    @Override
    public Object getValueRetain(RegionEntryContext context, boolean decompress) {
        if (decompress) {
            return AbstractRegionEntry.decompress(context, this.getValue());
        }
        return this.getValue();
    }

    @Override
    public void returnToPool() {
    }

    @Override
    public boolean isEvicted() {
        return false;
    }

    public static class HashRegionEntryCreator
    implements CustomEntryConcurrentHashMap.HashEntryCreator<Object, Object> {
        @Override
        public CustomEntryConcurrentHashMap.HashEntry<Object, Object> newEntry(Object key, int hash, CustomEntryConcurrentHashMap.HashEntry<Object, Object> next, Object value) {
            AbstractRegionEntry entry = (AbstractRegionEntry)value;
            int entryHash = entry.getEntryHash();
            if ((hash == 0 || entryHash != 0) && entryHash != hash) {
                Assert.fail("unexpected mismatch of hash, expected=" + hash + ", actual=" + entryHash + " for " + entry);
            }
            entry.setEntryHash(hash);
            entry.setNextEntry(next);
            return entry;
        }

        @Override
        public int keyHashCode(Object key, boolean compareValues) {
            return CustomEntryConcurrentHashMap.keyHash(key, compareValues);
        }
    }
}

