/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class MemoryThresholds {
    private static final boolean DISABLE_LOW_MEM_EXCEPTION = Boolean.getBoolean("gemfire.disableLowMemoryException");
    public static final float DEFAULT_CRITICAL_PERCENTAGE = 0.0f;
    public static final float DEFAULT_EVICTION_PERCENTAGE = 0.0f;
    private static final double THRESHOLD_THICKNESS = Double.parseDouble(System.getProperty("gemfire.thresholdThickness", "2.00"));
    private static final double THRESHOLD_THICKNESS_EVICT = Double.parseDouble(System.getProperty("gemfire.eviction-thresholdThickness", Double.toString(THRESHOLD_THICKNESS)));
    private final long maxMemoryBytes;
    private final float criticalThreshold;
    private final long criticalThresholdBytes;
    private final float evictionThreshold;
    private final long evictionThresholdBytes;
    private final long criticalThresholdClearBytes;
    private final long evictionThresholdClearBytes;

    MemoryThresholds(long maxMemoryBytes) {
        this(maxMemoryBytes, 0.0f, 0.0f);
    }

    public MemoryThresholds(long maxMemoryBytes, float criticalThreshold, float evictionThreshold) {
        if (criticalThreshold > 100.0f || criticalThreshold < 0.0f) {
            throw new IllegalArgumentException(LocalizedStrings.MemoryThresholds_CRITICAL_PERCENTAGE_GT_ZERO_AND_LTE_100.toLocalizedString());
        }
        if (evictionThreshold > 100.0f || evictionThreshold < 0.0f) {
            throw new IllegalArgumentException(LocalizedStrings.MemoryThresholds_EVICTION_PERCENTAGE_GT_ZERO_AND_LTE_100.toLocalizedString());
        }
        if (evictionThreshold != 0.0f && criticalThreshold != 0.0f && evictionThreshold >= criticalThreshold) {
            throw new IllegalArgumentException(LocalizedStrings.MemoryThresholds_CRITICAL_PERCENTAGE_GTE_EVICTION_PERCENTAGE.toLocalizedString());
        }
        this.maxMemoryBytes = maxMemoryBytes;
        this.criticalThreshold = criticalThreshold;
        this.criticalThresholdBytes = (long)((double)criticalThreshold * 0.01 * (double)maxMemoryBytes);
        this.criticalThresholdClearBytes = (long)((double)this.criticalThresholdBytes - 0.01 * THRESHOLD_THICKNESS * (double)this.maxMemoryBytes);
        this.evictionThreshold = evictionThreshold;
        this.evictionThresholdBytes = (long)((double)evictionThreshold * 0.01 * (double)maxMemoryBytes);
        this.evictionThresholdClearBytes = (long)((double)this.evictionThresholdBytes - 0.01 * THRESHOLD_THICKNESS_EVICT * (double)this.maxMemoryBytes);
    }

    public static boolean isLowMemoryExceptionDisabled() {
        return DISABLE_LOW_MEM_EXCEPTION;
    }

    public MemoryState computeNextState(MemoryState oldState, long bytesUsed) {
        assert (oldState != null);
        assert (bytesUsed >= 0L);
        if (this.evictionThreshold != 0.0f && this.criticalThreshold != 0.0f) {
            if (bytesUsed < this.evictionThresholdClearBytes || !oldState.isEviction() && bytesUsed < this.evictionThresholdBytes) {
                return MemoryState.NORMAL;
            }
            if (bytesUsed < this.criticalThresholdClearBytes || !oldState.isCritical() && bytesUsed < this.criticalThresholdBytes) {
                return MemoryState.EVICTION;
            }
            return MemoryState.EVICTION_CRITICAL;
        }
        if (this.evictionThreshold == 0.0f && this.criticalThreshold == 0.0f) {
            return MemoryState.DISABLED;
        }
        if (this.evictionThreshold == 0.0f) {
            if (bytesUsed < this.criticalThresholdClearBytes || !oldState.isCritical() && bytesUsed < this.criticalThresholdBytes) {
                return MemoryState.EVICTION_DISABLED;
            }
            return MemoryState.EVICTION_DISABLED_CRITICAL;
        }
        if (bytesUsed < this.evictionThresholdClearBytes || !oldState.isEviction() && bytesUsed < this.evictionThresholdBytes) {
            return MemoryState.CRITICAL_DISABLED;
        }
        return MemoryState.EVICTION_CRITICAL_DISABLED;
    }

    public String toString() {
        return "MemoryThresholds@[" + System.identityHashCode(this) + (" maxMemoryBytes:" + this.maxMemoryBytes) + (", criticalThreshold:" + this.criticalThreshold) + (", criticalThresholdBytes:" + this.criticalThresholdBytes) + (", criticalThresholdClearBytes:" + this.criticalThresholdClearBytes) + (", evictionThreshold:" + this.evictionThreshold) + (", evictionThresholdBytes:" + this.evictionThresholdBytes) + (", evictionThresholdClearBytes:" + this.evictionThresholdClearBytes) + "]";
    }

    public long getMaxMemoryBytes() {
        return this.maxMemoryBytes;
    }

    public float getCriticalThreshold() {
        return this.criticalThreshold;
    }

    public long getCriticalThresholdBytes() {
        return this.criticalThresholdBytes;
    }

    public long getCriticalThresholdClearBytes() {
        return this.criticalThresholdClearBytes;
    }

    public boolean isCriticalThresholdEnabled() {
        return this.criticalThreshold > 0.0f;
    }

    public float getEvictionThreshold() {
        return this.evictionThreshold;
    }

    public long getEvictionThresholdBytes() {
        return this.evictionThresholdBytes;
    }

    public long getEvictionThresholdClearBytes() {
        return this.evictionThresholdClearBytes;
    }

    public boolean isEvictionThresholdEnabled() {
        return this.evictionThreshold > 0.0f;
    }

    public static MemoryThresholds fromData(DataInput in) throws IOException {
        long maxMemoryBytes = in.readLong();
        float criticalThreshold = in.readFloat();
        float evictionThreshold = in.readFloat();
        return new MemoryThresholds(maxMemoryBytes, criticalThreshold, evictionThreshold);
    }

    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.maxMemoryBytes);
        out.writeFloat(this.criticalThreshold);
        out.writeFloat(this.evictionThreshold);
    }

    public static enum MemoryState {
        DISABLED,
        EVICTION_DISABLED,
        EVICTION_DISABLED_CRITICAL,
        CRITICAL_DISABLED,
        EVICTION_CRITICAL_DISABLED,
        NORMAL,
        EVICTION,
        CRITICAL,
        EVICTION_CRITICAL;


        public static MemoryState fromData(DataInput in) throws IOException {
            return MemoryState.values()[in.readInt()];
        }

        public void toData(DataOutput out) throws IOException {
            DataSerializer.writeInteger(this.ordinal(), out);
        }

        public boolean isEvictionDisabled() {
            return this == DISABLED || this == EVICTION_DISABLED_CRITICAL || this == EVICTION_DISABLED;
        }

        public boolean isCriticalDisabled() {
            return this == DISABLED || this == EVICTION_CRITICAL_DISABLED || this == CRITICAL_DISABLED;
        }

        public boolean isNormal() {
            return this == NORMAL || this == EVICTION_DISABLED || this == CRITICAL_DISABLED;
        }

        public boolean isEviction() {
            return this == EVICTION || this == EVICTION_CRITICAL_DISABLED || this == EVICTION_CRITICAL;
        }

        public boolean isCritical() {
            return this == CRITICAL || this == EVICTION_DISABLED_CRITICAL || this == EVICTION_CRITICAL;
        }
    }
}

