/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

class TemporaryBackupFiles {
    private static final Logger logger = LogService.getLogger();
    private final String diskStoreDirectoryName;
    private final Path directory;
    private final Map<DiskStore, Map<DirectoryHolder, Path>> diskStoreDirDirsByDiskStore = new HashMap<DiskStore, Map<DirectoryHolder, Path>>();

    static TemporaryBackupFiles create() throws IOException {
        long currentTime = System.currentTimeMillis();
        String diskStoreDirectoryName = "backupTemp_" + currentTime;
        Path temporaryDirectory = Files.createTempDirectory("backup_" + currentTime, new FileAttribute[0]);
        return new TemporaryBackupFiles(temporaryDirectory, diskStoreDirectoryName);
    }

    TemporaryBackupFiles(Path directory, String diskStoreDirectoryName) {
        if (directory == null) {
            throw new IllegalArgumentException("Must provide a temporary directory location");
        }
        if (diskStoreDirectoryName == null || diskStoreDirectoryName.isEmpty()) {
            throw new IllegalArgumentException("Must provide a name for temporary DiskStore directories");
        }
        this.directory = directory;
        this.diskStoreDirectoryName = diskStoreDirectoryName;
    }

    Path getDirectory() {
        return this.directory;
    }

    Path getDiskStoreDirectory(DiskStore diskStore, DirectoryHolder dirHolder) throws IOException {
        Map tempDirByDirectoryHolder = this.diskStoreDirDirsByDiskStore.computeIfAbsent(diskStore, k -> new HashMap());
        Path directory = (Path)tempDirByDirectoryHolder.get(dirHolder);
        if (directory != null) {
            return directory;
        }
        File diskStoreDir = dirHolder.getDir();
        directory = diskStoreDir.toPath().resolve(this.diskStoreDirectoryName);
        Files.createDirectories(directory, new FileAttribute[0]);
        tempDirByDirectoryHolder.put(dirHolder, directory);
        return directory;
    }

    void cleanupFiles() {
        if (this.directory != null) {
            this.deleteDirectory(this.directory);
        }
        for (Map<DirectoryHolder, Path> diskStoreDirToTempDirMap : this.diskStoreDirDirsByDiskStore.values()) {
            for (Path tempDir : diskStoreDirToTempDirMap.values()) {
                this.deleteDirectory(tempDir);
            }
        }
    }

    private void deleteDirectory(Path directory) {
        try {
            FileUtils.deleteDirectory((File)directory.toFile());
        }
        catch (IOException | IllegalArgumentException e) {
            logger.warn("Unable to delete temporary directory created during backup, " + this.directory, (Throwable)e);
        }
    }
}

