/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.IOException;
import java.util.Set;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.BackupStep;
import org.apache.geode.internal.cache.backup.FinishBackupFactory;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

class FinishBackupStep
extends BackupStep {
    private static final Logger logger = LogService.getLogger();
    private final InternalDistributedMember member;
    private final InternalCache cache;
    private final Set<InternalDistributedMember> recipients;
    private final FinishBackupFactory finishBackupFactory;

    FinishBackupStep(DistributionManager dm, InternalDistributedMember member, InternalCache cache, Set<InternalDistributedMember> recipients, FinishBackupFactory finishBackupFactory) {
        super(dm);
        this.member = member;
        this.cache = cache;
        this.recipients = recipients;
        this.finishBackupFactory = finishBackupFactory;
    }

    @Override
    ReplyProcessor21 createReplyProcessor() {
        return this.finishBackupFactory.createReplyProcessor(this, this.getDistributionManager(), this.recipients);
    }

    @Override
    DistributionMessage createDistributionMessage(ReplyProcessor21 replyProcessor) {
        return this.finishBackupFactory.createRequest(this.member, this.recipients, replyProcessor.getProcessorId());
    }

    @Override
    void processLocally() {
        try {
            this.addToResults(this.member, this.finishBackupFactory.createFinishBackup(this.cache).run());
        }
        catch (IOException e) {
            logger.fatal("Failed to FinishBackup in " + this.member, (Throwable)e);
        }
    }
}

