/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.backup.BackupDefinition;
import org.apache.geode.internal.cache.backup.BackupFilter;
import org.apache.geode.internal.cache.backup.BackupWriter;
import org.apache.geode.internal.cache.backup.FileSystemIncrementalBackupLocation;
import org.apache.geode.internal.cache.backup.IncrementalBackupFilter;
import org.apache.geode.internal.cache.backup.RestoreScript;
import org.apache.geode.internal.i18n.LocalizedStrings;

class FileSystemBackupWriter
implements BackupWriter {
    private final Path backupDirectory;
    private final FileSystemIncrementalBackupLocation incrementalBaselineLocation;
    private final BackupFilter filter;

    FileSystemBackupWriter(Path backupDirectory) {
        this(backupDirectory, null);
    }

    FileSystemBackupWriter(Path backupDirectory, FileSystemIncrementalBackupLocation incrementalBaselineLocation) {
        this.backupDirectory = backupDirectory;
        this.incrementalBaselineLocation = incrementalBaselineLocation;
        this.filter = this.createBackupFilter(incrementalBaselineLocation);
    }

    private BackupFilter createBackupFilter(FileSystemIncrementalBackupLocation incrementalBaselineLocation) {
        BackupFilter filter = incrementalBaselineLocation != null && Files.exists(incrementalBaselineLocation.getMemberBackupLocationDir(), new LinkOption[0]) ? new IncrementalBackupFilter(incrementalBaselineLocation) : (store, path) -> true;
        return filter;
    }

    @Override
    public void backupFiles(BackupDefinition backupDefinition) throws IOException {
        Files.createDirectories(this.backupDirectory, new FileAttribute[0]);
        Files.createFile(this.backupDirectory.resolve("INCOMPLETE_BACKUP_FILE"), new FileAttribute[0]);
        this.backupAllFilesets(backupDefinition);
        Files.delete(this.backupDirectory.resolve("INCOMPLETE_BACKUP_FILE"));
    }

    @Override
    public Path getBaselineDirectory() {
        return this.incrementalBaselineLocation.getMemberBackupLocationDir().getParent();
    }

    @Override
    public Path getBackupDirectory() {
        return this.backupDirectory;
    }

    private void backupAllFilesets(BackupDefinition backupDefinition) throws IOException {
        RestoreScript restoreScript = backupDefinition.getRestoreScript();
        this.backupDiskInitFiles(backupDefinition.getDiskInitFiles());
        this.backupOplogs(backupDefinition.getOplogFilesByDiskStore(), restoreScript);
        this.backupConfigFiles(backupDefinition.getConfigFiles());
        this.backupUserFiles(backupDefinition.getUserFiles(), restoreScript);
        this.backupDeployedJars(backupDefinition.getDeployedJars(), restoreScript);
        File scriptFile = restoreScript.generate(this.backupDirectory.toFile());
        this.backupRestoreScript(scriptFile.toPath());
        this.writeReadMe();
    }

    private void writeReadMe() throws IOException {
        String text = LocalizedStrings.BackupService_README.toLocalizedString();
        Files.write(this.backupDirectory.resolve("README_FILE.txt"), text.getBytes(), new OpenOption[0]);
    }

    private void backupRestoreScript(Path restoreScriptFile) throws IOException {
        Files.copy(restoreScriptFile, this.backupDirectory.resolve(restoreScriptFile.getFileName()), new CopyOption[0]);
    }

    private void backupDiskInitFiles(Map<DiskStore, Path> diskInitFiles) throws IOException {
        for (Map.Entry<DiskStore, Path> entry : diskInitFiles.entrySet()) {
            Path destinationDirectory = this.getOplogBackupDir(entry.getKey(), ((DiskStoreImpl)entry.getKey()).getInforFileDirIndex());
            Files.createDirectories(destinationDirectory, new FileAttribute[0]);
            Files.copy(entry.getValue(), destinationDirectory.resolve(entry.getValue().getFileName()), StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    private void backupUserFiles(Map<Path, Path> userFiles, RestoreScript restoreScript) throws IOException {
        Path userDirectory = this.backupDirectory.resolve("user");
        Files.createDirectories(userDirectory, new FileAttribute[0]);
        for (Map.Entry<Path, Path> userFileEntry : userFiles.entrySet()) {
            Path userFile = userFileEntry.getKey();
            Path originalFile = userFileEntry.getValue();
            Path destination = userDirectory.resolve(userFile.getFileName());
            this.moveFileOrDirectory(userFile, destination);
            restoreScript.addUserFile(originalFile.toFile(), destination.toFile());
        }
    }

    private void backupDeployedJars(Map<Path, Path> jarFiles, RestoreScript restoreScript) throws IOException {
        Path jarsDirectory = this.backupDirectory.resolve("user");
        Files.createDirectories(jarsDirectory, new FileAttribute[0]);
        for (Map.Entry<Path, Path> jarFileEntry : jarFiles.entrySet()) {
            Path jarFile = jarFileEntry.getKey();
            Path originalFile = jarFileEntry.getValue();
            Path destination = jarsDirectory.resolve(jarFile.getFileName());
            this.moveFileOrDirectory(jarFile, destination);
            restoreScript.addFile(originalFile.toFile(), destination.toFile());
        }
    }

    private void backupConfigFiles(Collection<Path> configFiles) throws IOException {
        Path configDirectory = this.backupDirectory.resolve("config");
        Files.createDirectories(configDirectory, new FileAttribute[0]);
        this.moveFilesOrDirectories(configFiles, configDirectory);
    }

    private void backupOplogs(Map<DiskStore, Collection<Path>> oplogFiles, RestoreScript restoreScript) throws IOException {
        File storesDir = new File(this.backupDirectory.toFile(), "diskstores");
        for (Map.Entry<DiskStore, Collection<Path>> entry : oplogFiles.entrySet()) {
            DiskStoreImpl diskStore = (DiskStoreImpl)entry.getKey();
            boolean diskstoreHasFilesInBackup = false;
            for (Path path : entry.getValue()) {
                if (this.filter.accept(diskStore, path)) {
                    diskstoreHasFilesInBackup = true;
                    int index = diskStore.getInforFileDirIndex();
                    Path backupDir = this.createOplogBackupDir(diskStore, index);
                    this.backupOplog(backupDir, path);
                    continue;
                }
                Map<String, File> baselineOplogMap = this.incrementalBaselineLocation.getBackedUpOplogs(diskStore);
                restoreScript.addBaselineFile(baselineOplogMap.get(path.getFileName().toString()), new File(path.toAbsolutePath().getParent().getParent().toFile(), path.getFileName().toString()));
            }
            if (diskstoreHasFilesInBackup) {
                this.addDiskStoreDirectoriesToRestoreScript((DiskStoreImpl)entry.getKey(), this.getBaseBackupDirectory().toFile(), restoreScript);
            }
            File targetStoresDir = new File(storesDir, this.getBackupDirName(diskStore));
            this.addDiskStoreDirectoriesToRestoreScript(diskStore, targetStoresDir, restoreScript);
        }
    }

    private Path getOplogBackupDir(DiskStore diskStore, int index) {
        String name = diskStore.getName();
        if (name == null) {
            name = GemFireCacheImpl.getDefaultDiskStoreName();
        }
        name = name + "_" + ((DiskStoreImpl)diskStore).getDiskStoreID().toString();
        return this.backupDirectory.resolve("diskstores").resolve(name).resolve("dir" + index);
    }

    private Path createOplogBackupDir(DiskStore diskStore, int index) throws IOException {
        Path oplogBackupDir = this.getOplogBackupDir(diskStore, index);
        Files.createDirectories(oplogBackupDir, new FileAttribute[0]);
        return oplogBackupDir;
    }

    private String getBackupDirName(DiskStoreImpl diskStore) {
        String name = diskStore.getName();
        if (name == null) {
            name = GemFireCacheImpl.getDefaultDiskStoreName();
        }
        return name + "_" + diskStore.getDiskStoreID().toString();
    }

    private void backupOplog(Path targetDir, Path path) throws IOException {
        this.backupFile(targetDir, path.toFile());
    }

    private void backupFile(Path targetDir, File file) throws IOException {
        Files.move(file.toPath(), targetDir.resolve(file.getName()), new CopyOption[0]);
    }

    private void moveFilesOrDirectories(Collection<Path> paths, Path targetDirectory) throws IOException {
        for (Path userFile : paths) {
            Path destination = targetDirectory.resolve(userFile.getFileName());
            this.moveFileOrDirectory(userFile, destination);
        }
    }

    private void moveFileOrDirectory(Path userFile, Path destination) throws IOException {
        if (Files.isDirectory(userFile, new LinkOption[0])) {
            FileUtils.moveDirectory((File)userFile.toFile(), (File)destination.toFile());
        } else {
            Files.move(userFile, destination, new CopyOption[0]);
        }
    }

    private void addDiskStoreDirectoriesToRestoreScript(DiskStoreImpl diskStore, File targetDir, RestoreScript restoreScript) {
        DirectoryHolder[] directories = diskStore.getDirectoryHolders();
        for (int i = 0; i < directories.length; ++i) {
            File backupDir = this.getBackupDirForCurrentMember(targetDir, i);
            restoreScript.addFile(directories[i].getDir(), backupDir);
        }
    }

    private File getBackupDirForCurrentMember(File targetDir, int index) {
        return new File(targetDir, "dir" + index);
    }

    private Path getBaseBackupDirectory() {
        return this.backupDirectory.getParent();
    }
}

