/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.annotations.TestingOnly;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.AbortBackupFactory;
import org.apache.geode.internal.cache.backup.BackupConfigFactory;
import org.apache.geode.internal.cache.backup.BackupDataStoreResult;
import org.apache.geode.internal.cache.backup.BackupLockService;
import org.apache.geode.internal.cache.backup.FinishBackupFactory;
import org.apache.geode.internal.cache.backup.FlushToDiskFactory;
import org.apache.geode.internal.cache.backup.PrepareBackupFactory;
import org.apache.geode.internal.cache.backup.PrepareBackupStep;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.management.BackupStatus;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.BackupStatusImpl;

public class BackupOperation {
    private final FlushToDiskFactory flushToDiskFactory;
    private final PrepareBackupFactory prepareBackupFactory;
    private final AbortBackupFactory abortBackupFactory;
    private final FinishBackupFactory finishBackupFactory;
    private final DistributionManager dm;
    private final InternalCache cache;
    private final BackupLockService backupLockService;
    private final MissingPersistentMembersProvider missingPersistentMembersProvider;

    public BackupOperation(DistributionManager dm, InternalCache cache) {
        this(new FlushToDiskFactory(), new PrepareBackupFactory(), new AbortBackupFactory(), new FinishBackupFactory(), dm, cache, new BackupLockService(), new DefaultMissingPersistentMembersProvider());
    }

    @TestingOnly
    BackupOperation(FlushToDiskFactory flushToDiskFactory, PrepareBackupFactory prepareBackupFactory, AbortBackupFactory abortBackupFactory, FinishBackupFactory finishBackupFactory, DistributionManager dm, InternalCache cache, BackupLockService backupLockService, MissingPersistentMembersProvider missingPersistentMembersProvider) {
        this.flushToDiskFactory = flushToDiskFactory;
        this.prepareBackupFactory = prepareBackupFactory;
        this.abortBackupFactory = abortBackupFactory;
        this.finishBackupFactory = finishBackupFactory;
        this.dm = dm;
        this.cache = cache;
        this.backupLockService = backupLockService;
        this.missingPersistentMembersProvider = missingPersistentMembersProvider;
    }

    public BackupStatus backupAllMembers(String targetDirPath, String baselineDirPath) {
        Properties properties = new BackupConfigFactory().withTargetDirPath(targetDirPath).withBaselineDirPath(baselineDirPath).createBackupProperties();
        return this.performBackup(properties);
    }

    private BackupStatus performBackup(Properties properties) throws ManagementException {
        if (this.backupLockService.obtainLock(this.dm)) {
            try {
                BackupStatus backupStatus = this.performBackupUnderLock(properties);
                return backupStatus;
            }
            finally {
                this.backupLockService.releaseLock(this.dm);
            }
        }
        throw new ManagementException(LocalizedStrings.DistributedSystem_BACKUP_ALREADY_IN_PROGRESS.toLocalizedString());
    }

    private BackupStatus performBackupUnderLock(Properties properties) {
        Set<PersistentID> missingMembers = this.missingPersistentMembersProvider.getMissingPersistentMembers(this.dm);
        Set<InternalDistributedMember> recipients = this.dm.getOtherDistributionManagerIds();
        BackupDataStoreResult result = this.performBackupSteps(this.dm.getId(), recipients, properties);
        for (Set<PersistentID> onlineMembersIds : result.getSuccessfulMembers().values()) {
            missingMembers.removeAll(onlineMembersIds);
        }
        result.getExistingDataStores().keySet().removeAll(result.getSuccessfulMembers().keySet());
        for (Set<PersistentID> lostMembersIds : result.getExistingDataStores().values()) {
            missingMembers.addAll(lostMembersIds);
        }
        return new BackupStatusImpl(result.getSuccessfulMembers(), missingMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackupDataStoreResult performBackupSteps(InternalDistributedMember member, Set<InternalDistributedMember> recipients, Properties properties) {
        Map<DistributedMember, Set<PersistentID>> successfulMembers;
        Map<DistributedMember, Set<PersistentID>> existingDataStores;
        this.flushToDiskFactory.createFlushToDiskStep(this.dm, member, this.cache, recipients, this.flushToDiskFactory).send();
        boolean abort = true;
        try {
            PrepareBackupStep prepareBackupStep = this.prepareBackupFactory.createPrepareBackupStep(this.dm, member, this.cache, recipients, this.prepareBackupFactory, properties);
            existingDataStores = prepareBackupStep.send();
            abort = false;
        }
        finally {
            if (abort) {
                this.abortBackupFactory.createAbortBackupStep(this.dm, member, this.cache, recipients, this.abortBackupFactory).send();
                successfulMembers = Collections.emptyMap();
            } else {
                successfulMembers = this.finishBackupFactory.createFinishBackupStep(this.dm, member, this.cache, recipients, this.finishBackupFactory).send();
            }
        }
        return new BackupDataStoreResult(existingDataStores, successfulMembers);
    }

    private static class DefaultMissingPersistentMembersProvider
    implements MissingPersistentMembersProvider {
        private DefaultMissingPersistentMembersProvider() {
        }

        @Override
        public Set<PersistentID> getMissingPersistentMembers(DistributionManager dm) {
            return AdminDistributedSystemImpl.getMissingPersistentMembers(dm);
        }
    }

    static interface MissingPersistentMembersProvider {
        public Set<PersistentID> getMissingPersistentMembers(DistributionManager var1);
    }
}

