/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.TestingOnly;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.locks.TXRegionLockRequest;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class TXRegionLockRequestImpl
implements TXRegionLockRequest {
    private static final long serialVersionUID = 5840033961584078082L;
    private static final Logger logger = LogService.getLogger();
    private transient InternalCache cache;
    private transient InternalRegion r;
    private String regionPath;
    private Set<Object> entryKeys;

    public TXRegionLockRequestImpl() {
        this.cache = null;
    }

    public TXRegionLockRequestImpl(InternalCache cache, InternalRegion r) {
        this.cache = cache;
        this.r = r;
        this.regionPath = null;
        this.entryKeys = null;
    }

    @TestingOnly
    public TXRegionLockRequestImpl(String regionPath, Set<Object> entryKeys) {
        this.cache = null;
        this.regionPath = regionPath;
        this.entryKeys = entryKeys;
    }

    public boolean isEmpty() {
        return this.entryKeys == null || this.entryKeys.isEmpty();
    }

    @Override
    public void addEntryKeys(Set<Object> s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        if (this.entryKeys == null) {
            HashSet<Object> tmp = new HashSet<Object>(s.size());
            tmp.addAll(s);
            this.entryKeys = tmp;
        } else {
            HashSet<Object> tmp = new HashSet<Object>(this.entryKeys.size() + s.size());
            tmp.addAll(s);
            tmp.addAll(this.entryKeys);
            this.entryKeys = tmp;
        }
    }

    @Override
    public void addEntryKey(Object key) {
        if (this.entryKeys == null) {
            this.entryKeys = new HashSet<Object>();
        }
        this.entryKeys.add(key);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionPath = DataSerializer.readString(in);
        this.cache = GemFireCacheImpl.getInstance();
        try {
            int size = InternalDataSerializer.readArrayLength(in);
            if (this.cache != null && size > 0) {
                this.r = (LocalRegion)this.cache.getRegion(this.regionPath);
            }
            this.entryKeys = this.readEntryKeySet(size, in);
        }
        catch (CacheClosedException ignore) {
            this.entryKeys = null;
        }
    }

    private Set<Object> readEntryKeySet(int size, DataInput in) throws IOException, ClassNotFoundException {
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading HashSet with size {}", (Object)size);
        }
        HashSet<Object> set = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = DataSerializer.readObject(in);
            set.add(key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Read HashSet with {} elements: {}", (Object)size, set);
        }
        return set;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.getRegionFullPath(), out);
        InternalDataSerializer.writeSet(this.entryKeys, out);
    }

    public static TXRegionLockRequestImpl createFromData(DataInput in) throws IOException, ClassNotFoundException {
        TXRegionLockRequestImpl result = new TXRegionLockRequestImpl();
        InternalDataSerializer.invokeFromData(result, in);
        return result;
    }

    @Override
    public String getRegionFullPath() {
        if (this.regionPath == null) {
            this.regionPath = this.r.getFullPath();
        }
        return this.regionPath;
    }

    @Override
    public Set<Object> getKeys() {
        if (this.entryKeys == null) {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
        }
        return this.entryKeys;
    }

    public InternalRegion getLocalRegion() {
        return this.r;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(256);
        result.append("regionPath=").append(this.getRegionFullPath()).append(" keys=").append(this.entryKeys);
        return result.toString();
    }
}

