/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.TransactionEvent;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.offheap.Releasable;

public class TXEvent
implements TransactionEvent,
Releasable {
    private final TXStateInterface localTxState;
    private List events;
    private final Cache cache;

    TXEvent(TXStateInterface localTxState, Cache cache) {
        this.localTxState = localTxState;
        this.cache = cache;
        this.events = null;
    }

    @Override
    public TransactionId getTransactionId() {
        return this.localTxState.getTransactionId();
    }

    public synchronized List getEvents() {
        if (this.events == null) {
            this.events = this.localTxState.getEvents();
        }
        return this.events;
    }

    public boolean hasOnlyInternalEvents() {
        List txevents = this.getEvents();
        if (txevents == null || txevents.isEmpty()) {
            return false;
        }
        for (CacheEvent txevent : txevents) {
            LocalRegion region = (LocalRegion)txevent.getRegion();
            if (region == null || region.isPdxTypesRegion() || region.isInternalRegion()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public synchronized void release() {
        if (this.events != null) {
            for (Object o : this.getEvents()) {
                if (!(o instanceof EntryEventImpl)) continue;
                ((EntryEventImpl)o).release();
            }
        }
    }
}

