/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class TXEntryUserAttrState {
    private final Object originalValue;
    private Object pendingValue;

    public TXEntryUserAttrState(Object originalValue) {
        this.originalValue = originalValue;
        this.pendingValue = originalValue;
    }

    public Object getOriginalValue() {
        return this.originalValue;
    }

    public Object getPendingValue() {
        return this.pendingValue;
    }

    public Object setPendingValue(Object pv) {
        Object result = this.pendingValue;
        this.pendingValue = pv;
        return result;
    }

    void checkForConflict(InternalRegion r, Object key) throws CommitConflictException {
        Object curCmtValue = r.basicGetEntryUserAttribute(key);
        if (this.originalValue != curCmtValue) {
            throw new CommitConflictException(LocalizedStrings.TXEntryUserAttrState_ENTRY_USER_ATTRIBUTE_FOR_KEY_0_ON_REGION_1_HAD_ALREADY_BEEN_CHANGED_TO_2.toLocalizedString(key, r.getFullPath(), curCmtValue));
        }
    }

    void applyChanges(InternalRegion r, Object key) {
        try {
            Region.Entry re = r.getEntry(key);
            re.setUserAttribute(this.pendingValue);
        }
        catch (CacheRuntimeException cacheRuntimeException) {
            // empty catch block
        }
    }
}

