/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.Executor;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.cache.AfterCompletion;
import org.apache.geode.internal.cache.BeforeCompletion;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class SingleThreadJTAExecutor {
    private static final Logger logger = LogService.getLogger();
    private final BeforeCompletion beforeCompletion;
    private final AfterCompletion afterCompletion;

    public SingleThreadJTAExecutor() {
        this(new BeforeCompletion(), new AfterCompletion());
    }

    public SingleThreadJTAExecutor(BeforeCompletion beforeCompletion, AfterCompletion afterCompletion) {
        this.beforeCompletion = beforeCompletion;
        this.afterCompletion = afterCompletion;
    }

    private void doOps(TXState txState, CancelCriterion cancelCriterion) {
        this.beforeCompletion.doOp(txState);
        this.afterCompletion.doOp(txState, cancelCriterion);
    }

    public void executeBeforeCompletion(TXState txState, Executor executor, CancelCriterion cancelCriterion) {
        executor.execute(() -> this.doOps(txState, cancelCriterion));
        this.beforeCompletion.execute(cancelCriterion);
    }

    public void executeAfterCompletion(CancelCriterion cancelCriterion, int status) {
        this.afterCompletion.execute(cancelCriterion, status);
    }

    public void cleanup(CancelCriterion cancelCriterion) {
        this.afterCompletion.cancel(cancelCriterion);
    }

    public boolean shouldDoCleanup() {
        return this.beforeCompletion.isFinished() && !this.afterCompletion.isStarted();
    }
}

