/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DistributedClearOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ReleaseClearLockMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private String regionPath;
    private int processorId;

    public ReleaseClearLockMessage() {
    }

    public ReleaseClearLockMessage(String regionPath, int processorId) {
        this.regionPath = regionPath;
        this.processorId = processorId;
    }

    public static void send(Set<InternalDistributedMember> members, DistributionManager dm, String regionPath) throws ReplyException {
        ReplyProcessor21 processor = new ReplyProcessor21(dm, members);
        ReleaseClearLockMessage msg = new ReleaseClearLockMessage(regionPath, processor.getProcessorId());
        msg.setRecipients(members);
        dm.putOutgoing(msg);
        processor.waitForRepliesUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        ReplyException exception = null;
        try {
            DistributedRegion region = DistributedClearOperation.regionUnlocked(this.getSender(), this.regionPath);
            if (region != null && region.getVersionVector() != null) {
                region.getVersionVector().unlockForClear(this.getSender());
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            exception = new ReplyException(t);
        }
        finally {
            ReplyMessage replyMsg = new ReplyMessage();
            replyMsg.setProcessorId(this.processorId);
            replyMsg.setRecipient(this.getSender());
            if (exception != null) {
                replyMsg.setException(exception);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Received {}, replying with {}", (Object)this, (Object)replyMsg);
            }
            dm.putOutgoing(replyMsg);
        }
    }

    @Override
    public int getDSFID() {
        return 2157;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regionPath = DataSerializer.readString(in);
        this.processorId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.regionPath, out);
        out.writeInt(this.processorId);
    }
}

