/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.i18n.LocalizedStrings;

class RegionNameValidation {
    private static final Pattern NAME_PATTERN = Pattern.compile("[aA-zZ0-9-_.]+");

    RegionNameValidation() {
    }

    static Pattern getNamePattern() {
        return NAME_PATTERN;
    }

    static void validate(String name) {
        RegionNameValidation.validate(name, new InternalRegionArguments());
    }

    static void validate(String name, InternalRegionArguments internalRegionArguments) {
        if (name == null) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_NULL.toLocalizedString());
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_EMPTY.toLocalizedString());
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_CONTAIN_THE_SEPARATOR_0.toLocalizedString("/"));
        }
        if (internalRegionArguments.isInternalRegion()) {
            return;
        }
        if (internalRegionArguments.isUsedForMetaRegion()) {
            return;
        }
        if (internalRegionArguments.isUsedForPartitionedRegionAdmin()) {
            return;
        }
        if (internalRegionArguments.isUsedForPartitionedRegionBucket()) {
            return;
        }
        if (name.startsWith("__")) {
            throw new IllegalArgumentException("Region names may not begin with a double-underscore: " + name);
        }
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Region names may only be alphanumeric and may contain hyphens or underscores: " + name);
        }
    }
}

