/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.PartitionedRegionDistributionException;
import org.apache.geode.cache.PartitionedRegionStorageException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionMembershipListener;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionDataRebalancedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.execute.EmptyRegionFunctionException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.partition.PartitionListener;
import org.apache.geode.cache.partition.PartitionNotAvailableException;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.persistence.PartitionOfflineException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexCreationException;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.Bag;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.cache.query.internal.QueryExecutor;
import org.apache.geode.cache.query.internal.ResultsBag;
import org.apache.geode.cache.query.internal.ResultsCollectionWrapper;
import org.apache.geode.cache.query.internal.ResultsSet;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.IndexCreationData;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ProfileListener;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockRemoteToken;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MemberAttributes;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.BucketDump;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.BucketServerLocation66;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.ColocationListener;
import org.apache.geode.internal.cache.ColocationLogger;
import org.apache.geode.internal.cache.CreateRegionProcessor;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DestroyPartitionedRegionMessage;
import org.apache.geode.internal.cache.DestroyRegionOperation;
import org.apache.geode.internal.cache.DestroyedEntry;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntriesSet;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntryExpiryTask;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.InternalDataView;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.InvalidatePartitionedRegionMessage;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LoaderHelperImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.Node;
import org.apache.geode.internal.cache.PRContainsValueFunction;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.internal.cache.PRQueryProcessor;
import org.apache.geode.internal.cache.PRSystemPropertyGetter;
import org.apache.geode.internal.cache.PartitionRegionConfig;
import org.apache.geode.internal.cache.PartitionRegionConfigValidator;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PartitionedRegionDataView;
import org.apache.geode.internal.cache.PartitionedRegionException;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.PartitionedRegionQueryEvaluator;
import org.apache.geode.internal.cache.PartitionedRegionRedundancyTracker;
import org.apache.geode.internal.cache.PartitionedRegionStats;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.SearchLoadAndWriteProcessor;
import org.apache.geode.internal.cache.StateFlushOperation;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.HeapEvictor;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.FunctionExecutionNodePruner;
import org.apache.geode.internal.cache.execute.FunctionRemoteContext;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionResultSender;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionResultWaiter;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.partitioned.ContainsKeyValueMessage;
import org.apache.geode.internal.cache.partitioned.DestroyMessage;
import org.apache.geode.internal.cache.partitioned.DumpAllPRConfigMessage;
import org.apache.geode.internal.cache.partitioned.DumpB2NRegion;
import org.apache.geode.internal.cache.partitioned.DumpBucketsMessage;
import org.apache.geode.internal.cache.partitioned.FetchBulkEntriesMessage;
import org.apache.geode.internal.cache.partitioned.FetchEntriesMessage;
import org.apache.geode.internal.cache.partitioned.FetchEntryMessage;
import org.apache.geode.internal.cache.partitioned.FetchKeysMessage;
import org.apache.geode.internal.cache.partitioned.GetMessage;
import org.apache.geode.internal.cache.partitioned.IdentityRequestMessage;
import org.apache.geode.internal.cache.partitioned.IdentityUpdateMessage;
import org.apache.geode.internal.cache.partitioned.IndexCreationMsg;
import org.apache.geode.internal.cache.partitioned.InterestEventMessage;
import org.apache.geode.internal.cache.partitioned.InvalidateMessage;
import org.apache.geode.internal.cache.partitioned.PREntriesIterator;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PRSanityCheckMessage;
import org.apache.geode.internal.cache.partitioned.PRUpdateEntryVersionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionObserver;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionObserverHolder;
import org.apache.geode.internal.cache.partitioned.PutAllPRMessage;
import org.apache.geode.internal.cache.partitioned.PutMessage;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.cache.partitioned.RemoveAllPRMessage;
import org.apache.geode.internal.cache.partitioned.RemoveIndexesMessage;
import org.apache.geode.internal.cache.partitioned.SizeMessage;
import org.apache.geode.internal.cache.persistence.PRPersistentConfig;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tier.sockets.command.Get70;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.cache.wan.GatewaySenderException;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import org.apache.geode.internal.concurrent.ConcurrentHashSet;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.sequencelog.RegionLogger;
import org.apache.geode.internal.size.Sizeable;
import org.apache.geode.internal.util.TransformUtils;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PartitionedRegion
extends LocalRegion
implements CacheDistributionAdvisee,
QueryExecutor {
    public static final Random RANDOM = new Random(Long.getLong("gemfire.PartitionedRegionRandomSeed", NanoTimer.getTime()));
    private static final AtomicInteger SERIAL_NUMBER_GENERATOR = new AtomicInteger();
    public static final int NETWORK_HOP_NONE = 0;
    private static final int NETWORK_HOP_TO_SAME_GROUP = 1;
    public static final int NETWORK_HOP_TO_DIFFERENT_GROUP = 2;
    private final DiskRegionStats diskRegionStats;
    static final boolean DISABLE_SECONDARY_BUCKET_ACK = Boolean.getBoolean("gemfire.disablePartitionedRegionBucketAck");
    public static boolean BEFORE_CALCULATE_STARTING_BUCKET_FLAG = false;
    private static ThreadLocal threadRandom = new ThreadLocal(){

        protected Object initialValue() {
            int i = RANDOM.nextInt();
            if (i < 0) {
                i = -1 * i;
            }
            return i;
        }
    };
    private volatile Region<String, PartitionRegionConfig> prRoot;
    protected PartitionedRegionDataStore dataStore;
    private final RegionAdvisor distAdvisor;
    private static final Logger logger = LogService.getLogger();
    private boolean cleanPRRegistration = false;
    private static final long VM_OWNERSHIP_WAIT_TIME = PRSystemPropertyGetter.parseLong(System.getProperty("gemfire.VM_OWNERSHIP_WAIT_TIME"), Long.MAX_VALUE);
    final int redundantCopies;
    final int minimumWriteRedundancy;
    final int minimumReadRedundancy;
    static final float rebalanceThreshold = 0.75f;
    final int localMaxMemory;
    private final int retryTimeout;
    public final PartitionedRegionStats prStats;
    private final int totalNumberOfBuckets;
    public static final int DEFAULT_RETRY_ITERATIONS = 3;
    private volatile boolean haveCacheLoader;
    private final String regionIdentifier;
    private static final PRIdMap prIdToPR = new PRIdMap();
    public volatile boolean isClosed = false;
    public volatile boolean isLocallyDestroyed = false;
    Thread locallyDestroyingThread;
    private volatile boolean hasPartitionedIndex = false;
    private final AdvisorListener advisorListener = new AdvisorListener();
    private final ConcurrentMap indexes = new ConcurrentHashMap();
    private volatile boolean recoveredFromDisk;
    public static final int RUNNING_MODE = -1;
    public static final int PRIMARY_BUCKETS_LOCKED = 1;
    public static final int DISK_STORE_FLUSHED = 2;
    public static final int OFFLINE_EQUAL_PERSISTED = 3;
    private volatile int shutDownAllStatus = -1;
    private final long birthTime = System.currentTimeMillis();
    private final PartitionedRegion colocatedWithRegion;
    private ColocationLogger missingColocatedRegionLogger;
    private List<BucketRegion> sortedBuckets;
    private ScheduledExecutorService bucketSorter;
    private final ConcurrentMap<String, Integer[]> partitionsMap = new ConcurrentHashMap<String, Integer[]>();
    private boolean enableConflation;
    private final Object indexLock = new Object();
    private final Set<ColocationListener> colocationListeners = new ConcurrentHashSet<ColocationListener>();
    private static final ThreadLocal<Byte> networkHopType = new ThreadLocal<Byte>(){

        @Override
        protected Byte initialValue() {
            return (byte)0;
        }
    };
    private static final ThreadLocal<Byte> metadataVersion = new ThreadLocal<Byte>(){

        @Override
        protected Byte initialValue() {
            return (byte)0;
        }
    };
    public static final String BUCKET_ID_SEPARATOR = ":";
    private static InternalDistributedSystem.DisconnectListener dsPRIdCleanUpListener = new InternalDistributedSystem.DisconnectListener(){

        public String toString() {
            return LocalizedStrings.PartitionedRegion_SHUTDOWN_LISTENER_FOR_PARTITIONEDREGION.toLocalizedString();
        }

        @Override
        public void onDisconnect(InternalDistributedSystem sys) {
            PartitionedRegion.clearPRIdMap();
        }
    };
    private int partitionedRegionId = -3;
    private final Node node;
    private final PRHARedundancyProvider redundancyProvider;
    private boolean requiresNotification;
    private final StoppableCountDownLatch initializationLatchAfterBucketIntialization;
    public static final String RETRY_TIMEOUT_PROPERTY = "gemfire.partitionedRegionRetryTimeout";
    private final PartitionRegionConfigValidator validator;
    final List<FixedPartitionAttributesImpl> fixedPAttrs;
    private byte fixedPASet;
    private final List<PartitionedRegion> colocatedByList = new CopyOnWriteArrayList<PartitionedRegion>();
    private final PartitionListener[] partitionListeners;
    private boolean isShadowPR = false;
    private AbstractGatewaySender parallelGatewaySender = null;
    private final PartitionedRegionRedundancyTracker redundancyTracker;
    public static final String BUCKET_NAME_SEPARATOR = "_";
    private final AtomicBoolean bucketSorterStarted = new AtomicBoolean(false);
    private final AtomicBoolean bucketSortedOnce = new AtomicBoolean(false);

    public void setShutDownAllStatus(int newStatus) {
        this.shutDownAllStatus = newStatus;
    }

    public ConcurrentMap<String, Integer[]> getPartitionsMap() {
        return this.partitionsMap;
    }

    public void addColocationListener(ColocationListener colocationListener) {
        if (colocationListener != null) {
            this.colocationListeners.add(colocationListener);
        }
    }

    public void removeColocationListener(ColocationListener colocationListener) {
        this.colocationListeners.remove(colocationListener);
    }

    static PRIdMap getPrIdToPR() {
        return prIdToPR;
    }

    public void clearNetworkHopData() {
        networkHopType.remove();
        metadataVersion.remove();
    }

    private void setNetworkHopType(Byte value) {
        networkHopType.set(value);
    }

    public byte getNetworkHopType() {
        return networkHopType.get();
    }

    private void setMetadataVersion(Byte value) {
        metadataVersion.set(value);
    }

    public byte getMetadataVersion() {
        return metadataVersion.get();
    }

    public EvictionController getPREvictionControllerFromDiskInitialization() {
        EvictionController result = null;
        if (this.getDiskStore() != null) {
            result = this.getDiskStore().getExistingPREvictionContoller(this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value, Object callbackArg) {
        long startTime = PartitionedRegionStats.startTime();
        try {
            boolean bl = super.remove(key, value, callbackArg);
            return bl;
        }
        finally {
            this.prStats.endDestroy(startTime);
        }
    }

    public PartitionListener[] getPartitionListeners() {
        return this.partitionListeners;
    }

    public String bucketStringForLogs(int bucketId) {
        return this.getPRId() + BUCKET_ID_SEPARATOR + bucketId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPRIdMap() {
        PRIdMap pRIdMap = prIdToPR;
        synchronized (pRIdMap) {
            prIdToPR.clear();
        }
    }

    PartitionedRegionRedundancyTracker getRedundancyTracker() {
        return this.redundancyTracker;
    }

    public PartitionedRegion(String regionName, RegionAttributes regionAttributes, LocalRegion parentRegion, InternalCache cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, regionAttributes, parentRegion, cache, internalRegionArgs);
        this.node = this.initializeNode();
        this.prStats = new PartitionedRegionStats(cache.getDistributedSystem(), this.getFullPath());
        this.regionIdentifier = this.getFullPath().replace('/', '#');
        if (logger.isDebugEnabled()) {
            logger.debug("Constructing Partitioned Region {}", (Object)regionName);
        }
        cache.getInternalDistributedSystem().addDisconnectListener(dsPRIdCleanUpListener);
        this.partitionAttributes = regionAttributes.getPartitionAttributes();
        this.localMaxMemory = this.partitionAttributes.getLocalMaxMemory();
        this.retryTimeout = Integer.getInteger(RETRY_TIMEOUT_PROPERTY, 3600000);
        this.totalNumberOfBuckets = this.partitionAttributes.getTotalNumBuckets();
        this.prStats.incTotalNumBuckets(this.totalNumberOfBuckets);
        this.distAdvisor = RegionAdvisor.createRegionAdvisor(this);
        this.redundancyProvider = new PRHARedundancyProvider(this);
        this.redundantCopies = regionAttributes.getPartitionAttributes().getRedundantCopies();
        this.redundancyTracker = new PartitionedRegionRedundancyTracker(this.totalNumberOfBuckets, this.redundantCopies, this.prStats, this.getFullPath());
        this.prStats.setConfiguredRedundantCopies(regionAttributes.getPartitionAttributes().getRedundantCopies());
        this.prStats.setLocalMaxMemory((long)regionAttributes.getPartitionAttributes().getLocalMaxMemory() * 1024L * 1024L);
        this.minimumWriteRedundancy = Integer.getInteger("gemfire.mimimumPartitionedRegionWriteRedundancy", 0);
        this.minimumReadRedundancy = Integer.getInteger("gemfire.mimimumPartitionedRegionReadRedundancy", 0);
        this.haveCacheLoader = regionAttributes.getCacheLoader() != null;
        this.initializationLatchAfterBucketIntialization = new StoppableCountDownLatch(this.getCancelCriterion(), 1);
        this.validator = new PartitionRegionConfigValidator(this);
        this.partitionListeners = this.partitionAttributes.getPartitionListeners();
        this.colocatedWithRegion = ColocationHelper.getColocatedRegion(this);
        if (this.colocatedWithRegion != null) {
            this.colocatedWithRegion.getColocatedByList().add(this);
        }
        if (this.colocatedWithRegion != null && !internalRegionArgs.isUsedForParallelGatewaySenderQueue()) {
            this.fixedPAttrs = this.colocatedWithRegion.getFixedPartitionAttributesImpl();
            this.fixedPASet = this.colocatedWithRegion.fixedPASet;
        } else {
            this.fixedPAttrs = this.partitionAttributes.getFixedPartitionAttributes();
            this.fixedPASet = 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Partitioned Region {} constructed {}", (Object)regionName, (Object)(this.haveCacheLoader ? "with a cache loader" : ""));
        }
        if (this.getEvictionAttributes() != null && this.getEvictionAttributes().getAlgorithm().isLRUHeap()) {
            this.sortedBuckets = new ArrayList<BucketRegion>();
            final LoggingThreadGroup grp = LoggingThreadGroup.createThreadGroup("BucketSorterThread", logger);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(grp, r, "BucketSorterThread");
                    t.setDaemon(true);
                    return t;
                }
            };
            this.bucketSorter = Executors.newScheduledThreadPool(1, tf);
        }
        if (this.getEvictionAttributes() != null && !this.getEvictionAttributes().getAlgorithm().isNone() && this.getEvictionAttributes().getAction().isOverflowToDisk() || this.getDataPolicy().withPersistence()) {
            DistributedSystem sf = this.getCache().getDistributedSystem();
            this.diskRegionStats = new DiskRegionStats(sf, this.getFullPath());
        } else {
            this.diskRegionStats = null;
        }
        if (internalRegionArgs.isUsedForParallelGatewaySenderQueue()) {
            this.isShadowPR = true;
            this.parallelGatewaySender = internalRegionArgs.getParallelGatewaySender();
        }
        if (this.getDataPolicy().withPersistence()) {
            this.startPersistenceProfileLogging();
        }
    }

    private void startPersistenceProfileLogging() {
        this.distAdvisor.addProfileChangeListener(new ProfileListener(){

            @Override
            public void profileCreated(DistributionAdvisor.Profile profile) {
            }

            @Override
            public void profileUpdated(DistributionAdvisor.Profile profile) {
            }

            @Override
            public void profileRemoved(DistributionAdvisor.Profile profile, boolean destroyed) {
                if (PartitionedRegion.this.isInitialized()) {
                    CacheDistributionAdvisor.CacheProfile cacheProfile = profile instanceof CacheDistributionAdvisor.CacheProfile ? (CacheDistributionAdvisor.CacheProfile)profile : null;
                    HashSet onlineMembers = new HashSet();
                    TransformUtils.transform(PartitionedRegion.this.distAdvisor.advisePersistentMembers().values(), onlineMembers, TransformUtils.persistentMemberIdToLogEntryTransformer);
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.PersistenceAdvisorImpl_PERSISTENT_VIEW, new Object[]{PartitionedRegion.this.getName(), TransformUtils.persistentMemberIdToLogEntryTransformer.transform(cacheProfile.persistentID), onlineMembers}));
                }
            }
        });
    }

    public boolean isShadowPR() {
        return this.isShadowPR;
    }

    public AbstractGatewaySender getParallelGatewaySender() {
        return this.parallelGatewaySender;
    }

    public Set<String> getParallelGatewaySenderIds() {
        Set<String> regionGatewaySenderIds = this.getAllGatewaySenderIds();
        if (regionGatewaySenderIds.isEmpty()) {
            return Collections.emptySet();
        }
        Set<GatewaySender> cacheGatewaySenders = this.getCache().getAllGatewaySenders();
        HashSet<String> parallelGatewaySenderIds = new HashSet<String>();
        for (GatewaySender sender : cacheGatewaySenders) {
            if (!regionGatewaySenderIds.contains(sender.getId()) || !sender.isParallel()) continue;
            parallelGatewaySenderIds.add(sender.getId());
        }
        return parallelGatewaySenderIds;
    }

    public List<PartitionedRegion> getColocatedByList() {
        return this.colocatedByList;
    }

    public boolean isColocatedBy() {
        return !this.colocatedByList.isEmpty();
    }

    private void createAndValidatePersistentConfig() {
        DiskStoreImpl diskStore = this.getDiskStore();
        if (this.getDataPolicy().withPersistence() && !this.getConcurrencyChecksEnabled() && this.supportsConcurrencyChecks()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_ENABLING_CONCURRENCY_CHECKS_FOR_PERSISTENT_PR, this.getFullPath()));
            this.setConcurrencyChecksEnabled(true);
        }
        if (diskStore != null && this.getDataPolicy().withPersistence()) {
            String colocatedWith = this.colocatedWithRegion == null ? "" : this.colocatedWithRegion.getFullPath();
            PRPersistentConfig config = diskStore.getPersistentPRConfig(this.getFullPath());
            if (config != null) {
                if (config.getTotalNumBuckets() != this.getTotalNumberOfBuckets()) {
                    Object[] prms = new Object[]{this.getFullPath(), this.getTotalNumberOfBuckets(), config.getTotalNumBuckets()};
                    throw new IllegalStateException(LocalizedStrings.PartitionedRegion_FOR_REGION_0_TotalBucketNum_1_SHOULD_NOT_BE_CHANGED_Previous_Configured_2.toString(prms));
                }
                if (!colocatedWith.equals(config.getColocatedWith())) {
                    Object[] prms = new Object[]{this.getFullPath(), colocatedWith, config.getColocatedWith()};
                    DiskAccessException dae = new DiskAccessException(LocalizedStrings.LocalRegion_A_DISKACCESSEXCEPTION_HAS_OCCURRED_WHILE_WRITING_TO_THE_DISK_FOR_REGION_0_THE_REGION_WILL_BE_CLOSED.toLocalizedString(this.getFullPath()), null, diskStore);
                    diskStore.handleDiskAccessException(dae);
                    throw new IllegalStateException(LocalizedStrings.PartitionedRegion_FOR_REGION_0_ColocatedWith_1_SHOULD_NOT_BE_CHANGED_Previous_Configured_2.toString(prms));
                }
            } else {
                config = new PRPersistentConfig(this.getTotalNumberOfBuckets(), colocatedWith);
                diskStore.addPersistentPR(this.getFullPath(), config);
                if (this.colocatedWithRegion != null && this.colocatedWithRegion.getDiskStore() != null && this.colocatedWithRegion.getDiskStore() != diskStore) {
                    this.colocatedWithRegion.getDiskStore().addPersistentPR(this.getFullPath(), config);
                }
            }
        }
    }

    private synchronized boolean initPRInternals(InternalRegionArguments internalRegionArgs) {
        block17: {
            boolean storesData;
            block16: {
                if (this.isLocallyDestroyed) {
                    return false;
                }
                if (this.cache.isCacheAtShutdownAll()) {
                    throw this.cache.getCacheClosedException("Cache is shutting down");
                }
                this.validator.validateColocation();
                this.createAndValidatePersistentConfig();
                this.initializePartitionedRegion();
                boolean bl = storesData = this.localMaxMemory > 0;
                if (storesData) {
                    this.initializeDataStore(this.getAttributes());
                }
                this.registerPartitionedRegion(storesData);
                this.getRegionAdvisor().initializeRegionAdvisor();
                this.getRegionAdvisor().addMembershipListener(this.advisorListener);
                this.validator.validateEvictionAttributesAgainstLocalMaxMemory();
                this.validator.validateFixedPartitionAttributes();
                try {
                    new CreateRegionProcessor(this).initializeRegion();
                }
                catch (IllegalStateException e) {
                    if (!this.isDataStore() && this.supportsConcurrencyChecks()) {
                        this.setConcurrencyChecksEnabled(!this.getConcurrencyChecksEnabled());
                        new CreateRegionProcessor(this).initializeRegion();
                    }
                    throw e;
                }
                if (!this.isDestroyed && !this.isLocallyDestroyed) {
                    this.cache.getInternalResourceManager().addResourceListener(InternalResourceManager.ResourceType.MEMORY, this);
                }
                this.createOQLIndexes(internalRegionArgs);
                if (this.isAllEvents()) {
                    StateFlushOperation sfo = new StateFlushOperation(this.getDistributionManager());
                    try {
                        sfo.flush(this.distAdvisor.adviseAllPRNodes(), this.getDistributionManager().getId(), 75, false);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.getCancelCriterion().checkCancelInProgress(ie);
                    }
                }
                this.releaseBeforeGetInitialImageLatch();
                this.getRegionAdvisor().processProfilesQueuedDuringInitialization();
                this.releaseAfterBucketMetadataSetupLatch();
                try {
                    if (storesData && this.redundancyProvider.recoverPersistentBuckets()) {
                        PartitionedRegion leaderRegion = ColocationHelper.getLeaderRegion(this);
                        this.markRecoveredRecursively(leaderRegion);
                    }
                }
                catch (RegionDestroyedException rde) {
                    if (!logger.isDebugEnabled()) break block16;
                    logger.debug("initPRInternals: failed due to exception", (Throwable)rde);
                }
            }
            this.releaseAfterGetInitialImageLatch();
            try {
                if (storesData) {
                    this.redundancyProvider.scheduleCreateMissingBuckets();
                    this.redundancyProvider.startRedundancyRecovery();
                }
            }
            catch (RegionDestroyedException rde) {
                if (!logger.isDebugEnabled()) break block17;
                logger.debug("initPRInternals: failed due to exception", (Throwable)rde);
            }
        }
        return true;
    }

    private void markRecoveredRecursively(PartitionedRegion region) {
        region.setRecoveredFromDisk();
        for (PartitionedRegion colocatedRegion : ColocationHelper.getColocatedChildRegions(region)) {
            this.markRecoveredRecursively(colocatedRegion);
        }
    }

    @Override
    public void postCreateRegion() {
        Set<String> allGatewaySenderIds;
        PartitionListener[] partitionListeners;
        int i;
        super.postCreateRegion();
        CacheListener[] listeners = this.fetchCacheListenersField();
        if (listeners != null && listeners.length > 0) {
            Set<InternalDistributedMember> others = this.getRegionAdvisor().adviseGeneric();
            for (i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof RegionMembershipListener)) continue;
                RegionMembershipListener rml = (RegionMembershipListener)listeners[i];
                try {
                    DistributedMember[] otherDms = new DistributedMember[others.size()];
                    others.toArray(otherDms);
                    rml.initialMembers(this, otherDms);
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.error((Message)LocalizedMessage.create(LocalizedStrings.DistributedRegion_EXCEPTION_OCCURRED_IN_REGIONMEMBERSHIPLISTENER), t);
                }
            }
        }
        if ((partitionListeners = this.getPartitionListeners()) != null && partitionListeners.length != 0) {
            for (i = 0; i < partitionListeners.length; ++i) {
                PartitionListener listener = partitionListeners[i];
                if (listener == null) continue;
                listener.afterRegionCreate(this);
            }
        }
        if (!(allGatewaySenderIds = this.getAllGatewaySenderIds()).isEmpty()) {
            for (GatewaySender sender : this.cache.getAllGatewaySenders()) {
                if (!sender.isParallel() || !allGatewaySenderIds.contains(sender.getId()) || !sender.isRunning()) continue;
                AbstractGatewaySender senderImpl = (AbstractGatewaySender)sender;
                ((ConcurrentParallelGatewaySenderQueue)senderImpl.getQueues().toArray(new RegionQueue[1])[0]).addShadowPartitionedRegionForUserPR(this);
            }
        }
    }

    @Override
    public void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, ClassNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug("PartitionedRegion#initialize {}", (Object)this.getName());
        }
        RegionLogger.logCreate(this.getName(), this.getDistributionManager().getDistributionManagerId());
        this.requiresNotification = this.cache.requiresNotificationFromPR(this);
        this.initPRInternals(internalRegionArgs);
        if (logger.isDebugEnabled()) {
            logger.debug("PartitionRegion#initialize: finished with {}", (Object)this);
        }
        this.cache.addPartitionedRegion(this);
    }

    @Override
    protected RegionVersionVector createRegionVersionVector() {
        return null;
    }

    private Node initializeNode() {
        return new Node(this.getDistributionManager().getId(), SERIAL_NUMBER_GENERATOR.getAndIncrement());
    }

    public void cacheRequiresNotification() {
        if (!(this.requiresNotification || this.isClosed || this.isLocallyDestroyed)) {
            this.requiresNotification = true;
            new UpdateAttributesProcessor(this).distribute(false);
        }
    }

    @Override
    void distributeUpdatedProfileOnSenderCreation() {
        if (!this.isClosed && !this.isLocallyDestroyed) {
            this.requiresNotification = true;
            new UpdateAttributesProcessor(this).distribute(false);
        }
    }

    @Override
    public void addGatewaySenderId(String gatewaySenderId) {
        super.addGatewaySenderId(gatewaySenderId);
        new UpdateAttributesProcessor(this).distribute();
        this.distributeUpdatedProfileOnSenderCreation();
        GatewaySender sender = this.getCache().getGatewaySender(gatewaySenderId);
        if (sender != null && sender.isParallel() && sender.isRunning()) {
            AbstractGatewaySender senderImpl = (AbstractGatewaySender)sender;
            ((ConcurrentParallelGatewaySenderQueue)senderImpl.getQueues().toArray(new RegionQueue[1])[0]).addShadowPartitionedRegionForUserPR(this);
        }
    }

    public void updatePRConfigWithNewSetOfGatewaySenders(Set<String> gatewaySendersToAdd) {
        PartitionRegionHelper.assignBucketsToPartitions(this);
        PartitionRegionConfig prConfig = this.prRoot.get(this.getRegionIdentifier());
        prConfig.setGatewaySenderIds(gatewaySendersToAdd);
        this.updatePRConfig(prConfig, false);
    }

    public void updatePRConfigWithNewGatewaySender(String aeqId) {
        PartitionRegionHelper.assignBucketsToPartitions(this);
        PartitionRegionConfig prConfig = this.prRoot.get(this.getRegionIdentifier());
        HashSet<String> newGateWayIds = prConfig.getGatewaySenderIds() != null ? new HashSet<String>(prConfig.getGatewaySenderIds()) : new HashSet<String>();
        newGateWayIds.add(aeqId);
        prConfig.setGatewaySenderIds(newGateWayIds);
        this.updatePRConfig(prConfig, false);
    }

    @Override
    public void removeGatewaySenderId(String gatewaySenderId) {
        super.removeGatewaySenderId(gatewaySenderId);
        new UpdateAttributesProcessor(this).distribute();
    }

    @Override
    public void addAsyncEventQueueId(String asyncEventQueueId) {
        this.addAsyncEventQueueId(asyncEventQueueId, false);
    }

    @Override
    public void addAsyncEventQueueId(String asyncEventQueueId, boolean isInternal) {
        super.addAsyncEventQueueId(asyncEventQueueId, isInternal);
        new UpdateAttributesProcessor(this).distribute();
        this.distributeUpdatedProfileOnSenderCreation();
        GatewaySender sender = this.getCache().getGatewaySender(AsyncEventQueueImpl.getSenderIdFromAsyncEventQueueId(asyncEventQueueId));
        if (sender != null && sender.isParallel() && sender.isRunning()) {
            AbstractGatewaySender senderImpl = (AbstractGatewaySender)sender;
            ((ConcurrentParallelGatewaySenderQueue)senderImpl.getQueues().toArray(new RegionQueue[1])[0]).addShadowPartitionedRegionForUserPR(this);
        }
    }

    @Override
    public void removeAsyncEventQueueId(String asyncEventQueueId) {
        super.removeAsyncEventQueueId(asyncEventQueueId);
        new UpdateAttributesProcessor(this).distribute();
    }

    @Override
    public void checkSameSenderIdsAvailableOnAllNodes() {
        List<Set<String>> senderIds = this.getCacheDistributionAdvisor().adviseSameGatewaySenderIds(this.getGatewaySenderIds());
        if (!senderIds.isEmpty()) {
            throw new GatewaySenderConfigurationException(LocalizedStrings.Region_REGION_0_HAS_1_GATEWAY_SENDER_IDS_ANOTHER_CACHE_HAS_THE_SAME_REGION_WITH_2_GATEWAY_SENDER_IDS_FOR_REGION_ACROSS_ALL_MEMBERS_IN_DS_GATEWAY_SENDER_IDS_SHOULD_BE_SAME.toLocalizedString(this.getName(), senderIds.get(0), senderIds.get(1)));
        }
        List<Set<String>> asycnQueueIds = this.getCacheDistributionAdvisor().adviseSameAsyncEventQueueIds(this.getVisibleAsyncEventQueueIds());
        if (!asycnQueueIds.isEmpty()) {
            throw new GatewaySenderConfigurationException(LocalizedStrings.Region_REGION_0_HAS_1_ASYNC_EVENT_QUEUE_IDS_ANOTHER_CACHE_HAS_THE_SAME_REGION_WITH_2_ASYNC_EVENT_QUEUE_IDS_FOR_REGION_ACROSS_ALL_MEMBERS_IN_DS_ASYNC_EVENT_QUEUE_IDS_SHOULD_BE_SAME.toLocalizedString(this.getName(), asycnQueueIds.get(0), asycnQueueIds.get(1)));
        }
    }

    private void initializePartitionedRegion() {
        this.prRoot = PartitionedRegionHelper.getPRRoot(this.getCache());
    }

    @Override
    public void remoteRegionInitialized(CacheDistributionAdvisor.CacheProfile profile) {
        if (this.isInitialized() && this.hasListener()) {
            CacheDistributionAdvisor.CacheProfile callback = DistributedRegion.TEST_HOOK_ADD_PROFILE ? profile : null;
            RegionEventImpl event = new RegionEventImpl(this, Operation.REGION_CREATE, callback, true, profile.peerMemberId);
            this.dispatchListenerEvent(EnumListenerEvent.AFTER_REMOTE_REGION_CREATE, event);
        }
    }

    private void initializeDataStore(RegionAttributes ra) {
        this.dataStore = PartitionedRegionDataStore.createDataStore(this.cache, this, ra.getPartitionAttributes());
    }

    protected DistributedLockService getPartitionedRegionLockService() {
        return this.getGemFireCache().getPartitionedRegionLockService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPartitionedRegion(boolean storesData) {
        PartitionRegionConfig prConfig = null;
        PartitionAttributes prAttribs = this.getAttributes().getPartitionAttributes();
        if (storesData) {
            if (this.fixedPAttrs != null) {
                this.node.setPRType(5);
            } else {
                this.node.setPRType(3);
            }
            this.node.setPersistence(this.getAttributes().getDataPolicy() == DataPolicy.PERSISTENT_PARTITION);
            byte loaderByte = (byte)(this.getAttributes().getCacheLoader() != null ? 1 : 0);
            byte writerByte = (byte)(this.getAttributes().getCacheWriter() != null ? 2 : 0);
            this.node.setLoaderWriterByte((byte)(loaderByte + writerByte));
        } else if (this.fixedPAttrs != null) {
            this.node.setPRType(4);
        } else {
            this.node.setPRType(1);
        }
        RegionLock rl = this.getRegionLock();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("registerPartitionedRegion: obtaining lock");
            }
            rl.lock();
            this.checkReadiness();
            prConfig = this.prRoot.get(this.getRegionIdentifier());
            if (prConfig == null) {
                this.validateParallelGatewaySenderIds();
                this.partitionedRegionId = this.generatePRId(this.getSystem());
                prConfig = new PartitionRegionConfig(this.partitionedRegionId, this.getFullPath(), prAttribs, this.getScope(), this.getAttributes().getEvictionAttributes(), this.getAttributes().getRegionIdleTimeout(), this.getAttributes().getRegionTimeToLive(), this.getAttributes().getEntryIdleTimeout(), this.getAttributes().getEntryTimeToLive(), this.getAllGatewaySenderIds());
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONED_REGION_0_IS_BORN_WITH_PRID_1_IDENT_2, new Object[]{this.getFullPath(), this.partitionedRegionId, this.getRegionIdentifier()}));
                PRSanityCheckMessage.schedule(this);
            } else {
                this.validator.validatePartitionAttrsFromPRConfig(prConfig);
                if (storesData) {
                    this.validator.validatePersistentMatchBetweenDataStores(prConfig);
                    this.validator.validateCacheLoaderWriterBetweenDataStores(prConfig);
                    this.validator.validateFixedPABetweenDataStores(prConfig);
                }
                this.partitionedRegionId = prConfig.getPRId();
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONED_REGION_0_IS_CREATED_WITH_PRID_1, new Object[]{this.getFullPath(), this.partitionedRegionId}));
            }
            PRIdMap writerByte = prIdToPR;
            synchronized (writerByte) {
                prIdToPR.put((Object)this.partitionedRegionId, this);
            }
            prConfig.addNode(this.node);
            if (this.getFixedPartitionAttributesImpl() != null) {
                this.calculateStartingBucketIDs(prConfig);
            }
            this.updatePRConfig(prConfig, false);
            this.cleanPRRegistration = true;
        }
        catch (LockServiceDestroyedException lsde) {
            if (logger.isDebugEnabled()) {
                logger.debug("registerPartitionedRegion: unable to obtain lock for {}", (Object)this);
            }
            this.cleanupFailedInitialization();
            throw new PartitionedRegionException(LocalizedStrings.PartitionedRegion_CAN_NOT_CREATE_PARTITIONEDREGION_FAILED_TO_ACQUIRE_REGIONLOCK.toLocalizedString(), lsde);
        }
        catch (IllegalStateException ill) {
            this.cleanupFailedInitialization();
            throw ill;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            String registerErrMsg;
            block36: {
                SystemFailure.checkFailure();
                registerErrMsg = LocalizedStrings.PartitionedRegion_AN_EXCEPTION_WAS_CAUGHT_WHILE_REGISTERING_PARTITIONEDREGION_0_DUMPPRID_1.toLocalizedString(this.getFullPath(), prIdToPR.dump());
                try {
                    PRIdMap pRIdMap = prIdToPR;
                    synchronized (pRIdMap) {
                        if (prIdToPR.containsKey(this.partitionedRegionId)) {
                            prIdToPR.put(this.partitionedRegionId, "Partitioned Region's Registration Failed", false);
                            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_FAILED_REGISTRATION_PRID_0_NAMED_1, new Object[]{this.partitionedRegionId, this.getName()}));
                        }
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable e) {
                    SystemFailure.checkFailure();
                    if (!logger.isDebugEnabled()) break block36;
                    logger.debug("Partitioned Region creation, could not clean up after caught exception", e);
                }
            }
            throw new PartitionedRegionException(registerErrMsg, t);
        }
        finally {
            block37: {
                try {
                    rl.unlock();
                    if (logger.isDebugEnabled()) {
                        logger.debug("registerPartitionedRegion: released lock");
                    }
                }
                catch (Exception es) {
                    if (!logger.isDebugEnabled()) break block37;
                    logger.debug(es.getMessage(), (Throwable)es);
                }
            }
        }
    }

    public void validateParallelGatewaySenderIds() throws PRLocallyDestroyedException {
        this.validateParallelGatewaySenderIds(this.getParallelGatewaySenderIds());
    }

    public Set<String> filterOutNonParallelGatewaySenders(Set<String> senderIds) {
        Set allParallelSenders = this.cache.getAllGatewaySenders().parallelStream().filter(GatewaySender::isParallel).map(GatewaySender::getId).collect(Collectors.toSet());
        HashSet<String> parallelSenders = new HashSet<String>();
        senderIds.parallelStream().forEach((? super T gatewaySenderId) -> {
            if (allParallelSenders.contains(gatewaySenderId)) {
                parallelSenders.add((String)gatewaySenderId);
            }
        });
        return parallelSenders;
    }

    public void validateParallelGatewaySenderIds(Set<String> parallelGatewaySenderIds) throws PRLocallyDestroyedException {
        for (String senderId : parallelGatewaySenderIds) {
            for (PartitionRegionConfig config : this.prRoot.values()) {
                if (!config.getGatewaySenderIds().contains(senderId) || this.getFullPath().equals(config.getFullPath())) continue;
                Map<String, PartitionedRegion> colocationMap = ColocationHelper.getAllColocationRegions(this);
                if (!colocationMap.isEmpty()) {
                    int prID;
                    PartitionedRegion colocatedPR;
                    PartitionedRegion leader;
                    if (colocationMap.containsKey(config.getFullPath()) || colocationMap.containsValue(leader = ColocationHelper.getLeaderRegion(colocatedPR = PartitionedRegion.getPRFromId(prID = config.getPRId())))) continue;
                    throw new IllegalStateException(LocalizedStrings.PartitionRegion_NON_COLOCATED_REGIONS_1_2_CANNOT_HAVE_SAME_PARALLEL_GATEWAY_SENDER_ID_2.toString(this.getFullPath(), config.getFullPath(), senderId.contains("AsyncEventQueue_") ? "async event queue" : "gateway sender", senderId));
                }
                throw new IllegalStateException(LocalizedStrings.PartitionRegion_NON_COLOCATED_REGIONS_1_2_CANNOT_HAVE_SAME_PARALLEL_GATEWAY_SENDER_ID_2.toString(this.getFullPath(), config.getFullPath(), senderId.contains("AsyncEventQueue_") ? "async event queue" : "gateway sender", senderId));
            }
        }
    }

    public boolean getRequiresNotification() {
        return this.requiresNotification;
    }

    public String getRegionIdentifier() {
        return this.regionIdentifier;
    }

    void setRecoveredFromDisk() {
        this.recoveredFromDisk = true;
        new UpdateAttributesProcessor(this).distribute(false);
    }

    public void checkPROffline() throws PartitionOfflineException {
        if (this.getDataPolicy().withPersistence() && !this.recoveredFromDisk) {
            HashSet<PersistentMemberID> persistIds = new HashSet<PersistentMemberID>(this.getRegionAdvisor().advisePersistentMembers().values());
            persistIds.removeAll(this.getRegionAdvisor().adviseInitializedPersistentMembers().values());
            throw new PartitionOfflineException(persistIds, LocalizedStrings.PRHARedundancyProvider_PARTITIONED_REGION_0_OFFLINE_HAS_UNRECOVERED_PERSISTENT_DATA_1.toLocalizedString(this.getFullPath(), persistIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePRConfig(PartitionRegionConfig prConfig, boolean putOnlyIfUpdated) {
        Set<Node> nodes = prConfig.getNodes();
        PartitionedRegion colocatedRegion = ColocationHelper.getColocatedRegion(this);
        RegionLock colocatedLock = null;
        boolean colocatedLockAcquired = false;
        try {
            boolean colocationComplete = false;
            if (colocatedRegion != null && !prConfig.isColocationComplete()) {
                colocatedLock = colocatedRegion.getRegionLock();
                colocatedLock.lock();
                colocatedLockAcquired = true;
                PartitionRegionConfig parentConf = this.prRoot.get(colocatedRegion.getRegionIdentifier());
                if (parentConf.isColocationComplete() && parentConf.hasSameDataStoreMembers(prConfig)) {
                    colocationComplete = true;
                    prConfig.setColocationComplete(this);
                }
            }
            if (this.isDataStore() && !prConfig.isFirstDataStoreCreated()) {
                prConfig.setDatastoreCreated(this.getEvictionAttributes());
            }
            if (!putOnlyIfUpdated || colocationComplete) {
                this.prRoot.put(this.getRegionIdentifier(), prConfig);
            }
        }
        finally {
            if (colocatedLockAcquired) {
                colocatedLock.unlock();
            }
        }
    }

    void executeColocationCallbacks() {
        this.colocationListeners.stream().forEach(ColocationListener::afterColocationCompleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Region.Entry<?, ?> nonTXGetEntry(KeyInfo keyInfo, boolean access, boolean allowTombstones) {
        long startTime = PartitionedRegionStats.startTime();
        Object key = keyInfo.getKey();
        try {
            int bucketId = keyInfo.getBucketId();
            if (bucketId == -1) {
                bucketId = PartitionedRegionHelper.getHashKey(this, Operation.GET_ENTRY, key, null, null);
                keyInfo.setBucketId(bucketId);
            }
            InternalDistributedMember targetNode = this.getOrCreateNodeForBucketRead(bucketId);
            EntrySnapshot entrySnapshot = this.getEntryInBucket(targetNode, bucketId, key, access, allowTombstones);
            return entrySnapshot;
        }
        finally {
            this.prStats.endGetEntry(startTime);
        }
    }

    protected EntrySnapshot getEntryInBucket(DistributedMember targetNode, int bucketId, Object key, boolean access, boolean allowTombstones) {
        int retryAttempts = this.calcRetry();
        if (logger.isTraceEnabled()) {
            logger.trace("getEntryInBucket: Key key={} ({}) from: {} bucketId={}", key, (Object)key.hashCode(), (Object)targetNode, (Object)this.bucketStringForLogs(bucketId));
        }
        Integer bucketIdInt = bucketId;
        EntrySnapshot ret = null;
        int count = 0;
        RetryTimeKeeper retryTime = null;
        InternalDistributedMember retryNode = (InternalDistributedMember)targetNode;
        while (count <= retryAttempts) {
            if (retryNode == null) {
                this.checkReadiness();
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                if (retryTime.overMaximum()) break;
                retryNode = this.getOrCreateNodeForBucketRead(bucketId);
                if (retryNode != null) continue;
                this.checkShutdown();
                return null;
            }
            try {
                boolean loc;
                boolean bl = loc = this.localMaxMemory > 0 && retryNode.equals(this.getMyId());
                if (loc) {
                    ret = this.dataStore.getEntryLocally(bucketId, key, access, allowTombstones);
                } else {
                    ret = this.getEntryRemotely(retryNode, bucketIdInt, key, access, allowTombstones);
                    String name = Thread.currentThread().getName();
                    if (name.startsWith("ServerConnection") && !this.getMyId().equals(targetNode)) {
                        this.setNetworkHopType(bucketIdInt, (InternalDistributedMember)targetNode);
                    }
                }
                return ret;
            }
            catch (PRLocallyDestroyedException pde) {
                if (logger.isDebugEnabled()) {
                    logger.debug("getEntryInBucket: Encountered PRLocallyDestroyedException", (Throwable)pde);
                }
                this.checkReadiness();
            }
            catch (EntryNotFoundException ignore) {
                return null;
            }
            catch (ForceReattemptException prce) {
                prce.checkKey(key);
                if (logger.isDebugEnabled()) {
                    logger.debug("getEntryInBucket: retrying, attempts so far: {}", (Object)count, (Object)prce);
                }
                this.checkReadiness();
                InternalDistributedMember lastNode = retryNode;
                retryNode = this.getOrCreateNodeForBucketRead(bucketIdInt);
                if (lastNode.equals(retryNode)) {
                    if (retryTime == null) {
                        retryTime = new RetryTimeKeeper(this.retryTimeout);
                    }
                    if (retryTime.overMaximum()) break;
                    retryTime.waitToRetryNode();
                }
            }
            catch (PrimaryBucketException notPrimary) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Bucket {} on Node {} not primary", (Object)notPrimary.getLocalizedMessage(), (Object)retryNode);
                }
                this.getRegionAdvisor().notPrimary(bucketIdInt, retryNode);
                retryNode = this.getOrCreateNodeForBucketRead(bucketIdInt);
            }
            this.checkShutdown();
            if (++count == 1) {
                this.prStats.incContainsKeyValueOpsRetried();
            }
            this.prStats.incContainsKeyValueRetries();
        }
        PartitionedRegionDistributionException e = null;
        if (logger.isDebugEnabled()) {
            e = new PartitionedRegionDistributionException(LocalizedStrings.PartitionRegion_NO_VM_AVAILABLE_FOR_GETENTRY_IN_0_ATTEMPTS.toLocalizedString(count));
        }
        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionRegion_NO_VM_AVAILABLE_FOR_GETENTRY_IN_0_ATTEMPTS, count), e);
        return null;
    }

    private void checkShutdown() {
        this.checkReadiness();
        this.cache.getCancelCriterion().checkCancelInProgress(null);
    }

    public EntrySnapshot getEntryRemotely(InternalDistributedMember targetNode, Integer bucketId, Object key, boolean access, boolean allowTombstones) throws EntryNotFoundException, PrimaryBucketException, ForceReattemptException {
        FetchEntryMessage.FetchEntryResponse r = FetchEntryMessage.send(targetNode, this, key, access);
        this.prStats.incPartitionMessagesSent();
        EntrySnapshot entry = r.waitForResponse();
        if (entry != null && entry.getRawValue() == Token.TOMBSTONE && !allowTombstones) {
            return null;
        }
        return entry;
    }

    @Override
    public void becomeLockGrantor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Region createSubregion(String subregionName, RegionAttributes regionAttributes) throws RegionExistsException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock getDistributedLock(Object key) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStatistics getStatistics() {
        throw new UnsupportedOperationException();
    }

    public Region getSubregion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock getRegionDistributedLock() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localDestroy(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localInvalidate(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localInvalidateRegion(Object aCallbackArgument) {
        this.getDataView().checkSupportsRegionInvalidate();
        throw new UnsupportedOperationException();
    }

    @Override
    public Object executeQuery(DefaultQuery query, Object[] parameters, Set buckets) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        while (true) {
            try {
                return this.doExecuteQuery(query, parameters, buckets);
            }
            catch (ForceReattemptException forceReattemptException) {
                continue;
            }
            break;
        }
    }

    private Object doExecuteQuery(DefaultQuery query, Object[] parameters, Set buckets) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException, ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing query :{}", (Object)query);
        }
        HashSet<Integer> allBuckets = new HashSet<Integer>();
        if (buckets == null) {
            Iterator<Integer> remoteIter = this.getRegionAdvisor().getBucketSet().iterator();
            try {
                while (remoteIter.hasNext()) {
                    allBuckets.add(remoteIter.next());
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        } else {
            Iterator<Object> localIter = null;
            localIter = this.dataStore != null ? buckets.iterator() : Collections.emptySet().iterator();
            try {
                while (localIter.hasNext()) {
                    allBuckets.add((Integer)localIter.next());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (allBuckets.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("No bucket storage allocated. PR has no data yet.");
            }
            ResultsSet resSet = new ResultsSet();
            resSet.setElementType(new ObjectTypeImpl(this.getValueConstraint() == null ? Object.class : this.getValueConstraint()));
            return resSet;
        }
        CompiledSelect selectExpr = query.getSimpleSelect();
        if (selectExpr == null) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionedRegion_QUERY_MUST_BE_A_SELECT_EXPRESSION_ONLY.toLocalizedString());
        }
        SelectResults results = selectExpr.getEmptyResultSet(parameters, this.getCache(), query);
        PartitionedRegionQueryEvaluator prqe = new PartitionedRegionQueryEvaluator(this.getSystem(), this, query, parameters, results, allBuckets);
        while (true) {
            this.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                results = prqe.queryBuckets(null);
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            catch (FunctionDomainException e) {
                throw e;
            }
            catch (TypeMismatchException e) {
                throw e;
            }
            catch (NameResolutionException e) {
                throw e;
            }
            catch (QueryInvocationTargetException e) {
                throw e;
            }
            catch (QueryException qe) {
                throw new QueryInvocationTargetException(LocalizedStrings.PartitionedRegion_UNEXPECTED_QUERY_EXCEPTION_OCCURRED_DURING_QUERY_EXECUTION_0.toLocalizedString(qe.getMessage()), qe);
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        boolean allowsDuplicates = results.getCollectionType().allowsDuplicates();
        if (selectExpr.isDistinct()) {
            ObjectType elementType = results.getCollectionType().getElementType();
            if (selectExpr.getOrderByAttrs() == null && allowsDuplicates) {
                results = new ResultsCollectionWrapper(elementType, results.asSet());
            }
            if (selectExpr.isCount() && (results.isEmpty() || selectExpr.isDistinct())) {
                ResultsBag resultCount = new ResultsBag(this.getCachePerfStats());
                resultCount.setElementType(new ObjectTypeImpl(Integer.class));
                ((Bag)resultCount).addAndGetOccurence(results.size());
                return resultCount;
            }
        }
        return results;
    }

    @Override
    public void saveSnapshot(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeToDisk() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    void basicClear(RegionEventImpl regionEvent, boolean cacheWrite) {
        throw new UnsupportedOperationException();
    }

    @Override
    void basicLocalClear(RegionEventImpl event) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        long startTime = PartitionedRegionStats.startTime();
        boolean result = false;
        DistributedPutAllOperation putAllOp_save = event.setPutAllOperation(null);
        if (event.getEventId() == null) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        boolean bucketStorageAssigned = true;
        try {
            Integer bucketId = event.getKeyInfo().getBucketId();
            assert (bucketId != -1);
            InternalDistributedMember targetNode = this.getNodeForBucketWrite(bucketId, null);
            if (logger.isDebugEnabled()) {
                logger.debug("PR.virtualPut putting event={}", (Object)event);
            }
            if (targetNode == null) {
                try {
                    bucketStorageAssigned = false;
                    targetNode = this.createBucket(bucketId, event.getNewValSizeForPR(), null);
                }
                catch (PartitionedRegionStorageException e) {
                    this.checkReadiness();
                    if (this.cache.isClosed()) {
                        throw new RegionDestroyedException(this.toString(), this.getFullPath());
                    }
                    throw e;
                }
            }
            if (event.isBridgeEvent() && bucketStorageAssigned) {
                this.setNetworkHopType(bucketId, targetNode);
            }
            if (putAllOp_save == null) {
                result = this.putInBucket(targetNode, bucketId, event, ifNew, ifOld, expectedOldValue, requireOldValue, ifNew ? 0L : lastModified);
                if (logger.isDebugEnabled()) {
                    logger.debug("PR.virtualPut event={} ifNew={} ifOld={} result={}", (Object)event, (Object)ifNew, (Object)ifOld, (Object)result);
                }
            } else {
                this.checkIfAboveThreshold(event);
                putAllOp_save.addEntry(event, bucketId);
                if (logger.isDebugEnabled()) {
                    logger.debug("PR.virtualPut PutAll added event={} into bucket {}", (Object)event, (Object)bucketId);
                }
                result = true;
            }
        }
        catch (RegionDestroyedException rde) {
            if (!rde.getRegionFullPath().equals(this.getFullPath())) {
                throw new RegionDestroyedException(this.toString(), this.getFullPath(), rde);
            }
        }
        finally {
            if (putAllOp_save == null) {
                if (ifNew) {
                    this.prStats.endCreate(startTime);
                } else {
                    this.prStats.endPut(startTime);
                }
            }
        }
        if (!result) {
            this.checkReadiness();
            if (!(ifNew || ifOld || this.getConcurrencyChecksEnabled())) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PRVIRTUALPUT_RETURNING_FALSE_WHEN_IFNEW_AND_IFOLD_ARE_BOTH_FALSE), (Throwable)new Exception(LocalizedStrings.PartitionedRegion_STACK_TRACE.toLocalizedString()));
            }
        }
        return result;
    }

    @Override
    public void performPutAllEntry(EntryEventImpl event) {
        this.getSharedDataView().putEntry(event, false, false, null, false, 0L, false);
    }

    @Override
    public void performRemoveAllEntry(EntryEventImpl event) {
        this.getSharedDataView().destroyExistingEntry(event, true, null);
    }

    @Override
    public void checkIfAboveThreshold(EntryEventImpl entryEvent) throws LowMemoryException {
        this.getRegionAdvisor().checkIfBucketSick(entryEvent.getKeyInfo().getBucketId(), entryEvent.getKey());
    }

    public boolean isFixedPartitionedRegion() {
        if (this.fixedPAttrs != null || this.fixedPASet == 1) {
            return true;
        }
        if (this.fixedPASet == 2) {
            return false;
        }
        this.fixedPASet = this.hasRemoteFPAttrs();
        return this.fixedPASet == 1;
    }

    private byte hasRemoteFPAttrs() {
        List<FixedPartitionAttributesImpl> fpaList = this.getRegionAdvisor().adviseAllFixedPartitionAttributes();
        Set<InternalDistributedMember> remoteDataStores = this.getRegionAdvisor().adviseDataStore();
        if (!fpaList.isEmpty() || this.fixedPAttrs != null && !this.fixedPAttrs.isEmpty()) {
            return 1;
        }
        if (this.isDataStore() || !remoteDataStores.isEmpty()) {
            return 2;
        }
        return 0;
    }

    @Override
    public void postPutAllFireEvents(DistributedPutAllOperation putAllOp, VersionedObjectList successfulPuts) {
    }

    @Override
    public void postRemoveAllFireEvents(DistributedRemoveAllOperation removeAllOp, VersionedObjectList successfulOps) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long postPutAllSend(DistributedPutAllOperation putAllOp, VersionedObjectList successfulPuts) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.cache.isCacheAtShutdownAll()) {
            throw this.cache.getCacheClosedException("Cache is shutting down");
        }
        long startTime = PartitionedRegionStats.startTime();
        HashMap prMsgMap = putAllOp.createPRMessages();
        PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(putAllOp.putAllDataSize);
        HashMap<Object, VersionTag> keyToVersionMap = new HashMap<Object, VersionTag>(successfulPuts.size());
        successfulPuts.clearVersions();
        for (Map.Entry mapEntry : prMsgMap.entrySet()) {
            long now;
            Integer bucketId = (Integer)mapEntry.getKey();
            PutAllPRMessage prMsg = (PutAllPRMessage)mapEntry.getValue();
            this.checkReadiness();
            long then = 0L;
            if (isDebugEnabled) {
                then = System.currentTimeMillis();
            }
            try {
                VersionedObjectList versions = this.sendMsgByBucket(bucketId, prMsg);
                if (versions.size() > 0) {
                    partialKeys.addKeysAndVersions(versions);
                    versions.saveVersions(keyToVersionMap);
                } else if (!this.getConcurrencyChecksEnabled()) {
                    Set keys = prMsg.getKeys();
                    partialKeys.addKeys(keys);
                }
            }
            catch (PutAllPartialResultException pre) {
                if (isDebugEnabled) {
                    logger.debug("PR.postPutAll encountered PutAllPartialResultException, ", (Throwable)pre);
                }
                partialKeys.consolidate(pre.getResult());
            }
            catch (Exception ex) {
                if (isDebugEnabled) {
                    logger.debug("PR.postPutAll encountered exception at sendMsgByBucket, ", (Throwable)ex);
                }
                EntryEventImpl firstEvent = prMsg.getFirstEvent(this);
                try {
                    partialKeys.saveFailedKey(firstEvent.getKey(), ex);
                }
                finally {
                    firstEvent.release();
                }
            }
            if (!isDebugEnabled || (now = System.currentTimeMillis()) - then < 10000L) continue;
            logger.debug("PR.sendMsgByBucket took " + (now - then) + " ms");
        }
        this.prStats.endPutAll(startTime);
        if (!keyToVersionMap.isEmpty()) {
            Iterator<Object> it = successfulPuts.getKeys().iterator();
            while (it.hasNext()) {
                successfulPuts.addVersion((VersionTag)keyToVersionMap.get(it.next()));
            }
            keyToVersionMap.clear();
        }
        if (partialKeys.hasFailure()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.Region_PutAll_Applied_PartialKeys_0_1, new Object[]{this.getFullPath(), partialKeys}));
            if (putAllOp.isBridgeOperation()) {
                if (partialKeys.getFailure() instanceof CancelException) {
                    throw (CancelException)partialKeys.getFailure();
                }
                throw new PutAllPartialResultException(partialKeys);
            }
            if (partialKeys.getFailure() instanceof RuntimeException) {
                throw (RuntimeException)partialKeys.getFailure();
            }
            throw new RuntimeException(partialKeys.getFailure());
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long postRemoveAllSend(DistributedRemoveAllOperation op, VersionedObjectList successfulOps) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.cache.isCacheAtShutdownAll()) {
            throw this.cache.getCacheClosedException("Cache is shutting down");
        }
        long startTime = PartitionedRegionStats.startTime();
        HashMap<Integer, RemoveAllPRMessage> prMsgMap = op.createPRMessages();
        PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(op.removeAllDataSize);
        HashMap<Object, VersionTag> keyToVersionMap = new HashMap<Object, VersionTag>(successfulOps.size());
        successfulOps.clearVersions();
        for (Map.Entry<Integer, RemoveAllPRMessage> mapEntry : prMsgMap.entrySet()) {
            long now;
            Integer bucketId = mapEntry.getKey();
            RemoveAllPRMessage prMsg = mapEntry.getValue();
            this.checkReadiness();
            long then = 0L;
            if (isDebugEnabled) {
                then = System.currentTimeMillis();
            }
            try {
                VersionedObjectList versions = this.sendMsgByBucket(bucketId, prMsg);
                if (versions.size() > 0) {
                    partialKeys.addKeysAndVersions(versions);
                    versions.saveVersions(keyToVersionMap);
                } else if (!this.getConcurrencyChecksEnabled()) {
                    Set keys = prMsg.getKeys();
                    partialKeys.addKeys(keys);
                }
            }
            catch (PutAllPartialResultException pre) {
                if (isDebugEnabled) {
                    logger.debug("PR.postRemoveAll encountered BulkOpPartialResultException, ", (Throwable)pre);
                }
                partialKeys.consolidate(pre.getResult());
            }
            catch (Exception ex) {
                if (isDebugEnabled) {
                    logger.debug("PR.postRemoveAll encountered exception at sendMsgByBucket, ", (Throwable)ex);
                }
                EntryEventImpl firstEvent = prMsg.getFirstEvent(this);
                try {
                    partialKeys.saveFailedKey(firstEvent.getKey(), ex);
                }
                finally {
                    firstEvent.release();
                }
            }
            if (!isDebugEnabled || (now = System.currentTimeMillis()) - then < 10000L) continue;
            logger.debug("PR.sendMsgByBucket took {} ms", (Object)(now - then));
        }
        this.prStats.endRemoveAll(startTime);
        if (!keyToVersionMap.isEmpty()) {
            Iterator<Object> it = successfulOps.getKeys().iterator();
            while (it.hasNext()) {
                successfulOps.addVersion((VersionTag)keyToVersionMap.get(it.next()));
            }
            keyToVersionMap.clear();
        }
        if (partialKeys.hasFailure()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.Region_PutAll_Applied_PartialKeys_0_1, new Object[]{this.getFullPath(), partialKeys}));
            if (op.isBridgeOperation()) {
                if (partialKeys.getFailure() instanceof CancelException) {
                    throw (CancelException)partialKeys.getFailure();
                }
                throw new PutAllPartialResultException(partialKeys);
            }
            if (partialKeys.getFailure() instanceof RuntimeException) {
                throw (RuntimeException)partialKeys.getFailure();
            }
            throw new RuntimeException(partialKeys.getFailure());
        }
        return -1L;
    }

    /*
     * Exception decompiling
     */
    private VersionedObjectList sendMsgByBucket(Integer bucketId, PutAllPRMessage prMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private VersionedObjectList sendMsgByBucket(Integer bucketId, RemoveAllPRMessage prMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public VersionedObjectList tryToSendOnePutAllMessage(PutAllPRMessage prMsg, InternalDistributedMember currentTarget) throws DataLocationException {
        boolean isLocal;
        boolean putResult = false;
        VersionedObjectList versions = null;
        boolean bl = isLocal = this.localMaxMemory > 0 && currentTarget.equals(this.getMyId());
        if (isLocal) {
            prMsg.initMessage(this, null, false, null);
            putResult = prMsg.doLocalPutAll(this, this.getDistributionManager().getDistributionManagerId(), 0L);
            versions = prMsg.getVersions();
        } else {
            PutAllPRMessage.PutAllResponse response = (PutAllPRMessage.PutAllResponse)prMsg.send(currentTarget, this);
            PutAllPRMessage.PutAllResult pr = null;
            if (response != null) {
                this.prStats.incPartitionMessagesSent();
                try {
                    pr = response.waitForResult();
                    putResult = pr.returnValue;
                    versions = pr.versions;
                }
                catch (RegionDestroyedException rde) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("prMsg.send: caught RegionDestroyedException", (Throwable)rde);
                    }
                    throw new RegionDestroyedException(this.toString(), this.getFullPath());
                }
                catch (CacheException ce) {
                    throw new PartitionedRegionDistributionException("prMsg.send on " + currentTarget + " failed", ce);
                }
            } else {
                putResult = true;
            }
        }
        if (!putResult) {
            ForceReattemptException fre = new ForceReattemptException("false result in PutAllMessage.send - retrying");
            fre.setHash(0);
            throw fre;
        }
        return versions;
    }

    public VersionedObjectList tryToSendOneRemoveAllMessage(RemoveAllPRMessage prMsg, InternalDistributedMember currentTarget) throws DataLocationException {
        boolean isLocal;
        boolean putResult = false;
        VersionedObjectList versions = null;
        boolean bl = isLocal = this.localMaxMemory > 0 && currentTarget.equals(this.getMyId());
        if (isLocal) {
            prMsg.initMessage(this, null, false, null);
            putResult = prMsg.doLocalRemoveAll(this, this.getDistributionManager().getDistributionManagerId(), true);
            versions = prMsg.getVersions();
        } else {
            RemoveAllPRMessage.RemoveAllResponse response = (RemoveAllPRMessage.RemoveAllResponse)prMsg.send(currentTarget, this);
            RemoveAllPRMessage.RemoveAllResult pr = null;
            if (response != null) {
                this.prStats.incPartitionMessagesSent();
                try {
                    pr = response.waitForResult();
                    putResult = pr.returnValue;
                    versions = pr.versions;
                }
                catch (RegionDestroyedException rde) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("prMsg.send: caught RegionDestroyedException", (Throwable)rde);
                    }
                    throw new RegionDestroyedException(this.toString(), this.getFullPath());
                }
                catch (CacheException ce) {
                    throw new PartitionedRegionDistributionException("prMsg.send on " + currentTarget + " failed", ce);
                }
            } else {
                putResult = true;
            }
        }
        if (!putResult) {
            ForceReattemptException fre = new ForceReattemptException("false result in PutAllMessage.send - retrying");
            fre.setHash(0);
            throw fre;
        }
        return versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putInBucket(InternalDistributedMember targetNode, Integer bucketId, EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified) {
        if (logger.isDebugEnabled()) {
            logger.debug("putInBucket: {} ({}) to {} to bucketId={} retry={} ms", event.getKey(), (Object)event.getKey().hashCode(), (Object)targetNode, (Object)this.bucketStringForLogs(bucketId), (Object)this.retryTimeout);
        }
        RetryTimeKeeper retryTime = null;
        boolean result = false;
        InternalDistributedMember currentTarget = targetNode;
        long timeOut = 0L;
        int count = 0;
        while (true) {
            switch (count) {
                case 0: {
                    break;
                }
                case 1: {
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    timeOut = System.currentTimeMillis() + (long)this.retryTimeout;
                    break;
                }
                default: {
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    long timeLeft = timeOut - System.currentTimeMillis();
                    if (timeLeft < 0L) {
                        PRHARedundancyProvider.timedOut(this, null, null, "update an entry", this.retryTimeout);
                    }
                    boolean interrupted = Thread.interrupted();
                    try {
                        Thread.sleep(100L);
                        break;
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                        break;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            ++count;
            if (currentTarget == null) {
                this.checkReadiness();
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                currentTarget = this.waitForNodeOrCreateBucket(retryTime, event, bucketId);
                this.checkShutdown();
                continue;
            }
            try {
                long start;
                boolean isLocal;
                boolean bl = isLocal = this.localMaxMemory > 0 && currentTarget.equals(this.getMyId());
                if (logger.isDebugEnabled()) {
                    logger.debug("putInBucket: currentTarget = {}; ifNew = {}; ifOld = {}; isLocal = {}", (Object)currentTarget, (Object)ifNew, (Object)ifOld, (Object)isLocal);
                }
                this.checkIfAboveThreshold(event);
                if (isLocal) {
                    event.setInvokePRCallbacks(true);
                    start = this.prStats.startPutLocal();
                    try {
                        BucketRegion br = this.dataStore.getInitializedBucketForId(event.getKey(), bucketId);
                        if (!ClusterDistributionManager.isFunctionExecutionThread().booleanValue()) {
                            br.forceSerialized(event);
                        }
                        if (ifNew) {
                            result = this.dataStore.createLocally(br, event, ifNew, ifOld, requireOldValue, lastModified);
                        }
                        result = this.dataStore.putLocally(br, event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified);
                    }
                    finally {
                        this.prStats.endPutLocal(start);
                    }
                } else {
                    start = this.prStats.startPutRemote();
                    try {
                        if (ifNew) {
                            result = this.createRemotely(currentTarget, bucketId, event, requireOldValue);
                        } else {
                            result = this.putRemotely(currentTarget, event, ifNew, ifOld, expectedOldValue, requireOldValue);
                            if (!requireOldValue) {
                                event.oldValueNotAvailable();
                            }
                        }
                    }
                    finally {
                        this.prStats.endPutRemote(start);
                    }
                }
                if (!(result || ifOld || ifNew)) {
                    Assert.assertTrue(!isLocal);
                    ForceReattemptException fre = new ForceReattemptException(LocalizedStrings.PartitionedRegion_FALSE_RESULT_WHEN_IFNEW_AND_IFOLD_IS_UNACCEPTABLE_RETRYING.toLocalizedString());
                    fre.setHash(event.getKey().hashCode());
                    throw fre;
                }
                return result;
            }
            catch (ConcurrentCacheModificationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("putInBucket: caught concurrent cache modification exception", (Throwable)e);
                }
                event.isConcurrencyConflict(true);
                if (logger.isTraceEnabled()) {
                    logger.trace("ConcurrentCacheModificationException received for putInBucket for bucketId: {}{}{} for event: {}  No reattampt is done, returning from here", (Object)this.getPRId(), (Object)BUCKET_ID_SEPARATOR, (Object)bucketId, (Object)event);
                }
                return result;
            }
            catch (ForceReattemptException prce) {
                prce.checkKey(event.getKey());
                if (logger.isDebugEnabled()) {
                    logger.debug("putInBucket: Got ForceReattemptException for {} on VM {} for node {}{}{} for bucket = {}", (Object)this, (Object)this.getMyId(), (Object)currentTarget, (Object)this.getPRId(), (Object)BUCKET_ID_SEPARATOR, (Object)bucketId, (Object)prce);
                    logger.debug("putInBucket: count={}", (Object)count);
                }
                this.checkReadiness();
                InternalDistributedMember lastTarget = currentTarget;
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                if (lastTarget.equals(currentTarget = this.getNodeForBucketWrite(bucketId, retryTime))) {
                    if (retryTime.overMaximum()) {
                        PRHARedundancyProvider.timedOut(this, null, null, "update an entry", this.retryTimeout);
                    }
                    retryTime.waitToRetryNode();
                }
                event.setPossibleDuplicate(true);
            }
            catch (PrimaryBucketException notPrimary) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Bucket {} on Node {} not primary", (Object)notPrimary.getLocalizedMessage(), (Object)currentTarget);
                }
                this.getRegionAdvisor().notPrimary(bucketId, currentTarget);
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                currentTarget = this.getNodeForBucketWrite(bucketId, retryTime);
            }
            this.checkShutdown();
            if (count == 1) {
                if (ifNew) {
                    this.prStats.incCreateOpsRetried();
                } else {
                    this.prStats.incPutOpsRetried();
                }
            }
            if (event.getOperation().isCreate()) {
                this.prStats.incCreateRetries();
            } else {
                this.prStats.incPutRetries();
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("putInBucket for bucketId = {} failed (attempt # {} ({} ms left), retrying with node {}", (Object)this.bucketStringForLogs(bucketId), (Object)count, (Object)(timeOut - System.currentTimeMillis()), (Object)currentTarget);
        }
    }

    private InternalDistributedMember waitForNodeOrCreateBucket(RetryTimeKeeper retryTime, EntryEventImpl event, Integer bucketId) {
        if (retryTime.overMaximum()) {
            PRHARedundancyProvider.timedOut(this, null, null, "allocate a bucket", retryTime.getRetryTime());
        }
        retryTime.waitForBucketsRecovery();
        InternalDistributedMember newNode = this.getNodeForBucketWrite(bucketId, retryTime);
        if (newNode == null) {
            newNode = this.createBucket(bucketId, PartitionedRegion.getEntrySize(event), retryTime);
        }
        return newNode;
    }

    private static int getEntrySize(EntryEventImpl eei) {
        Object v = eei.getRawNewValue();
        if (v instanceof CachedDeserializable) {
            return ((Sizeable)v).getSizeInBytes();
        }
        return 0;
    }

    public InternalDistributedMember getOrCreateNodeForBucketWrite(int bucketId, RetryTimeKeeper snoozer) {
        InternalDistributedMember targetNode = this.getNodeForBucketWrite(bucketId, snoozer);
        if (targetNode != null) {
            return targetNode;
        }
        try {
            return this.createBucket(bucketId, 0, null);
        }
        catch (PartitionedRegionStorageException e) {
            this.checkReadiness();
            if (this.cache.isClosed()) {
                throw new RegionDestroyedException(this.toString(), this.getFullPath());
            }
            throw e;
        }
    }

    public InternalDistributedMember getNodeForBucketWrite(int bucketId, RetryTimeKeeper snoozer) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        RetryTimeKeeper localSnoozer = snoozer;
        while (this.minimumWriteRedundancy > 0 && this.getRegionAdvisor().getBucketRedundancy(bucketId) < this.minimumWriteRedundancy) {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
            if (!this.getRegionAdvisor().isStorageAssignedForBucket(bucketId, this.minimumWriteRedundancy, false)) {
                if (isDebugEnabled) {
                    logger.debug("No storage assigned for bucket ({}{}{}) writer", (Object)this.getPRId(), (Object)BUCKET_ID_SEPARATOR, (Object)bucketId);
                }
                return null;
            }
            if (localSnoozer == null) {
                localSnoozer = new RetryTimeKeeper(this.retryTimeout);
            }
            if (!localSnoozer.overMaximum()) {
                localSnoozer.waitForBucketsRecovery();
                continue;
            }
            int red = this.getRegionAdvisor().getBucketRedundancy(bucketId);
            TimeoutException noTime = new TimeoutException(LocalizedStrings.PartitionedRegion_ATTEMPT_TO_ACQUIRE_PRIMARY_NODE_FOR_WRITE_ON_BUCKET_0_TIMED_OUT_IN_1_MS_CURRENT_REDUNDANCY_2_DOES_NOT_SATISFY_MINIMUM_3.toLocalizedString(this.bucketStringForLogs(bucketId), localSnoozer.getRetryTime(), red, this.minimumWriteRedundancy));
            this.checkReadiness();
            throw noTime;
        }
        return this.waitForNoStorageOrPrimary(bucketId, "write");
    }

    private InternalDistributedMember waitForNoStorageOrPrimary(int bucketId, String readOrWrite) {
        boolean isInterrupted = false;
        try {
            while (true) {
                isInterrupted = Thread.interrupted() || isInterrupted;
                InternalDistributedMember d = this.getBucketPrimary(bucketId);
                if (d != null) {
                    InternalDistributedMember internalDistributedMember = d;
                    return internalDistributedMember;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("No primary node found for bucket ({}{}{}) {}", (Object)this.getPRId(), (Object)BUCKET_ID_SEPARATOR, (Object)bucketId, (Object)readOrWrite);
                }
                if (!this.getRegionAdvisor().isStorageAssignedForBucket(bucketId)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No storage while waiting for primary for bucket ({}{}{}) {}", (Object)this.getPRId(), (Object)BUCKET_ID_SEPARATOR, (Object)bucketId, (Object)readOrWrite);
                    }
                    InternalDistributedMember internalDistributedMember = null;
                    return internalDistributedMember;
                }
                this.checkShutdown();
            }
        }
        finally {
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key, Object aCallbackArgument, boolean generateCallbacks, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws TimeoutException, CacheLoaderException {
        this.validateKey(key);
        this.checkReadiness();
        this.checkForNoAccess();
        this.discoverJTA();
        CachePerfStats stats = this.getCachePerfStats();
        long start = stats.startGet();
        boolean miss = true;
        try {
            Object value = this.getDataView().findObject(this.getKeyInfo(key, aCallbackArgument), this, true, generateCallbacks, null, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones);
            if (value != null && !Token.isInvalid(value)) {
                miss = false;
            }
            Object object = value;
            return object;
        }
        finally {
            stats.endGet(start, miss);
        }
    }

    public InternalDistributedMember getOrCreateNodeForBucketRead(int bucketId) {
        InternalDistributedMember targetNode = this.getNodeForBucketRead(bucketId);
        if (targetNode != null) {
            return targetNode;
        }
        try {
            return this.createBucket(bucketId, 0, null);
        }
        catch (PartitionedRegionStorageException e) {
            this.checkReadiness();
            if (this.cache.isClosed()) {
                throw new RegionDestroyedException(this.toString(), this.getFullPath());
            }
            throw e;
        }
    }

    public InternalDistributedMember getNodeForBucketRead(int bucketId) {
        InternalDistributedMember primary = this.waitForNoStorageOrPrimary(bucketId, "read");
        if (primary == null) {
            return null;
        }
        if (this.isTX()) {
            return this.getNodeForBucketWrite(bucketId, null);
        }
        return this.getRegionAdvisor().getPreferredNode(bucketId);
    }

    private InternalDistributedMember getNodeForBucketReadOrLoad(int bucketId) {
        InternalDistributedMember targetNode = !this.haveCacheLoader ? this.getNodeForBucketRead(bucketId) : this.getNodeForBucketWrite(bucketId, null);
        if (targetNode == null) {
            this.checkShutdown();
            targetNode = this.createBucket(bucketId, 0, null);
        }
        return targetNode;
    }

    public boolean putRemotely(DistributedMember recipient, EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) throws PrimaryBucketException, ForceReattemptException {
        long eventTime = event.getEventTime(0L);
        PutMessage.PutResponse response = (PutMessage.PutResponse)PutMessage.send(recipient, this, event, eventTime, ifNew, ifOld, expectedOldValue, requireOldValue);
        PutMessage.PutResult pr = null;
        if (response != null) {
            this.prStats.incPartitionMessagesSent();
            try {
                pr = response.waitForResult();
                event.setOperation(pr.op);
                event.setVersionTag(pr.versionTag);
                if (requireOldValue) {
                    event.setOldValue(pr.oldValue, true);
                }
                return pr.returnValue;
            }
            catch (RegionDestroyedException rde) {
                if (logger.isDebugEnabled()) {
                    logger.debug("putRemotely: caught RegionDestroyedException", (Throwable)rde);
                }
                throw new RegionDestroyedException(this.toString(), this.getFullPath());
            }
            catch (TransactionException te) {
                throw te;
            }
            catch (CacheException ce) {
                throw new PartitionedRegionDistributionException(LocalizedStrings.PartitionedRegion_PUTTING_ENTRY_ON_0_FAILED.toLocalizedString(recipient), ce);
            }
        }
        return true;
    }

    public InternalDistributedMember createBucket(int bucketId, int size, RetryTimeKeeper snoozer) {
        InternalDistributedMember ret = this.getNodeForBucketWrite(bucketId, snoozer);
        if (ret != null) {
            return ret;
        }
        PartitionedRegion colocatedWith = ColocationHelper.getColocatedRegion(this);
        if (colocatedWith != null) {
            colocatedWith.createBucket(bucketId, size, snoozer);
        }
        String partitionName = null;
        if (this.isFixedPartitionedRegion()) {
            FixedPartitionAttributesImpl fpa = PartitionedRegionHelper.getFixedPartitionAttributesForBucket(this, bucketId);
            partitionName = fpa.getPartitionName();
            int startBucketId = fpa.getStartingBucketID();
            if (startBucketId == -1) {
                throw new PartitionNotAvailableException(LocalizedStrings.FOR_FIXED_PARTITION_REGION_0_PARTITION_1_IS_NOT_YET_INITIALIZED_ON_DATASTORE.toString(this.getName(), partitionName));
            }
            if (startBucketId != bucketId) {
                this.createBucket(startBucketId, size, snoozer);
            }
        }
        long startTime = PartitionedRegionStats.startTime();
        ret = this.isDataStore() ? this.redundancyProvider.createBucketAtomically(bucketId, size, startTime, false, partitionName) : this.redundancyProvider.createBucketOnDataStore(bucketId, size, startTime, snoozer);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object findObjectInSystem(KeyInfo keyInfo, boolean isCreate, TXStateInterface tx, boolean generateCallbacks, Object localValue, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws CacheLoaderException, TimeoutException {
        Object obj = null;
        Object key = keyInfo.getKey();
        Object aCallbackArgument = keyInfo.getCallbackArg();
        long startTime = PartitionedRegionStats.startTime();
        try {
            boolean allowRetry;
            int bucketId = keyInfo.getBucketId();
            if (bucketId == -1) {
                bucketId = PartitionedRegionHelper.getHashKey(this, isCreate ? Operation.CREATE : null, key, null, aCallbackArgument);
                keyInfo.setBucketId(bucketId);
            }
            InternalDistributedMember targetNode = null;
            TXStateProxy txState = this.getTXState();
            if (txState != null) {
                if (txState.isRealDealLocal()) {
                    targetNode = this.getMyId();
                } else {
                    targetNode = (InternalDistributedMember)txState.getTarget();
                    assert (targetNode != null);
                }
                allowRetry = false;
            } else {
                targetNode = this.getBucketNodeForReadOrWrite(bucketId, clientEvent);
                allowRetry = true;
            }
            if (targetNode == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No need to create buckets on get(), no CacheLoader configured.");
                }
                Object var20_19 = null;
                return var20_19;
            }
            obj = this.getFromBucket(targetNode, bucketId, key, aCallbackArgument, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones, allowRetry);
        }
        finally {
            this.prStats.endGet(startTime);
        }
        return obj;
    }

    InternalDistributedMember getBucketNodeForReadOrWrite(int bucketId, EntryEventImpl clientEvent) {
        InternalDistributedMember targetNode = clientEvent != null && clientEvent.getOperation() != null && clientEvent.getOperation().isGetForRegisterInterest() ? this.getNodeForBucketWrite(bucketId, null) : this.getNodeForBucketReadOrLoad(bucketId);
        return targetNode;
    }

    public ResultCollector executeFunction(Function function, PartitionedRegionFunctionExecutor execution, ResultCollector rc, boolean executeOnBucketSet) {
        if (execution.isPrSingleHop()) {
            if (!executeOnBucketSet) {
                switch (execution.getFilter().size()) {
                    case 1: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Executing Function: (Single Hop) {} on single node.", (Object)function.getId());
                        }
                        return this.executeOnSingleNode(function, execution, rc, true, false);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function: (Single Hop) {} on multiple nodes.", (Object)function.getId());
                }
                return this.executeOnMultipleNodes(function, execution, rc, true, false);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: (Single Hop) {} on a set of buckets nodes.", (Object)function.getId());
            }
            return this.executeOnBucketSet(function, execution, rc, execution.getFilter());
        }
        switch (execution.getFilter().size()) {
            case 0: {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function: {} setArguments={} on all buckets.", (Object)function.getId(), execution.getArguments());
                }
                return this.executeOnAllBuckets(function, execution, rc, false);
            }
            case 1: {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function: {} setArguments={} on single node.", (Object)function.getId(), execution.getArguments());
                }
                return this.executeOnSingleNode(function, execution, rc, false, executeOnBucketSet);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing Function: {} setArguments={} on multiple nodes.", (Object)function.getId(), execution.getArguments());
        }
        return this.executeOnMultipleNodes(function, execution, rc, false, executeOnBucketSet);
    }

    private ResultCollector executeOnMultipleNodes(Function function, PartitionedRegionFunctionExecutor execution, ResultCollector rc, boolean isPRSingleHop, boolean isBucketSetAsFilter) {
        Set routingKeys = execution.getFilter();
        boolean primaryMembersNeeded = function.optimizeForWrite();
        HashMap<Integer, HashSet> bucketToKeysMap = FunctionExecutionNodePruner.groupByBucket(this, routingKeys, primaryMembersNeeded, false, isBucketSetAsFilter);
        HashMap memberToKeysMap = new HashMap();
        HashMap<InternalDistributedMember, HashSet<Integer>> memberToBuckets = FunctionExecutionNodePruner.groupByMemberToBuckets(this, bucketToKeysMap.keySet(), primaryMembersNeeded);
        if (isPRSingleHop && memberToBuckets.size() > 1) {
            for (InternalDistributedMember internalDistributedMember : memberToBuckets.keySet()) {
                if (internalDistributedMember.equals(this.getMyId())) continue;
                for (Integer bucketId : memberToBuckets.get(internalDistributedMember)) {
                    Set<BucketAdvisor.ServerBucketProfile> profiles = this.getRegionAdvisor().getClientBucketProfiles(bucketId);
                    if (profiles == null) continue;
                    for (BucketAdvisor.ServerBucketProfile profile : profiles) {
                        if (!profile.getDistributedMember().equals(internalDistributedMember)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("FunctionServiceSingleHop: Found multiple nodes.{}", (Object)this.getMyId());
                        }
                        throw new InternalFunctionInvocationTargetException(LocalizedStrings.PartitionedRegion_MULTIPLE_TARGET_NODE_FOUND_FOR.toLocalizedString());
                    }
                }
            }
        }
        while (!execution.getFailedNodes().isEmpty()) {
            Set<InternalDistributedMember> memberKeySet = memberToBuckets.keySet();
            RetryTimeKeeper retryTimeKeeper = new RetryTimeKeeper(this.retryTimeout);
            Iterator iterator = memberKeySet.iterator();
            boolean hasRemovedNode = false;
            while (iterator.hasNext()) {
                if (!execution.getFailedNodes().contains(((DistributedMember)iterator.next()).getId())) continue;
                hasRemovedNode = true;
            }
            if (hasRemovedNode) {
                if (retryTimeKeeper.overMaximum()) {
                    PRHARedundancyProvider.timedOut(this, null, null, "doing function execution", this.retryTimeout);
                }
                retryTimeKeeper.waitToRetryNode();
                memberToBuckets = FunctionExecutionNodePruner.groupByMemberToBuckets(this, bucketToKeysMap.keySet(), primaryMembersNeeded);
                continue;
            }
            execution.clearFailedNodes();
        }
        for (Map.Entry entry : memberToBuckets.entrySet()) {
            InternalDistributedMember member = (InternalDistributedMember)entry.getKey();
            HashSet buckets = (HashSet)entry.getValue();
            for (Integer bucket : buckets) {
                HashSet keys = (HashSet)memberToKeysMap.get(member);
                if (keys == null) {
                    keys = new HashSet();
                }
                keys.addAll(bucketToKeysMap.get(bucket));
                memberToKeysMap.put(member, keys);
            }
        }
        if (memberToKeysMap.isEmpty()) {
            throw new FunctionException(LocalizedStrings.PartitionedRegion_NO_TARGET_NODE_FOUND_FOR_KEY_0.toLocalizedString(routingKeys));
        }
        Set<InternalDistributedMember> dest = memberToKeysMap.keySet();
        execution.validateExecution(function, dest);
        execution.setExecutionNodes(dest);
        HashSet hashSet = (HashSet)memberToKeysMap.remove(this.getMyId());
        HashSet<Integer> localBucketSet = null;
        boolean remoteOnly = false;
        if (hashSet == null) {
            remoteOnly = true;
        } else {
            localBucketSet = FunctionExecutionNodePruner.getBucketSet(this, hashSet, false, isBucketSetAsFilter);
            remoteOnly = false;
        }
        LocalResultCollector<?, ?> localResultCollector = execution.getLocalResultCollector(function, rc);
        DistributionManager dm = this.getDistributionManager();
        PartitionedRegionFunctionResultSender resultSender = new PartitionedRegionFunctionResultSender(dm, this, 0L, localResultCollector, execution.getServerResultSender(), memberToKeysMap.isEmpty(), remoteOnly, execution.isForwardExceptions(), function, localBucketSet);
        if (hashSet != null) {
            RegionFunctionContextImpl prContext = new RegionFunctionContextImpl(this.cache, function.getId(), this, execution.getArgumentsForMember(this.getMyId().getId()), hashSet, ColocationHelper.constructAndGetAllColocatedLocalDataSet(this, localBucketSet), localBucketSet, resultSender, execution.isReExecute());
            if (logger.isDebugEnabled()) {
                logger.debug("FunctionService: Executing on local node with keys.{}", (Object)hashSet);
            }
            execution.executeFunctionOnLocalPRNode(function, prContext, resultSender, dm, this.isTX());
        }
        if (!memberToKeysMap.isEmpty()) {
            HashMap<InternalDistributedMember, FunctionRemoteContext> recipMap = new HashMap<InternalDistributedMember, FunctionRemoteContext>();
            for (Map.Entry me : memberToKeysMap.entrySet()) {
                InternalDistributedMember recip = (InternalDistributedMember)me.getKey();
                HashSet memKeys = (HashSet)me.getValue();
                FunctionRemoteContext context = new FunctionRemoteContext(function, execution.getArgumentsForMember(recip.getId()), memKeys, FunctionExecutionNodePruner.getBucketSet(this, memKeys, false, isBucketSetAsFilter), execution.isReExecute(), execution.isFnSerializationReqd());
                recipMap.put(recip, context);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("FunctionService: Executing on remote nodes with member to keys map.{}", memberToKeysMap);
            }
            PartitionedRegionFunctionResultWaiter resultReceiver = new PartitionedRegionFunctionResultWaiter(this.getSystem(), this.getPRId(), localResultCollector, function, resultSender);
            return resultReceiver.getPartitionedDataFrom(recipMap, this, execution);
        }
        return localResultCollector;
    }

    private ResultCollector executeOnSingleNode(Function function, PartitionedRegionFunctionExecutor execution, ResultCollector rc, boolean isPRSingleHop, boolean isBucketSetAsFilter) {
        Set<BucketAdvisor.ServerBucketProfile> profiles;
        Set routingKeys = execution.getFilter();
        Object key = routingKeys.iterator().next();
        Integer bucketId = isBucketSetAsFilter ? (Integer)key : Integer.valueOf(PartitionedRegionHelper.getHashKey(this, Operation.FUNCTION_EXECUTION, key, null, null));
        InternalDistributedMember targetNode = null;
        if (function.optimizeForWrite()) {
            targetNode = this.createBucket(bucketId, 0, null);
            this.cache.getInternalResourceManager().getHeapMonitor().checkForLowMemory(function, targetNode);
        } else {
            targetNode = this.getOrCreateNodeForBucketRead(bucketId);
        }
        InternalDistributedMember localVm = this.getMyId();
        if (targetNode != null && isPRSingleHop && !((Object)localVm).equals(targetNode) && (profiles = this.getRegionAdvisor().getClientBucketProfiles(bucketId)) != null) {
            for (BucketAdvisor.ServerBucketProfile profile : profiles) {
                if (!profile.getDistributedMember().equals(targetNode)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("FunctionServiceSingleHop: Found remote node.{}", (Object)localVm);
                }
                throw new InternalFunctionInvocationTargetException(LocalizedStrings.PartitionedRegion_MULTIPLE_TARGET_NODE_FOUND_FOR.toLocalizedString());
            }
        }
        if (targetNode == null) {
            throw new FunctionException(LocalizedStrings.PartitionedRegion_NO_TARGET_NODE_FOUND_FOR_KEY_0.toLocalizedString(key));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing Function: {} setArguments={} on {}", (Object)function.getId(), execution.getArguments(), (Object)targetNode);
        }
        while (!execution.getFailedNodes().isEmpty()) {
            RetryTimeKeeper retryTime = new RetryTimeKeeper(this.retryTimeout);
            if (execution.getFailedNodes().contains(targetNode.getId())) {
                targetNode = null;
                while (targetNode == null) {
                    if (retryTime.overMaximum()) {
                        PRHARedundancyProvider.timedOut(this, null, null, "doing function execution", this.retryTimeout);
                    }
                    retryTime.waitToRetryNode();
                    if (function.optimizeForWrite()) {
                        targetNode = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
                        continue;
                    }
                    targetNode = this.getOrCreateNodeForBucketRead(bucketId);
                }
                if (targetNode != null) continue;
                throw new FunctionException(LocalizedStrings.PartitionedRegion_NO_TARGET_NODE_FOUND_FOR_KEY_0.toLocalizedString(key));
            }
            execution.clearFailedNodes();
        }
        HashSet<Integer> buckets = new HashSet<Integer>();
        buckets.add(bucketId);
        Set<InternalDistributedMember> singleMember = Collections.singleton(targetNode);
        execution.validateExecution(function, singleMember);
        execution.setExecutionNodes(singleMember);
        LocalResultCollector<?, ?> localRC = execution.getLocalResultCollector(function, rc);
        if (targetNode.equals(localVm)) {
            DistributionManager dm = this.getDistributionManager();
            PartitionedRegionFunctionResultSender resultSender = new PartitionedRegionFunctionResultSender(dm, this, 0L, localRC, execution.getServerResultSender(), true, false, execution.isForwardExceptions(), function, buckets);
            RegionFunctionContextImpl context = new RegionFunctionContextImpl(this.cache, function.getId(), this, execution.getArgumentsForMember(localVm.getId()), routingKeys, ColocationHelper.constructAndGetAllColocatedLocalDataSet(this, buckets), buckets, resultSender, execution.isReExecute());
            execution.executeFunctionOnLocalPRNode(function, context, resultSender, dm, this.isTX());
            return localRC;
        }
        return this.executeFunctionOnRemoteNode(targetNode, function, execution.getArgumentsForMember(targetNode.getId()), routingKeys, function.isHA() ? rc : localRC, buckets, execution.getServerResultSender(), execution);
    }

    public ResultCollector executeOnBucketSet(Function function, PartitionedRegionFunctionExecutor execution, ResultCollector rc, Set<Integer> bucketSet) {
        Set<Integer> actualBucketSet = this.getRegionAdvisor().getBucketSet();
        try {
            bucketSet.retainAll(actualBucketSet);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        HashMap<InternalDistributedMember, HashSet<Integer>> memberToBuckets = FunctionExecutionNodePruner.groupByMemberToBuckets(this, bucketSet, function.optimizeForWrite());
        if (memberToBuckets.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing on bucketset : {} executeOnBucketSet Member to buckets map is : {} bucketSet is empty", bucketSet, memberToBuckets);
            }
            throw new EmptyRegionFunctionException(LocalizedStrings.PartitionedRegion_FUNCTION_NOT_EXECUTED_AS_REGION_IS_EMPTY.toLocalizedString());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing on bucketset : {} executeOnBucketSet Member to buckets map is : {}", bucketSet, memberToBuckets);
        }
        if (memberToBuckets.size() > 1) {
            for (InternalDistributedMember targetNode : memberToBuckets.keySet()) {
                if (targetNode.equals(this.getMyId())) continue;
                for (Integer bucketId : memberToBuckets.get(targetNode)) {
                    Set<BucketAdvisor.ServerBucketProfile> profiles = this.getRegionAdvisor().getClientBucketProfiles(bucketId);
                    if (profiles == null) continue;
                    for (BucketAdvisor.ServerBucketProfile profile : profiles) {
                        if (!profile.getDistributedMember().equals(targetNode)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("FunctionServiceSingleHop: Found multiple nodes for executing on bucket set.{}", (Object)this.getMyId());
                        }
                        throw new InternalFunctionInvocationTargetException(LocalizedStrings.PartitionedRegion_MULTIPLE_TARGET_NODE_FOUND_FOR.toLocalizedString());
                    }
                }
            }
        }
        execution = (PartitionedRegionFunctionExecutor)execution.withFilter((Set)new HashSet());
        while (!execution.getFailedNodes().isEmpty()) {
            Set<InternalDistributedMember> memberKeySet = memberToBuckets.keySet();
            RetryTimeKeeper retryTime = new RetryTimeKeeper(this.retryTimeout);
            Iterator<InternalDistributedMember> iterator = memberKeySet.iterator();
            boolean hasRemovedNode = false;
            while (iterator.hasNext()) {
                if (!execution.getFailedNodes().contains(((DistributedMember)iterator.next()).getId())) continue;
                hasRemovedNode = true;
            }
            if (hasRemovedNode) {
                if (retryTime.overMaximum()) {
                    PRHARedundancyProvider.timedOut(this, null, null, "doing function execution", this.retryTimeout);
                }
                retryTime.waitToRetryNode();
                memberToBuckets = FunctionExecutionNodePruner.groupByMemberToBuckets(this, bucketSet, function.optimizeForWrite());
                continue;
            }
            execution.clearFailedNodes();
        }
        Set<InternalDistributedMember> dest = memberToBuckets.keySet();
        this.cache.getInternalResourceManager().getHeapMonitor().checkForLowMemory(function, Collections.unmodifiableSet(dest));
        boolean isSelf = false;
        execution.setExecutionNodes(dest);
        Set localBucketSet = memberToBuckets.remove(this.getMyId());
        if (localBucketSet != null) {
            isSelf = true;
        }
        HashMap<InternalDistributedMember, FunctionRemoteContext> recipMap = new HashMap<InternalDistributedMember, FunctionRemoteContext>();
        for (InternalDistributedMember recip : dest) {
            FunctionRemoteContext context = new FunctionRemoteContext(function, execution.getArgumentsForMember(recip.getId()), null, (Set<Integer>)memberToBuckets.get(recip), execution.isReExecute(), execution.isFnSerializationReqd());
            recipMap.put(recip, context);
        }
        LocalResultCollector<?, ?> localRC = execution.getLocalResultCollector(function, rc);
        DistributionManager dm = this.getDistributionManager();
        PartitionedRegionFunctionResultSender resultSender = new PartitionedRegionFunctionResultSender(dm, this, 0L, localRC, execution.getServerResultSender(), recipMap.isEmpty(), !isSelf, execution.isForwardExceptions(), function, localBucketSet);
        if (isSelf && this.dataStore != null) {
            RegionFunctionContextImpl prContext = new RegionFunctionContextImpl(this.cache, function.getId(), this, execution.getArgumentsForMember(this.getMyId().getId()), null, ColocationHelper.constructAndGetAllColocatedLocalDataSet(this, localBucketSet), localBucketSet, resultSender, execution.isReExecute());
            execution.executeFunctionOnLocalNode(function, prContext, resultSender, dm, this.isTX());
        }
        PartitionedRegionFunctionResultWaiter resultReceiver = new PartitionedRegionFunctionResultWaiter(this.getSystem(), this.getPRId(), localRC, function, resultSender);
        return resultReceiver.getPartitionedDataFrom(recipMap, this, execution);
    }

    private ResultCollector executeOnAllBuckets(Function function, PartitionedRegionFunctionExecutor execution, ResultCollector rc, boolean isPRSingleHop) {
        HashSet<Integer> bucketSet = new HashSet<Integer>();
        Iterator<Integer> itr = this.getRegionAdvisor().getBucketSet().iterator();
        while (itr.hasNext()) {
            try {
                bucketSet.add(itr.next());
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        HashMap<InternalDistributedMember, HashSet<Integer>> memberToBuckets = FunctionExecutionNodePruner.groupByMemberToBuckets(this, bucketSet, function.optimizeForWrite());
        if (memberToBuckets.isEmpty()) {
            throw new EmptyRegionFunctionException(LocalizedStrings.PartitionedRegion_FUNCTION_NOT_EXECUTED_AS_REGION_IS_EMPTY.toLocalizedString());
        }
        while (!execution.getFailedNodes().isEmpty()) {
            Set<InternalDistributedMember> memberKeySet = memberToBuckets.keySet();
            RetryTimeKeeper retryTime = new RetryTimeKeeper(this.retryTimeout);
            Iterator<InternalDistributedMember> iterator = memberKeySet.iterator();
            boolean hasRemovedNode = false;
            while (iterator.hasNext()) {
                if (!execution.getFailedNodes().contains(((DistributedMember)iterator.next()).getId())) continue;
                hasRemovedNode = true;
            }
            if (hasRemovedNode) {
                if (retryTime.overMaximum()) {
                    PRHARedundancyProvider.timedOut(this, null, null, "doing function execution", this.retryTimeout);
                }
                retryTime.waitToRetryNode();
                memberToBuckets = FunctionExecutionNodePruner.groupByMemberToBuckets(this, bucketSet, function.optimizeForWrite());
                continue;
            }
            execution.clearFailedNodes();
        }
        Set<InternalDistributedMember> dest = memberToBuckets.keySet();
        execution.validateExecution(function, dest);
        execution.setExecutionNodes(dest);
        boolean isSelf = false;
        Set localBucketSet = memberToBuckets.remove(this.getMyId());
        if (localBucketSet != null) {
            isSelf = true;
        }
        HashMap<InternalDistributedMember, FunctionRemoteContext> recipMap = new HashMap<InternalDistributedMember, FunctionRemoteContext>();
        for (InternalDistributedMember recip : memberToBuckets.keySet()) {
            FunctionRemoteContext context = new FunctionRemoteContext(function, execution.getArgumentsForMember(recip.getId()), null, (Set<Integer>)memberToBuckets.get(recip), execution.isReExecute(), execution.isFnSerializationReqd());
            recipMap.put(recip, context);
        }
        LocalResultCollector<?, ?> localResultCollector = execution.getLocalResultCollector(function, rc);
        DistributionManager dm = this.getDistributionManager();
        PartitionedRegionFunctionResultSender resultSender = new PartitionedRegionFunctionResultSender(dm, this, 0L, localResultCollector, execution.getServerResultSender(), recipMap.isEmpty(), !isSelf, execution.isForwardExceptions(), function, localBucketSet);
        if (isSelf && this.dataStore != null) {
            RegionFunctionContextImpl prContext = new RegionFunctionContextImpl(this.cache, function.getId(), this, execution.getArgumentsForMember(this.getMyId().getId()), null, ColocationHelper.constructAndGetAllColocatedLocalDataSet(this, localBucketSet), localBucketSet, resultSender, execution.isReExecute());
            execution.executeFunctionOnLocalPRNode(function, prContext, resultSender, dm, this.isTX());
        }
        PartitionedRegionFunctionResultWaiter resultReceiver = new PartitionedRegionFunctionResultWaiter(this.getSystem(), this.getPRId(), localResultCollector, function, resultSender);
        return resultReceiver.getPartitionedDataFrom(recipMap, this, execution);
    }

    private Object getFromBucket(InternalDistributedMember targetNode, int bucketId, Object key, Object aCallbackArgument, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones, boolean allowRetry) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        int retryAttempts = this.calcRetry();
        int count = 0;
        RetryTimeKeeper retryTime = null;
        InternalDistributedMember retryNode = targetNode;
        while (count <= retryAttempts) {
            Throwable cause;
            if (retryNode == null) {
                this.checkReadiness();
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                if ((retryNode = this.getNodeForBucketReadOrLoad(bucketId)) != null) continue;
                this.checkShutdown();
                return null;
            }
            boolean isLocal = this.localMaxMemory > 0 && retryNode.equals(this.getMyId());
            try {
                Object obj;
                if (isLocal) {
                    obj = this.dataStore.getLocally(bucketId, key, aCallbackArgument, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones, false);
                } else {
                    if (this.haveCacheLoader && null != (obj = this.getFromLocalBucket(bucketId, key, aCallbackArgument, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones))) {
                        return obj;
                    }
                    obj = this.getRemotely(retryNode, bucketId, key, aCallbackArgument, preferCD, requestingClient, clientEvent, returnTombstones);
                    String name = Thread.currentThread().getName();
                    if (name.startsWith("ServerConnection") && !this.getMyId().equals(retryNode)) {
                        this.setNetworkHopType(bucketId, retryNode);
                    }
                }
                return obj;
            }
            catch (PRLocallyDestroyedException pde) {
                if (isDebugEnabled) {
                    logger.debug("getFromBucket Encountered PRLocallyDestroyedException", (Throwable)pde);
                }
                this.checkReadiness();
                if (allowRetry) {
                    retryNode = this.getNodeForBucketReadOrLoad(bucketId);
                }
                cause = pde.getCause();
                if (cause != null && cause instanceof RegionDestroyedException) {
                    throw (RegionDestroyedException)cause;
                }
                throw new RegionDestroyedException(this.toString(), this.getFullPath());
            }
            catch (ForceReattemptException prce) {
                prce.checkKey(key);
                this.checkReadiness();
                if (allowRetry) {
                    InternalDistributedMember lastNode = retryNode;
                    if (isDebugEnabled) {
                        logger.debug("getFromBucket: retry attempt: {} of {}", (Object)count, (Object)retryAttempts, (Object)prce);
                    }
                    if (lastNode.equals(retryNode = this.getNodeForBucketReadOrLoad(bucketId))) {
                        if (retryTime == null) {
                            retryTime = new RetryTimeKeeper(this.retryTimeout);
                        }
                        if (retryTime.overMaximum()) break;
                        if (isDebugEnabled) {
                            logger.debug("waiting to retry node {}", (Object)retryNode);
                        }
                        retryTime.waitToRetryNode();
                    }
                }
                if (prce instanceof BucketNotFoundException) {
                    throw new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString(key), prce);
                }
                cause = prce.getCause();
                if (cause instanceof PrimaryBucketException) {
                    throw (PrimaryBucketException)cause;
                }
                if (cause instanceof TransactionDataRebalancedException) {
                    throw (TransactionDataRebalancedException)cause;
                }
                if (cause instanceof RegionDestroyedException) {
                    throw new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString(key), cause);
                }
                throw new TransactionException("Failed to get key: " + key, prce);
            }
            catch (PrimaryBucketException notPrimary) {
                if (allowRetry) {
                    if (isDebugEnabled) {
                        logger.debug("getFromBucket: {} on Node {} not primary", (Object)notPrimary.getLocalizedMessage(), (Object)retryNode);
                    }
                    this.getRegionAdvisor().notPrimary(bucketId, retryNode);
                    retryNode = this.getNodeForBucketReadOrLoad(bucketId);
                }
                throw notPrimary;
            }
            this.checkShutdown();
            if (++count == 1) {
                this.prStats.incGetOpsRetried();
            }
            this.prStats.incGetRetries();
            if (!isDebugEnabled) continue;
            logger.debug("getFromBucket: Attempting to resend get to node {} after {} failed attempts", (Object)retryNode, (Object)count);
        }
        PartitionedRegionDistributionException e = null;
        if (logger.isDebugEnabled()) {
            e = new PartitionedRegionDistributionException(LocalizedStrings.PartitionRegion_NO_VM_AVAILABLE_FOR_GET_IN_0_ATTEMPTS.toLocalizedString(count));
        }
        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionRegion_NO_VM_AVAILABLE_FOR_GET_IN_0_ATTEMPTS, count), e);
        return null;
    }

    public Object getFromLocalBucket(int bucketId, Object key, Object aCallbackArgument, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws ForceReattemptException, PRLocallyDestroyedException {
        Object obj;
        InternalDistributedMember readNode = this.getNodeForBucketRead(bucketId);
        if (readNode == null) {
            return null;
        }
        if (readNode.equals(this.getMyId()) && null != (obj = this.dataStore.getLocally(bucketId, key, aCallbackArgument, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones, true))) {
            if (logger.isTraceEnabled()) {
                logger.trace("getFromBucket: Getting key {} ({}) locally - success", key, (Object)key.hashCode());
            }
            return obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean cacheWriteBeforeRegionDestroy(RegionEventImpl event) throws CacheWriterException, TimeoutException {
        if (event.getOperation().isDistributed()) {
            Set netWriteRecipients;
            this.serverRegionDestroy(event);
            CacheWriter localWriter = this.basicGetWriter();
            Set set = netWriteRecipients = localWriter == null ? this.distAdvisor.adviseNetWrite() : null;
            if (localWriter == null && (netWriteRecipients == null || netWriteRecipients.isEmpty())) {
                return false;
            }
            long start = this.getCachePerfStats().startCacheWriterCall();
            try {
                SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
                processor.initialize(this, "preDestroyRegion", null);
                processor.doNetWrite(event, netWriteRecipients, localWriter, 3);
                processor.release();
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
            return true;
        }
        return false;
    }

    public DistributedMember getMemberOwning(Object key) {
        int bucketId = PartitionedRegionHelper.getHashKey(this, null, key, null, null);
        return this.getNodeForBucketRead(bucketId);
    }

    public boolean localCacheContainsKey(Object key) {
        return this.getRegionMap().containsKey(key);
    }

    public Object localCacheGet(Object key) {
        RegionEntry re = this.getRegionMap().getEntry(key);
        if (re == null || re.isDestroyedOrRemoved()) {
            return null;
        }
        return re.getValue(this);
    }

    public Set localCacheKeySet() {
        return super.keys();
    }

    public List<BucketDump> getAllBucketEntries(final int bucketId) throws ForceReattemptException {
        if (bucketId >= this.getTotalNumberOfBuckets()) {
            return Collections.emptyList();
        }
        ArrayList<BucketDump> ret = new ArrayList<BucketDump>();
        HashSet<InternalDistributedMember> collected = new HashSet<InternalDistributedMember>();
        while (true) {
            Set<InternalDistributedMember> owners = this.getRegionAdvisor().getBucketOwners(bucketId);
            owners.removeAll(collected);
            if (owners.isEmpty()) break;
            Iterator<InternalDistributedMember> ownersI = owners.iterator();
            InternalDistributedMember owner = ownersI.next();
            collected.add(owner);
            if (owner.equals(this.getMyId())) {
                BucketRegion br = this.dataStore.handleRemoteGetEntries(bucketId);
                HashMap<Object, Object> m = new HashMap<Object, Object>(){
                    private static final long serialVersionUID = 0L;

                    @Override
                    public String toString() {
                        return "Bucket id = " + bucketId + " from local member = " + PartitionedRegion.this.getDistributionManager().getDistributionManagerId() + ": " + super.toString();
                    }
                };
                HashMap<Object, VersionTag> versions = new HashMap<Object, VersionTag>();
                for (LocalRegion.NonTXEntry entry : br.entrySet()) {
                    VersionTag versionTag;
                    RegionEntry re = entry.getRegionEntry();
                    Object value = re.getValue(br);
                    VersionStamp versionStamp = re.getVersionStamp();
                    VersionTag versionTag2 = versionTag = versionStamp != null ? versionStamp.asVersionTag() : null;
                    if (versionTag != null) {
                        versionTag.replaceNullIDs(br.getVersionMember());
                    }
                    if (Token.isRemoved(value)) continue;
                    if (Token.isInvalid(value)) {
                        value = null;
                    } else if (value instanceof CachedDeserializable) {
                        value = ((CachedDeserializable)value).getDeserializedForReading();
                    }
                    m.put(re.getKey(), value);
                    versions.put(re.getKey(), versionTag);
                }
                RegionVersionVector rvv = br.getVersionVector();
                rvv = rvv != null ? rvv.getCloneForTransmission() : null;
                ret.add(new BucketDump(bucketId, owner, rvv, (Map<Object, Object>)m, versions));
                continue;
            }
            try {
                FetchEntriesMessage.FetchEntriesResponse r = FetchEntriesMessage.send(owner, this, bucketId);
                ret.add(r.waitForEntries());
            }
            catch (ForceReattemptException forceReattemptException) {}
        }
        return ret;
    }

    public Set getBucketKeys(int bucketNum) {
        return this.getBucketKeys(bucketNum, false);
    }

    public Set getBucketKeys(int bucketNum, boolean allowTombstones) {
        Integer buck = bucketNum;
        int retryAttempts = this.calcRetry();
        Set ret = null;
        int count = 0;
        InternalDistributedMember nod = this.getOrCreateNodeForBucketRead(bucketNum);
        RetryTimeKeeper snoozer = null;
        while (count <= retryAttempts) {
            block15: {
                this.checkShutdown();
                if (nod == null) {
                    if (snoozer == null) {
                        snoozer = new RetryTimeKeeper(this.retryTimeout);
                    }
                    if ((nod = this.getOrCreateNodeForBucketRead(bucketNum)) == null) {
                        this.checkShutdown();
                        break;
                    }
                    ++count;
                    continue;
                }
                try {
                    if (nod.equals(this.getMyId())) {
                        ret = this.dataStore.getKeysLocally(buck, allowTombstones);
                    } else {
                        FetchKeysMessage.FetchKeysResponse r = FetchKeysMessage.send(nod, this, buck, allowTombstones);
                        ret = r.waitForKeys();
                    }
                    if (ret != null) {
                        return ret;
                    }
                }
                catch (PRLocallyDestroyedException ignore) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("getBucketKeys: Encountered PRLocallyDestroyedException");
                    }
                    this.checkReadiness();
                }
                catch (ForceReattemptException prce) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("getBucketKeys: attempt:{}", (Object)(count + 1), (Object)prce);
                    }
                    this.checkReadiness();
                    if (snoozer == null) {
                        snoozer = new RetryTimeKeeper(this.retryTimeout);
                    }
                    InternalDistributedMember oldNode = nod;
                    nod = this.getNodeForBucketRead(buck);
                    if (nod == null || !nod.equals(oldNode)) break block15;
                    if (snoozer.overMaximum()) {
                        this.checkReadiness();
                        throw new TimeoutException(LocalizedStrings.PartitionedRegion_ATTEMPT_TO_ACQUIRE_PRIMARY_NODE_FOR_READ_ON_BUCKET_0_TIMED_OUT_IN_1_MS.toLocalizedString(this.getBucketName(buck), snoozer.getRetryTime()));
                    }
                    snoozer.waitToRetryNode();
                }
            }
            ++count;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getBucketKeys: no keys found returning empty set");
        }
        return Collections.emptySet();
    }

    public void fetchEntries(HashMap<Integer, HashSet> bucketKeys, VersionedObjectList values, ServerConnection servConn) throws IOException {
        int retryAttempts = this.calcRetry();
        RetryTimeKeeper retryTime = null;
        HashMap<Integer, HashSet> failures = new HashMap<Integer, HashSet>(bucketKeys);
        HashMap<InternalDistributedMember, HashMap<Integer, HashSet>> nodeToBuckets = new HashMap<InternalDistributedMember, HashMap<Integer, HashSet>>();
        while (--retryAttempts >= 0 && !failures.isEmpty()) {
            Set<Integer> failedSet;
            nodeToBuckets.clear();
            this.updateNodeToBucketMap(nodeToBuckets, failures);
            failures.clear();
            HashMap<Integer, HashSet> localBuckets = nodeToBuckets.remove(this.getMyId());
            if (localBuckets != null && !localBuckets.isEmpty()) {
                HashSet keys = new HashSet();
                for (Integer id : localBuckets.keySet()) {
                    keys.addAll(localBuckets.get(id));
                }
                if (!keys.isEmpty()) {
                    BaseCommand.appendNewRegisterInterestResponseChunkFromLocal(this, values, "keyList", keys, servConn);
                }
            }
            if (!(failedSet = this.handleOldNodes(nodeToBuckets, values, servConn)).isEmpty()) {
                for (Integer bId : failedSet) {
                    failures.put(bId, bucketKeys.get(bId));
                }
                this.updateNodeToBucketMap(nodeToBuckets, failures);
                failures.clear();
            }
            this.fetchRemoteEntries(nodeToBuckets, failures, values, servConn);
            if (failures.isEmpty()) continue;
            if (retryTime == null) {
                retryTime = new RetryTimeKeeper(this.retryTimeout);
            }
            if (this.waitForFetchRemoteEntriesRetry(retryTime)) continue;
            break;
        }
        if (!failures.isEmpty()) {
            throw new InternalGemFireException("Failed to fetch entries from " + failures.size() + " buckets of region " + this.getName() + " for register interest.");
        }
    }

    void updateNodeToBucketMap(HashMap<InternalDistributedMember, HashMap<Integer, HashSet>> nodeToBuckets, HashMap<Integer, HashSet> bucketKeys) {
        for (int id : bucketKeys.keySet()) {
            InternalDistributedMember node = this.getOrCreateNodeForBucketWrite(id, null);
            if (nodeToBuckets.containsKey(node)) {
                nodeToBuckets.get(node).put(id, bucketKeys.get(id));
                continue;
            }
            HashMap<Integer, HashSet> map = new HashMap<Integer, HashSet>();
            map.put(id, bucketKeys.get(id));
            nodeToBuckets.put(node, map);
        }
    }

    private Set<Integer> handleOldNodes(HashMap nodeToBuckets, VersionedObjectList values, ServerConnection servConn) throws IOException {
        HashSet<Integer> failures = new HashSet<Integer>();
        HashMap oldFellas = this.filterOldMembers(nodeToBuckets);
        for (Map.Entry e : oldFellas.entrySet()) {
            InternalDistributedMember member = (InternalDistributedMember)e.getKey();
            Object bucketInfo = e.getValue();
            HashMap bucketKeys = null;
            Set buckets = null;
            if (bucketInfo instanceof Set) {
                buckets = (Set)bucketInfo;
            } else {
                bucketKeys = (HashMap)bucketInfo;
                buckets = bucketKeys.keySet();
            }
            for (Integer bucket : buckets) {
                Set keys = null;
                if (bucketKeys == null) {
                    try {
                        FetchKeysMessage.FetchKeysResponse fkr = FetchKeysMessage.send(member, this, bucket, true);
                        keys = fkr.waitForKeys();
                    }
                    catch (ForceReattemptException ignore) {
                        failures.add(bucket);
                    }
                } else {
                    keys = (Set)bucketKeys.get(bucket);
                }
                for (Object key : keys) {
                    Get70 command = (Get70)Get70.getCommand();
                    Get70.Entry ge = command.getValueAndIsObject(this, key, null, servConn);
                    if (ge.keyNotPresent) {
                        values.addObjectPartForAbsentKey(key, ge.value, ge.versionTag);
                    } else {
                        values.addObjectPart(key, ge.value, ge.isObject, ge.versionTag);
                    }
                    if (values.size() != BaseCommand.MAXIMUM_CHUNK_SIZE) continue;
                    BaseCommand.sendNewRegisterInterestResponseChunk(this, "keyList", values, false, servConn);
                    values.clear();
                }
            }
        }
        return failures;
    }

    private HashMap filterOldMembers(HashMap nodeToBuckets) {
        ClusterDistributionManager dm = (ClusterDistributionManager)this.getDistributionManager();
        HashMap oldGuys = new HashMap();
        HashSet<InternalDistributedMember> oldMembers = new HashSet<InternalDistributedMember>(nodeToBuckets.keySet());
        dm.removeMembersWithSameOrNewerVersion(oldMembers, Version.CURRENT);
        Iterator oldies = oldMembers.iterator();
        while (oldies.hasNext()) {
            InternalDistributedMember old = (InternalDistributedMember)oldies.next();
            if (nodeToBuckets.containsKey(old)) {
                oldGuys.put(old, nodeToBuckets.remove(old));
                continue;
            }
            oldies.remove();
        }
        return oldGuys;
    }

    public void fetchEntries(String regex, VersionedObjectList values, ServerConnection servConn) throws IOException {
        int retryAttempts = this.calcRetry();
        RetryTimeKeeper retryTime = null;
        HashSet<Integer> failures = new HashSet<Integer>(this.getRegionAdvisor().getBucketSet());
        HashMap<InternalDistributedMember, HashSet<Integer>> nodeToBuckets = new HashMap<InternalDistributedMember, HashSet<Integer>>();
        while (--retryAttempts >= 0 && !failures.isEmpty()) {
            nodeToBuckets.clear();
            this.updateNodeToBucketMap(nodeToBuckets, failures);
            failures.clear();
            HashSet<Integer> localBuckets = nodeToBuckets.remove(this.getMyId());
            if (localBuckets != null && !localBuckets.isEmpty()) {
                for (Integer id : localBuckets) {
                    Set keys = this.fetchAllLocalKeys(id, failures, regex);
                    if (keys.isEmpty()) continue;
                    BaseCommand.appendNewRegisterInterestResponseChunkFromLocal(this, values, regex != null ? regex : "ALL_KEYS", keys, servConn);
                }
            }
            this.updateNodeToBucketMap(nodeToBuckets, failures);
            failures.clear();
            Set<Integer> ret = this.handleOldNodes(nodeToBuckets, values, servConn);
            if (!ret.isEmpty()) {
                failures.addAll(ret);
                this.updateNodeToBucketMap(nodeToBuckets, failures);
                failures.clear();
            }
            if ((localBuckets = nodeToBuckets.remove(this.getMyId())) != null && !localBuckets.isEmpty()) {
                failures.addAll(localBuckets);
            }
            this.fetchAllRemoteEntries(nodeToBuckets, failures, regex, values, servConn);
            if (failures.isEmpty()) continue;
            if (retryTime == null) {
                retryTime = new RetryTimeKeeper(this.retryTimeout);
            }
            if (this.waitForFetchRemoteEntriesRetry(retryTime)) continue;
            break;
        }
        if (!failures.isEmpty()) {
            throw new InternalGemFireException("Failed to fetch entries from " + failures.size() + " buckets of region " + this.getName() + " for register interest.");
        }
    }

    void updateNodeToBucketMap(HashMap<InternalDistributedMember, HashSet<Integer>> nodeToBuckets, Set<Integer> buckets) {
        for (int id : buckets) {
            InternalDistributedMember node = this.getOrCreateNodeForBucketWrite(id, null);
            if (nodeToBuckets.containsKey(node)) {
                nodeToBuckets.get(node).add(id);
                continue;
            }
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(id);
            nodeToBuckets.put(node, set);
        }
    }

    private boolean waitForFetchRemoteEntriesRetry(RetryTimeKeeper retryTime) {
        if (retryTime.overMaximum()) {
            return false;
        }
        retryTime.waitToRetryNode();
        return true;
    }

    public Set fetchAllLocalKeys(Integer id, Set<Integer> failures, String regex) {
        HashSet result = new HashSet();
        try {
            Set keys = null;
            keys = regex != null ? this.dataStore.handleRemoteGetKeys(id, 1, regex, true) : this.dataStore.getKeysLocally(id, true);
            result.addAll(keys);
        }
        catch (ForceReattemptException ignore) {
            failures.add(id);
        }
        catch (PRLocallyDestroyedException ignore) {
            failures.add(id);
        }
        return result;
    }

    public void fetchRemoteEntries(HashMap<InternalDistributedMember, HashMap<Integer, HashSet>> nodeToBuckets, HashMap<Integer, HashSet> failures, VersionedObjectList values, ServerConnection servConn) throws IOException {
        HashSet<Map.Entry> result = null;
        HashMap<Integer, HashSet> oneBucketKeys = new HashMap<Integer, HashSet>();
        for (Map.Entry<InternalDistributedMember, HashMap<Integer, HashSet>> entry : nodeToBuckets.entrySet()) {
            HashMap<Integer, HashSet> bucketKeys = entry.getValue();
            FetchBulkEntriesMessage.FetchBulkEntriesResponse fber = null;
            result = new HashSet<Map.Entry>();
            for (Map.Entry<Integer, HashSet> e : bucketKeys.entrySet()) {
                result.clear();
                oneBucketKeys.clear();
                oneBucketKeys.put(e.getKey(), e.getValue());
                try {
                    if (entry.getKey().getVersionObject().compareTo(Version.GFE_80) < 0) {
                        failures.putAll((Map<Integer, HashSet>)nodeToBuckets.get(entry.getKey()));
                        continue;
                    }
                    fber = FetchBulkEntriesMessage.send(entry.getKey(), this, oneBucketKeys, null, null, true);
                    BucketDump[] bds = fber.waitForEntries();
                    if (fber.getFailedBucketIds() != null && !fber.getFailedBucketIds().isEmpty()) {
                        Iterator<Integer> iterator = fber.getFailedBucketIds().iterator();
                        while (iterator.hasNext()) {
                            int id = (Integer)iterator.next();
                            failures.put(id, nodeToBuckets.get(entry.getKey()).get(id));
                        }
                    }
                    for (BucketDump bd : bds) {
                        result.addAll(bd.getValuesWithVersions().entrySet());
                    }
                    BaseCommand.appendNewRegisterInterestResponseChunk(this, values, "keyList", result, servConn);
                }
                catch (ForceReattemptException ignore) {
                    failures.put(e.getKey(), e.getValue());
                }
            }
        }
    }

    public void fetchAllRemoteEntries(HashMap<InternalDistributedMember, HashSet<Integer>> nodeToBuckets, HashSet<Integer> failures, String regex, VersionedObjectList values, ServerConnection servConn) throws IOException {
        HashSet<Map.Entry> result = null;
        HashSet<Integer> bucketId = new HashSet<Integer>();
        for (Map.Entry<InternalDistributedMember, HashSet<Integer>> entry : nodeToBuckets.entrySet()) {
            HashSet buckets = new HashSet(entry.getValue());
            FetchBulkEntriesMessage.FetchBulkEntriesResponse fber = null;
            result = new HashSet<Map.Entry>();
            Iterator iterator = buckets.iterator();
            while (iterator.hasNext()) {
                int bucket = (Integer)iterator.next();
                result.clear();
                bucketId.clear();
                bucketId.add(bucket);
                try {
                    if (entry.getKey().getVersionObject().compareTo(Version.GFE_80) < 0) {
                        failures.addAll((Collection<Integer>)nodeToBuckets.get(entry.getKey()));
                        continue;
                    }
                    fber = FetchBulkEntriesMessage.send(entry.getKey(), this, null, bucketId, regex, true);
                    BucketDump[] bds = fber.waitForEntries();
                    if (fber.getFailedBucketIds() != null) {
                        failures.addAll(fber.getFailedBucketIds());
                    }
                    for (BucketDump bd : bds) {
                        result.addAll(bd.getValuesWithVersions().entrySet());
                    }
                    BaseCommand.appendNewRegisterInterestResponseChunk(this, values, regex != null ? regex : "ALL_KEYS", result, servConn);
                }
                catch (ForceReattemptException ignore) {
                    failures.add(bucket);
                }
            }
        }
    }

    public Set<InternalDistributedMember> getAllNodes() {
        Set<InternalDistributedMember> result = this.getRegionAdvisor().adviseDataStore(true);
        if (this.isDataStore()) {
            result.add(this.getDistributionManager().getId());
        }
        return result;
    }

    public long getLocalSize() {
        if (this.dataStore == null) {
            return 0L;
        }
        long ret = 0L;
        for (Integer i : this.dataStore.getSizeLocally().values()) {
            ret += (long)i.intValue();
        }
        return ret;
    }

    public Object getRemotely(InternalDistributedMember targetNode, int bucketId, Object key, Object aCallbackArgument, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws PrimaryBucketException, ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug("PartitionedRegion#getRemotely: getting value from bucketId={}{}{} for key {}", (Object)this.getPRId(), (Object)BUCKET_ID_SEPARATOR, (Object)bucketId, key);
        }
        GetMessage.GetResponse response = GetMessage.send(targetNode, this, key, aCallbackArgument, requestingClient, returnTombstones);
        this.prStats.incPartitionMessagesSent();
        Object value = response.waitForResponse(preferCD);
        if (clientEvent != null) {
            clientEvent.setVersionTag(response.getVersionTag());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getRemotely: got value {} for key {}", value, key);
        }
        return value;
    }

    private ResultCollector executeFunctionOnRemoteNode(InternalDistributedMember targetNode, Function function, Object object, Set routingKeys, ResultCollector rc, Set bucketSet, ServerToClientFunctionResultSender sender, AbstractExecution execution) {
        PartitionedRegionFunctionResultSender resultSender = new PartitionedRegionFunctionResultSender(null, this, 0L, rc, sender, false, true, execution.isForwardExceptions(), function, bucketSet);
        PartitionedRegionFunctionResultWaiter resultReceiver = new PartitionedRegionFunctionResultWaiter(this.getSystem(), this.getPRId(), rc, function, resultSender);
        FunctionRemoteContext context = new FunctionRemoteContext(function, object, routingKeys, bucketSet, execution.isReExecute(), execution.isFnSerializationReqd());
        HashMap<InternalDistributedMember, FunctionRemoteContext> recipMap = new HashMap<InternalDistributedMember, FunctionRemoteContext>();
        recipMap.put(targetNode, context);
        return resultReceiver.getPartitionedDataFrom(recipMap, this, execution);
    }

    public PartitionedRegionDataStore getDataStore() {
        return this.dataStore;
    }

    @Override
    public boolean canStoreDataLocally() {
        return this.getDataStore() != null;
    }

    private static boolean grabPRIDLock(DistributedLockService lockService) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean ownership = false;
        int n = 0;
        while (!ownership) {
            if (isDebugEnabled) {
                logger.debug("grabPRIDLock: Trying to get the dlock in allPartitionedRegions for {}: {}", (Object)"MAX_PARTITIONED_REGION_ID", (Object)(n + 1));
            }
            ownership = lockService.lock("MAX_PARTITIONED_REGION_ID", VM_OWNERSHIP_WAIT_TIME, -1L);
        }
        return ownership;
    }

    private static void releasePRIDLock(DistributedLockService lockService) {
        try {
            lockService.unlock("MAX_PARTITIONED_REGION_ID");
            if (logger.isDebugEnabled()) {
                logger.debug("releasePRIDLock: Released the dlock in allPartitionedRegions for {}", (Object)"MAX_PARTITIONED_REGION_ID");
            }
        }
        catch (Exception es) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_RELEASEPRIDLOCK_UNLOCKING_0_CAUGHT_AN_EXCEPTION, Integer.valueOf("MAX_PARTITIONED_REGION_ID")), (Throwable)es);
        }
    }

    public int generatePRId(InternalDistributedSystem sys) {
        DistributedLockService lockService = this.getPartitionedRegionLockService();
        return PartitionedRegion._generatePRId(sys, lockService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _generatePRId(InternalDistributedSystem sys, DistributedLockService lockService) {
        boolean ownership = false;
        int prid = 0;
        try {
            ownership = PartitionedRegion.grabPRIDLock(lockService);
            if (ownership) {
                Set<InternalDistributedMember> parMembers;
                IdentityRequestMessage.IdentityResponse pir;
                Integer currentPRID;
                if (logger.isDebugEnabled()) {
                    logger.debug("generatePRId: Got the dlock in allPartitionedRegions for {}", (Object)"MAX_PARTITIONED_REGION_ID");
                }
                if ((currentPRID = (pir = IdentityRequestMessage.send(parMembers = sys.getDistributionManager().getOtherDistributionManagerIds(), sys)).waitForId()) == null) {
                    currentPRID = 0;
                }
                prid = currentPRID + 1;
                currentPRID = prid;
                try {
                    IdentityUpdateMessage.IdentityUpdateResponse pr = IdentityUpdateMessage.send(parMembers, sys, currentPRID);
                    pr.waitForRepliesUninterruptibly();
                }
                catch (ReplyException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("generatePRId: Ignoring exception", (Throwable)e);
                    }
                }
            }
        }
        finally {
            if (ownership) {
                PartitionedRegion.releasePRIDLock(lockService);
            }
        }
        return prid;
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.distAdvisor;
    }

    @Override
    public CacheDistributionAdvisor getCacheDistributionAdvisor() {
        return this.distAdvisor;
    }

    public RegionAdvisor getRegionAdvisor() {
        return this.distAdvisor;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.distAdvisor.createProfile();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile p) {
        CacheDistributionAdvisor.CacheProfile profile = (CacheDistributionAdvisor.CacheProfile)p;
        profile.isPartitioned = true;
        profile.isPersistent = this.getDataPolicy().withPersistence();
        profile.dataPolicy = this.getDataPolicy();
        profile.hasCacheLoader = this.basicGetLoader() != null;
        profile.hasCacheWriter = this.basicGetWriter() != null;
        profile.hasCacheListener = this.hasListener();
        Assert.assertTrue(this.getScope().isDistributed());
        profile.scope = this.getScope();
        profile.setSubscriptionAttributes(this.getSubscriptionAttributes());
        profile.serialNumber = this.getSerialNumber();
        profile.regionInitialized = this.recoveredFromDisk;
        profile.hasCacheServer = this.cache.getCacheServers().size() > 0;
        profile.filterProfile = this.getFilterProfile();
        profile.gatewaySenderIds = this.getGatewaySenderIds();
        profile.asyncEventQueueIds = this.getVisibleAsyncEventQueueIds();
        if (this.getDataPolicy().withPersistence()) {
            profile.persistentID = this.getDiskStore().generatePersistentID(null);
        }
        this.fillInProfile((RegionAdvisor.PartitionProfile)profile);
        for (CacheServiceProfile csp : this.getCacheServiceProfiles().values()) {
            profile.addCacheServiceProfile(csp);
        }
        profile.isOffHeap = this.getOffHeap();
    }

    public void fillInProfile(RegionAdvisor.PartitionProfile profile) {
        boolean bl = profile.isDataStore = this.getLocalMaxMemory() > 0;
        if (this.dataStore != null) {
            profile.numBuckets = this.dataStore.getBucketsManaged();
        }
        profile.requiresNotification = this.requiresNotification;
        profile.localMaxMemory = this.getLocalMaxMemory();
        profile.fixedPAttrs = this.fixedPAttrs;
        profile.shutDownAllStatus = this.shutDownAllStatus;
    }

    @Override
    protected void initialized() {
    }

    @Override
    protected void cacheListenersChanged(boolean nowHasListener) {
        if (nowHasListener) {
            this.advisorListener.initRMLWrappers();
        }
        new UpdateAttributesProcessor(this).distribute();
    }

    @Override
    protected void cacheWriterChanged(CacheWriter p_oldWriter) {
        super.cacheWriterChanged(p_oldWriter);
        if (p_oldWriter == null ^ this.basicGetWriter() == null) {
            new UpdateAttributesProcessor(this).distribute();
        }
    }

    @Override
    protected void cacheLoaderChanged(CacheLoader oldLoader) {
        this.dataStore.cacheLoaderChanged(this.basicGetLoader(), oldLoader);
        super.cacheLoaderChanged(oldLoader);
        if (oldLoader == null ^ this.basicGetLoader() == null) {
            new UpdateAttributesProcessor(this).distribute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PartitionedRegion getPRFromId(int prid) throws PRLocallyDestroyedException {
        Object o;
        PRIdMap pRIdMap = prIdToPR;
        synchronized (pRIdMap) {
            o = prIdToPR.getRegion(prid);
        }
        return (PartitionedRegion)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validatePRID(InternalDistributedMember sender, int prId, String regionId) {
        try {
            PartitionedRegion pr = null;
            PRIdMap pRIdMap = prIdToPR;
            synchronized (pRIdMap) {
                pr = (PartitionedRegion)prIdToPR.getRegion(prId);
            }
            if (pr != null && !pr.isLocallyDestroyed && pr.getRegionIdentifier().equals(regionId)) {
                return;
            }
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (PartitionedRegionException partitionedRegionException) {
        }
        catch (PRLocallyDestroyedException pRLocallyDestroyedException) {
            // empty catch block
        }
        PRIdMap pRIdMap = prIdToPR;
        synchronized (pRIdMap) {
            for (Object o : prIdToPR.values()) {
                if (o instanceof String) continue;
                PartitionedRegion pr = (PartitionedRegion)o;
                if (pr.getPRId() == prId) {
                    if (pr.getRegionIdentifier().equals(regionId)) continue;
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_0_IS_USING_PRID_1_FOR_2_BUT_THIS_PROCESS_MAPS_THAT_PRID_TO_3, new Object[]{sender.toString(), prId, pr.getRegionIdentifier()}));
                    continue;
                }
                if (!pr.getRegionIdentifier().equals(regionId)) continue;
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_0_IS_USING_PRID_1_FOR_2_BUT_THIS_PROCESS_IS_USING_PRID_3, new Object[]{sender, prId, pr.getRegionIdentifier(), pr.getPRId()}));
            }
        }
    }

    public static String dumpPRId() {
        return prIdToPR.dump();
    }

    public String dumpAllPartitionedRegions() {
        StringBuilder sb = new StringBuilder(this.prRoot.getFullPath());
        sb.append("\n");
        String key = null;
        Iterator<String> i = this.prRoot.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            sb.append((Object)key).append("=>").append(this.prRoot.get(key));
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getPRId() {
        return this.partitionedRegionId;
    }

    void updateLocalCache(Object key, Object value, long newVersion) {
    }

    public int getTotalNumberOfBuckets() {
        return this.totalNumberOfBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        long startTime = PartitionedRegionStats.startTime();
        try {
            if (event.getEventId() == null) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            this.discoverJTA();
            this.getDataView().destroyExistingEntry(event, cacheWrite, expectedOldValue);
        }
        catch (RegionDestroyedException rde) {
            if (!rde.getRegionFullPath().equals(this.getFullPath())) {
                throw new RegionDestroyedException(this.toString(), this.getFullPath(), rde);
            }
        }
        finally {
            this.prStats.endDestroy(startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyInBucket(EntryEventImpl event, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException {
        Integer bucketId = event.getKeyInfo().getBucketId();
        assert (bucketId != -1);
        InternalDistributedMember targetNode = this.getOrCreateNodeForBucketWrite(bucketId, null);
        if (logger.isDebugEnabled()) {
            logger.debug("destroyInBucket: key={} ({}) in node {} to bucketId={} retry={} ms", event.getKey(), (Object)event.getKey().hashCode(), (Object)targetNode, (Object)this.bucketStringForLogs(bucketId), (Object)this.retryTimeout);
        }
        RetryTimeKeeper retryTime = null;
        InternalDistributedMember currentTarget = targetNode;
        long timeOut = 0L;
        int count = 0;
        while (true) {
            switch (count) {
                case 0: {
                    break;
                }
                case 1: {
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    timeOut = System.currentTimeMillis() + (long)this.retryTimeout;
                    break;
                }
                default: {
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    long timeLeft = timeOut - System.currentTimeMillis();
                    if (timeLeft < 0L) {
                        PRHARedundancyProvider.timedOut(this, null, null, "destroy an entry", this.retryTimeout);
                    }
                    boolean interrupted = Thread.interrupted();
                    try {
                        Thread.sleep(100L);
                        break;
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                        break;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            ++count;
            if (currentTarget == null) {
                this.checkReadiness();
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                if (retryTime.overMaximum()) {
                    if (this.getRegionAdvisor().getBucket(bucketId).getBucketAdvisor().basicGetPrimaryMember() == null) {
                        throw new EntryNotFoundException(LocalizedStrings.PartitionedRegion_ENTRY_NOT_FOUND_FOR_KEY_0.toLocalizedString(event.getKey()));
                    }
                    TimeoutException e = new TimeoutException(LocalizedStrings.PartitionedRegion_TIME_OUT_LOOKING_FOR_TARGET_NODE_FOR_DESTROY_WAITED_0_MS.toLocalizedString(retryTime.getRetryTime()));
                    if (logger.isDebugEnabled()) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    this.checkReadiness();
                    throw e;
                }
                currentTarget = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
                if (currentTarget != null) continue;
                this.checkEntryNotFound(event.getKey());
                continue;
            }
            boolean isLocal = this.localMaxMemory > 0 && currentTarget.equals(this.getMyId());
            try {
                DistributedRemoveAllOperation savedOp = event.setRemoveAllOperation(null);
                if (savedOp != null) {
                    savedOp.addEntry(event, bucketId);
                    return;
                }
                if (isLocal) {
                    event.setInvokePRCallbacks(true);
                    this.dataStore.destroyLocally(bucketId, event, expectedOldValue);
                } else {
                    if (event.isBridgeEvent()) {
                        this.setNetworkHopType(bucketId, currentTarget);
                    }
                    this.destroyRemotely(currentTarget, bucketId, event, expectedOldValue);
                }
                return;
            }
            catch (ConcurrentCacheModificationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("destroyInBucket: caught concurrent cache modification exception", (Throwable)e);
                }
                event.isConcurrencyConflict(true);
                if (logger.isTraceEnabled()) {
                    logger.trace("ConcurrentCacheModificationException received for destroyInBucket for bucketId: {}{}{} for event: {} No reattempt is done, returning from here", (Object)this.getPRId(), (Object)BUCKET_ID_SEPARATOR, (Object)bucketId, (Object)event);
                }
                return;
            }
            catch (ForceReattemptException e) {
                e.checkKey(event.getKey());
                this.checkReadiness();
                InternalDistributedMember lastNode = currentTarget;
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                currentTarget = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
                event.setPossibleDuplicate(true);
                if (lastNode.equals(currentTarget)) {
                    if (retryTime.overMaximum()) {
                        PRHARedundancyProvider.timedOut(this, null, null, "destroy an entry", retryTime.getRetryTime());
                    }
                    retryTime.waitToRetryNode();
                }
            }
            catch (PrimaryBucketException notPrimary) {
                if (logger.isDebugEnabled()) {
                    logger.debug("destroyInBucket: {} on Node {} not primary", (Object)notPrimary.getLocalizedMessage(), (Object)currentTarget);
                }
                this.getRegionAdvisor().notPrimary(bucketId, currentTarget);
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                currentTarget = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
            }
            if (count == 1) {
                this.prStats.incDestroyOpsRetried();
            }
            this.prStats.incDestroyRetries();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("destroyInBucket: Attempting to resend destroy to node {} after {} failed attempts", (Object)currentTarget, (Object)count);
        }
    }

    private void setNetworkHopType(Integer bucketId, InternalDistributedMember targetNode) {
        Set<BucketAdvisor.ServerBucketProfile> profiles;
        if (this.isDataStore() && !this.getMyId().equals(targetNode) && (profiles = this.getRegionAdvisor().getClientBucketProfiles(bucketId)) != null) {
            for (BucketAdvisor.ServerBucketProfile profile : profiles) {
                if (!profile.getDistributedMember().equals(targetNode)) continue;
                if (this.isProfileFromSameGroup(profile)) {
                    if (this.getNetworkHopType() != 1 && logger.isDebugEnabled()) {
                        logger.debug("one-hop: cache op meta data staleness observed.  Message is in same server group (byte 1)");
                    }
                    this.setNetworkHopType((byte)1);
                } else {
                    if (this.getNetworkHopType() != 2 && logger.isDebugEnabled()) {
                        logger.debug("one-hop: cache op meta data staleness observed.  Message is to different server group (byte 2)");
                    }
                    this.setNetworkHopType((byte)2);
                }
                this.setMetadataVersion((byte)profile.getVersion());
                break;
            }
        }
    }

    public boolean isProfileFromSameGroup(BucketAdvisor.ServerBucketProfile profile) {
        Set<String> localServerGroups = this.getLocalServerGroups();
        if (localServerGroups.isEmpty()) {
            return true;
        }
        Set<BucketServerLocation66> locations = profile.getBucketServerLocations();
        for (BucketServerLocation66 sl : locations) {
            String[] groups = sl.getServerGroups();
            if (groups.length == 0) {
                return true;
            }
            for (String s : groups) {
                if (!localServerGroups.contains(s)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getLocalServerGroups() {
        HashSet<String> localServerGroups = new HashSet<String>();
        InternalCache cache = this.getCache();
        List<CacheServer> servers = cache.getCacheServers();
        Collections.addAll(localServerGroups, MemberAttributes.parseGroups(null, cache.getInternalDistributedSystem().getConfig().getGroups()));
        for (CacheServer object : servers) {
            CacheServerImpl server = (CacheServerImpl)object;
            if (!server.isRunning() || server.getExternalAddress() == null) continue;
            Collections.addAll(localServerGroups, server.getGroups());
        }
        return localServerGroups;
    }

    public void destroyRemotely(DistributedMember recipient, Integer bucketId, EntryEventImpl event, Object expectedOldValue) throws EntryNotFoundException, PrimaryBucketException, ForceReattemptException {
        DestroyMessage.DestroyResponse response = DestroyMessage.send(recipient, this, event, expectedOldValue);
        if (response != null) {
            this.prStats.incPartitionMessagesSent();
            try {
                response.waitForCacheException();
                event.setVersionTag(response.getVersionTag());
            }
            catch (EntryNotFoundException enfe) {
                throw enfe;
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (TransactionDataRebalancedException e) {
                throw e;
            }
            catch (CacheException ce) {
                throw new PartitionedRegionException(LocalizedStrings.PartitionedRegion_DESTROY_OF_ENTRY_ON_0_FAILED.toLocalizedString(recipient), ce);
            }
            catch (RegionDestroyedException ignore) {
                throw new RegionDestroyedException(this.toString(), this.getFullPath());
            }
        }
    }

    public int getLocalMaxMemory() {
        return this.localMaxMemory;
    }

    public int getRedundantCopies() {
        return this.redundantCopies;
    }

    @Override
    public VersionTag findVersionTagForEvent(EventID eventId) {
        if (this.dataStore != null) {
            Set<Map.Entry<Integer, BucketRegion>> bucketMap = this.dataStore.getAllLocalBuckets();
            for (Map.Entry<Integer, BucketRegion> entry : bucketMap) {
                VersionTag result = entry.getValue().findVersionTagForEvent(eventId);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public VersionTag findVersionTagForClientBulkOp(EventID eventId) {
        HashMap results = new HashMap();
        if (this.dataStore != null) {
            Set<Map.Entry<Integer, BucketRegion>> bucketMap = this.dataStore.getAllLocalBuckets();
            for (Map.Entry<Integer, BucketRegion> entry : bucketMap) {
                VersionTag bucketResult = entry.getValue().findVersionTagForClientBulkOp(eventId);
                if (bucketResult == null) continue;
                return bucketResult;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupFailedInitialization() {
        super.cleanupFailedInitialization();
        this.redundancyProvider.waitForPersistentBucketRecovery();
        this.cache.removePartitionedRegion(this);
        this.cache.getInternalResourceManager(false).removeResourceListener(this);
        this.redundancyProvider.shutdown();
        int[] serials = this.getRegionAdvisor().getBucketSerials();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_CLOSE, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        try {
            this.sendDestroyRegionMessage(event, serials);
        }
        catch (Exception ex) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONEDREGION_CLEANUPFAILEDINITIALIZATION_FAILED_TO_CLEAN_THE_PARTIONREGION_DATA_STORE), (Throwable)ex);
        }
        if (null != this.dataStore) {
            try {
                this.dataStore.cleanUp(true, false);
            }
            catch (Exception ex) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONEDREGION_CLEANUPFAILEDINITIALIZATION_FAILED_TO_CLEAN_THE_PARTIONREGION_DATA_STORE), (Throwable)ex);
            }
        }
        if (this.cleanPRRegistration) {
            try {
                PRIdMap ex = prIdToPR;
                synchronized (ex) {
                    if (prIdToPR.containsKey(this.partitionedRegionId)) {
                        prIdToPR.put(this.partitionedRegionId, "Partitioned Region's Registration Failed", false);
                        if (logger.isDebugEnabled()) {
                            logger.debug("cleanupFailedInitialization: set failed for prId={} named {}", (Object)this.partitionedRegionId, (Object)this.getName());
                        }
                    }
                }
                PartitionedRegionHelper.removeGlobalMetadataForFailedNode(this.node, this.getRegionIdentifier(), this.getGemFireCache(), true);
            }
            catch (Exception ex) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONEDREGION_CLEANUPFAILEDINITIALIZATION_FAILED_TO_CLEAN_THE_PARTIONREGION_ALLPARTITIONEDREGIONS), (Throwable)ex);
            }
        }
        this.distAdvisor.close();
        this.getPrStats().close();
        if (this.getDiskStore() != null && this.getDiskStore().getOwnedByRegion()) {
            this.getDiskStore().close();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cleanupFailedInitialization: end of {}", (Object)this.getName());
        }
    }

    static void afterRegionsClosedByCacheClose(InternalCache cache) {
        PRQueryProcessor.shutdown();
        PartitionedRegion.clearPRIdMap();
    }

    @Override
    void basicInvalidateRegion(RegionEventImpl event) {
        if (!event.isOriginRemote()) {
            this.sendInvalidateRegionMessage(event);
        }
        for (BucketRegion br : this.getDataStore().getAllLocalPrimaryBucketRegions()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalidating bucket {}", (Object)br);
            }
            br.basicInvalidateRegion(event);
        }
        super.basicInvalidateRegion(event);
    }

    @Override
    protected void invalidateAllEntries(RegionEvent rgnEvent) {
    }

    private void sendInvalidateRegionMessage(RegionEventImpl event) {
        int retryAttempts = this.calcRetry();
        Exception thr = null;
        int count = 0;
        while (count <= retryAttempts) {
            try {
                ++count;
                Set<InternalDistributedMember> recipients = this.getRegionAdvisor().adviseDataStore();
                ReplyProcessor21 response = InvalidatePartitionedRegionMessage.send(recipients, this, event);
                response.waitForReplies();
                thr = null;
                break;
            }
            catch (ReplyException e) {
                thr = e;
                if (this.isClosed || this.isDestroyed || !logger.isDebugEnabled()) continue;
                logger.debug("Invalidating partitioned region caught exception", (Throwable)e);
            }
            catch (InterruptedException e) {
                thr = e;
                if (this.cache.getCancelCriterion().isCancelInProgress() || !logger.isDebugEnabled()) continue;
                logger.debug("Invalidating partitioned region caught exception", (Throwable)e);
            }
        }
        if (thr != null) {
            PartitionedRegionDistributionException e = new PartitionedRegionDistributionException(LocalizedStrings.PartitionedRegion_INVALIDATING_REGION_CAUGHT_EXCEPTION.toLocalizedString(count));
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicInvalidate(EntryEventImpl event) throws EntryNotFoundException {
        long startTime = PartitionedRegionStats.startTime();
        try {
            if (event.getEventId() == null) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            this.discoverJTA();
            this.getDataView().invalidateExistingEntry(event, this.isInitialized(), false);
        }
        catch (RegionDestroyedException rde) {
            if (!rde.getRegionFullPath().equals(this.getFullPath())) {
                throw new RegionDestroyedException(this.toString(), this.getFullPath(), rde);
            }
        }
        finally {
            this.prStats.endInvalidate(startTime);
        }
    }

    @Override
    void basicUpdateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        block3: {
            try {
                if (event.getEventId() == null) {
                    event.setNewEventId(this.cache.getDistributedSystem());
                }
                this.getDataView().updateEntryVersion(event);
            }
            catch (RegionDestroyedException rde) {
                if (rde.getRegionFullPath().equals(this.getFullPath())) break block3;
                throw new RegionDestroyedException(this.toString(), this.getFullPath(), rde);
            }
        }
    }

    void invalidateInBucket(EntryEventImpl event) throws EntryNotFoundException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Integer bucketId = event.getKeyInfo().getBucketId();
        assert (bucketId != -1);
        InternalDistributedMember targetNode = this.getOrCreateNodeForBucketWrite(bucketId, null);
        int retryAttempts = this.calcRetry();
        int count = 0;
        RetryTimeKeeper retryTime = null;
        InternalDistributedMember retryNode = targetNode;
        while (count <= retryAttempts) {
            this.checkShutdown();
            if (retryNode == null) {
                this.checkReadiness();
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                try {
                    retryNode = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
                }
                catch (TimeoutException ignore) {
                    if (!this.getRegionAdvisor().isStorageAssignedForBucket(bucketId)) break;
                    throw new EntryNotFoundException(LocalizedStrings.PartitionedRegion_ENTRY_NOT_FOUND_FOR_KEY_0.toLocalizedString(event.getKey()));
                }
                if (retryNode != null) continue;
                this.checkEntryNotFound(event.getKey());
                continue;
            }
            boolean isLocal = this.localMaxMemory > 0 && retryNode.equals(this.getMyId());
            try {
                if (isLocal) {
                    event.setInvokePRCallbacks(true);
                    this.dataStore.invalidateLocally(bucketId, event);
                } else {
                    this.invalidateRemotely(retryNode, bucketId, event);
                }
                return;
            }
            catch (ConcurrentCacheModificationException e) {
                if (isDebugEnabled) {
                    logger.debug("invalidateInBucket: caught concurrent cache modification exception", (Throwable)e);
                }
                event.isConcurrencyConflict(true);
                if (isDebugEnabled) {
                    logger.debug("ConcurrentCacheModificationException received for invalidateInBucket for bucketId: {}{}{} for event: {}  No reattampt is done, returning from here", (Object)this.getPRId(), (Object)BUCKET_ID_SEPARATOR, (Object)bucketId, (Object)event);
                }
                return;
            }
            catch (ForceReattemptException prce) {
                prce.checkKey(event.getKey());
                if (isDebugEnabled) {
                    logger.debug("invalidateInBucket: retry attempt:{} of {}", (Object)count, (Object)retryAttempts, (Object)prce);
                }
                this.checkReadiness();
                InternalDistributedMember lastNode = retryNode;
                retryNode = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
                if (lastNode.equals(retryNode)) {
                    if (retryTime == null) {
                        retryTime = new RetryTimeKeeper(this.retryTimeout);
                    }
                    if (retryTime.overMaximum()) break;
                    retryTime.waitToRetryNode();
                }
                event.setPossibleDuplicate(true);
            }
            catch (PrimaryBucketException notPrimary) {
                if (isDebugEnabled) {
                    logger.debug("invalidateInBucket {} on Node {} not primary", (Object)notPrimary.getLocalizedMessage(), (Object)retryNode);
                }
                this.getRegionAdvisor().notPrimary(bucketId, retryNode);
                retryNode = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
            }
            if (++count == 1) {
                this.prStats.incInvalidateOpsRetried();
            }
            this.prStats.incInvalidateRetries();
            if (!isDebugEnabled) continue;
            logger.debug("invalidateInBucket: Attempting to resend invalidate to node {} after {} failed attempts", (Object)retryNode, (Object)count);
        }
        PartitionedRegionDistributionException e = new PartitionedRegionDistributionException(LocalizedStrings.PartitionedRegion_NO_VM_AVAILABLE_FOR_INVALIDATE_IN_0_ATTEMPTS.toLocalizedString(count));
        if (!isDebugEnabled) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_NO_VM_AVAILABLE_FOR_INVALIDATE_IN_0_ATTEMPTS, count));
        } else {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        throw e;
    }

    public void invalidateRemotely(DistributedMember recipient, Integer bucketId, EntryEventImpl event) throws EntryNotFoundException, PrimaryBucketException, ForceReattemptException {
        InvalidateMessage.InvalidateResponse response = InvalidateMessage.send(recipient, this, event);
        if (response != null) {
            this.prStats.incPartitionMessagesSent();
            try {
                response.waitForResult();
                event.setVersionTag(response.versionTag);
                return;
            }
            catch (EntryNotFoundException ex) {
                throw ex;
            }
            catch (TransactionDataNotColocatedException ex) {
                throw ex;
            }
            catch (TransactionDataRebalancedException e) {
                throw e;
            }
            catch (CacheException ce) {
                throw new PartitionedRegionException(LocalizedStrings.PartitionedRegion_INVALIDATION_OF_ENTRY_ON_0_FAILED.toLocalizedString(recipient), ce);
            }
        }
    }

    private int calcRetry() {
        return this.retryTimeout / 100 + 1;
    }

    private boolean createRemotely(DistributedMember recipient, Integer bucketId, EntryEventImpl event, boolean requireOldValue) throws PrimaryBucketException, ForceReattemptException {
        boolean ret = false;
        long eventTime = event.getEventTime(0L);
        PutMessage.PutResponse reply = (PutMessage.PutResponse)PutMessage.send(recipient, this, event, eventTime, true, false, null, requireOldValue);
        PutMessage.PutResult pr = null;
        if (reply != null) {
            this.prStats.incPartitionMessagesSent();
            try {
                pr = reply.waitForResult();
                event.setOperation(pr.op);
                event.setVersionTag(pr.versionTag);
                if (requireOldValue) {
                    event.setOldValue(pr.oldValue, true);
                }
                ret = pr.returnValue;
            }
            catch (EntryExistsException ignore) {
                ret = false;
            }
            catch (TransactionDataNotColocatedException tdnce) {
                throw tdnce;
            }
            catch (TransactionDataRebalancedException e) {
                throw e;
            }
            catch (CacheException ce) {
                throw new PartitionedRegionException(LocalizedStrings.PartitionedRegion_CREATE_OF_ENTRY_ON_0_FAILED.toLocalizedString(recipient), ce);
            }
            catch (RegionDestroyedException rde) {
                if (logger.isDebugEnabled()) {
                    logger.debug("createRemotely: caught exception", (Throwable)rde);
                }
                throw new RegionDestroyedException(this.toString(), this.getFullPath());
            }
        }
        return ret;
    }

    @Override
    public Set entrySet(boolean recursive) {
        this.checkReadiness();
        if (!this.restoreSetOperationTransactionBehavior) {
            this.discoverJTA();
        }
        return Collections.unmodifiableSet(new PREntriesSet());
    }

    public Set<Region.Entry> entrySet(Set<Integer> bucketIds) {
        return new PREntriesSet(bucketIds);
    }

    @Override
    public Set keys() {
        this.checkReadiness();
        if (!this.restoreSetOperationTransactionBehavior) {
            this.discoverJTA();
        }
        return Collections.unmodifiableSet(new KeysSet());
    }

    @Override
    public Set keySet(boolean allowTombstones) {
        this.checkReadiness();
        return Collections.unmodifiableSet(new KeysSet(allowTombstones));
    }

    public Set keySet(Set<Integer> bucketSet) {
        return new KeysSet(bucketSet);
    }

    public Set keysWithoutCreatesForTests() {
        this.checkReadiness();
        HashSet<Integer> availableBuckets = new HashSet<Integer>();
        for (int i = 0; i < this.getTotalNumberOfBuckets(); ++i) {
            if (!this.distAdvisor.isStorageAssignedForBucket(i)) continue;
            availableBuckets.add(i);
        }
        return Collections.unmodifiableSet(new KeysSet(availableBuckets));
    }

    @Override
    public Collection values() {
        this.checkReadiness();
        if (!this.restoreSetOperationTransactionBehavior) {
            this.discoverJTA();
        }
        return Collections.unmodifiableSet(new ValuesSet());
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_VALUE_FOR_CONTAINSVALUEVALUE_CANNOT_BE_NULL.toLocalizedString());
        }
        this.checkReadiness();
        if (this.getDataStore() != null) {
            ValuesSet vSet = new ValuesSet(this.getDataStore().getAllLocalPrimaryBucketIds());
            for (Object v : vSet) {
                if (!v.equals(value)) continue;
                return true;
            }
        }
        ResultCollector rc = null;
        try {
            rc = FunctionService.onRegion(this).setArguments((Serializable)value).execute(PRContainsValueFunction.class.getName());
            List results = (List)rc.getResult();
            for (Boolean r : results) {
                if (!r.booleanValue()) continue;
                return true;
            }
        }
        catch (FunctionException fe) {
            this.checkShutdown();
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PR_CONTAINSVALUE_WARNING), fe.getCause());
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkReadiness();
        this.validateKey(key);
        return this.getDataView().containsKey(this.getKeyInfo(key), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean nonTXContainsKey(KeyInfo keyInfo) {
        long startTime = PartitionedRegionStats.startTime();
        boolean contains = false;
        try {
            int bucketId = keyInfo.getBucketId();
            if (bucketId == -1) {
                bucketId = PartitionedRegionHelper.getHashKey(this, Operation.CONTAINS_KEY, keyInfo.getKey(), keyInfo.getValue(), keyInfo.getCallbackArg());
                keyInfo.setBucketId(bucketId);
            }
            Integer bucketIdInt = bucketId;
            InternalDistributedMember targetNode = this.getOrCreateNodeForBucketRead(bucketId);
            if (targetNode != null) {
                contains = this.containsKeyInBucket(targetNode, bucketIdInt, keyInfo.getKey(), false);
            }
        }
        finally {
            this.prStats.endContainsKey(startTime);
        }
        return contains;
    }

    boolean containsKeyInBucket(InternalDistributedMember targetNode, Integer bucketIdInt, Object key, boolean valueCheck) {
        int retryAttempts = this.calcRetry();
        if (logger.isDebugEnabled()) {
            logger.debug("containsKeyInBucket: {}{} ({}) from: {} bucketId={}", (Object)(valueCheck ? "ValueForKey key=" : "Key key="), key, (Object)key.hashCode(), (Object)targetNode, (Object)this.bucketStringForLogs(bucketIdInt));
        }
        int count = 0;
        RetryTimeKeeper retryTime = null;
        InternalDistributedMember retryNode = targetNode;
        while (count <= retryAttempts) {
            block16: {
                if (retryNode == null) {
                    this.checkReadiness();
                    if (retryTime == null) {
                        retryTime = new RetryTimeKeeper(this.retryTimeout);
                    }
                    if (retryTime.overMaximum()) break;
                    retryNode = this.getOrCreateNodeForBucketRead(bucketIdInt);
                    if (retryNode != null) continue;
                    this.checkShutdown();
                    return false;
                }
                try {
                    boolean loc = retryNode.equals(this.getMyId());
                    boolean ret = loc ? (valueCheck ? this.dataStore.containsValueForKeyLocally(bucketIdInt, key) : this.dataStore.containsKeyLocally(bucketIdInt, key)) : (valueCheck ? this.containsValueForKeyRemotely(retryNode, bucketIdInt, key) : this.containsKeyRemotely(retryNode, bucketIdInt, key));
                    return ret;
                }
                catch (PRLocallyDestroyedException pde) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("containsKeyInBucket: Encountered PRLocallyDestroyedException", (Throwable)pde);
                    }
                    this.checkReadiness();
                }
                catch (ForceReattemptException prce) {
                    prce.checkKey(key);
                    if (logger.isDebugEnabled()) {
                        logger.debug("containsKeyInBucket: retry attempt:{} of {}", (Object)count, (Object)retryAttempts, (Object)prce);
                    }
                    this.checkReadiness();
                    InternalDistributedMember lastNode = retryNode;
                    retryNode = this.getOrCreateNodeForBucketRead(bucketIdInt);
                    if (lastNode.equals(retryNode)) {
                        if (retryTime == null) {
                            retryTime = new RetryTimeKeeper(this.retryTimeout);
                        }
                        if (retryTime.overMaximum()) break;
                        retryTime.waitToRetryNode();
                    }
                }
                catch (PrimaryBucketException notPrimary) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("containsKeyInBucket {} on Node {} not primary", (Object)notPrimary.getLocalizedMessage(), (Object)retryNode);
                    }
                    this.getRegionAdvisor().notPrimary(bucketIdInt, retryNode);
                    retryNode = this.getOrCreateNodeForBucketRead(bucketIdInt);
                }
                catch (RegionDestroyedException rde) {
                    if (rde.getRegionFullPath().equals(this.getFullPath())) break block16;
                    throw new RegionDestroyedException(this.toString(), this.getFullPath(), rde);
                }
            }
            this.checkShutdown();
            if (++count == 1) {
                this.prStats.incContainsKeyValueOpsRetried();
            }
            this.prStats.incContainsKeyValueRetries();
        }
        StringId msg = null;
        msg = valueCheck ? LocalizedStrings.PartitionedRegion_NO_VM_AVAILABLE_FOR_CONTAINS_VALUE_FOR_KEY_IN_1_ATTEMPTS : LocalizedStrings.PartitionedRegion_NO_VM_AVAILABLE_FOR_CONTAINS_KEY_IN_1_ATTEMPTS;
        Integer countInteger = count;
        PartitionedRegionDistributionException e = null;
        if (logger.isDebugEnabled()) {
            e = new PartitionedRegionDistributionException(msg.toLocalizedString(countInteger));
        }
        logger.warn((Message)LocalizedMessage.create(msg, countInteger), e);
        return false;
    }

    public boolean containsKeyRemotely(InternalDistributedMember targetNode, Integer bucketId, Object key) throws PrimaryBucketException, ForceReattemptException {
        ContainsKeyValueMessage.ContainsKeyValueResponse r = ContainsKeyValueMessage.send(targetNode, this, key, bucketId, false);
        this.prStats.incPartitionMessagesSent();
        return r.waitForContainsResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValueForKey(Object key) {
        this.checkReadiness();
        this.validateKey(key);
        long startTime = PartitionedRegionStats.startTime();
        boolean containsValueForKey = false;
        try {
            containsValueForKey = this.getDataView().containsValueForKey(this.getKeyInfo(key), this);
        }
        finally {
            this.prStats.endContainsValueForKey(startTime);
        }
        return containsValueForKey;
    }

    @Override
    protected boolean nonTXContainsValueForKey(KeyInfo keyInfo) {
        InternalDistributedMember targetNode;
        boolean containsValueForKey = false;
        int bucketId = keyInfo.getBucketId();
        if (bucketId == -1) {
            bucketId = PartitionedRegionHelper.getHashKey(this, Operation.CONTAINS_VALUE_FOR_KEY, keyInfo.getKey(), keyInfo.getValue(), keyInfo.getCallbackArg());
            keyInfo.setBucketId(bucketId);
        }
        if ((targetNode = this.getOrCreateNodeForBucketRead(bucketId)) != null) {
            containsValueForKey = this.containsKeyInBucket(targetNode, bucketId, keyInfo.getKey(), true);
        }
        return containsValueForKey;
    }

    public boolean containsValueForKeyRemotely(InternalDistributedMember targetNode, Integer bucketId, Object key) throws PrimaryBucketException, ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug("containsValueForKeyRemotely: key={}", key);
        }
        ContainsKeyValueMessage.ContainsKeyValueResponse r = ContainsKeyValueMessage.send(targetNode, this, key, bucketId, true);
        this.prStats.incPartitionMessagesSent();
        return r.waitForContainsResult();
    }

    public PartitionedRegionStats getPrStats() {
        return this.prStats;
    }

    @Override
    public int getRegionSize() {
        return this.entryCount(null);
    }

    public int entryCount(boolean localOnly) {
        if (localOnly) {
            if (this.isDataStore()) {
                return this.entryCount(this.dataStore.getAllLocalBucketIds());
            }
            return 0;
        }
        return this.entryCount(null);
    }

    @Override
    public int entryCount(Set<Integer> buckets) {
        return this.entryCount(buckets, false);
    }

    @Override
    public int entryCount(Set<Integer> buckets, boolean estimate) {
        Map<Integer, SizeEntry> bucketSizes = null;
        if (buckets != null) {
            if (this.dataStore != null) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.addAll(buckets);
                bucketSizes = this.dataStore.getSizeLocallyForBuckets(list);
            }
        } else {
            if (this.dataStore != null) {
                bucketSizes = this.dataStore.getSizeForLocalBuckets();
            }
            HashSet recips = (HashSet)this.getRegionAdvisor().adviseDataStore(true);
            recips.remove(this.getMyId());
            if (!recips.isEmpty()) {
                Map<Integer, SizeEntry> remoteSizes = this.getSizeRemotely(recips, false);
                if (logger.isDebugEnabled()) {
                    logger.debug("entryCount: {} remoteSizes={}", (Object)this, remoteSizes);
                }
                if (bucketSizes != null && !bucketSizes.isEmpty()) {
                    for (Map.Entry<Integer, SizeEntry> me : remoteSizes.entrySet()) {
                        Integer k = me.getKey();
                        if (bucketSizes.containsKey(k) && bucketSizes.get(k).isPrimary()) continue;
                        bucketSizes.put(k, me.getValue());
                    }
                } else {
                    bucketSizes = remoteSizes;
                }
            }
        }
        int size = 0;
        if (bucketSizes != null) {
            for (SizeEntry entry : bucketSizes.values()) {
                size += entry.getSize();
            }
        }
        return size;
    }

    @Override
    public long getEstimatedLocalSize() {
        PartitionedRegionDataStore ds = this.dataStore;
        if (ds != null) {
            return ds.getEstimatedLocalBucketSize(false);
        }
        return 0L;
    }

    private Map<Integer, SizeEntry> getSizeRemotely(Set targetNodes, boolean estimate) {
        SizeMessage.SizeResponse r = SizeMessage.send(targetNodes, this, null, estimate);
        this.prStats.incPartitionMessagesSent();
        Map<Integer, SizeEntry> retVal = null;
        try {
            retVal = r.waitBucketSizes();
        }
        catch (CacheException e) {
            this.checkReadiness();
            throw e;
        }
        return retVal;
    }

    private String getLockNameForBucket2NodeModification(int bucketID) {
        return this.getRegionIdentifier() + BUCKET_ID_SEPARATOR + bucketID;
    }

    public BucketLock getBucketLock(int bucketID) {
        String lockName = this.getLockNameForBucket2NodeModification(bucketID);
        return new BucketLock(lockName, this.getCache(), false);
    }

    @Override
    public String toString() {
        return new StringBuffer().append("Partitioned Region ").append("@").append(Integer.toHexString(this.hashCode())).append(" [").append("path='").append(this.getFullPath()).append("'; dataPolicy=").append(this.getDataPolicy()).append("; prId=").append(this.partitionedRegionId).append("; isDestroyed=").append(this.isDestroyed).append("; isClosed=").append(this.isClosed).append("; retryTimeout=").append(this.retryTimeout).append("; serialNumber=").append(this.getSerialNumber()).append("; partition attributes=").append(this.getPartitionAttributes().toString()).append("; on VM ").append(this.getMyId()).append("]").toString();
    }

    public RegionLock getRegionLock() {
        return PartitionedRegion.getRegionLock(this.getRegionIdentifier(), this.getGemFireCache());
    }

    public static RegionLock getRegionLock(String regionIdentifier, InternalCache cache) {
        return new RegionLock(regionIdentifier, cache);
    }

    public RecoveryLock getRecoveryLock() {
        return new RecoveryLock();
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public LoaderHelper createLoaderHelper(Object key, Object callbackArgument, boolean netSearchAllowed, boolean netLoadAllowed, SearchLoadAndWriteProcessor searcher) {
        return new LoaderHelperImpl(this, key, callbackArgument, netSearchAllowed, netLoadAllowed, searcher);
    }

    public PRHARedundancyProvider getRedundancyProvider() {
        return this.redundancyProvider;
    }

    public void checkClosed() {
        if (this.isClosed) {
            throw new RegionDestroyedException(LocalizedStrings.PartitionedRegion_PR_0_IS_LOCALLY_CLOSED.toLocalizedString(this), this.getFullPath());
        }
    }

    public void checkClosedOrDestroyed() {
        this.checkClosed();
        if (this.isDestroyed()) {
            throw new RegionDestroyedException(this.toString(), this.getFullPath());
        }
    }

    public void setHaveCacheLoader() {
        if (!this.haveCacheLoader) {
            this.haveCacheLoader = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePartitionedRegion(RegionEventImpl event) {
        boolean isClose = event.getOperation().isClose();
        if (isClose) {
            this.isClosed = true;
        }
        RegionLock rl = this.getRegionLock();
        try {
            rl.lock();
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONED_REGION_0_WITH_PRID_1_CLOSING, new Object[]{this.getFullPath(), this.getPRId()}));
            if (!this.checkIfAlreadyDestroyedOrOldReference()) {
                PartitionedRegionHelper.removeGlobalMetadataForFailedNode(this.getNode(), this.getRegionIdentifier(), this.getGemFireCache(), false);
            }
            int[] serials = this.getRegionAdvisor().getBucketSerials();
            if (!event.getOperation().isClose() && this.getDiskStore() != null && this.getDataStore() != null) {
                for (BucketRegion bucketRegion : this.getDataStore().getAllLocalBucketRegions()) {
                    bucketRegion.isDestroyingDiskRegion = true;
                    bucketRegion.getDiskRegion().beginDestroy(bucketRegion);
                }
            }
            this.sendDestroyRegionMessage(event, serials);
            PRIdMap pRIdMap = prIdToPR;
            synchronized (pRIdMap) {
                prIdToPR.put(this.getPRId(), "Partitioned Region Is Locally Destroyed", false);
            }
            this.redundancyProvider.shutdown();
            if (this.dataStore != null) {
                this.dataStore.cleanUp(true, !isClose);
            }
        }
        finally {
            PRIdMap pRIdMap = prIdToPR;
            synchronized (pRIdMap) {
                prIdToPR.put(this.getPRId(), "Partitioned Region Is Locally Destroyed", false);
            }
            rl.unlock();
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONED_REGION_0_WITH_PRID_1_CLOSED, new Object[]{this.getFullPath(), this.getPRId()}));
    }

    public void checkForColocatedChildren() {
        List<PartitionedRegion> listOfChildRegions = ColocationHelper.getColocatedChildRegions(this);
        if (listOfChildRegions.size() != 0) {
            ArrayList<String> childRegionList = new ArrayList<String>();
            for (PartitionedRegion childRegion : listOfChildRegions) {
                if (childRegion.getName().contains("_PARALLEL_GATEWAY_SENDER_QUEUE")) continue;
                childRegionList.add(childRegion.getFullPath());
            }
            if (!childRegionList.isEmpty()) {
                throw new IllegalStateException(String.format("The parent region [%s] in colocation chain cannot be destroyed, unless all its children [%s] are destroyed", this.getFullPath(), childRegionList));
            }
        }
    }

    @Override
    public void destroyRegion(Object aCallbackArgument) throws CacheWriterException, TimeoutException {
        this.cache.invokeBeforeDestroyed(this);
        this.checkForColocatedChildren();
        this.getDataView().checkSupportsRegionDestroy();
        this.checkForLimitedOrNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_DESTROY, aCallbackArgument, false, (DistributedMember)this.getMyId(), this.generateEventID());
        this.basicDestroyRegion(event, true);
    }

    private void stopMissingColocatedRegionLogger() {
        if (this.missingColocatedRegionLogger != null) {
            this.missingColocatedRegionLogger.stopLogger();
        }
        this.missingColocatedRegionLogger = null;
    }

    public void addMissingColocatedRegionLogger(String childName) {
        if (this.missingColocatedRegionLogger == null) {
            this.missingColocatedRegionLogger = new ColocationLogger(this);
        }
        this.missingColocatedRegionLogger.addMissingChildRegion(childName);
    }

    public void addMissingColocatedRegionLogger(PartitionedRegion childRegion) {
        if (this.missingColocatedRegionLogger == null) {
            this.missingColocatedRegionLogger = new ColocationLogger(this);
        }
        this.missingColocatedRegionLogger.addMissingChildRegions(childRegion);
    }

    public List<String> getMissingColocatedChildren() {
        ColocationLogger regionLogger = this.missingColocatedRegionLogger;
        if (regionLogger != null) {
            return regionLogger.updateAndGetMissingChildRegions();
        }
        return Collections.emptyList();
    }

    public void destroyParallelGatewaySenderRegion(Operation op, boolean cacheWrite, boolean lock, boolean callbackEvents) {
        if (logger.isDebugEnabled()) {
            logger.debug("Destoying parallel queue region for senders: {}", this.getParallelGatewaySenderIds());
        }
        boolean keepWaiting = true;
        while (true) {
            ArrayList<String> pausedSenders = new ArrayList<String>();
            ArrayList<ConcurrentParallelGatewaySenderQueue> parallelQueues = new ArrayList<ConcurrentParallelGatewaySenderQueue>();
            this.isDestroyedForParallelWAN = true;
            int countOfQueueRegionsToBeDestroyed = 0;
            for (String senderId : this.getParallelGatewaySenderIds()) {
                ConcurrentParallelGatewaySenderQueue parallelQueue;
                PartitionedRegion parallelQueueRegion;
                AbstractGatewaySenderEventProcessor ep;
                AbstractGatewaySender sender = (AbstractGatewaySender)this.cache.getGatewaySender(senderId);
                if (sender == null || sender.getEventProcessor() == null) continue;
                if (cacheWrite && sender.isPaused()) {
                    pausedSenders.add(senderId);
                    continue;
                }
                if (!pausedSenders.isEmpty() || (ep = sender.getEventProcessor()) == null || (parallelQueueRegion = (parallelQueue = (ConcurrentParallelGatewaySenderQueue)ep.getQueue()).getRegion(this.getFullPath())) == null || parallelQueueRegion.isDestroyed || parallelQueueRegion.isClosed) continue;
                parallelQueues.add(parallelQueue);
                ++countOfQueueRegionsToBeDestroyed;
            }
            if (!pausedSenders.isEmpty()) {
                String exception = null;
                exception = pausedSenders.size() == 1 ? LocalizedStrings.PartitionedRegion_GATEWAYSENDER_0_IS_PAUSED_RESUME_IT_BEFORE_DESTROYING_USER_REGION_1.toLocalizedString(pausedSenders, this.getName()) : LocalizedStrings.PartitionedRegion_GATEWAYSENDERS_0_ARE_PAUSED_RESUME_THEM_BEFORE_DESTROYING_USER_REGION_1.toLocalizedString(pausedSenders, this.getName());
                this.isDestroyedForParallelWAN = false;
                throw new GatewaySenderException(exception);
            }
            if (countOfQueueRegionsToBeDestroyed == 0) break;
            for (ConcurrentParallelGatewaySenderQueue parallelQueue : parallelQueues) {
                PartitionedRegion parallelQueueRegion = parallelQueue.getRegion(this.getFullPath());
                if (cacheWrite && parallelQueueRegion.size() != 0 && keepWaiting) continue;
                RegionEventImpl event = null;
                event = op.isClose() ? new RegionEventImpl((Region)parallelQueueRegion, op, null, false, (DistributedMember)this.getMyId(), this.generateEventID()) : new RegionEventImpl((Region)parallelQueueRegion, Operation.REGION_LOCAL_DESTROY, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
                parallelQueueRegion.basicDestroyRegion(event, false, lock, callbackEvents);
                parallelQueue.removeShadowPR(this.getFullPath());
                --countOfQueueRegionsToBeDestroyed;
            }
            if (countOfQueueRegionsToBeDestroyed == 0) break;
            if (!cacheWrite) continue;
            if (AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME == -1) {
                keepWaiting = true;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                Thread.sleep(AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            keepWaiting = false;
        }
    }

    @Override
    public void localDestroyRegion(Object aCallbackArgument) {
        this.getDataView().checkSupportsRegionDestroy();
        String prName = this.getColocatedWith();
        List<PartitionedRegion> listOfChildRegions = ColocationHelper.getColocatedChildRegions(this);
        ArrayList<String> childRegionsWithoutSendersList = new ArrayList<String>();
        if (listOfChildRegions.size() != 0) {
            for (PartitionedRegion childRegion : listOfChildRegions) {
                if (childRegion.getName().contains("_PARALLEL_GATEWAY_SENDER_QUEUE")) continue;
                childRegionsWithoutSendersList.add(childRegion.getFullPath());
            }
        }
        if (prName != null || !childRegionsWithoutSendersList.isEmpty()) {
            throw new UnsupportedOperationException("Any Region in colocation chain cannot be destroyed locally.");
        }
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_LOCAL_DESTROY, aCallbackArgument, false, (DistributedMember)this.getMyId(), this.generateEventID());
        try {
            this.basicDestroyRegion(event, false);
        }
        catch (CacheWriterException e) {
            throw new Error("CacheWriterException should not be thrown in localDestroyRegion", e);
        }
        catch (TimeoutException e) {
            throw new Error("TimeoutException should not be thrown in localDestroyRegion", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyPartitionedRegion(RegionEventImpl event) {
        RegionLock rl = this.getRegionLock();
        boolean isLocked = false;
        boolean removeFromDisk = !event.getOperation().isClose();
        try {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONED_REGION_0_WITH_PRID_1_IS_BEING_DESTROYED, new Object[]{this.getFullPath(), this.getPRId()}));
            if (!event.isOriginRemote()) {
                try {
                    rl.lock();
                    isLocked = true;
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                if (!this.destroyPartitionedRegionGlobally(event) && this.destroyPartitionedRegionLocally(removeFromDisk)) {
                    this.sendLocalDestroyRegionMessage(event);
                }
            } else {
                PartitionRegionConfig prConfig = null;
                try {
                    prConfig = this.prRoot.get(this.getRegionIdentifier());
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                if (!this.checkIfAlreadyDestroyedOrOldReference() && null != prConfig && !prConfig.getIsDestroying()) {
                    try {
                        rl.lock();
                        isLocked = true;
                    }
                    catch (CancelException cancelException) {
                        // empty catch block
                    }
                    if (!this.destroyPartitionedRegionGlobally(event) && this.destroyPartitionedRegionLocally(removeFromDisk)) {
                        this.sendLocalDestroyRegionMessage(event);
                    }
                } else if (this.destroyPartitionedRegionLocally(removeFromDisk)) {
                    this.sendLocalDestroyRegionMessage(event);
                }
            }
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONED_REGION_0_WITH_PRID_1_IS_DESTROYED, new Object[]{this.getFullPath(), this.getPRId()}));
        }
        finally {
            try {
                if (isLocked) {
                    rl.unlock();
                }
            }
            catch (Exception es) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_CAUGHT_EXCEPTION_WHILE_TRYING_TO_UNLOCK_DURING_REGION_DESTRUCTION), (Throwable)es);
            }
        }
    }

    private boolean destroyPartitionedRegionGlobally(RegionEventImpl event) {
        PartitionRegionConfig prConfig;
        if (this.checkIfAlreadyDestroyedOrOldReference()) {
            return false;
        }
        try {
            prConfig = this.prRoot.get(this.getRegionIdentifier());
        }
        catch (CancelException ignore) {
            return false;
        }
        if (prConfig == null || prConfig.getIsDestroying()) {
            return false;
        }
        prConfig.setIsDestroying();
        try {
            this.prRoot.put(this.getRegionIdentifier(), prConfig);
        }
        catch (CancelException ignore) {
            // empty catch block
        }
        int[] serials = this.getRegionAdvisor().getBucketSerials();
        boolean isClose = event.getOperation().isClose();
        this.destroyPartitionedRegionLocally(!isClose);
        this.destroyCleanUp(event, serials);
        return true;
    }

    private void sendLocalDestroyRegionMessage(RegionEventImpl event) {
        int[] serials = this.getRegionAdvisor().getBucketSerials();
        RegionEventImpl eventForLocalDestroy = (RegionEventImpl)event.clone();
        eventForLocalDestroy.setOperation(Operation.REGION_LOCAL_DESTROY);
        this.sendDestroyRegionMessage(event, serials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyCleanUp(RegionEventImpl event, int[] serials) {
        String rId = this.getRegionIdentifier();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegion#destroyCleanUp: Destroying region: {}", (Object)this.getFullPath());
            }
            this.sendDestroyRegionMessage(event, serials);
            try {
                if (null != this.prRoot) {
                    this.prRoot.destroy(rId);
                }
            }
            catch (EntryNotFoundException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("PartitionedRegion#destroyCleanup: caught exception", (Throwable)ex);
                }
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegion#destroyCleanUp: Destroyed region: {}", (Object)this.getFullPath());
            }
        }
    }

    private void sendDestroyRegionMessage(RegionEventImpl event, int[] serials) {
        boolean retry = true;
        while (retry) {
            retry = this.attemptToSendDestroyRegionMessage(event, serials);
        }
    }

    private boolean attemptToSendDestroyRegionMessage(RegionEventImpl event, int[] serials) {
        if (this.prRoot == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Partition region {} failed to initialize. Remove its profile from remote members.", (Object)this);
            }
            new UpdateAttributesProcessor(this, true).distribute(false);
            return false;
        }
        HashSet<InternalDistributedMember> configRecipients = new HashSet<InternalDistributedMember>(this.getRegionAdvisor().adviseAllPRNodes());
        try {
            PartitionRegionConfig prConfig = this.prRoot.get(this.getRegionIdentifier());
            if (prConfig != null) {
                Iterator<Node> itr = prConfig.getNodes().iterator();
                while (itr.hasNext()) {
                    InternalDistributedMember idm = itr.next().getMemberId();
                    if (idm.equals(this.getMyId())) continue;
                    configRecipients.add(idm);
                }
            }
        }
        catch (CancelException prConfig) {
            // empty catch block
        }
        try {
            DestroyPartitionedRegionMessage.DestroyPartitionedRegionResponse resp = DestroyPartitionedRegionMessage.send(configRecipients, this, event, serials);
            resp.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            if (e.getRootCause() instanceof ForceReattemptException) {
                return true;
            }
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_PARTITIONEDREGION_SENDDESTROYREGIONMESSAGE_CAUGHT_EXCEPTION_DURING_DESTROYREGIONMESSAGE_SEND_AND_WAITING_FOR_RESPONSE), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean destroyPartitionedRegionLocally(boolean removeFromDisk) {
        Map map = this;
        synchronized (map) {
            if (this.isLocallyDestroyed) {
                return false;
            }
            this.locallyDestroyingThread = Thread.currentThread();
            this.isLocallyDestroyed = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("destroyPartitionedRegionLocally: Starting destroy for PR = {}", (Object)this);
        }
        try {
            map = prIdToPR;
            synchronized (map) {
                prIdToPR.remove(this.getPRId());
            }
            this.redundancyProvider.shutdown();
            if (this.dataStore != null) {
                this.dataStore.cleanUp(false, removeFromDisk);
            }
        }
        finally {
            this.getRegionAdvisor().close();
            this.getPrStats().close();
            this.cache.getInternalResourceManager(false).removeResourceListener(this);
            this.locallyDestroyingThread = null;
            if (logger.isDebugEnabled()) {
                logger.debug("destroyPartitionedRegionLocally: Ending destroy for PR = {}", (Object)this);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void postDestroyRegion(boolean destroyDiskRegion, RegionEventImpl event) {
        DiskStoreImpl dsi;
        Operation op;
        block28: {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegion#postDestroyRegion: {}", (Object)this);
            }
            Assert.assertTrue(this.isDestroyed || this.isClosed);
            this.redundancyProvider.waitForPersistentBucketRecovery();
            this.cache.removePartitionedRegion(this);
            this.cache.getInternalResourceManager(false).removeResourceListener(this);
            op = event.getOperation();
            this.stopMissingColocatedRegionLogger();
            if (op.isClose() || Operation.REGION_LOCAL_DESTROY.equals(op)) {
                try {
                    if (Operation.CACHE_CLOSE.equals(op) || Operation.FORCED_DISCONNECT.equals(op)) {
                        int[] serials = this.getRegionAdvisor().getBucketSerials();
                        try {
                            PartitionedRegionDataStore store;
                            this.getRegionAdvisor().closeBucketAdvisors();
                            this.sendDestroyRegionMessage(event, serials);
                            if (RegionLogger.isEnabled() && (store = this.getDataStore()) != null) {
                                for (BucketRegion bucket : store.getAllLocalBucketRegions()) {
                                    RegionLogger.logDestroy(bucket.getFullPath(), this.getMyId(), bucket.getPersistentID(), true);
                                }
                            }
                            break block28;
                        }
                        catch (CancelException ignore) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("postDestroyRegion: failed sending DestroyRegionMessage due to cache closure");
                            }
                            break block28;
                        }
                        finally {
                            DiskStoreImpl dsi2 = this.getDiskStore();
                            if (dsi2 != null && dsi2.getOwnedByRegion()) {
                                this.cache.addDiskStore(dsi2);
                            }
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Making closePartitionedRegion call for {} with origin = {} op= {}", (Object)this, (Object)event.isOriginRemote(), (Object)op);
                    }
                    try {
                        this.closePartitionedRegion(event);
                        break block28;
                    }
                    finally {
                        if (Operation.REGION_LOCAL_DESTROY.equals(op) && (dsi = this.getDiskStore()) != null && dsi.getOwnedByRegion()) {
                            dsi.destroy();
                        }
                    }
                }
                finally {
                    this.getRegionAdvisor().close();
                    this.getPrStats().close();
                }
            }
            if (Operation.REGION_DESTROY.equals(op) || Operation.REGION_EXPIRE_DESTROY.equals(op)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("PartitionedRegion#postDestroyRegion: Making destroyPartitionedRegion call for {} with originRemote = {}", (Object)this, (Object)event.isOriginRemote());
                }
                this.destroyPartitionedRegion(event);
            } else {
                Assert.assertTrue(false, "Unknown op" + op);
            }
        }
        if (!(this.isUsedForMetaRegion() || this.isUsedForPartitionedRegionAdmin() || this.isUsedForPartitionedRegionBucket() || this.isUsedForParallelGatewaySenderQueue())) {
            FilterRoutingInfo localCqFrInfo = this.getFilterProfile().getFilterRoutingInfoPart1(event, FilterProfile.NO_PROFILES, Collections.emptySet());
            FilterRoutingInfo localCqInterestFrInfo = this.getFilterProfile().getFilterRoutingInfoPart2(localCqFrInfo, event);
            if (localCqInterestFrInfo != null) {
                event.setLocalFilterInfo(localCqInterestFrInfo.getLocalFilterInfo());
            }
        }
        if (destroyDiskRegion && (dsi = this.getDiskStore()) != null && this.getDataPolicy().withPersistence()) {
            dsi.removePersistentPR(this.getFullPath());
            if (this.colocatedWithRegion != null && this.colocatedWithRegion.getDiskStore() != null && this.colocatedWithRegion.getDiskStore() != dsi) {
                this.colocatedWithRegion.getDiskStore().removePersistentPR(this.getFullPath());
            }
        }
        if (this.colocatedWithRegion != null) {
            this.colocatedWithRegion.getColocatedByList().remove(this);
        }
        RegionLogger.logDestroy(this.getName(), this.cache.getInternalDistributedSystem().getDistributedMember(), null, op.isClose());
    }

    private boolean checkIfAlreadyDestroyedOrOldReference() {
        PartitionRegionConfig prConfig = null;
        try {
            prConfig = this.prRoot.get(this.getRegionIdentifier());
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        boolean isAlreadyDestroyedOrOldReference = false;
        if (null == prConfig) {
            isAlreadyDestroyedOrOldReference = true;
        } else if (prConfig.getPRId() != this.partitionedRegionId) {
            isAlreadyDestroyedOrOldReference = true;
        }
        return isAlreadyDestroyedOrOldReference;
    }

    @Override
    public void dispatchListenerEvent(EnumListenerEvent op, InternalCacheEvent event) {
        if (this.hasListener()) {
            EntryEventImpl ev;
            if (event.getOperation().isEntry() && !(ev = (EntryEventImpl)event).getInvokePRCallbacks() && this.getSubscriptionAttributes().getInterestPolicy() == InterestPolicy.CACHE_CONTENT) {
                if (logger.isTraceEnabled(LogMarker.DM_BRIDGE_SERVER_VERBOSE)) {
                    logger.trace(LogMarker.DM_BRIDGE_SERVER_VERBOSE, "not dispatching PR event in this member as there is no interest in it");
                }
                return;
            }
            super.dispatchListenerEvent(op, event);
        }
    }

    @Override
    protected void generateLocalFilterRouting(InternalCacheEvent event) {
        if (event.getLocalFilterInfo() == null) {
            super.generateLocalFilterRouting(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheWriteBeforePut(EntryEventImpl event, Set netWriteRecipients, CacheWriter localWriter, boolean requireOldValue, Object expectedOldValue) throws CacheWriterException, TimeoutException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (event.inhibitAllNotifications()) {
            if (isDebugEnabled) {
                logger.debug("Notification inhibited for key {}", event.getKey());
            }
            return;
        }
        boolean isNewKey = event.getOperation().isCreate();
        this.serverPut(event, requireOldValue, expectedOldValue);
        if (localWriter == null && (netWriteRecipients == null || netWriteRecipients.isEmpty())) {
            if (isDebugEnabled) {
                logger.debug("cacheWriteBeforePut: beforePut empty set returned by advisor.adviseNetWrite in netWrite");
            }
            return;
        }
        long start = this.getCachePerfStats().startCacheWriterCall();
        try {
            SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
            processor.initialize(this, "preUpdate", null);
            try {
                if (!isNewKey) {
                    if (isDebugEnabled) {
                        logger.debug("cacheWriteBeforePut: doNetWrite(BEFOREUPDATE)");
                    }
                    processor.doNetWrite(event, netWriteRecipients, localWriter, 2);
                } else {
                    if (isDebugEnabled) {
                        logger.debug("cacheWriteBeforePut: doNetWrite(BEFORECREATE)");
                    }
                    processor.doNetWrite(event, netWriteRecipients, localWriter, 0);
                }
            }
            finally {
                processor.release();
            }
        }
        finally {
            this.getCachePerfStats().endCacheWriterCall(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cacheWriteBeforeDestroy(EntryEventImpl event, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        if (event.inhibitAllNotifications()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notification inhibited for key {}", event.getKey());
            }
            return false;
        }
        if (event.isDistributed()) {
            Set netWriteRecipients;
            this.serverDestroy(event, expectedOldValue);
            CacheWriter localWriter = this.basicGetWriter();
            Set set = netWriteRecipients = localWriter == null ? this.distAdvisor.adviseNetWrite() : null;
            if (localWriter == null && (netWriteRecipients == null || netWriteRecipients.isEmpty())) {
                return false;
            }
            long start = this.getCachePerfStats().startCacheWriterCall();
            try {
                event.setOldValueFromRegion();
                SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
                processor.initialize(this, event.getKey(), null);
                processor.doNetWrite(event, netWriteRecipients, localWriter, 1);
                processor.release();
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
            return true;
        }
        return false;
    }

    public void dumpAllBuckets(boolean distribute) throws ReplyException {
        if (logger.isDebugEnabled()) {
            logger.debug("[dumpAllBuckets] distribute={} {}", (Object)distribute, (Object)this);
        }
        this.getRegionAdvisor().dumpProfiles("dumpAllBuckets");
        if (distribute) {
            PartitionMessage.PartitionResponse response = DumpBucketsMessage.send(this.getRegionAdvisor().adviseAllPRNodes(), this, false, false);
            response.waitForRepliesUninterruptibly();
        }
        if (this.dataStore != null) {
            this.dataStore.dumpEntries(false);
        }
    }

    @Override
    public void dumpBackingMap() {
        this.dumpAllBuckets(true);
    }

    public void validateAllBuckets() throws ReplyException {
        PartitionMessage.PartitionResponse response = DumpBucketsMessage.send(this.getRegionAdvisor().adviseAllPRNodes(), this, true, false);
        response.waitForRepliesUninterruptibly();
        if (this.dataStore != null) {
            this.dataStore.dumpEntries(true);
        }
    }

    public void sendDumpB2NRegionForBucket(int bucketId) {
        block6: {
            this.getRegionAdvisor().dumpProfiles("dumpB2NForBucket");
            try {
                DumpB2NRegion.DumpB2NResponse response = DumpB2NRegion.send(this.getRegionAdvisor().adviseAllPRNodes(), this, bucketId, false);
                response.waitForRepliesUninterruptibly();
                this.dumpB2NForBucket(bucketId);
            }
            catch (ReplyException re) {
                if (logger.isDebugEnabled()) {
                    logger.debug("sendDumpB2NRegionForBucket got ReplyException", (Throwable)re);
                }
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("sendDumpB2NRegionForBucket got CacheClosedException", (Throwable)e);
                }
            }
            catch (RegionDestroyedException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("sendDumpB2RegionForBucket got RegionDestroyedException", (Throwable)e);
            }
        }
    }

    public void dumpB2NForBucket(int bId) {
        this.getRegionAdvisor().getBucket(bId).getBucketAdvisor().dumpProfiles("Dumping advisor bucket meta-data for bId=" + this.bucketStringForLogs(bId) + " aka " + this.getBucketName(bId));
    }

    public void sendDumpAllPartitionedRegions() throws ReplyException {
        this.getRegionAdvisor().dumpProfiles("dumpAllPartitionedRegions");
        PartitionMessage.PartitionResponse response = DumpAllPRConfigMessage.send(this.getRegionAdvisor().adviseAllPRNodes(), this);
        response.waitForRepliesUninterruptibly();
        this.dumpSelfEntryFromAllPartitionedRegions();
    }

    public void dumpSelfEntryFromAllPartitionedRegions() {
        StringBuilder sb = new StringBuilder(this.prRoot.getFullPath());
        sb.append("Dumping allPartitionedRegions for ");
        sb.append(this);
        sb.append("\n");
        sb.append(this.prRoot.get(this.getRegionIdentifier()));
        logger.debug(sb.toString());
    }

    public List getLocalBucketsListTestOnly() {
        List localBucketList = null;
        if (this.dataStore != null) {
            localBucketList = this.dataStore.getLocalBucketsListTestOnly();
        }
        return localBucketList;
    }

    public List getLocalPrimaryBucketsListTestOnly() {
        List localPrimaryList = null;
        if (this.dataStore != null) {
            localPrimaryList = this.dataStore.getLocalPrimaryBucketsListTestOnly();
        }
        return localPrimaryList;
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return (DistributionAdvisee)((Object)this.basicGetParentRegion());
    }

    public String getBucketName(int bucketId) {
        return PartitionedRegionHelper.getBucketName(this.getFullPath(), bucketId);
    }

    public boolean isDataStore() {
        return this.localMaxMemory > 0;
    }

    @Override
    protected void enableConcurrencyChecks() {
        if (this.supportsConcurrencyChecks()) {
            this.setConcurrencyChecksEnabled(true);
            assert (!this.isDataStore());
        }
    }

    public void getKeysWithRegEx(String regex, boolean allowTombstones, SetCollector collector) throws IOException {
        this._getKeysWithInterest(1, regex, allowTombstones, collector);
    }

    public void getKeysWithList(List keyList, boolean allowTombstones, SetCollector collector) throws IOException {
        this._getKeysWithInterest(0, keyList, allowTombstones, collector);
    }

    private void _getKeysWithInterest(int interestType2, Object interestArg, boolean allowTombstones, SetCollector collector) throws IOException {
        int totalBuckets = this.getTotalNumberOfBuckets();
        int retryAttempts = this.calcRetry();
        for (int bucket = 0; bucket < totalBuckets; ++bucket) {
            Set bucketSet = null;
            Integer lbucket = bucket;
            RetryTimeKeeper retryTime = new RetryTimeKeeper(Integer.MAX_VALUE);
            InternalDistributedMember bucketNode = this.getOrCreateNodeForBucketRead(lbucket);
            for (int count = 0; count <= retryAttempts; ++count) {
                if (logger.isDebugEnabled()) {
                    logger.debug("_getKeysWithInterest bucketId={} attempt={}", (Object)bucket, (Object)(count + 1));
                }
                try {
                    if (bucketNode == null) break;
                    if (bucketNode.equals(this.getMyId())) {
                        bucketSet = this.dataStore.handleRemoteGetKeys(lbucket, interestType2, interestArg, allowTombstones);
                        break;
                    }
                    FetchKeysMessage.FetchKeysResponse r = FetchKeysMessage.sendInterestQuery(bucketNode, this, lbucket, interestType2, interestArg, allowTombstones);
                    bucketSet = r.waitForKeys();
                    break;
                }
                catch (PRLocallyDestroyedException ignore) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("_getKeysWithInterest: Encountered PRLocallyDestroyedException");
                    }
                    this.checkReadiness();
                    continue;
                }
                catch (ForceReattemptException prce) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("_getKeysWithInterest: retry attempt: {}", (Object)count, (Object)prce);
                    }
                    this.checkReadiness();
                    InternalDistributedMember lastTarget = bucketNode;
                    bucketNode = this.getOrCreateNodeForBucketRead(lbucket);
                    if (lastTarget == null || !lastTarget.equals(bucketNode)) continue;
                    if (retryTime.overMaximum()) break;
                    retryTime.waitToRetryNode();
                }
            }
            if (bucketSet == null) continue;
            collector.receiveSet(bucketSet);
        }
    }

    @Override
    public boolean generateEventID() {
        return true;
    }

    @Override
    public boolean shouldNotifyBridgeClients() {
        return true;
    }

    public boolean isIndexed() {
        return this.hasPartitionedIndex;
    }

    public Map getIndex() {
        Hashtable availableIndexes = new Hashtable();
        for (Object ind : this.indexes.values()) {
            if (!(ind instanceof Index)) continue;
            availableIndexes.put(((Index)ind).getName(), ind);
        }
        return availableIndexes;
    }

    public PartitionedIndex getIndex(String indexName) {
        for (Object ind : this.indexes.values()) {
            if (!(ind instanceof PartitionedIndex) || !((Index)ind).getName().equals(indexName)) continue;
            return (PartitionedIndex)ind;
        }
        return null;
    }

    public Collection getIndexes() {
        if (this.indexes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList idxs = new ArrayList();
        for (Object ind : this.indexes.values()) {
            if (!(ind instanceof Index)) continue;
            idxs.add(ind);
        }
        return idxs;
    }

    public Index createIndex(boolean remotelyOriginated, IndexType indexType, String indexName, String indexedExpression, String fromClause, String imports, boolean loadEntries) throws ForceReattemptException, IndexCreationException, IndexNameConflictException, IndexExistsException {
        return this.createIndex(remotelyOriginated, indexType, indexName, indexedExpression, fromClause, imports, loadEntries, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index createIndex(boolean remotelyOriginated, IndexType indexType, String indexName, String indexedExpression, String fromClause, String imports, boolean loadEntries, boolean sendMessage) throws ForceReattemptException, IndexCreationException, IndexNameConflictException, IndexExistsException {
        Index index;
        block25: {
            FutureTask<Index> indexFutureTask;
            IndexTask indexTask;
            FutureTask<Index> ind;
            if (remotelyOriginated && this.dataStore == null) {
                if (this.getLocalMaxMemory() != 0) {
                    throw new IndexCreationException(LocalizedStrings.PartitionedRegion_DATA_STORE_ON_THIS_VM_IS_NULL_AND_THE_LOCAL_MAX_MEMORY_IS_NOT_ZERO_THE_DATA_POLICY_IS_0_AND_THE_LOCALMAXMEMEORY_IS_1.toLocalizedString(this.getDataPolicy(), this.getLocalMaxMemory()));
                }
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_THIS_IS_AN_ACCESSOR_VM_AND_DOESNT_CONTAIN_DATA));
                return null;
            }
            if (this.indexManager == null) {
                this.indexManager = IndexUtils.getIndexManager(this.cache, this, true);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Started creating index with Index Name :{} On PartitionedRegion {}, Indexfrom caluse={}, Remote Request: {}", (Object)indexName, (Object)this.getFullPath(), (Object)fromClause, (Object)remotelyOriginated);
            }
            if ((ind = this.indexes.putIfAbsent(indexTask = new IndexTask(remotelyOriginated, indexType, indexName, indexedExpression, fromClause, imports, loadEntries), indexFutureTask = new FutureTask<Index>(indexTask))) instanceof Index) {
                if (remotelyOriginated) {
                    return (Index)((Object)ind);
                }
                throw new IndexNameConflictException(LocalizedStrings.IndexManager_INDEX_NAMED_0_ALREADY_EXISTS.toLocalizedString(indexName));
            }
            FutureTask<Index> oldIndexFutureTask = ind;
            index = null;
            boolean interrupted = false;
            try {
                if (oldIndexFutureTask == null) {
                    indexFutureTask.run();
                    index = indexFutureTask.get();
                    if (index == null) break block25;
                    this.indexes.put(indexTask, index);
                    PartitionedIndex prIndex = (PartitionedIndex)index;
                    this.indexManager.addIndex(indexName, index);
                    if (remotelyOriginated || !sendMessage) break block25;
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_CREATED_INDEX_LOCALLY_SENDING_INDEX_CREATION_MESSAGE_TO_ALL_MEMBERS_AND_WILL_BE_WAITING_FOR_RESPONSE_0, prIndex));
                    HashSet<IndexCreationData> singleIndexDefinition = new HashSet<IndexCreationData>();
                    IndexCreationData icd = new IndexCreationData(indexName);
                    icd.setIndexData(indexType, fromClause, indexedExpression, imports, loadEntries);
                    singleIndexDefinition.add(icd);
                    IndexCreationMsg.IndexCreationResponse response = null;
                    try {
                        IndexCreationMsg.IndexCreationResult result;
                        Map<String, Integer> indexBucketsMap;
                        response = (IndexCreationMsg.IndexCreationResponse)IndexCreationMsg.send(null, this, singleIndexDefinition);
                        if (response != null && (indexBucketsMap = (result = response.waitForResult()).getIndexBucketsMap()) != null && indexBucketsMap.size() > 0) {
                            prIndex.setRemoteBucketesIndexed(indexBucketsMap.values().iterator().next());
                        }
                        break block25;
                    }
                    catch (UnsupportedOperationException ignore) {
                        this.indexes.remove(index);
                        this.indexManager.removeIndex(index);
                        throw new IndexCreationException(LocalizedStrings.PartitionedRegion_INDEX_CREATION_FAILED_ROLLING_UPGRADE.toLocalizedString());
                    }
                }
                index = oldIndexFutureTask.get();
                if (remotelyOriginated) {
                    Index prIndex = index;
                    return prIndex;
                }
                throw new IndexNameConflictException(LocalizedStrings.IndexManager_INDEX_NAMED_0_ALREADY_EXISTS.toLocalizedString(indexName));
            }
            catch (InterruptedException ignore) {
                interrupted = true;
            }
            catch (ExecutionException ee) {
                if (!remotelyOriginated) {
                    Throwable cause = ee.getCause();
                    if (cause instanceof IndexNameConflictException) {
                        throw (IndexNameConflictException)cause;
                    }
                    if (cause instanceof IndexExistsException) {
                        throw (IndexExistsException)cause;
                    }
                    throw new IndexInvalidException(ee);
                }
            }
            finally {
                if (index == null && (ind = this.indexes.get(indexTask)) != null && !(ind instanceof Index)) {
                    this.indexes.remove(indexTask);
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Completed creating index with Index Name :{} On PartitionedRegion {}, Remote Request: {}", (Object)indexName, (Object)this.getFullPath(), (Object)remotelyOriginated);
        }
        return index;
    }

    public List<Index> createIndexes(boolean remotelyOriginated, HashSet<IndexCreationData> indexDefinitions) throws MultiIndexCreationException, CacheException, ForceReattemptException, IndexCreationException {
        if (remotelyOriginated && this.dataStore == null) {
            if (this.getLocalMaxMemory() != 0) {
                throw new IndexCreationException(LocalizedStrings.PartitionedRegion_DATA_STORE_ON_THIS_VM_IS_NULL_AND_THE_LOCAL_MAX_MEMORY_IS_NOT_ZERO_THE_DATA_POLICY_IS_0_AND_THE_LOCALMAXMEMEORY_IS_1.toLocalizedString(this.getDataPolicy(), this.getLocalMaxMemory()));
            }
            logger.info((Object)LocalizedStrings.PartitionedRegion_THIS_IS_AN_ACCESSOR_VM_AND_DOESNT_CONTAIN_DATA);
            return new ArrayList<Index>();
        }
        HashSet<Index> indexes = new HashSet<Index>();
        boolean throwException = false;
        HashMap<String, Exception> exceptionsMap = new HashMap<String, Exception>();
        throwException |= this.createEmptyIndexes(indexDefinitions, remotelyOriginated, indexes, exceptionsMap);
        Set<Index> unpopulatedIndexes = null;
        if (indexes.size() > 0) {
            unpopulatedIndexes = this.getUnpopulatedIndexes(indexes);
        }
        if (unpopulatedIndexes != null && unpopulatedIndexes.size() > 0) {
            throwException |= this.populateEmptyIndexes(unpopulatedIndexes, exceptionsMap);
        }
        if (throwException |= this.sendCreateIndexesMessage(remotelyOriginated, indexDefinitions, indexes, exceptionsMap)) {
            throw new MultiIndexCreationException(exceptionsMap);
        }
        for (Index ind : indexes) {
            ((AbstractIndex)ind).setPopulated(true);
        }
        return new ArrayList<Index>(indexes);
    }

    private boolean createEmptyIndexes(HashSet<IndexCreationData> indexDefinitions, boolean remotelyOriginated, Set<Index> indexes, HashMap<String, Exception> exceptionsMap) {
        boolean throwException = false;
        for (IndexCreationData icd : indexDefinitions) {
            try {
                Index ind = this.createIndex(remotelyOriginated, icd.getIndexType(), icd.getIndexName(), icd.getIndexExpression(), icd.getIndexFromClause(), icd.getIndexImportString(), false, false);
                if (ind == null) continue;
                indexes.add(ind);
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Creation failed for index: {}, {}", (Object)icd.getIndexName(), (Object)ex.getMessage(), (Object)ex);
                }
                exceptionsMap.put(icd.getIndexName(), ex);
                throwException = true;
            }
        }
        return throwException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Index> getUnpopulatedIndexes(Set<Index> indexSet) {
        Object object = this.indexLock;
        synchronized (object) {
            HashSet<Index> unpopulatedIndexes = new HashSet<Index>();
            for (Index ind : indexSet) {
                PartitionedIndex prIndex = (PartitionedIndex)ind;
                if (prIndex.isPopulateInProgress()) continue;
                prIndex.setPopulateInProgress(true);
                unpopulatedIndexes.add(prIndex);
            }
            return unpopulatedIndexes;
        }
    }

    private boolean populateEmptyIndexes(Set<Index> indexes, HashMap<String, Exception> exceptionsMap) {
        boolean throwException = false;
        if (this.getDataStore() != null && indexes.size() > 0) {
            Set<Map.Entry<Integer, BucketRegion>> localBuckets = this.getDataStore().getAllLocalBuckets();
            for (Map.Entry<Integer, BucketRegion> entry : localBuckets) {
                Region bucket = entry.getValue();
                if (bucket == null) continue;
                IndexManager bucketIndexManager = IndexUtils.getIndexManager(this.cache, bucket, true);
                Set<Index> bucketIndexes = this.getBucketIndexesForPRIndexes(bucket, indexes);
                try {
                    bucketIndexManager.populateIndexes(bucketIndexes);
                }
                catch (MultiIndexCreationException ex) {
                    exceptionsMap.putAll(ex.getExceptionsMap());
                    throwException = true;
                }
            }
        }
        return throwException;
    }

    private Set<Index> getBucketIndexesForPRIndexes(Region bucket, Set<Index> indexes) {
        HashSet<Index> bucketIndexes = new HashSet<Index>();
        for (Index ind : indexes) {
            bucketIndexes.addAll(((PartitionedIndex)ind).getBucketIndexes(bucket));
        }
        return bucketIndexes;
    }

    private boolean sendCreateIndexesMessage(boolean remotelyOriginated, HashSet<IndexCreationData> indexDefinitions, Set<Index> indexes, HashMap<String, Exception> exceptionsMap) throws CacheException, ForceReattemptException {
        boolean throwException = false;
        if (!remotelyOriginated) {
            logger.info((Object)LocalizedStrings.PartitionedRegion_CREATED_INDEX_LOCALLY_SENDING_INDEX_CREATION_MESSAGE_TO_ALL_MEMBERS_AND_WILL_BE_WAITING_FOR_RESPONSE_0);
            try {
                IndexCreationMsg.IndexCreationResult result;
                Map<String, Integer> remoteIndexBucketsMap;
                IndexCreationMsg.IndexCreationResponse response = (IndexCreationMsg.IndexCreationResponse)IndexCreationMsg.send(null, this, indexDefinitions);
                if (response != null && (remoteIndexBucketsMap = (result = response.waitForResult()).getIndexBucketsMap()) != null) {
                    for (Index ind : indexes) {
                        if (!remoteIndexBucketsMap.containsKey(ind.getName())) continue;
                        ((PartitionedIndex)ind).setRemoteBucketesIndexed(remoteIndexBucketsMap.get(ind.getName()));
                    }
                }
            }
            catch (UnsupportedOperationException ignore) {
                for (Index ind : indexes) {
                    exceptionsMap.put(ind.getName(), new IndexCreationException(LocalizedStrings.PartitionedRegion_INDEX_CREATION_FAILED_ROLLING_UPGRADE.toLocalizedString()));
                    this.indexes.remove(ind);
                    this.indexManager.removeIndex(ind);
                }
                throwException = true;
            }
        }
        return throwException;
    }

    public void sendIndexCreationMsg(InternalDistributedMember idM) {
        if (!this.isIndexed()) {
            return;
        }
        RegionAdvisor advisor = (RegionAdvisor)this.getCacheDistributionAdvisor();
        Set<InternalDistributedMember> recipients = advisor.adviseDataStore();
        if (!recipients.contains(idM)) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_NEWLY_ADDED_MEMBER_TO_THE_PR_IS_AN_ACCESSOR_AND_WILL_NOT_RECEIVE_INDEX_INFORMATION_0, idM));
            return;
        }
        if (this.indexes.isEmpty()) {
            return;
        }
        Iterator it = this.indexes.values().iterator();
        HashSet<IndexCreationData> indexDefinitions = new HashSet<IndexCreationData>();
        HashSet<PartitionedIndex> indexes = new HashSet<PartitionedIndex>();
        while (it.hasNext()) {
            Object ind = it.next();
            if (!(ind instanceof Index)) continue;
            PartitionedIndex prIndex = (PartitionedIndex)ind;
            indexes.add(prIndex);
            IndexCreationData indexCreationData = new IndexCreationData(prIndex.getName());
            indexCreationData.setIndexData(prIndex.getType(), prIndex.getFromClause(), prIndex.getIndexedExpression(), prIndex.getImports(), true);
            indexDefinitions.add(indexCreationData);
        }
        IndexCreationMsg.IndexCreationResponse response = (IndexCreationMsg.IndexCreationResponse)IndexCreationMsg.send(idM, this, indexDefinitions);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending explicitly index creation message to : {}", (Object)idM);
        }
        if (response != null) {
            try {
                IndexCreationMsg.IndexCreationResult result = response.waitForResult();
                Map<String, Integer> remoteIndexBucketsMap = result.getIndexBucketsMap();
                for (Index index : indexes) {
                    ((PartitionedIndex)index).setRemoteBucketesIndexed(remoteIndexBucketsMap.get(index.getName()));
                }
            }
            catch (ForceReattemptException e) {
                logger.info((Object)LocalizedStrings.PartitionedRegion_FORCEREATTEMPT_EXCEPTION___0, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeIndexes(boolean remotelyOriginated) throws CacheException, ForceReattemptException {
        int numBuckets = 0;
        if (!this.hasPartitionedIndex || this.indexes.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("This partitioned regions does not have any index : {}", (Object)this);
            }
            return numBuckets;
        }
        this.hasPartitionedIndex = false;
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_REMOVING_ALL_THE_INDEXES_ON_THIS_PARITITION_REGION__0, this));
        try {
            for (Map.Entry<Integer, BucketRegion> bucketEntryObject : this.dataStore.getAllLocalBuckets()) {
                LocalRegion bucket = null;
                Map.Entry<Integer, BucketRegion> bucketEntry = bucketEntryObject;
                bucket = bucketEntry.getValue();
                if (bucket == null) continue;
                bucket.waitForData();
                IndexManager indexMang = IndexUtils.getIndexManager(this.cache, bucket, false);
                if (indexMang == null) continue;
                indexMang.removeIndexes();
                ++numBuckets;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Removed all the indexes on bucket {}", (Object)bucket);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Removed this many indexes on the buckets : {}", (Object)numBuckets);
            }
            if (!remotelyOriginated) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_SENDING_REMOVEINDEX_MESSAGE_TO_ALL_THE_PARTICIPATING_PRS));
                RemoveIndexesMessage.RemoveIndexesResponse response = (RemoveIndexesMessage.RemoveIndexesResponse)RemoveIndexesMessage.send(this, null, true);
                if (null != response) {
                    response.waitForResults();
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_DONE_WATING_FOR_REMOVE_INDEX));
                    if (logger.isDebugEnabled()) {
                        logger.debug("Total number of buckets which removed indexes , locally : {} and remotely removed : {} and the total number of remote buckets : {}", (Object)numBuckets, (Object)response.getRemoteRemovedIndexes(), (Object)response.getTotalRemoteBuckets());
                    }
                }
            }
            this.indexManager.removeIndexes();
            int n = numBuckets;
            return n;
        }
        finally {
            this.indexes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeIndex(Index ind, boolean remotelyOriginated) throws CacheException, ForceReattemptException {
        PartitionedIndex index;
        Index index1;
        int numBuckets = 0;
        IndexTask indexTask = null;
        Object prIndex = null;
        if (ind != null) {
            indexTask = new IndexTask(ind.getName());
            prIndex = this.indexes.get(indexTask);
        }
        if (prIndex == null || !(prIndex instanceof Index)) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_THIS_INDEX__0_IS_NOT_ON_THIS_PARTITONED_REGION___1, new Object[]{ind, this}));
            return numBuckets;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Remove index called, IndexName: {} Index: {}  Will be removing all the bucket indexes.", (Object)ind.getName(), (Object)ind);
        }
        if ((index1 = this.indexManager.getIndex(ind.getName())) != null) {
            this.indexManager.removeIndex(index1);
        }
        if (prIndex != null) {
            index = prIndex;
            index.acquireIndexWriteLockForRemove();
        }
        this.indexes.remove(indexTask);
        try {
            index = prIndex;
            synchronized (index) {
                List allBucketIndex = ((PartitionedIndex)prIndex).getBucketIndexes();
                Iterator it = allBucketIndex.iterator();
                if (logger.isDebugEnabled()) {
                    logger.debug("Will be removing indexes on : {} buckets", (Object)allBucketIndex.size());
                }
                while (it.hasNext()) {
                    Index in = (Index)it.next();
                    LocalRegion region = (LocalRegion)in.getRegion();
                    region.waitForData();
                    IndexManager indMng = region.getIndexManager();
                    indMng.removeIndex(in);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Removed index : {} on bucket {}", (Object)in, (Object)region);
                    }
                    ++numBuckets;
                    ((PartitionedIndex)prIndex).removeFromBucketIndexes(region, in);
                }
            }
        }
        finally {
            ((PartitionedIndex)prIndex).releaseIndexWriteLockForRemove();
        }
        if (!remotelyOriginated) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_SENDING_REMOVEINDEX_MESSAGE_TO_ALL_THE_PARTICIPATING_PRS));
            RemoveIndexesMessage.RemoveIndexesResponse response = (RemoveIndexesMessage.RemoveIndexesResponse)RemoveIndexesMessage.send(this, ind, false);
            if (response != null) {
                response.waitForResults();
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_DONE_WATING_FOR_REMOVE_INDEX));
                if (logger.isDebugEnabled()) {
                    logger.debug("Total number of buckets which removed indexs , locally : {} and remotely removed : {} and the total number of remote buckets : {}", (Object)numBuckets, (Object)response.getRemoteRemovedIndexes(), (Object)response.getTotalRemoteBuckets());
                }
            }
        }
        return numBuckets;
    }

    public int removeIndex(String indexName) throws CacheException, ForceReattemptException {
        int numBuckets = 0;
        Object ind = this.indexes.get(indexName);
        if (ind instanceof Index) {
            numBuckets = this.removeIndex((Index)this.indexes.get(indexName), true);
        }
        return numBuckets;
    }

    @Override
    public Object getValueInVM(Object key) throws EntryNotFoundException {
        if (this.dataStore == null) {
            throw new EntryNotFoundException(key.toString());
        }
        int bucketId = PartitionedRegionHelper.getHashKey(this, null, key, null, null);
        return this.dataStore.getLocalValueInVM(key, bucketId);
    }

    @Override
    public Object getValueInVM(EntryEventImpl event) throws EntryNotFoundException {
        if (this.dataStore == null) {
            throw new EntryNotFoundException(event.getKey().toString());
        }
        int bucketId = PartitionedRegionHelper.getHashKey(event);
        return this.dataStore.getLocalValueInVM(event.getKey(), bucketId);
    }

    @Override
    public Object getValueOnDisk(Object key) throws EntryNotFoundException {
        int bucketId = PartitionedRegionHelper.getHashKey(this, null, key, null, null);
        if (this.dataStore == null) {
            throw new EntryNotFoundException(key.toString());
        }
        return this.dataStore.getLocalValueOnDisk(key, bucketId);
    }

    @Override
    public Object getValueOnDiskOrBuffer(Object key) throws EntryNotFoundException {
        int bucketId = PartitionedRegionHelper.getHashKey(this, null, key, null, null);
        if (this.dataStore == null) {
            throw new EntryNotFoundException(key.toString());
        }
        return this.dataStore.getLocalValueOnDiskOrBuffer(key, bucketId);
    }

    public List getBucketOwnersForValidation(int bucketId) throws ForceReattemptException {
        TimeoutException rte = null;
        LinkedList<Object[]> remoteInfos = null;
        for (int i = 0; i < 3; ++i) {
            rte = null;
            DumpB2NRegion.DumpB2NResponse response = DumpB2NRegion.send(this.getRegionAdvisor().adviseDataStore(), this, bucketId, true);
            try {
                remoteInfos = new LinkedList<Object[]>(response.waitForPrimaryInfos());
                continue;
            }
            catch (TimeoutException e) {
                rte = e;
                logger.info("DumpB2NRegion failed to get PR {}, bucket id {}'s info due to {}, retrying...", (Object)this.getFullPath(), (Object)bucketId, (Object)e.getMessage());
            }
        }
        if (rte != null) {
            logger.info("DumpB2NRegion retried 3 times", rte);
            throw rte;
        }
        if (this.getRegionAdvisor().getBucket(bucketId).isHosting()) {
            if (this.getRegionAdvisor().isPrimaryForBucket(bucketId)) {
                remoteInfos.add(new Object[]{this.getSystem().getDM().getId(), Boolean.TRUE, ""});
            } else {
                remoteInfos.add(new Object[]{this.getSystem().getDM().getId(), Boolean.FALSE, ""});
            }
        }
        return remoteInfos;
    }

    public InternalDistributedMember getBucketPrimary(int bucketId) {
        return this.getRegionAdvisor().getPrimaryMemberForBucket(bucketId);
    }

    public void waitOnBucketMetadataInitialization() {
        this.waitOnInitialization(this.initializationLatchAfterBucketIntialization);
    }

    private void releaseAfterBucketMetadataSetupLatch() {
        this.initializationLatchAfterBucketIntialization.countDown();
    }

    @Override
    protected void releaseLatches() {
        super.releaseLatches();
        this.releaseAfterBucketMetadataSetupLatch();
    }

    public int getRetryTimeout() {
        return this.retryTimeout;
    }

    public long getBirthTime() {
        return this.birthTime;
    }

    public PartitionResolver getPartitionResolver() {
        return this.partitionAttributes.getPartitionResolver();
    }

    public String getColocatedWith() {
        return this.partitionAttributes.getColocatedWith();
    }

    @Override
    protected RegionEntry basicGetTXEntry(KeyInfo keyInfo) {
        InternalDistributedMember primary;
        int bucketId = keyInfo.getBucketId();
        if (bucketId == -1) {
            bucketId = PartitionedRegionHelper.getHashKey(this, null, keyInfo.getKey(), keyInfo.getValue(), keyInfo.getCallbackArg());
            keyInfo.setBucketId(bucketId);
        }
        if (keyInfo.isCheckPrimary() && !((Object)(primary = this.getRegionAdvisor().getPrimaryMemberForBucket(bucketId))).equals(this.getMyId())) {
            throw new PrimaryBucketException("Bucket " + bucketId + " is not primary. Current primary holder is " + primary);
        }
        BucketRegion br = this.dataStore.getLocalBucketById(bucketId);
        RegionEntry re = br.basicGetEntry(keyInfo.getKey());
        if (re != null && re.isRemoved()) {
            re = null;
        }
        return re;
    }

    @Override
    protected boolean usesDiskStore(RegionAttributes regionAttributes) {
        if (regionAttributes.getPartitionAttributes().getLocalMaxMemory() <= 0) {
            return false;
        }
        return super.usesDiskStore(regionAttributes);
    }

    @Override
    protected DiskStoreImpl findDiskStore(RegionAttributes regionAttributes, InternalRegionArguments internalRegionArgs) {
        DiskStoreImpl store = super.findDiskStore(regionAttributes, internalRegionArgs);
        if (store != null && store.getOwnedByRegion()) {
            store.initializeIfNeeded();
        }
        return store;
    }

    @Override
    protected DiskRegion createDiskRegion(InternalRegionArguments internalRegionArgs) throws DiskAccessException {
        if (internalRegionArgs.getDiskRegion() != null) {
            return internalRegionArgs.getDiskRegion();
        }
        return null;
    }

    @Override
    public void handleInterestEvent(InterestRegistrationEvent event) {
        block11: {
            InterestEventMessage.InterestEventResponse response;
            Set<InternalDistributedMember> allRemoteStores;
            block10: {
                if (logger.isDebugEnabled()) {
                    logger.debug("PartitionedRegion {} handling {}", (Object)this.getFullPath(), (Object)event);
                }
                allRemoteStores = this.getRegionAdvisor().adviseDataStore(true);
                if (logger.isDebugEnabled()) {
                    logger.debug("PartitionedRegion {} sending InterestEvent message to:{}", (Object)this.getFullPath(), allRemoteStores);
                }
                response = null;
                if (!allRemoteStores.isEmpty()) {
                    try {
                        response = InterestEventMessage.send(allRemoteStores, this, event);
                    }
                    catch (ForceReattemptException e) {
                        if (!logger.isDebugEnabled()) break block10;
                        logger.debug("PartitionedRegion {} caught exception", (Object)this.getFullPath(), (Object)e);
                    }
                }
            }
            if (this.dataStore != null) {
                this.dataStore.handleInterestEvent(event);
            }
            if (response != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("PartitionedRegion {} waiting for response from {}", (Object)this.getFullPath(), allRemoteStores);
                    }
                    response.waitForResponse();
                }
                catch (ForceReattemptException e) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug("PartitionedRegion {} caught exception", (Object)this.getFullPath(), (Object)e);
                }
            }
        }
    }

    @Override
    public AttributesMutator getAttributesMutator() {
        this.checkReadiness();
        return this;
    }

    @Override
    public ExpirationAttributes setRegionTimeToLive(ExpirationAttributes timeToLive) {
        ExpirationAttributes attr = super.setRegionTimeToLive(timeToLive);
        if (this.getDataStore() != null) {
            Iterator<Map.Entry<Integer, BucketRegion>> iterator = this.getDataStore().getAllLocalBuckets().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, BucketRegion> o;
                Map.Entry<Integer, BucketRegion> entry = o = iterator.next();
                Region bucketRegion = entry.getValue();
                bucketRegion.getAttributesMutator().setRegionTimeToLive(timeToLive);
            }
        }
        return attr;
    }

    @Override
    public ExpirationAttributes setRegionIdleTimeout(ExpirationAttributes idleTimeout) {
        ExpirationAttributes attr = super.setRegionIdleTimeout(idleTimeout);
        if (this.getDataStore() != null) {
            Iterator<Map.Entry<Integer, BucketRegion>> iterator = this.getDataStore().getAllLocalBuckets().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, BucketRegion> o;
                Map.Entry<Integer, BucketRegion> entry = o = iterator.next();
                Region bucketRegion = entry.getValue();
                bucketRegion.getAttributesMutator().setRegionIdleTimeout(idleTimeout);
            }
        }
        return attr;
    }

    @Override
    public ExpirationAttributes setEntryTimeToLive(ExpirationAttributes timeToLive) {
        ExpirationAttributes attr = super.setEntryTimeToLive(timeToLive);
        PartitionRegionHelper.assignBucketsToPartitions(this);
        this.dataStore.lockBucketCreationAndVisit((bucketId, r) -> r.getAttributesMutator().setEntryTimeToLive(timeToLive));
        this.updatePRConfig(this.getPRConfigWithLatestExpirationAttributes(), false);
        return attr;
    }

    private PartitionRegionConfig getPRConfigWithLatestExpirationAttributes() {
        PartitionRegionConfig prConfig = this.prRoot.get(this.getRegionIdentifier());
        return new PartitionRegionConfig(prConfig.getPRId(), prConfig.getFullPath(), prConfig.getPartitionAttrs(), prConfig.getScope(), prConfig.getEvictionAttributes(), this.getRegionIdleTimeout(), this.getRegionTimeToLive(), this.getEntryIdleTimeout(), this.getEntryTimeToLive(), prConfig.getGatewaySenderIds());
    }

    @Override
    public CustomExpiry setCustomEntryTimeToLive(CustomExpiry custom) {
        CustomExpiry expiry = super.setCustomEntryTimeToLive(custom);
        this.dataStore.lockBucketCreationAndVisit((bucketId, r) -> r.getAttributesMutator().setCustomEntryTimeToLive(custom));
        return expiry;
    }

    @Override
    public ExpirationAttributes setEntryIdleTimeout(ExpirationAttributes idleTimeout) {
        ExpirationAttributes attr = super.setEntryIdleTimeout(idleTimeout);
        PartitionRegionHelper.assignBucketsToPartitions(this);
        this.dataStore.lockBucketCreationAndVisit((bucketId, r) -> r.getAttributesMutator().setEntryIdleTimeout(idleTimeout));
        this.updatePRConfig(this.getPRConfigWithLatestExpirationAttributes(), false);
        return attr;
    }

    @Override
    public CustomExpiry setCustomEntryIdleTimeout(CustomExpiry custom) {
        CustomExpiry expiry = super.setCustomEntryIdleTimeout(custom);
        this.dataStore.lockBucketCreationAndVisit((bucketId, r) -> r.getAttributesMutator().setCustomEntryIdleTimeout(custom));
        return expiry;
    }

    @Override
    protected void setMemoryThresholdFlag(MemoryEvent event) {
        if (event.getState().isCritical() && !event.getPreviousState().isCritical() && (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY || event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY && this.getOffHeap())) {
            this.getRegionAdvisor().markBucketsOnMember(event.getMember(), true);
        } else if (!event.getState().isCritical() && event.getPreviousState().isCritical() && (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY || event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY && this.getOffHeap())) {
            this.getRegionAdvisor().markBucketsOnMember(event.getMember(), false);
        }
    }

    @Override
    public void initialCriticalMembers(boolean localMemoryIsCritical, Set<InternalDistributedMember> criticalMembers) {
        for (InternalDistributedMember idm : criticalMembers) {
            this.getRegionAdvisor().markBucketsOnMember(idm, true);
        }
    }

    public DiskRegionStats getDiskRegionStats() {
        return this.diskRegionStats;
    }

    @Override
    public void removeCriticalMember(DistributedMember member) {
        if (logger.isDebugEnabled()) {
            logger.debug("PR: removing member {} from critical member list", (Object)member);
        }
        this.getRegionAdvisor().markBucketsOnMember(member, false);
    }

    public PartitionedRegion getColocatedWithRegion() {
        return this.colocatedWithRegion;
    }

    public List<BucketRegion> getSortedBuckets() {
        if (!this.bucketSorterStarted.get()) {
            this.bucketSorterStarted.set(true);
            this.bucketSorter.scheduleAtFixedRate(new BucketSorterThread(), 0L, HeapEvictor.BUCKET_SORTING_INTERVAL, TimeUnit.MILLISECONDS);
            if (logger.isDebugEnabled()) {
                logger.debug("Started BucketSorter to sort the buckets according to numver of entries in each bucket for every {} milliseconds", (Object)HeapEvictor.BUCKET_SORTING_INTERVAL);
            }
        }
        ArrayList<BucketRegion> bucketList = new ArrayList<BucketRegion>();
        if (!this.bucketSortedOnce.get()) {
            while (!this.bucketSortedOnce.get()) {
            }
        }
        bucketList.addAll(this.sortedBuckets);
        return bucketList;
    }

    @Override
    public LocalRegion getDataRegionForRead(KeyInfo keyInfo) {
        BucketRegion br;
        block7: {
            Object entryKey = keyInfo.getKey();
            try {
                PartitionedRegionDataStore ds = this.getDataStore();
                if (ds == null) {
                    throw new TransactionException(LocalizedStrings.PartitionedRegion_TX_ON_DATASTORE.toLocalizedString());
                }
                int bucketId = keyInfo.getBucketId();
                if (bucketId == -1) {
                    bucketId = PartitionedRegionHelper.getHashKey(this, null, entryKey, keyInfo.getValue(), keyInfo.getCallbackArg());
                    keyInfo.setBucketId(bucketId);
                }
                br = ds.getInitializedBucketWithKnownPrimaryForId(null, bucketId);
                if (!keyInfo.isCheckPrimary()) break block7;
                try {
                    br.checkForPrimary();
                }
                catch (PrimaryBucketException pbe) {
                    throw new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString(), pbe);
                }
            }
            catch (RegionDestroyedException ignore) {
                throw new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_KEY_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(entryKey));
            }
            catch (ForceReattemptException ignore) {
                br = null;
            }
        }
        return br;
    }

    @Override
    public LocalRegion getDataRegionForWrite(KeyInfo keyInfo) {
        BucketRegion br = null;
        Object entryKey = keyInfo.getKey();
        try {
            int retryAttempts = this.calcRetry();
            int bucketId = keyInfo.getBucketId();
            if (bucketId == -1) {
                bucketId = PartitionedRegionHelper.getHashKey(this, null, entryKey, keyInfo.getValue(), keyInfo.getCallbackArg());
                keyInfo.setBucketId(bucketId);
            }
            for (int count = 0; count <= retryAttempts; ++count) {
                try {
                    PartitionedRegionDataStore ds = this.getDataStore();
                    if (ds == null) {
                        throw new TransactionException(LocalizedStrings.PartitionedRegion_TX_ON_DATASTORE.toLocalizedString());
                    }
                    br = ds.getInitializedBucketWithKnownPrimaryForId(entryKey, bucketId);
                    break;
                }
                catch (ForceReattemptException ignore) {
                    InternalDistributedMember member = this.createBucket(bucketId, 0, null);
                    if (this.getMyId().equals(member) || !keyInfo.isCheckPrimary()) continue;
                    throw new PrimaryBucketException("Bucket " + bucketId + " is not primary. Current primary holder is " + member);
                }
            }
            Assert.assertTrue(br != null, "Could not create storage for Entry");
            if (keyInfo.isCheckPrimary()) {
                br.checkForPrimary();
            }
        }
        catch (PrimaryBucketException pbe) {
            throw new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString(), pbe);
        }
        catch (RegionDestroyedException ignore) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_KEY_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(entryKey));
        }
        return br;
    }

    @Override
    protected InternalDataView buildDataView() {
        return new PartitionedRegionDataView();
    }

    @Override
    public DistributedMember getOwnerForKey(KeyInfo key) {
        if (key == null) {
            return super.getOwnerForKey(null);
        }
        int bucketId = key.getBucketId();
        if (bucketId == -1) {
            bucketId = PartitionedRegionHelper.getHashKey(this, null, key.getKey(), key.getValue(), key.getCallbackArg());
            key.setBucketId(bucketId);
        }
        return this.createBucket(bucketId, 0, null);
    }

    @Override
    public KeyInfo getKeyInfo(Object key) {
        return this.getKeyInfo(key, null);
    }

    @Override
    public KeyInfo getKeyInfo(Object key, Object callbackArg) {
        return this.getKeyInfo(key, null, callbackArg);
    }

    @Override
    public KeyInfo getKeyInfo(Object key, Object value, Object callbackArg) {
        int bucketId = key == null ? -1 : PartitionedRegionHelper.getHashKey(this, null, key, value, callbackArg);
        return new KeyInfo(key, callbackArg, bucketId);
    }

    public List<FixedPartitionAttributesImpl> getFixedPartitionAttributesImpl() {
        return this.fixedPAttrs;
    }

    public List<FixedPartitionAttributesImpl> getPrimaryFixedPartitionAttributes_TestsOnly() {
        LinkedList<FixedPartitionAttributesImpl> primaryFixedPAttrs = new LinkedList<FixedPartitionAttributesImpl>();
        if (this.fixedPAttrs != null) {
            for (FixedPartitionAttributesImpl fpa : this.fixedPAttrs) {
                if (!fpa.isPrimary()) continue;
                primaryFixedPAttrs.add(fpa);
            }
        }
        return primaryFixedPAttrs;
    }

    public List<FixedPartitionAttributesImpl> getSecondaryFixedPartitionAttributes_TestsOnly() {
        LinkedList<FixedPartitionAttributesImpl> secondaryFixedPAttrs = new LinkedList<FixedPartitionAttributesImpl>();
        if (this.fixedPAttrs != null) {
            for (FixedPartitionAttributesImpl fpa : this.fixedPAttrs) {
                if (fpa.isPrimary()) continue;
                secondaryFixedPAttrs.add(fpa);
            }
        }
        return secondaryFixedPAttrs;
    }

    private void calculateStartingBucketIDs(PartitionRegionConfig prConfig) {
        if (BEFORE_CALCULATE_STARTING_BUCKET_FLAG) {
            PartitionedRegionObserver pro = PartitionedRegionObserverHolder.getInstance();
            pro.beforeCalculatingStartingBucketId();
        }
        List<FixedPartitionAttributesImpl> fpaList = this.getFixedPartitionAttributesImpl();
        if (this.getColocatedWith() == null) {
            Set<FixedPartitionAttributesImpl> elderFPAs = prConfig.getElderFPAs();
            int startingBucketID = 0;
            if (elderFPAs != null && !elderFPAs.isEmpty()) {
                int largestStartBucId = -1;
                for (FixedPartitionAttributesImpl fpa : elderFPAs) {
                    if (fpa.getStartingBucketID() <= largestStartBucId) continue;
                    largestStartBucId = fpa.getStartingBucketID();
                    startingBucketID = largestStartBucId + fpa.getNumBuckets();
                }
            }
            for (FixedPartitionAttributesImpl fpaImpl : fpaList) {
                if (elderFPAs != null && elderFPAs.contains(fpaImpl)) {
                    for (FixedPartitionAttributesImpl remotefpa : elderFPAs) {
                        if (!remotefpa.equals(fpaImpl)) continue;
                        fpaImpl.setStartingBucketID(remotefpa.getStartingBucketID());
                    }
                    continue;
                }
                fpaImpl.setStartingBucketID(startingBucketID);
                startingBucketID += fpaImpl.getNumBuckets();
            }
        }
        prConfig.addFPAs(fpaList);
        for (FixedPartitionAttributesImpl fxPrAttr : fpaList) {
            this.partitionsMap.put(fxPrAttr.getPartitionName(), new Integer[]{fxPrAttr.getStartingBucketID(), fxPrAttr.getNumBuckets()});
        }
    }

    public BucketRegion getBucketRegion(Object key) {
        if (this.dataStore == null) {
            return null;
        }
        Integer bucketId = PartitionedRegionHelper.getHashKey(this, null, key, null, null);
        return this.dataStore.getLocalBucketById(bucketId);
    }

    public BucketRegion getBucketRegion(Object key, Object value) {
        if (this.dataStore == null) {
            return null;
        }
        Integer bucketId = PartitionedRegionHelper.getHashKey(this, null, key, value, null);
        return this.dataStore.getLocalBucketById(bucketId);
    }

    public int getPerEntryLRUOverhead() {
        if (this.dataStore == null) {
            return -1;
        }
        try {
            return this.dataStore.getPerEntryLRUOverhead();
        }
        catch (NoSuchElementException ignore) {
            return -1;
        }
    }

    @Override
    protected boolean isEntryIdleExpiryPossible() {
        return false;
    }

    @Override
    public boolean hasSeenEvent(EntryEventImpl ev) {
        if (this.dataStore == null) {
            return false;
        }
        return this.dataStore.hasSeenEvent(ev);
    }

    public void enableConflation(boolean conflation) {
        this.enableConflation = conflation;
    }

    public boolean isConflationEnabled() {
        return this.enableConflation;
    }

    @Override
    public CachePerfStats getRegionPerfStats() {
        PartitionedRegionDataStore ds = this.getDataStore();
        CachePerfStats result = null;
        if (ds != null) {
            result = ds.getCachePerfStats();
        }
        return result;
    }

    public void updateEntryVersionInBucket(EntryEventImpl event) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Integer bucketId = event.getKeyInfo().getBucketId();
        assert (bucketId != -1);
        InternalDistributedMember targetNode = this.getOrCreateNodeForBucketWrite(bucketId, null);
        int retryAttempts = this.calcRetry();
        int count = 0;
        RetryTimeKeeper retryTime = null;
        InternalDistributedMember retryNode = targetNode;
        while (count <= retryAttempts) {
            this.checkShutdown();
            if (retryNode == null) {
                this.checkReadiness();
                if (retryTime == null) {
                    retryTime = new RetryTimeKeeper(this.retryTimeout);
                }
                try {
                    retryNode = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
                }
                catch (TimeoutException ignore) {
                    if (!this.getRegionAdvisor().isStorageAssignedForBucket(bucketId)) break;
                    throw new EntryNotFoundException(LocalizedStrings.PartitionedRegion_ENTRY_NOT_FOUND_FOR_KEY_0.toLocalizedString(event.getKey()));
                }
                if (retryNode != null) continue;
                this.checkEntryNotFound(event.getKey());
                continue;
            }
            boolean isLocal = this.localMaxMemory > 0 && retryNode.equals(this.getMyId());
            try {
                if (isLocal) {
                    this.dataStore.updateEntryVersionLocally(bucketId, event);
                } else {
                    this.updateEntryVersionRemotely(retryNode, bucketId, event);
                }
                return;
            }
            catch (ConcurrentCacheModificationException e) {
                if (isDebugEnabled) {
                    logger.debug("updateEntryVersionInBucket: caught concurrent cache modification exception", (Throwable)e);
                }
                event.isConcurrencyConflict(true);
                if (isDebugEnabled) {
                    logger.debug("ConcurrentCacheModificationException received for updateEntryVersionInBucket for bucketId: {}{}{} for event: {}  No reattampt is done, returning from here", (Object)this.getPRId(), (Object)BUCKET_ID_SEPARATOR, (Object)bucketId, (Object)event);
                }
                return;
            }
            catch (ForceReattemptException prce) {
                prce.checkKey(event.getKey());
                if (isDebugEnabled) {
                    logger.debug("updateEntryVersionInBucket: retry attempt:{} of {}", (Object)count, (Object)retryAttempts, (Object)prce);
                }
                this.checkReadiness();
                InternalDistributedMember lastNode = retryNode;
                retryNode = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
                if (lastNode.equals(retryNode)) {
                    if (retryTime == null) {
                        retryTime = new RetryTimeKeeper(this.retryTimeout);
                    }
                    if (retryTime.overMaximum()) break;
                    retryTime.waitToRetryNode();
                }
            }
            catch (PrimaryBucketException notPrimary) {
                if (isDebugEnabled) {
                    logger.debug("updateEntryVersionInBucket {} on Node {} not primary", (Object)notPrimary.getLocalizedMessage(), (Object)retryNode);
                }
                this.getRegionAdvisor().notPrimary(bucketId, retryNode);
                retryNode = this.getOrCreateNodeForBucketWrite(bucketId, retryTime);
            }
            ++count;
            if (!isDebugEnabled) continue;
            logger.debug("updateEntryVersionInBucket: Attempting to resend update version to node {} after {} failed attempts", (Object)retryNode, (Object)count);
        }
        PartitionedRegionDistributionException e = new PartitionedRegionDistributionException(LocalizedStrings.PartitionedRegion_NO_VM_AVAILABLE_FOR_UPDATE_ENTRY_VERSION_IN_0_ATTEMPTS.toLocalizedString(count));
        if (!isDebugEnabled) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_NO_VM_AVAILABLE_FOR_UPDATE_ENTRY_VERSION_IN_0_ATTEMPTS, count));
        } else {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        throw e;
    }

    private void updateEntryVersionRemotely(InternalDistributedMember recipient, Integer bucketId, EntryEventImpl event) throws EntryNotFoundException, PrimaryBucketException, ForceReattemptException {
        PRUpdateEntryVersionMessage.UpdateEntryVersionResponse response = PRUpdateEntryVersionMessage.send(recipient, this, event);
        if (response != null) {
            this.prStats.incPartitionMessagesSent();
            try {
                response.waitForResult();
                return;
            }
            catch (EntryNotFoundException ex) {
                throw ex;
            }
            catch (TransactionDataNotColocatedException ex) {
                throw ex;
            }
            catch (TransactionDataRebalancedException e) {
                throw e;
            }
            catch (CacheException ce) {
                throw new PartitionedRegionException(LocalizedStrings.PartitionedRegion_UPDATE_VERSION_OF_ENTRY_ON_0_FAILED.toLocalizedString(recipient), ce);
            }
        }
    }

    public void shadowPRWaitForBucketRecovery() {
        boolean isAccessor;
        assert (this.isShadowPR());
        PartitionedRegion userPR = ColocationHelper.getLeaderRegion(this);
        boolean bl = isAccessor = userPR.getLocalMaxMemory() == 0;
        if (isAccessor) {
            return;
        }
        Set<Integer> allBuckets = userPR.getDataStore().getAllLocalBucketIds();
        HashSet<Integer> allBucketsClone = new HashSet<Integer>();
        allBucketsClone.addAll(allBuckets);
        while (allBucketsClone.size() != 0) {
            logger.debug("Need to wait until partitionedRegionQueue <<{}>> is loaded with all the buckets", (Object)this.getName());
            Iterator itr = allBucketsClone.iterator();
            while (itr.hasNext()) {
                InternalDistributedMember node = this.getNodeForBucketWrite((Integer)itr.next(), null);
                if (node == null) continue;
                itr.remove();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected void preDestroyChecks() {
        try {
            this.checkForColocatedChildren();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    @Override
    protected boolean hasStorage() {
        return this.getLocalMaxMemory() != 0;
    }

    @Override
    public EntryExpiryTask getEntryExpiryTask(Object key) {
        BucketRegion br = this.getDataStore().getLocalBucketByKey(key);
        if (br == null) {
            throw new EntryNotFoundException("Bucket for key " + key + " does not exist.");
        }
        return br.getEntryExpiryTask(key);
    }

    public Logger getLogger() {
        return logger;
    }

    public class IndexTask
    implements Callable<Index> {
        public String indexName;
        public boolean remotelyOriginated;
        private IndexType indexType;
        private String indexedExpression;
        private String fromClause;
        public String imports;
        public boolean loadEntries;

        IndexTask(boolean remotelyOriginated, IndexType indexType, String indexName, String indexedExpression, String fromClaus, String imports, boolean loadEntries) {
            this.indexName = indexName;
            this.remotelyOriginated = remotelyOriginated;
            this.indexType = indexType;
            this.indexName = indexName;
            this.indexedExpression = indexedExpression;
            this.fromClause = fromClaus;
            this.imports = imports;
            this.loadEntries = loadEntries;
        }

        IndexTask(String indexName) {
            this.indexName = indexName;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            IndexTask otherIndexTask = (IndexTask)other;
            return this.indexName.equals(otherIndexTask.indexName);
        }

        public int hashCode() {
            return this.indexName.hashCode();
        }

        @Override
        public PartitionedIndex call() throws IndexCreationException, IndexNameConflictException, IndexExistsException, ForceReattemptException {
            PartitionedIndex prIndex;
            if (PartitionedRegion.this.dataStore != null) {
                prIndex = this.createIndexOnPRBuckets();
            } else {
                if (PartitionedRegion.this.getLocalMaxMemory() != 0) {
                    throw new IndexCreationException(LocalizedStrings.PartitionedRegion_DATA_STORE_ON_THIS_VM_IS_NULL_AND_THE_LOCAL_MAX_MEMORY_IS_NOT_ZERO_0.toLocalizedString(PartitionedRegion.this.getLocalMaxMemory()));
                }
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_THIS_IS_AN_ACCESSOR_VM_AND_DOESNT_CONTAIN_DATA));
                prIndex = new PartitionedIndex(PartitionedRegion.this.cache, this.indexType, this.indexName, PartitionedRegion.this, this.indexedExpression, this.fromClause, this.imports);
            }
            PartitionedRegion.this.hasPartitionedIndex = true;
            return prIndex;
        }

        private PartitionedIndex createIndexOnPRBuckets() throws IndexNameConflictException, IndexExistsException, IndexCreationException {
            Set<Map.Entry<Integer, BucketRegion>> localBuckets = PartitionedRegion.this.getDataStore().getAllLocalBuckets();
            Iterator<Map.Entry<Integer, BucketRegion>> it = localBuckets.iterator();
            QCompiler compiler = new QCompiler();
            if (this.imports != null) {
                compiler.compileImports(this.imports);
            }
            PartitionedIndex parIndex = new PartitionedIndex(PartitionedRegion.this.cache, this.indexType, this.indexName, PartitionedRegion.this, this.indexedExpression, this.fromClause, this.imports);
            if (!it.hasNext()) {
                parIndex.setPopulated(true);
            }
            while (it.hasNext()) {
                Map.Entry<Integer, BucketRegion> entry = it.next();
                Region bucket = entry.getValue();
                if (bucket == null) continue;
                ExecutionContext externalContext = new ExecutionContext(null, PartitionedRegion.this.cache);
                externalContext.setBucketRegion(PartitionedRegion.this, (BucketRegion)bucket);
                IndexManager indMng = IndexUtils.getIndexManager(PartitionedRegion.this.cache, bucket, true);
                try {
                    Index index = indMng.createIndex(this.indexName, this.indexType, this.indexedExpression, this.fromClause, this.imports, externalContext, parIndex, this.loadEntries);
                }
                catch (IndexNameConflictException ince) {
                    if (this.remotelyOriginated) continue;
                    throw ince;
                }
                catch (IndexExistsException iee) {
                    if (this.remotelyOriginated) continue;
                    throw iee;
                }
            }
            parIndex.markValid(true);
            return parIndex;
        }
    }

    public static class SizeEntry
    implements Serializable {
        private final int size;
        private final boolean isPrimary;

        public SizeEntry(int size, boolean isPrimary) {
            this.size = size;
            this.isPrimary = isPrimary;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isPrimary() {
            return this.isPrimary;
        }

        public String toString() {
            return "SizeEntry(" + this.size + ", primary=" + this.isPrimary + ")";
        }
    }

    class BucketSorterThread
    implements Runnable {
        BucketSorterThread() {
        }

        @Override
        public void run() {
            block5: {
                try {
                    ArrayList<BucketRegion> bucketList = new ArrayList<BucketRegion>();
                    Set<BucketRegion> buckets = PartitionedRegion.this.dataStore.getAllLocalBucketRegions();
                    for (BucketRegion br : buckets) {
                        if (HeapEvictor.MINIMUM_ENTRIES_PER_BUCKET >= br.getSizeForEviction()) continue;
                        bucketList.add(br);
                    }
                    if (!bucketList.isEmpty()) {
                        Collections.sort(bucketList, new Comparator<BucketRegion>(){

                            @Override
                            public int compare(BucketRegion buk1, BucketRegion buk2) {
                                long buk2NumEntries;
                                long buk1NumEntries = buk1.getSizeForEviction();
                                if (buk1NumEntries > (buk2NumEntries = (long)buk2.getSizeForEviction())) {
                                    return -1;
                                }
                                if (buk1NumEntries < buk2NumEntries) {
                                    return 1;
                                }
                                return 0;
                            }
                        });
                    }
                    PartitionedRegion.this.sortedBuckets = bucketList;
                    if (!PartitionedRegion.this.bucketSortedOnce.get()) {
                        PartitionedRegion.this.bucketSortedOnce.set(true);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("BucketSorterThread : encountered Exception ", (Throwable)e);
                }
            }
        }
    }

    protected class AdvisorListener
    implements MembershipListener {
        protected AdvisorListener() {
        }

        protected synchronized void initRMLWrappers() {
            if (PartitionedRegion.this.isInitialized() && PartitionedRegion.this.hasListener()) {
                PartitionedRegion.this.initPostCreateRegionMembershipListeners(PartitionedRegion.this.getRegionAdvisor().adviseAllPRNodes());
            }
        }

        @Override
        public synchronized void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        }

        @Override
        public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        @Override
        public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public synchronized void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            if (PartitionedRegion.this.isInitialized() && PartitionedRegion.this.hasListener()) {
                RegionEventImpl event = new RegionEventImpl(PartitionedRegion.this, Operation.REGION_CLOSE, null, true, id);
                if (crashed) {
                    PartitionedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_REMOTE_REGION_CRASH, event);
                } else if (DestroyRegionOperation.isRegionDepartureNotificationOk()) {
                    PartitionedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_REMOTE_REGION_DEPARTURE, event);
                }
            }
        }
    }

    public static interface SetCollector {
        public void receiveSet(Set var1) throws IOException;
    }

    public static class RetryTimeKeeper {
        private int totalTimeInRetry;
        private final int maxTimeInRetry;

        public RetryTimeKeeper(int maxTime) {
            this.maxTimeInRetry = maxTime;
        }

        public void waitToRetryNode() {
            this.waitForBucketsRecovery();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForBucketsRecovery() {
            long start = System.currentTimeMillis();
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            long delta = System.currentTimeMillis() - start;
            if (delta < 1L) {
                delta = 1L;
            }
            this.totalTimeInRetry = (int)((long)this.totalTimeInRetry + delta);
        }

        public boolean overMaximum() {
            return this.totalTimeInRetry > this.maxTimeInRetry;
        }

        public int getRetryTime() {
            return this.totalTimeInRetry;
        }
    }

    public class RecoveryLock
    extends BucketLock {
        protected RecoveryLock() {
            super(PartitionedRegion.this.getRegionIdentifier() + "-RecoveryLock", PartitionedRegion.this.getCache(), false);
        }

        @Override
        public String toString() {
            return "RecoveryLock@" + System.identityHashCode(this) + "lockName=" + this.lockName + " lockService=" + this.lockService;
        }
    }

    public static class RegionLock
    extends BucketLock {
        protected RegionLock(String regionIdentifier, InternalCache cache) {
            super(regionIdentifier, cache, true);
        }

        @Override
        public String toString() {
            return "RegionLock@" + System.identityHashCode(this) + "lockName=" + this.lockName + " lockService=" + this.lockService;
        }
    }

    static class BucketLock {
        protected final DLockService lockService;
        protected final String lockName;
        private boolean lockOwned = false;
        private final InternalCache cache;
        private final boolean enableAlerts;

        protected BucketLock(String lockName, InternalCache cache, boolean enableAlerts) {
            this.lockService = (DLockService)cache.getPartitionedRegionLockService();
            this.cache = cache;
            this.lockName = lockName;
            this.enableAlerts = enableAlerts;
        }

        public void lock() {
            try {
                this.basicLock();
            }
            catch (LockServiceDestroyedException e) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                throw e;
            }
        }

        public boolean tryLock() {
            try {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                this.basicTryLock(100L);
            }
            catch (LockServiceDestroyedException e) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                throw e;
            }
            return this.lockOwned;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void basicLock() {
            if (this.enableAlerts) {
                ReplyProcessor21.forceSevereAlertProcessing();
            }
            try {
                long startTime;
                long waitInterval;
                DistributionManager dm = this.cache.getInternalDistributedSystem().getDistributionManager();
                long ackWaitThreshold = 0L;
                long ackSAThreshold = dm.getConfig().getAckSevereAlertThreshold() * 1000;
                boolean suspected = false;
                boolean severeAlertIssued = false;
                DistributedMember lockHolder = null;
                if (!this.enableAlerts) {
                    ackWaitThreshold = dm.getConfig().getAckWaitThreshold() * 1000;
                    waitInterval = ackWaitThreshold - 1L;
                    startTime = System.currentTimeMillis();
                } else if (ackSAThreshold > 0L) {
                    waitInterval = ackWaitThreshold = (long)(dm.getConfig().getAckWaitThreshold() * 1000);
                    startTime = System.currentTimeMillis();
                } else {
                    waitInterval = VM_OWNERSHIP_WAIT_TIME;
                    startTime = 0L;
                }
                while (!this.lockOwned) {
                    DLockRemoteToken remoteToken;
                    long elapsed;
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    this.lockOwned = this.lockService.lock(this.lockName, waitInterval, -1L, false, false, !this.enableAlerts);
                    if (this.lockOwned || ackSAThreshold <= 0L || !this.enableAlerts || (elapsed = System.currentTimeMillis() - startTime) <= ackWaitThreshold || !this.enableAlerts) continue;
                    if (!suspected) {
                        suspected = true;
                        severeAlertIssued = false;
                        waitInterval = ackSAThreshold;
                        remoteToken = this.lockService.queryLock(this.lockName);
                        lockHolder = remoteToken.getLessee();
                        if (lockHolder == null) continue;
                        dm.getMembershipManager().suspectMember(lockHolder, "Has not released a partitioned region lock in over " + ackWaitThreshold / 1000L + " sec");
                        continue;
                    }
                    if (elapsed <= ackSAThreshold || !this.enableAlerts) continue;
                    remoteToken = this.lockService.queryLock(this.lockName);
                    if (lockHolder != null && remoteToken.getLessee() != null && lockHolder.equals(remoteToken.getLessee())) {
                        if (severeAlertIssued) continue;
                        severeAlertIssued = true;
                        logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_0_SECONDS_HAVE_ELAPSED_WAITING_FOR_THE_PARTITIONED_REGION_LOCK_HELD_BY_1, new Object[]{(ackWaitThreshold + ackSAThreshold) / 1000L, lockHolder}));
                        continue;
                    }
                    suspected = false;
                    waitInterval = ackWaitThreshold;
                    lockHolder = null;
                }
            }
            finally {
                if (this.enableAlerts) {
                    ReplyProcessor21.unforceSevereAlertProcessing();
                }
            }
        }

        private void basicTryLock(long time) {
            long waitInterval;
            long ackWaitThreshold;
            long end;
            String key = this.lockName;
            DistributionManager dm = this.cache.getInternalDistributedSystem().getDistributionManager();
            long start = System.currentTimeMillis();
            long timeoutMS = time;
            if (timeoutMS < 0L) {
                timeoutMS = Long.MAX_VALUE;
                end = Long.MAX_VALUE;
            } else {
                end = start + timeoutMS;
            }
            long ackSAThreshold = this.cache.getInternalDistributedSystem().getConfig().getAckSevereAlertThreshold() * 1000;
            boolean suspected = false;
            boolean severeAlertIssued = false;
            DistributedMember lockHolder = null;
            if (ackSAThreshold > 0L) {
                waitInterval = ackWaitThreshold = (long)(this.cache.getInternalDistributedSystem().getConfig().getAckWaitThreshold() * 1000);
                start = System.currentTimeMillis();
            } else {
                waitInterval = timeoutMS;
                ackWaitThreshold = 0L;
                start = 0L;
            }
            do {
                try {
                    DLockRemoteToken remoteToken;
                    long elapsed;
                    waitInterval = Math.min(end - System.currentTimeMillis(), waitInterval);
                    ReplyProcessor21.forceSevereAlertProcessing();
                    this.lockOwned = this.lockService.lock(key, waitInterval, -1L, true, false);
                    if (this.lockOwned) {
                        return;
                    }
                    if (ackSAThreshold <= 0L || (elapsed = System.currentTimeMillis() - start) <= ackWaitThreshold) continue;
                    if (!suspected) {
                        suspected = true;
                        severeAlertIssued = false;
                        waitInterval = ackSAThreshold;
                        remoteToken = this.lockService.queryLock(key);
                        lockHolder = remoteToken.getLessee();
                        if (lockHolder == null) continue;
                        dm.getMembershipManager().suspectMember(lockHolder, "Has not released a global region entry lock in over " + ackWaitThreshold / 1000L + " sec");
                        continue;
                    }
                    if (elapsed <= ackSAThreshold) continue;
                    remoteToken = this.lockService.queryLock(key);
                    if (lockHolder != null && remoteToken.getLessee() != null && lockHolder.equals(remoteToken.getLessee())) {
                        if (severeAlertIssued) continue;
                        severeAlertIssued = true;
                        logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_0_SECONDS_HAVE_ELAPSED_WAITING_FOR_GLOBAL_REGION_ENTRY_LOCK_HELD_BY_1, new Object[]{(ackWaitThreshold + ackSAThreshold) / 1000L, lockHolder}));
                        continue;
                    }
                    suspected = false;
                    waitInterval = ackWaitThreshold;
                    lockHolder = null;
                }
                catch (IllegalStateException ex) {
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    throw ex;
                }
                finally {
                    ReplyProcessor21.unforceSevereAlertProcessing();
                }
            } while (System.currentTimeMillis() < end);
        }

        public DistributedMember queryLock() {
            try {
                DLockRemoteToken remoteToken = this.lockService.queryLock(this.lockName);
                return remoteToken.getLessee();
            }
            catch (LockServiceDestroyedException e) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                throw e;
            }
        }

        public void unlock() {
            if (this.lockOwned) {
                try {
                    this.lockService.unlock(this.lockName);
                }
                catch (LockServiceDestroyedException e) {
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    if (logger.isDebugEnabled()) {
                        logger.debug("BucketLock#unlock: Lock service {} was destroyed", (Object)this.lockService, (Object)e);
                    }
                }
                finally {
                    this.lockOwned = false;
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BucketLock)) {
                return false;
            }
            BucketLock other = (BucketLock)obj;
            if (!this.lockName.equals(other.lockName)) {
                return false;
            }
            DLockService ls1 = this.lockService;
            DLockService ls2 = other.lockService;
            if ((ls1 == null || ls2 == null) && ls1 != ls2) {
                return false;
            }
            return ls1.equals(ls2);
        }

        public int hashCode() {
            return this.lockName.hashCode();
        }

        public String toString() {
            return "BucketLock@" + System.identityHashCode(this) + "lockName=" + this.lockName + " lockService=" + this.lockService;
        }
    }

    protected class ValuesSet
    extends KeysSet {
        public ValuesSet() {
        }

        public ValuesSet(Set<Integer> bucketSet) {
            super(bucketSet);
        }

        @Override
        public Iterator iterator() {
            this.checkTX();
            return new ValuesSetIterator(this.bucketSet);
        }

        private class ValuesSetIterator
        extends KeysSet.KeysSetIterator {
            Object nextValue;
            private final KeyInfo key;

            public ValuesSetIterator(Set bucketSet) {
                super(bucketSet, false);
                this.nextValue = null;
                this.key = new KeyInfo(null, null, null);
            }

            @Override
            public boolean hasNext() {
                if (this.nextValue != null) {
                    return true;
                }
                while (this.nextValue == null) {
                    if (!super.hasNext()) {
                        return false;
                    }
                    this.key.setKey(super.next());
                    this.key.setBucketId(this.currentBucketId);
                    Region.Entry re = (Region.Entry)ValuesSet.this.view.getEntryForIterator(this.key, PartitionedRegion.this, ValuesSet.this.rememberReads, this.allowTombstones);
                    if (re == null) continue;
                    this.nextValue = re.getValue();
                }
                return true;
            }

            @Override
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Assert.assertTrue(this.nextValue != null, "nextValue found to be null");
                Object result = this.nextValue;
                this.nextValue = null;
                return result;
            }

            @Override
            public void remove() {
                super.remove();
                this.nextValue = null;
            }
        }
    }

    protected class KeysSet
    extends EntriesSet {
        protected final Set<Integer> bucketSet;

        public KeysSet() {
            super(PartitionedRegion.this, false, LocalRegion.IteratorType.KEYS, false);
            this.bucketSet = null;
        }

        public KeysSet(boolean allowTombstones) {
            super(PartitionedRegion.this, false, LocalRegion.IteratorType.KEYS, allowTombstones);
            this.bucketSet = null;
        }

        public KeysSet(Set<Integer> bucketSet) {
            super(PartitionedRegion.this, false, LocalRegion.IteratorType.KEYS, false);
            this.bucketSet = bucketSet;
        }

        @Override
        public int size() {
            this.checkTX();
            return PartitionedRegion.this.entryCount(this.bucketSet);
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] array) {
            ArrayList temp = new ArrayList(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                temp.add(iter.next());
            }
            if (array == null) {
                return temp.toArray();
            }
            return temp.toArray(array);
        }

        @Override
        public Iterator iterator() {
            this.checkTX();
            return new KeysSetIterator(this.bucketSet, this.allowTombstones);
        }

        class KeysSetIterator
        implements PREntriesIterator<Object> {
            final Iterator<Integer> bucketSetI;
            volatile Iterator currentBucketI = null;
            int currentBucketId = -1;
            volatile Object currentKey = null;
            protected final Set<Integer> bucketSet;
            boolean allowTombstones;

            public KeysSetIterator(Set<Integer> bucketSet, boolean allowTombstones) {
                PartitionedRegion.this.checkReadiness();
                this.bucketSet = bucketSet;
                this.allowTombstones = allowTombstones;
                this.bucketSetI = this.createBucketSetI();
                this.currentBucketI = this.getNextBucketIter(false);
            }

            protected Iterator<Integer> createBucketSetI() {
                if (this.bucketSet != null) {
                    return this.bucketSet.iterator();
                }
                return PartitionedRegion.this.getRegionAdvisor().getBucketSet().iterator();
            }

            @Override
            public boolean hasNext() {
                PartitionedRegion.this.checkReadiness();
                if (this.currentBucketI.hasNext()) {
                    return true;
                }
                while (!this.currentBucketI.hasNext() && this.bucketSetI.hasNext()) {
                    PartitionedRegion.this.checkReadiness();
                    this.currentBucketI = this.getNextBucketIter(false);
                }
                return this.currentBucketI.hasNext();
            }

            @Override
            public Object next() {
                if (KeysSet.this.myTX != null) {
                    KeysSet.this.checkTX();
                }
                PartitionedRegion.this.checkReadiness();
                if (this.currentBucketI.hasNext()) {
                    this.currentKey = this.currentBucketI.next();
                } else {
                    this.currentKey = null;
                    while (!this.currentBucketI.hasNext() && this.bucketSetI.hasNext()) {
                        PartitionedRegion.this.checkReadiness();
                        this.currentBucketI = this.getNextBucketIter(true);
                    }
                    this.currentKey = this.currentBucketI.next();
                }
                return this.currentKey;
            }

            protected Iterator getNextBucketIter(boolean canThrow) {
                try {
                    this.currentBucketId = this.bucketSetI.next();
                    return KeysSet.this.view.getBucketKeys(PartitionedRegion.this, this.currentBucketId, this.allowTombstones).iterator();
                }
                catch (NoSuchElementException endOfTheLine) {
                    if (canThrow) {
                        throw endOfTheLine;
                    }
                    return Collections.emptySet().iterator();
                }
            }

            @Override
            public void remove() {
                if (this.currentKey == null) {
                    throw new IllegalStateException();
                }
                try {
                    PartitionedRegion.this.destroy(this.currentKey);
                }
                catch (EntryNotFoundException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Caught exception during KeySetIterator remove", (Throwable)e);
                    }
                }
                finally {
                    this.currentKey = null;
                }
            }

            @Override
            public PartitionedRegion getPartitionedRegion() {
                return PartitionedRegion.this;
            }

            @Override
            public int getBucketId() {
                return this.currentBucketId;
            }
        }
    }

    protected class PREntriesSet
    extends KeysSet {
        boolean allowTombstones;

        public PREntriesSet() {
        }

        public PREntriesSet(Set<Integer> bucketSet) {
            super(bucketSet);
        }

        @Override
        public Iterator iterator() {
            this.checkTX();
            return new EntriesSetIterator(this.bucketSet, this.allowTombstones);
        }

        private class EntriesSetIterator
        extends KeysSet.KeysSetIterator {
            private final KeyInfo key;

            public EntriesSetIterator(Set bucketSet, boolean allowTombstones) {
                super(bucketSet, allowTombstones);
                this.key = new KeyInfo(null, null, null);
                PREntriesSet.this.allowTombstones = allowTombstones;
            }

            @Override
            public Object next() {
                this.key.setKey(super.next());
                this.key.setBucketId(this.currentBucketId);
                Object entry = PREntriesSet.this.view.getEntryForIterator(this.key, PartitionedRegion.this, true, this.allowTombstones);
                return entry != null ? entry : new DestroyedEntry(this.key.getKey().toString());
            }
        }
    }

    public static class PRIdMap
    extends HashMap {
        private static final long serialVersionUID = 3667357372967498179L;
        public static final String DESTROYED = "Partitioned Region Destroyed";
        static final String LOCALLY_DESTROYED = "Partitioned Region Is Locally Destroyed";
        static final String FAILED_REGISTRATION = "Partitioned Region's Registration Failed";
        public static final String NO_PATH_FOUND = "NoPathFound";
        private volatile boolean cleared = true;

        @Override
        public Object get(Object key) {
            throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_PRIDMAPGET_NOT_SUPPORTED_USE_GETREGION_INSTEAD.toLocalizedString());
        }

        public Object getRegion(Object key) throws PRLocallyDestroyedException {
            Assert.assertTrue(key instanceof Integer);
            Object o = super.get(key);
            if (o == DESTROYED) {
                throw new RegionDestroyedException(LocalizedStrings.PartitionedRegion_REGION_FOR_PRID_0_IS_DESTROYED.toLocalizedString(key), NO_PATH_FOUND);
            }
            if (o == LOCALLY_DESTROYED) {
                throw new PRLocallyDestroyedException(LocalizedStrings.PartitionedRegion_REGION_WITH_PRID_0_IS_LOCALLY_DESTROYED_ON_THIS_NODE.toLocalizedString(key));
            }
            if (o == FAILED_REGISTRATION) {
                throw new PRLocallyDestroyedException(LocalizedStrings.PartitionedRegion_REGION_WITH_PRID_0_FAILED_INITIALIZATION_ON_THIS_NODE.toLocalizedString(key));
            }
            return o;
        }

        @Override
        public Object remove(Object key) {
            return this.put(key, DESTROYED, true);
        }

        @Override
        public Object put(Object key, Object value) {
            return this.put(key, value, true);
        }

        public Object put(Object key, Object value, boolean sendIdentityRequestMessage) {
            if (this.cleared) {
                this.cleared = false;
            }
            if (key == null) {
                throw new NullPointerException(LocalizedStrings.PartitionedRegion_NULL_KEY_NOT_ALLOWED_FOR_PRIDTOPR_MAP.toLocalizedString());
            }
            if (value == null) {
                throw new NullPointerException(LocalizedStrings.PartitionedRegion_NULL_VALUE_NOT_ALLOWED_FOR_PRIDTOPR_MAP.toLocalizedString());
            }
            Assert.assertTrue(key instanceof Integer);
            if (sendIdentityRequestMessage) {
                IdentityRequestMessage.setLatestId((Integer)key);
            }
            if (super.get(key) == DESTROYED && value instanceof PartitionedRegion) {
                throw new PartitionedRegionException(LocalizedStrings.PartitionedRegion_CAN_NOT_REUSE_OLD_PARTITIONED_REGION_ID_0.toLocalizedString(key));
            }
            return super.put(key, value);
        }

        @Override
        public void clear() {
            this.cleared = true;
            super.clear();
        }

        public synchronized String dump() {
            StringBuilder sb = new StringBuilder("prIdToPR Map@");
            sb.append(System.identityHashCode(prIdToPR)).append(':').append(SystemUtils.getLineSeparator());
            Iterator iterator = prIdToPR.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry mapEntry = iterator.next();
                sb.append(mapEntry.getKey()).append("=>").append(mapEntry.getValue());
                if (!iterator.hasNext()) continue;
                sb.append(SystemUtils.getLineSeparator());
            }
            return sb.toString();
        }
    }
}

