/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class KeyInfo {
    public static final int UNKNOWN_BUCKET = -1;
    private Object key;
    private Object callbackArg;
    private int bucketId;
    private final Object value;

    public KeyInfo(Object key, Object value, Object callbackArg) {
        this.key = key;
        this.callbackArg = callbackArg;
        this.bucketId = -1;
        this.value = value;
    }

    public KeyInfo(Object key, Object callbackArg, int bucketId) {
        this.key = key;
        this.callbackArg = callbackArg;
        this.bucketId = bucketId;
        this.value = null;
    }

    public KeyInfo(KeyInfo keyInfo) {
        this.bucketId = keyInfo.bucketId;
        this.callbackArg = keyInfo.callbackArg;
        this.value = keyInfo.value;
        this.key = keyInfo.key;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getCallbackArg() {
        return this.callbackArg;
    }

    public Object getValue() {
        return this.value;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public void setBucketId(int bucketId) {
        this.bucketId = bucketId;
    }

    public void setCallbackArg(Object callbackArg) {
        this.callbackArg = callbackArg;
    }

    public String toString() {
        return "(key=" + this.key + ",bucketId=" + this.bucketId + ")";
    }

    public boolean isCheckPrimary() throws UnsupportedOperationInTransactionException {
        return true;
    }

    public void setCheckPrimary(boolean checkPrimary) throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.Dist_TX_PRECOMMIT_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString("setCheckPrimary"));
    }

    public boolean isDistKeyInfo() {
        return false;
    }
}

