/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

public class InlineKeyHelper {
    public static boolean INLINE_REGION_KEYS = !Boolean.getBoolean("gemfire.DISABLE_INLINE_REGION_KEYS");
    public static final int MAX_LONGS_USED_FOR_STRING_KEY = 2;

    public static int getMaxInlineStringKey(int longCount, boolean byteEncoded) {
        return longCount * (byteEncoded ? 8 : 4) - 1;
    }

    public static Boolean canStringBeInlineEncoded(String skey) {
        if (skey.length() > InlineKeyHelper.getMaxInlineStringKey(2, true)) {
            return null;
        }
        if (InlineKeyHelper.isByteEncodingOk(skey)) {
            return Boolean.TRUE;
        }
        if (skey.length() > InlineKeyHelper.getMaxInlineStringKey(2, false)) {
            return null;
        }
        return Boolean.FALSE;
    }

    private static boolean isByteEncodingOk(String skey) {
        for (int i = 0; i < skey.length(); ++i) {
            if (skey.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

