/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;

public class ExpireDisconnectedClientTransactionsMessage
extends HighPriorityDistributionMessage {
    Set<TXId> txIds;

    static void send(DistributionManager dm, Set<InternalDistributedMember> recipients, Set<TXId> txIds) {
        ExpireDisconnectedClientTransactionsMessage msg = new ExpireDisconnectedClientTransactionsMessage();
        msg.txIds = txIds;
        HashSet<InternalDistributedMember> newVersionRecipients = new HashSet<InternalDistributedMember>();
        for (InternalDistributedMember recipient : recipients) {
            if (recipient.getVersionObject().compareTo(Version.GEODE_170) < 0) continue;
            newVersionRecipients.add(recipient);
        }
        msg.setRecipients(newVersionRecipients);
        dm.putOutgoing(msg);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeHashSet((HashSet)this.txIds, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.txIds = DataSerializer.readHashSet(in);
    }

    @Override
    public int getDSFID() {
        return 138;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        InternalCache cache = dm.getCache();
        InternalDistributedMember sender = this.getSender();
        if (cache != null) {
            TXManagerImpl mgr = cache.getTXMgr();
            if (sender.getVersionObject().compareTo(Version.GEODE_170) >= 0) {
                mgr.expireDisconnectedClientTransactions(this.txIds, false);
            } else {
                mgr.removeExpiredClientTransactions(this.txIds);
            }
        }
    }
}

