/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.InternalDataView;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.AbstractRegionEntry;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class EntriesSet
extends AbstractSet {
    final LocalRegion topRegion;
    final boolean recursive;
    final LocalRegion.IteratorType iterType;
    protected final TXStateInterface myTX;
    final boolean allowTombstones;
    protected final InternalDataView view;
    final boolean rememberReads;
    private boolean keepSerialized = false;
    protected boolean ignoreCopyOnReadForQuery = false;

    EntriesSet(LocalRegion region, boolean recursive, LocalRegion.IteratorType viewType, boolean allowTombstones) {
        this.topRegion = region;
        this.recursive = recursive;
        this.iterType = viewType;
        this.myTX = region.getTXState();
        this.view = this.myTX == null ? region.getSharedDataView() : this.myTX;
        this.rememberReads = true;
        this.allowTombstones = allowTombstones;
    }

    protected void checkTX() {
        if (this.myTX != null) {
            if (!this.myTX.isInProgress()) {
                throw new IllegalStateException(LocalizedStrings.LocalRegion_REGION_COLLECTION_WAS_CREATED_WITH_TRANSACTION_0_THAT_IS_NO_LONGER_ACTIVE.toLocalizedString(this.myTX.getTransactionId()));
            }
        } else if (this.topRegion.isTX()) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_NON_TRANSACTIONAL_REGION_COLLECTION_IS_BEING_USED_IN_A_TRANSACTION.toLocalizedString(this.topRegion.getTXState().getTransactionId()));
        }
    }

    @Override
    public Iterator<Object> iterator() {
        this.checkTX();
        return new EntriesIterator();
    }

    @Override
    public int size() {
        this.checkTX();
        if (this.iterType == LocalRegion.IteratorType.VALUES) {
            int s = 0;
            EntriesIterator itr = new EntriesIterator();
            while (itr.hasNext()) {
                ++s;
                itr.next();
            }
            return s;
        }
        if (this.recursive) {
            return this.topRegion.allEntriesSize();
        }
        return this.view.entryCount(this.topRegion);
    }

    @Override
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    public Object[] toArray(Object[] array) {
        this.checkTX();
        ArrayList temp = new ArrayList(this.size());
        EntriesIterator iter = new EntriesIterator();
        while (iter.hasNext()) {
            temp.add(iter.next());
        }
        if (array == null) {
            return temp.toArray();
        }
        return temp.toArray(array);
    }

    public void setKeepSerialized(boolean keepSerialized) {
        this.keepSerialized = keepSerialized;
    }

    public boolean isKeepSerialized() {
        return this.keepSerialized;
    }

    public void setIgnoreCopyOnReadForQuery(boolean ignoreCopyOnReadForQuery) {
        this.ignoreCopyOnReadForQuery = ignoreCopyOnReadForQuery;
    }

    public boolean isIgnoreCopyOnReadForQuery() {
        return this.ignoreCopyOnReadForQuery;
    }

    static /* synthetic */ boolean access$000(EntriesSet x0) {
        return x0.keepSerialized;
    }

    private class EntriesIterator
    implements Iterator<Object> {
        final List<LocalRegion> regions;
        final int numSubRegions;
        int regionsIndex;
        LocalRegion currRgn;
        Object nextElem;
        Iterator<?> currItr;
        Collection<?> additionalKeysFromView;
        protected final KeyInfo keyInfo = new KeyInfo(null, null, null);

        protected EntriesIterator() {
            if (EntriesSet.this.recursive) {
                this.regions = new ArrayList<LocalRegion>(EntriesSet.this.topRegion.subregions(true));
                this.numSubRegions = this.regions.size();
            } else {
                this.regions = null;
                this.numSubRegions = 0;
            }
            this.createIterator(EntriesSet.this.topRegion);
            this.nextElem = this.moveNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_THIS_ITERATOR_DOES_NOT_SUPPORT_MODIFICATION.toLocalizedString());
        }

        @Override
        public boolean hasNext() {
            return this.nextElem != null;
        }

        @Override
        public Object next() {
            Object result = this.nextElem;
            if (result != null) {
                this.nextElem = this.moveNext();
                return result;
            }
            throw new NoSuchElementException();
        }

        /*
         * Unable to fully structure code
         */
        private Object moveNext() {
            while (true) lbl-1000:
            // 8 sources

            {
                if (this.currItr.hasNext()) {
                    currKey = this.currItr.next();
                    this.keyInfo.setKey(currKey);
                    if (this.additionalKeysFromView != null) {
                        if (currKey instanceof AbstractRegionEntry) {
                            this.additionalKeysFromView.remove(((AbstractRegionEntry)currKey).getKey());
                        } else {
                            this.additionalKeysFromView.remove(currKey);
                        }
                    }
                    if (EntriesSet.this.iterType == LocalRegion.IteratorType.KEYS) {
                        result = EntriesSet.this.view.getKeyForIterator(this.keyInfo, this.currRgn, EntriesSet.this.rememberReads, EntriesSet.this.allowTombstones);
                        if (result == null) continue;
                        return result;
                    }
                    if (EntriesSet.this.iterType == LocalRegion.IteratorType.ENTRIES) {
                        result = EntriesSet.this.view.getEntryForIterator(this.keyInfo, this.currRgn, EntriesSet.this.rememberReads, EntriesSet.this.allowTombstones);
                        if (result == null) continue;
                        return result;
                    }
                    re = (Region.Entry)EntriesSet.this.view.getEntryForIterator(this.keyInfo, this.currRgn, EntriesSet.this.rememberReads, EntriesSet.this.allowTombstones);
                    if (re == null) continue;
                    try {
                        result = EntriesSet.access$000(EntriesSet.this) != false ? ((LocalRegion.NonTXEntry)re).getRawValue() : (EntriesSet.this.ignoreCopyOnReadForQuery != false ? ((LocalRegion.NonTXEntry)re).getValue(true) : re.getValue());
                        if (result != null && !Token.isInvalidOrRemoved(result)) {
                            return result;
                        }
                        if (result != Token.TOMBSTONE || !EntriesSet.this.allowTombstones) ** GOTO lbl-1000
                        return result;
                    }
                    catch (EntryDestroyedException var4_4) {}
                    continue;
                }
                if (this.additionalKeysFromView != null) {
                    this.currItr = this.additionalKeysFromView.iterator();
                    this.additionalKeysFromView = null;
                    continue;
                }
                if (this.regionsIndex >= this.numSubRegions) break;
                this.createIterator(this.regions.get(this.regionsIndex));
                ++this.regionsIndex;
            }
            return null;
        }

        private void createIterator(LocalRegion rgn) {
            this.currRgn = rgn;
            this.currItr = EntriesSet.this.view.getRegionKeysForIteration(rgn).iterator();
            this.additionalKeysFromView = EntriesSet.this.view.getAdditionalKeysForIterator(rgn);
        }
    }
}

