/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DistTXPrecommitMessage;
import org.apache.geode.internal.cache.DistTXState;
import org.apache.geode.internal.cache.DistTXStateProxyImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class DistTXStateProxyImplOnDatanode
extends DistTXStateProxyImpl {
    private DistTXPrecommitMessage preCommitMessage = null;
    private boolean preCommitResponse = false;

    public DistTXStateProxyImplOnDatanode(InternalCache cache, TXManagerImpl managerImpl, TXId id, InternalDistributedMember clientMember) {
        super(cache, managerImpl, id, clientMember);
    }

    public DistTXStateProxyImplOnDatanode(InternalCache cache, TXManagerImpl managerImpl, TXId id, boolean isjta) {
        super(cache, managerImpl, id, isjta);
    }

    @Override
    public TXStateInterface getRealDeal(KeyInfo key, InternalRegion r) {
        if (this.realDeal == null) {
            this.realDeal = new DistTXState(this, false);
            if (r != null) {
                r.waitOnInitialization(r.getInitializationLatchBeforeGetInitialImage());
                this.target = r.getOwnerForKey(key);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Built a new DistTXState: {} me:{}", (Object)this.realDeal, (Object)this.txMgr.getDM().getId());
            }
        }
        return this.realDeal;
    }

    @Override
    public TXStateInterface getRealDeal(DistributedMember t) {
        assert (t != null);
        if (this.realDeal == null) {
            this.target = t;
            this.realDeal = new DistTXState(this, false);
            if (logger.isDebugEnabled()) {
                logger.debug("Built a new DistTXState: {} me:{}", (Object)this.realDeal, (Object)this.txMgr.getDM().getId());
            }
        }
        return this.realDeal;
    }

    private DistTXState getRealDeal() throws UnsupportedOperationInTransactionException {
        if (this.realDeal == null || !this.realDeal.isDistTx() || !this.realDeal.isTxState() || this.realDeal.isCreatedOnDistTxCoordinator()) {
            throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistTXStateOnDatanode", this.realDeal != null ? this.realDeal.getClass().getSimpleName() : "null"));
        }
        return (DistTXState)this.realDeal;
    }

    @Override
    public void precommit() throws CommitConflictException, UnsupportedOperationInTransactionException {
        try {
            DistTXState txState = this.getRealDeal();
            boolean retVal = txState.applyOpsOnRedundantCopy(this.preCommitMessage.getSender(), this.preCommitMessage.getSecondaryTransactionalOperations());
            if (retVal) {
                this.setCommitOnBehalfOfRemoteStub(true);
                txState.precommit();
            }
            this.preCommitResponse = retVal;
        }
        finally {
            this.inProgress = true;
        }
    }

    public void setPreCommitMessage(DistTXPrecommitMessage preCommitMessage) {
        this.preCommitMessage = preCommitMessage;
    }

    public boolean getPreCommitResponse() {
        return this.preCommitResponse;
    }

    public boolean populateDistTxEntryStateList(TreeMap<String, ArrayList<TXEntryState.DistTxThinEntryState>> entryStateSortedMap) {
        return this.getRealDeal().populateDistTxEntryStateList(entryStateSortedMap);
    }

    public void populateDistTxEntryStates(ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryEventList) {
        this.getRealDeal().setDistTxEntryStates(entryEventList);
    }
}

