/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.internal.cache.EntryBits;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.i18n.LocalizedStrings;

public abstract class DiskId {
    private long id;
    protected int valueLength = 0;
    public static final long OPLOG_ID_MASK = 0xFFFFFFFFFFFFFFL;
    public static final long USER_BITS_MASK = -72057594037927936L;
    public static final long MAX_OPLOG_ID = 0x7FFFFFFFFFFFFFL;
    public static final long OPLOG_ID_SIGN_BIT = 0x80000000000000L;
    public static final long USER_BITS_SHIFT = 56L;

    public abstract long getKeyId();

    public abstract long getOffsetInOplog();

    public synchronized long getOplogId() {
        long oplogId = this.id & 0x7FFFFFFFFFFFFFL;
        if ((this.id & 0x80000000000000L) != 0L) {
            oplogId = -1L * oplogId;
        }
        return oplogId;
    }

    public abstract void setKeyId(long var1);

    public abstract void setOffsetInOplog(long var1);

    public abstract void markForWriting();

    public abstract void unmarkForWriting();

    public abstract boolean needsToBeWritten();

    public synchronized long setOplogId(long oplogId) {
        long result = this.getOplogId();
        long oldUserBits = this.id & 0xFF00000000000000L;
        long opId = oplogId;
        if (oplogId < 0L) {
            opId = -1L * oplogId;
            opId |= 0x80000000000000L;
        }
        this.id = opId | oldUserBits;
        return result;
    }

    public synchronized byte getUserBits() {
        return (byte)(this.id >> 56);
    }

    public synchronized void setUserBits(byte userBits) {
        long userLong = (long)userBits << 56;
        this.id &= 0xFFFFFFFFFFFFFFL;
        this.id |= userLong;
    }

    public boolean isPendingAsync() {
        return EntryBits.isPendingAsync(this.getUserBits());
    }

    public synchronized void setPendingAsync(boolean v) {
        byte newBits;
        byte origBits = this.getUserBits();
        if (origBits != (newBits = EntryBits.setPendingAsync(origBits, v))) {
            this.setUserBits(newBits);
        }
    }

    public synchronized void setRecoveredFromDisk(boolean v) {
        byte newBits;
        byte origBits = this.getUserBits();
        if (origBits != (newBits = EntryBits.setRecoveredFromDisk(origBits, v))) {
            this.setUserBits(newBits);
        }
    }

    public int getValueLength() {
        return this.valueLength & Integer.MAX_VALUE;
    }

    public void setValueLength(int valueLength) {
        if (valueLength < 0) {
            throw new IllegalStateException("Expected DiskId valueLength " + valueLength + " to be >= 0.");
        }
        this.valueLength = this.valueLength & Integer.MIN_VALUE | valueLength;
    }

    public DiskEntry getPrev() {
        return null;
    }

    public DiskEntry getNext() {
        return null;
    }

    public void setPrev(DiskEntry v) {
        throw new IllegalStateException("should only be called by disk compaction");
    }

    public void setNext(DiskEntry v) {
        throw new IllegalStateException("should only be called by disk compaction");
    }

    public String toString() {
        StringBuilder temp = new StringBuilder("Oplog ID = ");
        temp.append(this.getOplogId());
        temp.append("; Offset in Oplog = ");
        temp.append(this.getOffsetInOplog());
        temp.append("; Value Length = ");
        temp.append(this.getValueLength());
        temp.append("; UserBits is = ");
        temp.append(this.getUserBits());
        return temp.toString();
    }

    public static DiskId createDiskId(long maxOplogSize, boolean isPersistenceType, boolean needsLinkedList) {
        long bytes = maxOplogSize * 1024L * 1024L;
        if (bytes > Integer.MAX_VALUE) {
            if (isPersistenceType) {
                if (needsLinkedList) {
                    return new PersistenceWithLongOffset();
                }
                return new PersistenceWithLongOffsetNoLL();
            }
            if (needsLinkedList) {
                return new OverflowOnlyWithLongOffset();
            }
            return new OverflowOnlyWithLongOffsetNoLL();
        }
        if (isPersistenceType) {
            if (needsLinkedList) {
                return new PersistenceWithIntOffset();
            }
            return new PersistenceWithIntOffsetNoLL();
        }
        if (needsLinkedList) {
            return new OverflowOnlyWithIntOffset();
        }
        return new OverflowOnlyWithIntOffsetNoLL();
    }

    static boolean isInstanceofPersistIntOplogOffsetDiskId(DiskId diskId) {
        return diskId instanceof PersistenceWithIntOffset;
    }

    static boolean isInstanceofPersistLongOplogOffsetDiskId(DiskId diskId) {
        return diskId instanceof PersistenceWithLongOffset;
    }

    static boolean isInstanceofOverflowIntOplogOffsetDiskId(DiskId diskId) {
        return diskId instanceof OverflowOnlyWithIntOffset;
    }

    static boolean isInstanceofOverflowOnlyWithLongOffset(DiskId diskId) {
        return diskId instanceof OverflowOnlyWithLongOffset;
    }

    protected static final class PersistenceWithLongOffset
    extends PersistenceWithLongOffsetNoLL {
        private DiskEntry prev;
        private DiskEntry next;

        protected PersistenceWithLongOffset() {
        }

        @Override
        public DiskEntry getPrev() {
            return this.prev;
        }

        @Override
        public DiskEntry getNext() {
            return this.next;
        }

        @Override
        public void setPrev(DiskEntry v) {
            this.prev = v;
        }

        @Override
        public void setNext(DiskEntry v) {
            this.next = v;
        }
    }

    protected static class PersistenceWithLongOffsetNoLL
    extends LongOplogOffsetDiskId {
        private long keyId;

        protected PersistenceWithLongOffsetNoLL() {
        }

        @Override
        public long getKeyId() {
            return this.keyId;
        }

        @Override
        public void setKeyId(long keyId) {
            this.keyId = keyId;
        }

        @Override
        public void markForWriting() {
            throw new IllegalStateException("Should not be used for persistent region");
        }

        @Override
        public void unmarkForWriting() {
        }

        @Override
        public String toString() {
            StringBuilder temp = new StringBuilder("Oplog Key ID = ");
            temp.append(this.keyId);
            temp.append("; ");
            temp.append(super.toString());
            return temp.toString();
        }

        @Override
        public boolean needsToBeWritten() {
            return false;
        }
    }

    protected static final class PersistenceWithIntOffset
    extends PersistenceWithIntOffsetNoLL {
        private DiskEntry prev;
        private DiskEntry next;

        protected PersistenceWithIntOffset() {
        }

        @Override
        public DiskEntry getPrev() {
            return this.prev;
        }

        @Override
        public DiskEntry getNext() {
            return this.next;
        }

        @Override
        public void setPrev(DiskEntry v) {
            this.prev = v;
        }

        @Override
        public void setNext(DiskEntry v) {
            this.next = v;
        }
    }

    protected static class PersistenceWithIntOffsetNoLL
    extends IntOplogOffsetDiskId {
        private long keyId;

        protected PersistenceWithIntOffsetNoLL() {
        }

        @Override
        public long getKeyId() {
            return this.keyId;
        }

        @Override
        public void setKeyId(long keyId) {
            this.keyId = keyId;
        }

        @Override
        public void markForWriting() {
            throw new IllegalStateException("Should not be used for persistent region");
        }

        @Override
        public void unmarkForWriting() {
        }

        @Override
        public boolean needsToBeWritten() {
            return false;
        }

        @Override
        public String toString() {
            StringBuilder temp = new StringBuilder("Oplog Key ID = ");
            temp.append(this.keyId);
            temp.append("; ");
            temp.append(super.toString());
            return temp.toString();
        }
    }

    protected static final class OverflowOnlyWithLongOffset
    extends OverflowOnlyWithLongOffsetNoLL {
        private DiskEntry prev;
        private DiskEntry next;

        protected OverflowOnlyWithLongOffset() {
        }

        @Override
        public DiskEntry getPrev() {
            return this.prev;
        }

        @Override
        public DiskEntry getNext() {
            return this.next;
        }

        @Override
        public void setPrev(DiskEntry v) {
            this.prev = v;
        }

        @Override
        public void setNext(DiskEntry v) {
            this.next = v;
        }
    }

    protected static class OverflowOnlyWithLongOffsetNoLL
    extends LongOplogOffsetDiskId {
        OverflowOnlyWithLongOffsetNoLL() {
            this.markForWriting();
        }

        @Override
        public long getKeyId() {
            throw new UnsupportedOperationException(LocalizedStrings.DiskId_FOR_OVERFLOW_ONLY_MODE_THE_KEYID_SHOULD_NOT_BE_QUERIED.toLocalizedString());
        }

        @Override
        public void setKeyId(long keyId) {
            throw new UnsupportedOperationException(LocalizedStrings.DiskId_FOR_OVERFLOW_ONLY_MODE_THE_KEYID_SHOULD_NOT_BE_SET.toLocalizedString());
        }

        @Override
        public void markForWriting() {
            this.valueLength |= Integer.MIN_VALUE;
        }

        @Override
        public void unmarkForWriting() {
            this.valueLength &= Integer.MAX_VALUE;
        }

        @Override
        public boolean needsToBeWritten() {
            return (this.valueLength & Integer.MIN_VALUE) != 0;
        }
    }

    protected static final class OverflowOnlyWithIntOffset
    extends OverflowOnlyWithIntOffsetNoLL {
        private DiskEntry prev;
        private DiskEntry next;

        protected OverflowOnlyWithIntOffset() {
        }

        @Override
        public DiskEntry getPrev() {
            return this.prev;
        }

        @Override
        public DiskEntry getNext() {
            return this.next;
        }

        @Override
        public void setPrev(DiskEntry v) {
            this.prev = v;
        }

        @Override
        public void setNext(DiskEntry v) {
            this.next = v;
        }
    }

    protected static class OverflowOnlyWithIntOffsetNoLL
    extends IntOplogOffsetDiskId {
        OverflowOnlyWithIntOffsetNoLL() {
            this.markForWriting();
        }

        @Override
        public long getKeyId() {
            throw new UnsupportedOperationException(LocalizedStrings.DiskId_FOR_OVERFLOW_ONLY_MODE_THE_KEYID_SHOULD_NOT_BE_QUERIED.toLocalizedString());
        }

        @Override
        public void setKeyId(long keyId) {
            throw new UnsupportedOperationException(LocalizedStrings.DiskId_FOR_OVERFLOW_ONLY_MODE_THE_KEYID_SHOULD_NOT_BE_SET.toLocalizedString());
        }

        @Override
        public void markForWriting() {
            this.valueLength |= Integer.MIN_VALUE;
        }

        @Override
        public void unmarkForWriting() {
            this.valueLength &= Integer.MAX_VALUE;
        }

        @Override
        public boolean needsToBeWritten() {
            return (this.valueLength & Integer.MIN_VALUE) != 0;
        }
    }

    protected static abstract class LongOplogOffsetDiskId
    extends DiskId {
        private volatile long offsetInOplog;

        protected LongOplogOffsetDiskId() {
        }

        @Override
        public long getOffsetInOplog() {
            return this.offsetInOplog;
        }

        @Override
        public void setOffsetInOplog(long offsetInOplog) {
            this.offsetInOplog = offsetInOplog;
        }
    }

    protected static abstract class IntOplogOffsetDiskId
    extends DiskId {
        private volatile int offsetInOplog;

        protected IntOplogOffsetDiskId() {
        }

        @Override
        public long getOffsetInOplog() {
            return this.offsetInOplog;
        }

        @Override
        public void setOffsetInOplog(long offsetInOplog) {
            this.offsetInOplog = (int)offsetInOplog;
        }
    }
}

