/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.List;
import org.apache.geode.cache.client.internal.InternalClientCache;
import org.apache.geode.internal.cache.xmlcache.CacheServerCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.SecurityManager;

public class CacheConfig {
    public static final boolean DEFAULT_PDX_READ_SERIALIZED = false;
    public static final PdxSerializer DEFAULT_PDX_SERIALIZER = null;
    public static final String DEFAULT_PDX_DISK_STORE = null;
    public static final boolean DEFAULT_PDX_PERSISTENT = false;
    public static final boolean DEFAULT_PDX_IGNORE_UNREAD_FIELDS = false;
    private SecurityManager securityManager = null;
    private PostProcessor postProcessor = null;
    public boolean pdxReadSerialized = false;
    private String cacheXMLDescription = null;
    private List<CacheServerCreation> cacheServerCreation;
    public boolean pdxReadSerializedUserSet = false;
    public PdxSerializer pdxSerializer = DEFAULT_PDX_SERIALIZER;
    public boolean pdxSerializerUserSet = false;
    public String pdxDiskStore = DEFAULT_PDX_DISK_STORE;
    public boolean pdxDiskStoreUserSet = false;
    public boolean pdxPersistent = false;
    public boolean pdxPersistentUserSet = false;
    public boolean pdxIgnoreUnreadFields = false;
    public boolean pdxIgnoreUnreadFieldsUserSet = false;

    public boolean isPdxReadSerialized() {
        return this.pdxReadSerialized;
    }

    public void setPdxReadSerialized(boolean pdxReadSerialized) {
        this.pdxReadSerializedUserSet = true;
        this.pdxReadSerialized = pdxReadSerialized;
    }

    public PdxSerializer getPdxSerializer() {
        return this.pdxSerializer;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void setPdxSerializer(PdxSerializer pdxSerializer) {
        this.pdxSerializerUserSet = true;
        this.pdxSerializer = pdxSerializer;
    }

    public PostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(PostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public String getPdxDiskStore() {
        return this.pdxDiskStore;
    }

    public void setPdxDiskStore(String pdxDiskStore) {
        this.pdxDiskStoreUserSet = true;
        this.pdxDiskStore = pdxDiskStore;
    }

    public boolean isPdxPersistent() {
        return this.pdxPersistent;
    }

    public void setPdxPersistent(boolean pdxPersistent) {
        this.pdxPersistentUserSet = true;
        this.pdxPersistent = pdxPersistent;
    }

    public boolean getPdxIgnoreUnreadFields() {
        return this.pdxIgnoreUnreadFields;
    }

    public void setPdxIgnoreUnreadFields(boolean ignore) {
        this.pdxIgnoreUnreadFields = ignore;
        this.pdxIgnoreUnreadFieldsUserSet = true;
    }

    public String getCacheXMLDescription() {
        return this.cacheXMLDescription;
    }

    public void setCacheXMLDescription(String cacheXMLDescription) {
        this.cacheXMLDescription = cacheXMLDescription;
    }

    public List<CacheServerCreation> getCacheServerCreation() {
        return this.cacheServerCreation;
    }

    public void setCacheServerCreation(List<CacheServerCreation> servers) {
        this.cacheServerCreation = servers;
    }

    public void validateCacheConfig(InternalClientCache cacheInstance) {
        if (this.pdxReadSerializedUserSet && this.pdxReadSerialized != cacheInstance.getPdxReadSerialized()) {
            throw new IllegalStateException(LocalizedStrings.CacheFactory_0_EXISTING_CACHE_WITH_DIFFERENT_CACHE_CONFIG.toLocalizedString("pdxReadSerialized: " + cacheInstance.getPdxReadSerialized()));
        }
        if (this.pdxDiskStoreUserSet && !this.equals(this.pdxDiskStore, cacheInstance.getPdxDiskStore())) {
            throw new IllegalStateException(LocalizedStrings.CacheFactory_0_EXISTING_CACHE_WITH_DIFFERENT_CACHE_CONFIG.toLocalizedString("pdxDiskStore: " + cacheInstance.getPdxDiskStore()));
        }
        if (this.pdxPersistentUserSet && this.pdxPersistent != cacheInstance.getPdxPersistent()) {
            throw new IllegalStateException(LocalizedStrings.CacheFactory_0_EXISTING_CACHE_WITH_DIFFERENT_CACHE_CONFIG.toLocalizedString("pdxPersistent: " + cacheInstance.getPdxPersistent()));
        }
        if (this.pdxIgnoreUnreadFieldsUserSet && this.pdxIgnoreUnreadFields != cacheInstance.getPdxIgnoreUnreadFields()) {
            throw new IllegalStateException(LocalizedStrings.CacheFactory_0_EXISTING_CACHE_WITH_DIFFERENT_CACHE_CONFIG.toLocalizedString("pdxIgnoreUnreadFields: " + cacheInstance.getPdxIgnoreUnreadFields()));
        }
        if (this.pdxSerializerUserSet && !this.samePdxSerializer(this.pdxSerializer, cacheInstance.getPdxSerializer())) {
            throw new IllegalStateException(LocalizedStrings.CacheFactory_0_EXISTING_CACHE_WITH_DIFFERENT_CACHE_CONFIG.toLocalizedString("pdxSerializer: " + cacheInstance.getPdxSerializer()));
        }
    }

    private boolean samePdxSerializer(PdxSerializer s1, PdxSerializer s2) {
        Object o1 = s1;
        Object o2 = s2;
        if (s1 instanceof ReflectionBasedAutoSerializer && s2 instanceof ReflectionBasedAutoSerializer) {
            o1 = ((ReflectionBasedAutoSerializer)s1).getManager();
            o2 = ((ReflectionBasedAutoSerializer)s2).getManager();
        }
        return this.equals(o1, o2);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public void setDeclarativeConfig(CacheConfig cacheConfig) {
        if (!this.pdxDiskStoreUserSet) {
            this.pdxDiskStore = cacheConfig.getPdxDiskStore();
            this.pdxDiskStoreUserSet = cacheConfig.pdxDiskStoreUserSet;
        }
        if (!this.pdxPersistentUserSet) {
            this.pdxPersistent = cacheConfig.isPdxPersistent();
            this.pdxPersistentUserSet = cacheConfig.pdxPersistentUserSet;
        }
        if (!this.pdxReadSerializedUserSet) {
            this.pdxReadSerialized = cacheConfig.isPdxReadSerialized();
            this.pdxReadSerializedUserSet = cacheConfig.pdxReadSerializedUserSet;
        }
        if (!this.pdxSerializerUserSet) {
            this.pdxSerializer = cacheConfig.getPdxSerializer();
            this.pdxSerializerUserSet = cacheConfig.pdxSerializerUserSet;
        }
        if (!this.pdxIgnoreUnreadFieldsUserSet) {
            this.pdxIgnoreUnreadFields = cacheConfig.getPdxIgnoreUnreadFields();
            this.pdxIgnoreUnreadFieldsUserSet = cacheConfig.pdxIgnoreUnreadFieldsUserSet;
        }
    }
}

