/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.function.BooleanSupplier;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class AfterCompletion {
    private static final Logger logger = LogService.getLogger();
    private boolean started;
    private boolean finished;
    private int status = -1;
    private boolean cancelled;
    private RuntimeException exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doOp(TXState txState, CancelCriterion cancelCriterion) {
        this.waitForExecuteOrCancel(cancelCriterion);
        this.started = true;
        logger.debug("executing afterCompletion notification");
        try {
            if (this.cancelled) {
                txState.doCleanup();
            } else {
                txState.doAfterCompletion(this.status);
            }
        }
        catch (RuntimeException exception) {
            this.exception = exception;
        }
        finally {
            logger.debug("afterCompletion notification completed");
            this.finished = true;
            this.notifyAll();
        }
    }

    private void waitForExecuteOrCancel(CancelCriterion cancelCriterion) {
        this.waitForCondition(cancelCriterion, () -> this.status != -1 || this.cancelled);
    }

    private synchronized void waitForCondition(CancelCriterion cancelCriterion, BooleanSupplier condition) {
        while (!condition.getAsBoolean()) {
            cancelCriterion.checkCancelInProgress(null);
            try {
                logger.debug("waiting for notification");
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void execute(CancelCriterion cancelCriterion, int status) {
        this.status = status;
        this.signalAndWaitForDoOp(cancelCriterion);
    }

    private void signalAndWaitForDoOp(CancelCriterion cancelCriterion) {
        this.notifyAll();
        this.waitUntilFinished(cancelCriterion);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void waitUntilFinished(CancelCriterion cancelCriterion) {
        this.waitForCondition(cancelCriterion, () -> this.finished);
    }

    public synchronized void cancel(CancelCriterion cancelCriterion) {
        this.cancelled = true;
        this.signalAndWaitForDoOp(cancelCriterion);
    }

    public synchronized boolean isStarted() {
        return this.started;
    }
}

