/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminRegion;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CacheDisplay;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.cache.InternalCache;

public class RootRegionResponse
extends AdminResponse {
    private String[] regions;
    private String[] userAttrs;

    public static RootRegionResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        RootRegionResponse m = new RootRegionResponse();
        try {
            InternalCache cache = (InternalCache)CacheFactory.getInstance(dm.getSystem());
            Set<Region<?, ?>> roots = !Boolean.getBoolean("gemfire.PRDebug") ? cache.rootRegions() : cache.rootRegions(true);
            ArrayList<String> regionNames = new ArrayList<String>();
            ArrayList<Object> userAttributes = new ArrayList<Object>();
            for (Object e : roots) {
                Region r = (Region)e;
                regionNames.add(r.getName());
                userAttributes.add(CacheDisplay.getCachedObjectDisplay(r.getUserAttribute(), 100));
            }
            String[] temp = new String[]{};
            m.regions = regionNames.toArray(temp);
            m.userAttrs = userAttributes.toArray(temp);
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        m.setRecipient(recipient);
        return m;
    }

    public Region[] getRegions(RemoteGemFireVM vm) {
        if (this.regions.length > 0) {
            Region[] roots = new Region[this.regions.length];
            for (int i = 0; i < this.regions.length; ++i) {
                roots[i] = new AdminRegion(this.regions[i], vm, this.userAttrs[i]);
            }
            return roots;
        }
        return new Region[0];
    }

    @Override
    public int getDSFID() {
        return 1054;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.regions, out);
        DataSerializer.writeObject(this.userAttrs, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regions = (String[])DataSerializer.readObject(in);
        this.userAttrs = (String[])DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "RootRegionResponse from " + this.getRecipient();
    }
}

