/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.distributed.Locator;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.net.SocketCreator;

public class DistributionLocatorId
implements Serializable {
    private static final long serialVersionUID = 6587390186971937865L;
    private InetAddress host;
    private final int port;
    private final String bindAddress;
    private transient SSLConfig sslConfig;
    private boolean peerLocator = true;
    private boolean serverLocator = true;
    private String hostnameForClients;
    private String hostname;

    public DistributionLocatorId(InetAddress host, int port, String bindAddress, SSLConfig sslConfig) {
        this.host = host;
        this.port = port;
        this.bindAddress = this.validateBindAddress(bindAddress);
        this.sslConfig = this.validateSSLConfig(sslConfig);
    }

    public DistributionLocatorId(int port, String bindAddress) {
        this(port, bindAddress, null);
    }

    public DistributionLocatorId(int port, String bindAddress, String hostnameForClients) {
        try {
            this.host = SocketCreator.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new InternalGemFireException(LocalizedStrings.DistributionLocatorId_FAILED_GETTING_LOCAL_HOST.toLocalizedString(), ex);
        }
        this.port = port;
        this.bindAddress = this.validateBindAddress(bindAddress);
        this.sslConfig = this.validateSSLConfig(null);
        this.hostnameForClients = hostnameForClients;
    }

    public DistributionLocatorId(InetAddress host, int port, String bindAddress, SSLConfig sslConfig, String hostnameForClients) {
        this.host = host;
        this.port = port;
        this.bindAddress = this.validateBindAddress(bindAddress);
        this.sslConfig = this.validateSSLConfig(sslConfig);
        this.hostnameForClients = hostnameForClients;
    }

    public DistributionLocatorId(String marshalled) {
        int portStartIdx = marshalled.indexOf(91);
        int portEndIdx = marshalled.indexOf(93);
        if (portStartIdx < 0 || portEndIdx < portStartIdx) {
            throw new IllegalArgumentException(LocalizedStrings.DistributionLocatorId__0_IS_NOT_IN_THE_FORM_HOSTNAMEPORT.toLocalizedString(marshalled));
        }
        int bindIdx = marshalled.lastIndexOf(64);
        if (bindIdx < 0) {
            bindIdx = marshalled.lastIndexOf(58);
        }
        this.hostname = marshalled.substring(0, bindIdx > -1 ? bindIdx : portStartIdx);
        if (this.hostname.indexOf(58) >= 0) {
            bindIdx = marshalled.lastIndexOf(64);
            this.hostname = marshalled.substring(0, bindIdx > -1 ? bindIdx : portStartIdx);
        }
        try {
            this.host = InetAddress.getByName(this.hostname);
        }
        catch (UnknownHostException ex) {
            this.host = null;
        }
        try {
            this.port = Integer.parseInt(marshalled.substring(portStartIdx + 1, portEndIdx));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(LocalizedStrings.DistributionLocatorId_0_DOES_NOT_CONTAIN_A_VALID_PORT_NUMBER.toLocalizedString(marshalled));
        }
        this.bindAddress = bindIdx > -1 ? this.validateBindAddress(marshalled.substring(bindIdx + 1, portStartIdx)) : this.validateBindAddress("");
        this.sslConfig = this.validateSSLConfig(null);
        int optionsIndex = marshalled.indexOf(44);
        if (optionsIndex > 0) {
            String[] options = marshalled.substring(optionsIndex).split(",");
            for (int i = 0; i < options.length; ++i) {
                String[] optionFields = options[i].split("=");
                if (optionFields.length != 2 || optionFields[0].equalsIgnoreCase("peer") || optionFields[0].equalsIgnoreCase("server")) continue;
                if (optionFields[0].equalsIgnoreCase("hostname-for-clients")) {
                    this.hostnameForClients = optionFields[1];
                    continue;
                }
                throw new IllegalArgumentException(marshalled + " invalid option " + optionFields[0] + ". valid options are \"peer\", \"server\" and \"hostname-for-clients\"");
            }
        }
    }

    public DistributionLocatorId(InetAddress address, Locator locator) {
        this(address, locator.getPort(), locator.getBindAddress() == null ? null : locator.getBindAddress().getHostAddress(), null, locator.getHostnameForClients());
    }

    public String marshal() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.host.getHostAddress());
        if (!this.bindAddress.isEmpty()) {
            if (this.bindAddress.contains(":")) {
                sb.append('@');
            } else {
                sb.append(':');
            }
            sb.append(this.bindAddress);
        }
        sb.append('[').append(this.port).append(']');
        return sb.toString();
    }

    private SSLConfig validateSSLConfig(SSLConfig sslConfig) {
        if (sslConfig == null) {
            return new SSLConfig();
        }
        return sslConfig;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public void setSSLConfig(SSLConfig sslConfig) {
        this.sslConfig = this.validateSSLConfig(sslConfig);
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getHost() throws UnknownHostException {
        boolean isIpString;
        if (this.hostname != null && (isIpString = InetAddressValidator.getInstance().isValid(this.hostname))) {
            if (this.host == null) {
                this.host = InetAddress.getByName(this.hostname);
            }
            return new InetSocketAddress(this.host, this.port);
        }
        if (this.hostname == null) {
            if (this.host != null) {
                return new InetSocketAddress(this.host, this.port);
            }
            throw new UnknownHostException("locator ID has no hostname or resolved inet address");
        }
        return new InetSocketAddress(this.hostname, this.port);
    }

    public String getHostName() {
        if (this.hostname == null) {
            this.hostname = this.host.getHostName();
        }
        return this.hostname;
    }

    public boolean isMcastId() {
        return this.host.isMulticastAddress();
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getHostnameForClients() {
        return this.hostnameForClients;
    }

    private String validateBindAddress(String bindAddress) {
        if (bindAddress == null) {
            return "";
        }
        return bindAddress;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.hostnameForClients != null && this.hostnameForClients.length() > 0) {
            sb.append(this.hostnameForClients);
        } else if (this.bindAddress != null && this.bindAddress.length() > 0) {
            sb.append(this.bindAddress);
        } else if (this.isMcastId()) {
            sb.append(this.host.getHostAddress());
        } else {
            sb.append(SocketCreator.getHostName(this.host));
        }
        sb.append("[").append(this.port).append("]");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof DistributionLocatorId)) {
            return false;
        }
        DistributionLocatorId that = (DistributionLocatorId)other;
        if (!(this.host == that.host || this.host != null && this.host.equals(that.host))) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        return StringUtils.equals((String)this.bindAddress, (String)that.bindAddress);
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 37 * result + this.port;
        result = 37 * result + (this.bindAddress == null ? 0 : this.bindAddress.hashCode());
        return result;
    }

    public static Collection<DistributionLocatorId> asDistributionLocatorIds(Collection<Locator> locators) throws UnknownHostException {
        if (locators.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DistributionLocatorId> locatorIds = new ArrayList<DistributionLocatorId>();
        for (Locator locator : locators) {
            DistributionLocatorId locatorId = new DistributionLocatorId(SocketCreator.getLocalHost(), locator);
            locatorIds.add(locatorId);
        }
        return locatorIds;
    }

    public static Collection<String> asStrings(Collection<DistributionLocatorId> locatorIds) {
        if (locatorIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (DistributionLocatorId locatorId : locatorIds) {
            strings.add(locatorId.marshal());
        }
        return strings;
    }
}

