/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.remote.AddHealthListenerResponse;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class AddHealthListenerRequest
extends AdminRequest {
    private GemFireHealthConfig cfg;

    public static AddHealthListenerRequest create(GemFireHealthConfig cfg) {
        if (cfg == null) {
            throw new NullPointerException(LocalizedStrings.AddHealthListenerRequest_NULL_GEMFIREHEALTHCONFIG.toLocalizedString());
        }
        AddHealthListenerRequest m = new AddHealthListenerRequest();
        m.cfg = cfg;
        return m;
    }

    public AddHealthListenerRequest() {
        this.friendlyName = LocalizedStrings.AddHealthListenerRequest_ADD_HEALTH_LISTENER.toLocalizedString();
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return AddHealthListenerResponse.create(dm, this.getSender(), this.cfg);
    }

    @Override
    public int getDSFID() {
        return 1000;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.cfg, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.cfg = (GemFireHealthConfig)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "AddHealthListenerRequest from " + this.getRecipient() + " cfg=" + this.cfg;
    }
}

