/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.admin.remote.ClientHealthStats;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ClientStatsManager {
    private static InternalCache lastInitializedCache = null;
    private static Statistics cachePerfStats = null;
    private static Statistics vmStats = null;
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void publishClientStats(PoolImpl pool) {
        GemFireCacheImpl currentCache = GemFireCacheImpl.getInstance();
        if (!ClientStatsManager.initializeStatistics(currentCache)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Entering ClientStatsManager#publishClientStats...");
        }
        ClientHealthStats stats = ClientStatsManager.getClientHealthStats(currentCache, pool);
        try {
            InternalDistributedSystem ds = (InternalDistributedSystem)currentCache.getDistributedSystem();
            ServerRegionProxy regionProxy = new ServerRegionProxy("__ADMIN_CLIENT_HEALTH_MONITORING__", pool);
            EventID eventId = new EventID(ds);
            EntryEventImpl event = new EntryEventImpl((Object)null);
            try {
                event.setEventId(eventId);
                regionProxy.putForMetaRegion(ds.getDistributedMember(), stats, null, event, null, true);
            }
            finally {
                event.release();
            }
        }
        catch (DistributedSystemDisconnectedException e) {
            throw e;
        }
        catch (CacheWriterException cwx) {
            pool.getCancelCriterion().checkCancelInProgress(cwx);
            currentCache.getCancelCriterion().checkCancelInProgress(cwx);
            logger.warn((Object)LocalizedStrings.ClientStatsManager_FAILED_TO_SEND_CLIENT_HEALTH_STATS_TO_CACHESERVER, (Throwable)cwx);
        }
        catch (Exception e) {
            pool.getCancelCriterion().checkCancelInProgress(e);
            currentCache.getCancelCriterion().checkCancelInProgress(e);
            logger.info((Object)LocalizedStrings.ClientStatsManager_FAILED_TO_PUBLISH_CLIENT_STATISTICS, (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exiting ClientStatsManager#publishClientStats.");
        }
    }

    public static void cleanupForTests() {
        lastInitializedCache = null;
    }

    private static boolean initializeStatistics(InternalCache currentCache) {
        Statistics[] statistics;
        StatisticsType type;
        if (currentCache == null) {
            return false;
        }
        InternalDistributedSystem ds = (InternalDistributedSystem)currentCache.getDistributedSystem();
        if (currentCache.isClosed()) {
            return false;
        }
        boolean restart = lastInitializedCache != currentCache;
        lastInitializedCache = currentCache;
        if (restart) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)LocalizedStrings.ClientStatsManager_CLIENTSTATSMANAGER_INTIALIZING_THE_STATISTICS);
            }
            cachePerfStats = null;
            vmStats = null;
        }
        if (cachePerfStats == null && (type = ds.findType("CachePerfStats")) != null && (statistics = ds.findStatisticsByType(type)) != null && statistics.length > 0) {
            cachePerfStats = statistics[0];
        }
        if (vmStats == null && (type = ds.findType("VMStats")) != null && (statistics = ds.findStatisticsByType(type)) != null && statistics.length > 0) {
            vmStats = statistics[0];
        }
        if (cachePerfStats == null && restart) {
            logger.warn(LocalizedStrings.ClientStatsManager_CLIENTSTATSMANAGER_0_ARE_NOT_AVAILABLE.toLocalizedString("CachePerfStats"));
        }
        if (vmStats == null && restart) {
            logger.warn(LocalizedStrings.ClientStatsManager_CLIENTSTATSMANAGER_0_ARE_NOT_AVAILABLE.toLocalizedString("VMStats"));
        }
        return true;
    }

    private static ClientHealthStats getClientHealthStats(InternalCache currentCache, PoolImpl pool) {
        if (currentCache == null) {
            return null;
        }
        ClientHealthStats stats = new ClientHealthStats();
        int gets = -1;
        int puts = -1;
        int misses = -1;
        int cacheListenerCalls = -1;
        if (cachePerfStats != null) {
            gets = cachePerfStats.getInt("gets");
            puts = cachePerfStats.getInt("puts");
            misses = cachePerfStats.getInt("misses");
            cacheListenerCalls = cachePerfStats.getInt("cacheListenerCallsCompleted");
        }
        long processCpuTime = -1L;
        int threads = -1;
        int cpus = -1;
        if (vmStats != null) {
            processCpuTime = vmStats.getLong("processCpuTime");
            threads = vmStats.getInt("threads");
            cpus = vmStats.getInt("cpus");
        }
        stats.setNumOfGets(gets);
        stats.setNumOfPuts(puts);
        stats.setNumOfMisses(misses);
        stats.setNumOfCacheListenerCalls(cacheListenerCalls);
        stats.setProcessCpuTime(processCpuTime);
        stats.setNumOfThreads(threads);
        stats.setCpus(cpus);
        String poolName = pool.getName();
        try {
            HashMap<String, String> newPoolStats = stats.getPoolStats();
            String poolStatsStr = "MinConnections=" + pool.getMinConnections() + ";MaxConnections=" + pool.getMaxConnections() + ";Redundancy=" + pool.getSubscriptionRedundancy() + ";CQS=" + pool.getQueryService().getCqs().length;
            logger.debug("ClientHealthStats for poolName " + poolName + " poolStatsStr=" + poolStatsStr);
            newPoolStats.put(poolName, poolStatsStr);
        }
        catch (Exception e) {
            logger.debug("Exception in getting pool stats in  getClientHealthStats " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        stats.setUpdateTime(new Date());
        return stats;
    }
}

