/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSEncryptionCipherPool;

public final class GMSEncrypt {
    private static final BigInteger dhP = new BigInteger("135287020639910739997189928970717021771311421882765429190887700940242697307989907008041927806610978529253822307916592536509818186767394634756714063947534092593553024224277712367371302394452615862654308111809029797196494501056604787763641987260783383085570220968104473500348898008043285865193451061481841186553");
    private static final BigInteger dhG = new BigInteger("130583456807197150961665134075139695376245536366239321690167044250081505657615277976871655435431431908701485776974110415733273525810283593126577393912282416840649805564834470583437473176415335737232689814802018696718110109967325936556664646275595822588612548788965341273697569202082715873518528062345259949959");
    private static final int dhL = 1023;
    private final PrivateKey dhPrivateKey;
    private final PublicKey dhPublicKey;
    private final String dhSKAlgo;
    private Services services;
    private NetView view;
    private final Map<InternalDistributedMember.InternalDistributedMemberWrapper, byte[]> memberToPublicKey = new ConcurrentHashMap<InternalDistributedMember.InternalDistributedMemberWrapper, byte[]>();
    private final ConcurrentHashMap<InternalDistributedMember, GMSEncryptionCipherPool> peerEncryptors = new ConcurrentHashMap();
    private GMSEncryptionCipherPool clusterEncryptor;

    protected void installView(NetView view) {
        this.view = view;
        this.view.setPublicKey(this.services.getJoinLeave().getMemberID(), this.getPublicKeyBytes());
    }

    void overrideInstallViewForTest(NetView view) {
        this.view = view;
    }

    protected byte[] getClusterSecretKey() {
        if (this.clusterEncryptor != null) {
            return this.clusterEncryptor.getSecretBytes();
        }
        return null;
    }

    protected synchronized void initClusterSecretKey() throws Exception {
        if (this.clusterEncryptor == null) {
            this.clusterEncryptor = new GMSEncryptionCipherPool(this, this.generateSecret(this.dhPublicKey));
        }
    }

    protected synchronized void setClusterKey(byte[] secretBytes) {
        this.clusterEncryptor = new GMSEncryptionCipherPool(this, secretBytes);
    }

    private byte[] getPublicKeyIfIAmLocator(InternalDistributedMember mbr) {
        return this.services.getPublicKey(mbr);
    }

    GMSEncrypt(Services services, String dhSKAlgo) throws Exception {
        this.services = services;
        this.dhSKAlgo = dhSKAlgo;
        if (this.dhSKAlgo != null && this.dhSKAlgo.length() > 0) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH");
            DHParameterSpec dhSpec = new DHParameterSpec(dhP, dhG, 1023);
            keyGen.initialize(dhSpec);
            KeyPair keypair = keyGen.generateKeyPair();
            this.dhPrivateKey = keypair.getPrivate();
            this.dhPublicKey = keypair.getPublic();
        } else {
            this.dhPrivateKey = null;
            this.dhPublicKey = null;
        }
    }

    byte[] decryptData(byte[] data, InternalDistributedMember member) throws Exception {
        return this.getPeerEncryptor(member).decryptBytes(data);
    }

    byte[] encryptData(byte[] data, InternalDistributedMember member) throws Exception {
        return this.getPeerEncryptor(member).encryptBytes(data);
    }

    byte[] decryptData(byte[] data) throws Exception {
        return this.clusterEncryptor.decryptBytes(data);
    }

    byte[] decryptData(byte[] data, byte[] pkBytes) throws Exception {
        GMSEncryptionCipherPool encryptor = new GMSEncryptionCipherPool(this, this.generateSecret(pkBytes));
        return encryptor.decryptBytes(data);
    }

    byte[] encryptData(byte[] data) throws Exception {
        return this.clusterEncryptor.encryptBytes(data);
    }

    byte[] getPublicKeyBytes() {
        return this.dhPublicKey.getEncoded();
    }

    private byte[] lookupKeyByMember(InternalDistributedMember member) {
        byte[] pk = this.memberToPublicKey.get(new InternalDistributedMember.InternalDistributedMemberWrapper(member));
        if (pk == null) {
            pk = this.getPublicKeyIfIAmLocator(member);
        }
        if (pk == null) {
            pk = (byte[])this.view.getPublicKey(member);
        }
        return pk;
    }

    protected byte[] getPublicKey(InternalDistributedMember member) {
        try {
            InternalDistributedMember localMbr = this.services.getMessenger().getMemberID();
            if (localMbr != null && localMbr.equals(member)) {
                return this.dhPublicKey.getEncoded();
            }
            return this.lookupKeyByMember(member);
        }
        catch (Exception e) {
            throw new RuntimeException("Not found public key for member " + member, e);
        }
    }

    protected void setPublicKey(byte[] publickey, InternalDistributedMember mbr) {
        try {
            this.memberToPublicKey.put(new InternalDistributedMember.InternalDistributedMemberWrapper(mbr), publickey);
            this.peerEncryptors.replace(mbr, new GMSEncryptionCipherPool(this, this.generateSecret(publickey)));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create peer encryptor " + mbr, e);
        }
    }

    private GMSEncryptionCipherPool getPeerEncryptor(InternalDistributedMember member) throws Exception {
        return this.peerEncryptors.computeIfAbsent(member, mbr -> {
            try {
                return new GMSEncryptionCipherPool(this, this.generateSecret(this.lookupKeyByMember(member)));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private static int getKeySize(String skAlgo) {
        String algoStr;
        int colIdx = skAlgo.indexOf(58);
        int algoKeySize = 0;
        if (colIdx >= 0) {
            algoStr = skAlgo.substring(0, colIdx);
            algoKeySize = Integer.parseInt(skAlgo.substring(colIdx + 1));
        } else {
            algoStr = skAlgo;
        }
        int keysize = -1;
        if (algoStr.equalsIgnoreCase("DESede")) {
            keysize = 24;
        } else if (algoStr.equalsIgnoreCase("Blowfish")) {
            keysize = algoKeySize > 128 ? algoKeySize / 8 : 16;
        } else if (algoStr.equalsIgnoreCase("AES")) {
            keysize = algoKeySize != 192 && algoKeySize != 256 ? 16 : algoKeySize / 8;
        }
        return keysize;
    }

    private static String getDhAlgoStr(String skAlgo) {
        int colIdx = skAlgo.indexOf(58);
        String algoStr = colIdx >= 0 ? skAlgo.substring(0, colIdx) : skAlgo;
        return algoStr;
    }

    private static int getBlockSize(String skAlgo) {
        int blocksize = -1;
        String algoStr = GMSEncrypt.getDhAlgoStr(skAlgo);
        if (algoStr.equalsIgnoreCase("DESede")) {
            blocksize = 8;
        } else if (algoStr.equalsIgnoreCase("Blowfish")) {
            blocksize = 8;
        } else if (algoStr.equalsIgnoreCase("AES")) {
            blocksize = 16;
        }
        return blocksize;
    }

    Cipher getEncryptCipher(byte[] secretBytes) throws Exception {
        Cipher encrypt = null;
        int keysize = GMSEncrypt.getKeySize(this.dhSKAlgo);
        int blocksize = GMSEncrypt.getBlockSize(this.dhSKAlgo);
        if (keysize == -1 || blocksize == -1) {
            SecretKeySpec sks = new SecretKeySpec(secretBytes, this.dhSKAlgo);
            encrypt = Cipher.getInstance(this.dhSKAlgo);
            encrypt.init(1, sks);
        } else {
            String dhAlgoStr = GMSEncrypt.getDhAlgoStr(this.dhSKAlgo);
            SecretKeySpec sks = new SecretKeySpec(secretBytes, 0, keysize, dhAlgoStr);
            IvParameterSpec ivps = new IvParameterSpec(secretBytes, keysize, blocksize);
            encrypt = Cipher.getInstance(dhAlgoStr + "/CBC/PKCS5Padding");
            encrypt.init(1, (Key)sks, ivps);
        }
        return encrypt;
    }

    Cipher getDecryptCipher(byte[] secretBytes) throws Exception {
        Cipher decrypt;
        int keysize = GMSEncrypt.getKeySize(this.dhSKAlgo);
        int blocksize = GMSEncrypt.getBlockSize(this.dhSKAlgo);
        if (keysize == -1 || blocksize == -1) {
            SecretKeySpec sks = new SecretKeySpec(secretBytes, this.dhSKAlgo);
            decrypt = Cipher.getInstance(this.dhSKAlgo);
            decrypt.init(2, sks);
        } else {
            String algoStr = GMSEncrypt.getDhAlgoStr(this.dhSKAlgo);
            SecretKeySpec sks = new SecretKeySpec(secretBytes, 0, keysize, algoStr);
            IvParameterSpec ivps = new IvParameterSpec(secretBytes, keysize, blocksize);
            decrypt = Cipher.getInstance(algoStr + "/CBC/PKCS5Padding");
            decrypt.init(2, (Key)sks, ivps);
        }
        return decrypt;
    }

    private byte[] generateSecret(byte[] peerKeyBytes) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(peerKeyBytes);
        KeyFactory keyFact = KeyFactory.getInstance("DH");
        PublicKey peerKey = keyFact.generatePublic(x509KeySpec);
        return GMSEncrypt.generateSecret(this.dhSKAlgo, this.dhPrivateKey, peerKey);
    }

    private byte[] generateSecret(PublicKey peerKey) throws Exception {
        return GMSEncrypt.generateSecret(this.dhSKAlgo, this.dhPrivateKey, peerKey);
    }

    private static byte[] generateSecret(String dhSKAlgo, PrivateKey privateKey, PublicKey otherPublicKey) throws Exception {
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(privateKey);
        ka.doPhase(otherPublicKey, true);
        int keysize = GMSEncrypt.getKeySize(dhSKAlgo);
        int blocksize = GMSEncrypt.getBlockSize(dhSKAlgo);
        if (keysize == -1 || blocksize == -1) {
            SecretKey sKey = ka.generateSecret(dhSKAlgo);
            return sKey.getEncoded();
        }
        return ka.generateSecret();
    }
}

