/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.distributed.internal.membership.gms.membership.HostAddress;
import org.apache.geode.internal.net.SocketCreator;

public class GMSUtil {
    public static List<HostAddress> parseLocators(String locatorsString, String bindAddress) {
        InetAddress addr = null;
        try {
            addr = bindAddress == null || bindAddress.trim().length() == 0 ? SocketCreator.getLocalHost() : InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return GMSUtil.parseLocators(locatorsString, addr);
    }

    public static List<HostAddress> parseLocators(String locatorsString, InetAddress bindAddress) {
        ArrayList<HostAddress> result = new ArrayList<HostAddress>(2);
        boolean checkLoopback = bindAddress != null;
        boolean isLoopback = checkLoopback && bindAddress.isLoopbackAddress();
        StringTokenizer parts = new StringTokenizer(locatorsString, ",");
        while (parts.hasMoreTokens()) {
            try {
                String start;
                String str = parts.nextToken();
                String host = str.substring(0, str.indexOf(91));
                int idx = host.lastIndexOf(64);
                if (idx < 0) {
                    idx = host.lastIndexOf(58);
                }
                if ((start = host.substring(0, idx > -1 ? idx : host.length())).indexOf(58) >= 0) {
                    idx = host.lastIndexOf(64);
                }
                if (idx >= 0) {
                    host = host.substring(idx + 1, host.length());
                }
                int startIdx = str.indexOf(91) + 1;
                int endIdx = str.indexOf(93);
                int port = Integer.parseInt(str.substring(startIdx, endIdx));
                InetSocketAddress isa = new InetSocketAddress(host, port);
                if (checkLoopback && isLoopback && !isa.getAddress().isLoopbackAddress()) {
                    throw new GemFireConfigException("This process is attempting to join with a loopback address (" + bindAddress + ") using a locator that does not have a local address (" + isa + ").  On Unix this usually means that /etc/hosts is misconfigured.");
                }
                HostAddress la = new HostAddress(isa, host);
                result.add(la);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public static String replaceStrings(String properties, String property, String value) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int index = properties.indexOf(property);
        while (index != -1) {
            sb.append(properties.substring(start, index));
            sb.append(value);
            start = index + property.length();
            index = properties.indexOf(property, start);
        }
        sb.append(properties.substring(start));
        return sb.toString();
    }

    public static String formatBytes(byte[] buf, int startIndex, int length) {
        StringBuilder w = new StringBuilder(20000);
        int count = 0;
        int i = startIndex;
        while (i < length) {
            String s = Integer.toHexString(buf[i] & 0xFF);
            if (s.length() == 1) {
                w.append('0');
            }
            w.append(s).append(' ');
            if (count % 50 == 49) {
                w.append("\n");
            }
            ++i;
            ++count;
        }
        return w.toString();
    }
}

