/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.deadlock;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.distributed.internal.deadlock.DLockDependencyMonitor;
import org.apache.geode.distributed.internal.deadlock.Dependency;
import org.apache.geode.distributed.internal.deadlock.DependencyMonitor;
import org.apache.geode.internal.CopyOnWriteHashSet;

public class DependencyMonitorManager {
    private static Set<DependencyMonitor> monitors = new CopyOnWriteHashSet<DependencyMonitor>();

    public static void addMonitor(DependencyMonitor monitor) {
        monitors.add(monitor);
    }

    public static void removeMonitor(DependencyMonitor monitor) {
        monitors.remove(monitor);
    }

    public static Set<Dependency<Thread, Serializable>> getBlockedThreads() {
        HashSet<Dependency<Thread, Serializable>> blockedThreads = new HashSet<Dependency<Thread, Serializable>>();
        Thread[] allThreads = DependencyMonitorManager.getAllThreads();
        for (DependencyMonitor monitor : monitors) {
            blockedThreads.addAll(monitor.getBlockedThreads(allThreads));
        }
        return blockedThreads;
    }

    public static Set<Dependency<Serializable, Thread>> getHeldResources() {
        Thread[] allThreads = DependencyMonitorManager.getAllThreads();
        HashSet<Dependency<Serializable, Thread>> heldResources = new HashSet<Dependency<Serializable, Thread>>();
        for (DependencyMonitor monitor : monitors) {
            heldResources.addAll(monitor.getHeldResources(allThreads));
        }
        return heldResources;
    }

    public static Thread[] getAllThreads() {
        Map<Thread, StackTraceElement[]> allStacks = Thread.getAllStackTraces();
        Thread[] results = new Thread[allStacks.size()];
        results = allStacks.keySet().toArray(results);
        return results;
    }

    static {
        DependencyMonitorManager.addMonitor(DLockDependencyMonitor.INSTANCE);
    }
}

