/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CollectingReplyProcessor<T>
extends ReplyProcessor21 {
    private Map<InternalDistributedMember, T> results = new HashMap<InternalDistributedMember, T>();

    public CollectingReplyProcessor(DistributionManager dm, Collection initMembers) {
        super(dm, initMembers);
    }

    @Override
    protected void process(DistributionMessage msg, boolean warn) {
        if (msg instanceof ReplyMessage) {
            InternalDistributedSystem.getLoggerI18n().info(LocalizedStrings.DEBUG, "processing message with return value " + ((ReplyMessage)msg).getReturnValue());
            this.results.put(msg.getSender(), ((ReplyMessage)msg).getReturnValue());
        }
        super.process(msg, warn);
    }

    public Map<InternalDistributedMember, T> getResults() {
        return this.results;
    }
}

