/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.NotSerializableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.IncompatibleSystemException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.SystemFailure;
import org.apache.geode.ToDataException;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionMessageObserver;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.FunctionExecutionPooledExecutor;
import org.apache.geode.distributed.internal.HealthMonitor;
import org.apache.geode.distributed.internal.HealthMonitorImpl;
import org.apache.geode.distributed.internal.HighPriorityAckedMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.OverflowQueueWithDMStats;
import org.apache.geode.distributed.internal.PooledExecutorWithDMStats;
import org.apache.geode.distributed.internal.SerialQueuedExecutorWithDMStats;
import org.apache.geode.distributed.internal.ShutdownMessage;
import org.apache.geode.distributed.internal.StartupMessage;
import org.apache.geode.distributed.internal.StartupOperation;
import org.apache.geode.distributed.internal.StartupResponseMessage;
import org.apache.geode.distributed.internal.ThrottlingMemLinkedQueueWithDMStats;
import org.apache.geode.distributed.internal.locks.ElderState;
import org.apache.geode.distributed.internal.membership.DistributedMembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MemberFactory;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.SetUtils;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.admin.remote.AdminConsoleDisconnectMessage;
import org.apache.geode.internal.admin.remote.RemoteGfManagerAgent;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.AlertAppender;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.monitoring.ThreadsMonitoringImpl;
import org.apache.geode.internal.monitoring.ThreadsMonitoringImplDummy;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.sequencelog.MembershipLogger;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.tcp.ReenteredConnectException;
import org.apache.geode.internal.util.concurrent.StoppableReentrantLock;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ClusterDistributionManager
implements DistributionManager {
    private static final Logger logger = LogService.getLogger();
    private static final int STARTUP_TIMEOUT = Integer.getInteger("DistributionManager.STARTUP_TIMEOUT", 15000);
    private static final boolean DEBUG_NO_ACKNOWLEDGEMENTS = Boolean.getBoolean("DistributionManager.DEBUG_NO_ACKNOWLEDGEMENTS");
    private static final int MAX_STOP_TIME = 20000;
    private static final int STOP_PAUSE_TIME = 1000;
    private static final int MAX_STOP_ATTEMPTS = 10;
    private static final boolean SYNC_EVENTS = Boolean.getBoolean("DistributionManager.syncEvents");
    private static final boolean MULTI_SERIAL_EXECUTORS = !Boolean.getBoolean("DistributionManager.singleSerialExecutor");
    private static final int MAX_WAITING_THREADS = Integer.getInteger("DistributionManager.MAX_WAITING_THREADS", Integer.MAX_VALUE);
    private static final int MAX_PR_META_DATA_CLEANUP_THREADS = Integer.getInteger("DistributionManager.MAX_PR_META_DATA_CLEANUP_THREADS", 1);
    public static final int MAX_THREADS = Integer.getInteger("DistributionManager.MAX_THREADS", 100);
    private static final int MAX_PR_THREADS = Integer.getInteger("DistributionManager.MAX_PR_THREADS", Math.max(Runtime.getRuntime().availableProcessors() * 4, 16));
    private static final int MAX_FE_THREADS = Integer.getInteger("DistributionManager.MAX_FE_THREADS", Math.max(Runtime.getRuntime().availableProcessors() * 4, 16));
    private static final int INCOMING_QUEUE_LIMIT = Integer.getInteger("DistributionManager.INCOMING_QUEUE_LIMIT", 80000);
    private static final double THROTTLE_PERCENT = (double)Integer.getInteger("DistributionManager.SERIAL_QUEUE_THROTTLE_PERCENT", 75).intValue() / 100.0;
    static final int SERIAL_QUEUE_BYTE_LIMIT = Integer.getInteger("DistributionManager.SERIAL_QUEUE_BYTE_LIMIT", 0x2800000);
    static final int SERIAL_QUEUE_THROTTLE = Integer.getInteger("DistributionManager.SERIAL_QUEUE_THROTTLE", (int)((double)SERIAL_QUEUE_BYTE_LIMIT * THROTTLE_PERCENT));
    static final int TOTAL_SERIAL_QUEUE_BYTE_LIMIT = Integer.getInteger("DistributionManager.TOTAL_SERIAL_QUEUE_BYTE_LIMIT", 0x5000000);
    static final int TOTAL_SERIAL_QUEUE_THROTTLE = Integer.getInteger("DistributionManager.TOTAL_SERIAL_QUEUE_THROTTLE", (int)((double)SERIAL_QUEUE_BYTE_LIMIT * THROTTLE_PERCENT));
    static final int SERIAL_QUEUE_SIZE_LIMIT = Integer.getInteger("DistributionManager.SERIAL_QUEUE_SIZE_LIMIT", 20000);
    static final int SERIAL_QUEUE_SIZE_THROTTLE = Integer.getInteger("DistributionManager.SERIAL_QUEUE_SIZE_THROTTLE", (int)((double)SERIAL_QUEUE_SIZE_LIMIT * THROTTLE_PERCENT));
    static final int MAX_SERIAL_QUEUE_THREAD = Integer.getInteger("DistributionManager.MAX_SERIAL_QUEUE_THREAD", 20);
    public static final int NORMAL_DM_TYPE = 10;
    public static final int LOCATOR_DM_TYPE = 11;
    public static final int ADMIN_ONLY_DM_TYPE = 12;
    public static final int LONER_DM_TYPE = 13;
    public static final int STANDARD_EXECUTOR = 73;
    public static final int SERIAL_EXECUTOR = 74;
    public static final int HIGH_PRIORITY_EXECUTOR = 75;
    public static final int WAITING_POOL_EXECUTOR = 77;
    public static final int PARTITIONED_REGION_EXECUTOR = 78;
    public static final int VIEW_EXECUTOR = 79;
    public static final int REGION_FUNCTION_EXECUTION_EXECUTOR = 80;
    private static volatile boolean isDedicatedAdminVM = false;
    private static ThreadLocal<Boolean> isStartupThread = new ThreadLocal();
    private static final InheritableThreadLocal<Boolean> isFunctionExecutionThread = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final Object elderMonitor = new Object();
    private boolean waitingForElderChange = false;
    private boolean adam = false;
    protected volatile InternalDistributedMember elder = null;
    private final InternalDistributedMember localAddress;
    private final int dmType;
    private final ConcurrentMap<MembershipListener, Boolean> membershipListeners;
    private volatile Set<MembershipListener> allMembershipListeners = Collections.emptySet();
    private final Object allMembershipListenersLock = new Object();
    private final BlockingQueue<MemberEvent> membershipEventQueue = new LinkedBlockingQueue<MemberEvent>();
    private Thread memberEventThread;
    protected final String description;
    protected final DistributionStats stats;
    private boolean exceptionInThreads;
    private volatile boolean shutdownMsgSent = false;
    private volatile boolean closeInProgress = false;
    private volatile boolean receivedStartupResponse = false;
    private volatile String rejectionMessage = null;
    private MembershipManager membershipManager;
    private Map<InternalDistributedMember, InternalDistributedMember> members = Collections.emptyMap();
    private Set<InternalDistributedMember> membersAndAdmin = Collections.emptySet();
    private Map<InternalDistributedMember, Collection<String>> hostedLocatorsAll = Collections.emptyMap();
    private Map<InternalDistributedMember, Collection<String>> hostedLocatorsWithSharedConfiguration = Collections.emptyMap();
    private final Object membersLock = new Object();
    private final Object adminConsolesLock = new Object();
    private volatile Set<InternalDistributedMember> adminConsoles = Collections.emptySet();
    protected LoggingThreadGroup threadGroup;
    private ThreadPoolExecutor threadPool;
    private ThreadPoolExecutor highPriorityPool;
    private ThreadPoolExecutor waitingPool;
    private ThreadPoolExecutor prMetaDataCleanupThreadPool;
    private ThreadPoolExecutor partitionedRegionThread;
    private ThreadPoolExecutor partitionedRegionPool;
    private ThreadPoolExecutor functionExecutionThread;
    private ThreadPoolExecutor functionExecutionPool;
    private ThreadPoolExecutor serialThread;
    private ThreadPoolExecutor viewThread;
    private ThrottlingMemLinkedQueueWithDMStats<Runnable> serialQueue;
    private final ThreadsMonitoring threadMonitor;
    private volatile boolean readyForMessages = false;
    private volatile boolean readyToSendMsgs = false;
    private final Object readyToSendMsgsLock = new Object();
    private volatile boolean closed = false;
    private InternalDistributedSystem system;
    private RemoteTransportConfig transport;
    private volatile RemoteGfManagerAgent agent;
    private SerialQueuedExecutorPool serialQueuedExecutorPool;
    private final Semaphore parallelGIIs = new Semaphore(InitialImageOperation.MAX_PARALLEL_GIIS);
    private final HashMap<InetAddress, Set<InetAddress>> equivalentHosts = new HashMap();
    private int distributedSystemId = -1;
    private final Map<InternalDistributedMember, String> redundancyZones = Collections.synchronizedMap(new HashMap());
    private boolean enforceUniqueZone = false;
    private volatile Throwable rootCause = null;
    private final Object shutdownMutex = new Object();
    private volatile boolean shutdownInProgress = false;
    private final Object membershipViewIdGuard = new Object();
    private long membershipViewIdAcknowledged;
    private Set<InternalDistributedMember> unfinishedStartups = null;
    private final Object unfinishedStartupsLock = new Object();
    private final StoppableReentrantLock elderLock;
    private ElderState elderState;
    private volatile boolean elderStateInitialized;
    private final ConcurrentMap<InternalDistributedMember, HealthMonitor> hmMap = new ConcurrentHashMap<InternalDistributedMember, HealthMonitor>();
    private volatile InternalCache cache;
    private final Stopper stopper = new Stopper(this);

    public static Boolean isFunctionExecutionThread() {
        return (Boolean)isFunctionExecutionThread.get();
    }

    static ClusterDistributionManager create(InternalDistributedSystem system) {
        ClusterDistributionManager distributionManager = null;
        boolean beforeJoined = true;
        try {
            int vmKind = Boolean.getBoolean("Locator.forceLocatorDMType") ? 11 : (ClusterDistributionManager.isDedicatedAdminVM() ? 12 : 10);
            RemoteTransportConfig transport = new RemoteTransportConfig(system.getConfig(), vmKind);
            transport.setIsReconnectingDS(system.isReconnectingDS());
            transport.setOldDSMembershipInfo(system.oldDSMembershipInfo());
            long start = System.currentTimeMillis();
            distributionManager = new ClusterDistributionManager(system, transport);
            distributionManager.assertDistributionManagerType();
            beforeJoined = false;
            InternalDistributedMember id = distributionManager.getDistributionManagerId();
            if (!"".equals(id.getName())) {
                for (InternalDistributedMember m : distributionManager.getViewMembers()) {
                    if (m.equals(id)) break;
                    if (!id.getName().equals(m.getName()) || !distributionManager.getMembershipManager().verifyMember(m, "member is using the name of " + id)) continue;
                    throw new IncompatibleSystemException("Member " + id + " could not join this distributed system because the existing member " + m + " used the same name. Set the \"name\" gemfire property to a unique value.");
                }
            }
            distributionManager.addNewMember(id);
            distributionManager.selectElder();
            StartupOperation op = new StartupOperation(distributionManager, transport);
            try {
                if (!distributionManager.sendStartupMessage(op)) {
                    if (distributionManager.getOtherDistributionManagerIds().size() == 0) {
                        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_DIDNT_HEAR_BACK_FROM_ANY_OTHER_SYSTEM_I_AM_THE_FIRST_ONE));
                    } else if (transport.isMcastEnabled() && !distributionManager.testMulticast()) {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_RECEIVED_NO_STARTUP_RESPONSES_BUT_OTHER_MEMBERS_EXIST_MULTICAST_IS_NOT_RESPONSIVE));
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new InternalGemFireException(LocalizedStrings.DistributionManager_INTERRUPTED_WHILE_WAITING_FOR_FIRST_STARTUPRESPONSEMESSAGE.toLocalizedString(), ex);
            }
            catch (IncompatibleSystemException ex) {
                logger.fatal(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            finally {
                distributionManager.readyToSendMsgs();
            }
            if (logger.isInfoEnabled()) {
                long delta = System.currentTimeMillis() - start;
                Object[] objectArray = new Object[6];
                objectArray[0] = distributionManager.getDistributionManagerId();
                objectArray[1] = transport;
                objectArray[2] = distributionManager.getOtherDistributionManagerIds().size();
                objectArray[3] = distributionManager.getOtherDistributionManagerIds();
                Object object = objectArray[4] = logger.isInfoEnabled(LogMarker.DM_MARKER) ? " (VERBOSE, took " + delta + " ms)" : "";
                objectArray[5] = distributionManager.getDMType() == 12 ? " (admin only)" : (distributionManager.getDMType() == 11 ? " (locator)" : "");
                Object[] logArgs = objectArray;
                logger.info(LogMarker.DM_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_DISTRIBUTIONMANAGER_0_STARTED_ON_1_THERE_WERE_2_OTHER_DMS_3_4_5, logArgs));
                MembershipLogger.logStartup(distributionManager.getDistributionManagerId());
            }
            return distributionManager;
        }
        catch (RuntimeException r) {
            if (distributionManager != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("cleaning up incompletely started DistributionManager due to exception", (Throwable)r);
                }
                super.uncleanShutdown(beforeJoined);
            }
            throw r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterDistributionManager(RemoteTransportConfig transport, InternalDistributedSystem system) {
        LoggingThreadGroup group;
        this.dmType = transport.getVmKind();
        this.system = system;
        this.elderLock = new StoppableReentrantLock(this.stopper);
        this.transport = transport;
        this.membershipListeners = new ConcurrentHashMap<MembershipListener, Boolean>();
        this.distributedSystemId = system.getConfig().getDistributedSystemId();
        long statId = OSProcess.getId();
        this.stats = new DistributionStats(system, statId);
        DistributionStats.enableClockStats = system.getConfig().getEnableTimeStatistics();
        this.exceptionInThreads = false;
        this.threadGroup = group = LoggingThreadGroup.createThreadGroup("DistributionManager Threads", logger);
        Properties nonDefault = new Properties();
        DistributionConfigImpl distributionConfigImpl = new DistributionConfigImpl(nonDefault);
        if (distributionConfigImpl.getThreadMonitorEnabled()) {
            this.threadMonitor = new ThreadsMonitoringImpl(system);
            logger.info("[ThreadsMonitor] a New Monitor object and process were created.\n");
        } else {
            this.threadMonitor = new ThreadsMonitoringImplDummy();
            logger.info("[ThreadsMonitor] Monitoring is disabled and will not be run.\n");
        }
        boolean finishedConstructor = false;
        try {
            OverflowQueueWithDMStats<Runnable> poolQueue;
            if (MULTI_SERIAL_EXECUTORS) {
                if (logger.isInfoEnabled(LogMarker.DM_MARKER)) {
                    logger.info(LogMarker.DM_MARKER, "Serial Queue info : THROTTLE_PERCENT: " + THROTTLE_PERCENT + " SERIAL_QUEUE_BYTE_LIMIT :" + SERIAL_QUEUE_BYTE_LIMIT + " SERIAL_QUEUE_THROTTLE :" + SERIAL_QUEUE_THROTTLE + " TOTAL_SERIAL_QUEUE_BYTE_LIMIT :" + TOTAL_SERIAL_QUEUE_BYTE_LIMIT + " TOTAL_SERIAL_QUEUE_THROTTLE :" + TOTAL_SERIAL_QUEUE_THROTTLE + " SERIAL_QUEUE_SIZE_LIMIT :" + SERIAL_QUEUE_SIZE_LIMIT + " SERIAL_QUEUE_SIZE_THROTTLE :" + SERIAL_QUEUE_SIZE_THROTTLE);
                }
                boolean throttlingDisabled = system.getConfig().getDisableTcp();
                this.serialQueuedExecutorPool = new SerialQueuedExecutorPool(this.threadGroup, this.stats, throttlingDisabled, this.threadMonitor);
            }
            if (SERIAL_QUEUE_BYTE_LIMIT == 0) {
                poolQueue = new OverflowQueueWithDMStats<Runnable>(this.stats.getSerialQueueHelper());
            } else {
                this.serialQueue = new ThrottlingMemLinkedQueueWithDMStats(TOTAL_SERIAL_QUEUE_BYTE_LIMIT, TOTAL_SERIAL_QUEUE_THROTTLE, SERIAL_QUEUE_SIZE_LIMIT, SERIAL_QUEUE_SIZE_THROTTLE, this.stats.getSerialQueueHelper());
                poolQueue = this.serialQueue;
            }
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable command) {
                    ClusterDistributionManager.this.stats.incSerialThreadStarts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ClusterDistributionManager.this.stats.incNumSerialThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                ClusterDistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                ClusterDistributionManager.this.stats.incNumSerialThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_SERIAL_MESSAGE_PROCESSOR.toLocalizedString());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            this.serialThread = new SerialQueuedExecutorWithDMStats(poolQueue, this.stats.getSerialProcessorHelper(), tf, this.threadMonitor);
            LinkedBlockingQueue q = new LinkedBlockingQueue();
            tf = new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable command) {
                    ClusterDistributionManager.this.stats.incViewThreadStarts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ClusterDistributionManager.this.stats.incNumViewThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                ClusterDistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                ClusterDistributionManager.this.stats.incNumViewThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_VIEW_MESSAGE_PROCESSOR.toLocalizedString());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            this.viewThread = new SerialQueuedExecutorWithDMStats(q, this.stats.getViewProcessorHelper(), tf, this.threadMonitor);
            poolQueue = INCOMING_QUEUE_LIMIT == 0 ? new OverflowQueueWithDMStats(this.stats.getOverflowQueueHelper()) : new OverflowQueueWithDMStats(INCOMING_QUEUE_LIMIT, this.stats.getOverflowQueueHelper());
            tf = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    ClusterDistributionManager.this.stats.incProcessingThreadStarts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ClusterDistributionManager.this.stats.incNumProcessingThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                ClusterDistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                ClusterDistributionManager.this.stats.incNumProcessingThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_POOLED_MESSAGE_PROCESSOR.toLocalizedString() + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            this.threadPool = new PooledExecutorWithDMStats(poolQueue, MAX_THREADS, this.stats.getNormalPoolHelper(), tf, this.threadMonitor);
            poolQueue = INCOMING_QUEUE_LIMIT == 0 ? new OverflowQueueWithDMStats(this.stats.getHighPriorityQueueHelper()) : new OverflowQueueWithDMStats(INCOMING_QUEUE_LIMIT, this.stats.getHighPriorityQueueHelper());
            tf = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    ClusterDistributionManager.this.stats.incHighPriorityThreadStarts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ClusterDistributionManager.this.stats.incHighPriorityThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                ClusterDistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                ClusterDistributionManager.this.stats.incHighPriorityThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_POOLED_HIGH_PRIORITY_MESSAGE_PROCESSOR.toLocalizedString() + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            this.highPriorityPool = new PooledExecutorWithDMStats(poolQueue, MAX_THREADS, this.stats.getHighPriorityPoolHelper(), tf, this.threadMonitor);
            ThreadFactory tf2 = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    ClusterDistributionManager.this.stats.incWaitingThreadStarts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ClusterDistributionManager.this.stats.incWaitingThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                ClusterDistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                ClusterDistributionManager.this.stats.incWaitingThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_POOLED_WAITING_MESSAGE_PROCESSOR.toLocalizedString() + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            AbstractQueue poolQueue2 = MAX_WAITING_THREADS == Integer.MAX_VALUE ? new SynchronousQueue() : new OverflowQueueWithDMStats(this.stats.getWaitingQueueHelper());
            this.waitingPool = new PooledExecutorWithDMStats((BlockingQueue<Runnable>)((Object)poolQueue2), MAX_WAITING_THREADS, this.stats.getWaitingPoolHelper(), tf2, this.threadMonitor);
            tf2 = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    ClusterDistributionManager.this.stats.incWaitingThreadStarts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ClusterDistributionManager.this.stats.incWaitingThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                ClusterDistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                ClusterDistributionManager.this.stats.incWaitingThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_PR_META_DATA_CLEANUP_MESSAGE_PROCESSOR.toLocalizedString() + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            poolQueue2 = new OverflowQueueWithDMStats(this.stats.getWaitingQueueHelper());
            this.prMetaDataCleanupThreadPool = new PooledExecutorWithDMStats((BlockingQueue<Runnable>)((Object)poolQueue2), MAX_PR_META_DATA_CLEANUP_THREADS, this.stats.getWaitingPoolHelper(), tf2, this.threadMonitor);
            poolQueue = INCOMING_QUEUE_LIMIT == 0 ? new OverflowQueueWithDMStats(this.stats.getPartitionedRegionQueueHelper()) : new OverflowQueueWithDMStats(INCOMING_QUEUE_LIMIT, this.stats.getPartitionedRegionQueueHelper());
            tf = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    ClusterDistributionManager.this.stats.incPartitionedRegionThreadStarts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ClusterDistributionManager.this.stats.incPartitionedRegionThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                ClusterDistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                ClusterDistributionManager.this.stats.incPartitionedRegionThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, "PartitionedRegion Message Processor" + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            if (MAX_PR_THREADS > 1) {
                this.partitionedRegionPool = new PooledExecutorWithDMStats(poolQueue, MAX_PR_THREADS, this.stats.getPartitionedRegionPoolHelper(), tf, this.threadMonitor);
            } else {
                this.partitionedRegionThread = new SerialQueuedExecutorWithDMStats(poolQueue, this.stats.getPartitionedRegionPoolHelper(), tf, this.threadMonitor);
            }
            poolQueue = INCOMING_QUEUE_LIMIT == 0 ? new OverflowQueueWithDMStats(this.stats.getFunctionExecutionQueueHelper()) : new OverflowQueueWithDMStats(INCOMING_QUEUE_LIMIT, this.stats.getFunctionExecutionQueueHelper());
            tf = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    ClusterDistributionManager.this.stats.incFunctionExecutionThreadStarts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ClusterDistributionManager.this.stats.incFunctionExecutionThreads(1);
                            isFunctionExecutionThread.set(Boolean.TRUE);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                ClusterDistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                ClusterDistributionManager.this.stats.incFunctionExecutionThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, "Function Execution Processor" + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            if (MAX_FE_THREADS > 1) {
                this.functionExecutionPool = new FunctionExecutionPooledExecutor(poolQueue, MAX_FE_THREADS, this.stats.getFunctionExecutionPoolHelper(), tf, true, this.threadMonitor);
            } else {
                this.functionExecutionThread = new SerialQueuedExecutorWithDMStats(poolQueue, this.stats.getFunctionExecutionPoolHelper(), tf, this.threadMonitor);
            }
            if (!SYNC_EVENTS) {
                this.memberEventThread = new Thread(group, new MemberEventInvoker(), "DM-MemberEventInvoker");
                this.memberEventThread.setDaemon(true);
            }
            StringBuffer sb = new StringBuffer(" (took ");
            long start = System.currentTimeMillis();
            DMListener l = new DMListener(this);
            this.membershipManager = MemberFactory.newMembershipManager(l, system.getConfig(), transport, this.stats, system.getSecurityService());
            sb.append(System.currentTimeMillis() - start);
            this.localAddress = this.membershipManager.getLocalMember();
            this.membershipManager.postConnect();
            sb.append(" ms)");
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_STARTING_DISTRIBUTIONMANAGER_0_1, new Object[]{this.localAddress, logger.isInfoEnabled(LogMarker.DM_MARKER) ? sb.toString() : ""}));
            this.description = "Distribution manager on " + this.localAddress + " started at " + new Date(System.currentTimeMillis()).toString();
            finishedConstructor = true;
        }
        finally {
            if (!finishedConstructor) {
                this.askThreadsToStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterDistributionManager(InternalDistributedSystem system, RemoteTransportConfig transport) {
        this(transport, system);
        boolean finishedConstructor = false;
        try {
            ClusterDistributionManager.setIsStartupThread(Boolean.TRUE);
            this.startThreads();
            this.membershipManager.startEventProcessing();
            while (true) {
                this.getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.membershipManager.waitForEventProcessing();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            finishedConstructor = true;
        }
        finally {
            if (!finishedConstructor) {
                this.askThreadsToStop();
            }
        }
    }

    public static boolean isDedicatedAdminVM() {
        return isDedicatedAdminVM;
    }

    public static void setIsDedicatedAdminVM(boolean isDedicatedAdminVM) {
        ClusterDistributionManager.isDedicatedAdminVM = isDedicatedAdminVM;
    }

    private static Boolean getIsStartupThread() {
        return isStartupThread.get();
    }

    private static void setIsStartupThread(Boolean isStartup) {
        isStartupThread.set(isStartup);
    }

    private void runUntilShutdown(Runnable r) {
        try {
            r.run();
        }
        catch (CancelException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("Caught shutdown exception", (Throwable)e);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (this.isCloseInProgress()) {
                logger.debug("Caught unusual exception during shutdown: {}", (Object)t.getMessage(), (Object)t);
            }
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_TASK_FAILED_WITH_EXCEPTION), t);
        }
    }

    @Override
    public boolean areOnEquivalentHost(InternalDistributedMember member1, InternalDistributedMember member2) {
        Set<InetAddress> equivalents1 = this.getEquivalents(member1.getInetAddress());
        return equivalents1.contains(member2.getInetAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEquivalentHosts(Set<InetAddress> equivs) {
        Iterator<InetAddress> it = equivs.iterator();
        HashMap<InetAddress, Set<InetAddress>> hashMap = this.equivalentHosts;
        synchronized (hashMap) {
            while (it.hasNext()) {
                this.equivalentHosts.put(it.next(), Collections.unmodifiableSet(equivs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InetAddress> getEquivalents(InetAddress in) {
        Set<InetAddress> result;
        HashMap<InetAddress, Set<InetAddress>> hashMap = this.equivalentHosts;
        synchronized (hashMap) {
            result = this.equivalentHosts.get(in);
        }
        if (result == null) {
            result = Collections.singleton(in);
        }
        return result;
    }

    void setRedundancyZone(InternalDistributedMember member, String redundancyZone) {
        if (redundancyZone != null && !redundancyZone.equals("")) {
            this.redundancyZones.put(member, redundancyZone);
        }
        if (member != this.getDistributionManagerId()) {
            String relationship = this.areInSameZone(this.getDistributionManagerId(), member) ? "" : "not ";
            Object[] logArgs = new Object[]{member, relationship};
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_DISTRIBUTIONMANAGER_MEMBER_0_IS_1_EQUIVALENT, logArgs));
        }
    }

    void setEnforceUniqueZone(boolean enforceUniqueZone) {
        this.enforceUniqueZone |= enforceUniqueZone;
    }

    @Override
    public boolean enforceUniqueZone() {
        return this.enforceUniqueZone;
    }

    public String getRedundancyZone(InternalDistributedMember member) {
        return this.redundancyZones.get(member);
    }

    private void assertDistributionManagerType() {
        int theDmType = this.getDMType();
        switch (theDmType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                Assert.assertTrue(false, "unknown distribution manager type");
            }
        }
        InternalDistributedMember theId = this.getDistributionManagerId();
        int vmKind = theId.getVmKind();
        if (theDmType != vmKind) {
            Assert.assertTrue(false, "InternalDistributedMember has a vmKind of " + vmKind + " instead of " + theDmType);
        }
    }

    @Override
    public int getDMType() {
        return this.dmType;
    }

    @Override
    public List<InternalDistributedMember> getViewMembers() {
        return this.membershipManager.getView().getMembers();
    }

    private boolean testMulticast() {
        return this.membershipManager.testMulticast();
    }

    private void startThreads() {
        this.system.setDM(this);
        if (this.memberEventThread != null) {
            this.memberEventThread.start();
        }
        try {
            NetView v = this.membershipManager.getView();
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_INITIAL_MEMBERSHIPMANAGER_VIEW___0, String.valueOf(v)));
            for (InternalDistributedMember internalDistributedMember : v.getMembers()) {
                this.addNewMember(internalDistributedMember);
            }
            this.selectElder();
        }
        catch (Exception ex) {
            throw new InternalGemFireException(LocalizedStrings.DistributionManager_COULD_NOT_PROCESS_INITIAL_VIEW.toLocalizedString(), ex);
        }
        try {
            this.getWaitingThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    ClusterDistributionManager.setIsStartupThread(Boolean.TRUE);
                    ClusterDistributionManager.this.readyForMessages();
                }
            });
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_UNCAUGHT_EXCEPTION_CALLING_READYFORMESSAGES), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyForMessages() {
        ClusterDistributionManager clusterDistributionManager = this;
        synchronized (clusterDistributionManager) {
            this.readyForMessages = true;
            this.notifyAll();
        }
        this.membershipManager.startEventProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitUntilReadyForMessages() {
        if (this.readyForMessages) {
            return;
        }
        ClusterDistributionManager clusterDistributionManager = this;
        synchronized (clusterDistributionManager) {
            while (!this.readyForMessages) {
                this.stopper.checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.stopper.checkCancelInProgress(e);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyToSendMsgs() {
        Object object = this.readyToSendMsgsLock;
        synchronized (object) {
            this.readyToSendMsgs = true;
            this.readyToSendMsgsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitUntilReadyToSendMsgs(DistributionMessage msg) {
        if (this.readyToSendMsgs) {
            return;
        }
        if (msg instanceof StartupMessage) return;
        if (msg instanceof StartupResponseMessage) return;
        if (msg instanceof AdminMessageType) {
            return;
        }
        if (ClusterDistributionManager.getIsStartupThread() == Boolean.TRUE) {
            return;
        }
        Object object = this.readyToSendMsgsLock;
        synchronized (object) {
            while (!this.readyToSendMsgs) {
                this.stopper.checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.readyToSendMsgsLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.stopper.checkCancelInProgress(e);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    @Override
    public void forceUDPMessagingForCurrentThread() {
        this.membershipManager.forceUDPMessagingForCurrentThread();
    }

    @Override
    public void releaseUDPMessagingForCurrentThread() {
        this.membershipManager.releaseUDPMessagingForCurrentThread();
    }

    @Override
    public boolean exceptionInThreads() {
        return this.exceptionInThreads || this.threadGroup.getUncaughtExceptionsCount() > 0L;
    }

    @Override
    public void clearExceptionInThreads() {
        this.exceptionInThreads = false;
        this.threadGroup.clearUncaughtExceptionsCount();
    }

    @Override
    public long cacheTimeMillis() {
        return this.system.getClock().cacheTimeMillis();
    }

    @Override
    public DistributedMember getMemberWithName(String name) {
        for (DistributedMember distributedMember : this.members.values()) {
            if (!Objects.equals(distributedMember.getName(), name)) continue;
            return distributedMember;
        }
        if (Objects.equals(this.localAddress, name)) {
            return this.localAddress;
        }
        return null;
    }

    @Override
    public InternalDistributedMember getDistributionManagerId() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalDistributedMember> getDistributionManagerIds() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.members.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHostedLocators(InternalDistributedMember member, Collection<String> locators, boolean isSharedConfigurationEnabled) {
        Object object = this.membersLock;
        synchronized (object) {
            if (locators == null || locators.isEmpty()) {
                throw new IllegalArgumentException("Cannot use empty collection of locators");
            }
            if (this.hostedLocatorsAll.isEmpty()) {
                this.hostedLocatorsAll = new HashMap<InternalDistributedMember, Collection<String>>();
            }
            Map<InternalDistributedMember, Collection<String>> tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsAll);
            tmp.remove(member);
            tmp.put(member, locators);
            tmp = Collections.unmodifiableMap(tmp);
            this.hostedLocatorsAll = tmp;
            if (isSharedConfigurationEnabled) {
                if (locators == null || locators.isEmpty()) {
                    throw new IllegalArgumentException("Cannot use empty collection of locators");
                }
                if (this.hostedLocatorsWithSharedConfiguration.isEmpty()) {
                    this.hostedLocatorsWithSharedConfiguration = new HashMap<InternalDistributedMember, Collection<String>>();
                }
                tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsWithSharedConfiguration);
                tmp.remove(member);
                tmp.put(member, locators);
                tmp = Collections.unmodifiableMap(tmp);
                this.hostedLocatorsWithSharedConfiguration = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHostedLocators(InternalDistributedMember member) {
        Object object = this.membersLock;
        synchronized (object) {
            Map<InternalDistributedMember, Collection<String>> tmp;
            if (this.hostedLocatorsAll.containsKey(member)) {
                tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsAll);
                tmp.remove(member);
                tmp = tmp.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(tmp);
                this.hostedLocatorsAll = tmp;
            }
            if (this.hostedLocatorsWithSharedConfiguration.containsKey(member)) {
                tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsWithSharedConfiguration);
                tmp.remove(member);
                tmp = tmp.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(tmp);
                this.hostedLocatorsWithSharedConfiguration = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getHostedLocators(InternalDistributedMember member) {
        Object object = this.membersLock;
        synchronized (object) {
            return this.hostedLocatorsAll.get(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InternalDistributedMember, Collection<String>> getAllHostedLocators() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.hostedLocatorsAll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InternalDistributedMember, Collection<String>> getAllHostedLocatorsWithSharedConfiguration() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.hostedLocatorsWithSharedConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalDistributedMember> getDistributionManagerIdsIncludingAdmin() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.membersAndAdmin;
        }
    }

    @Override
    public Set<InternalDistributedMember> getOtherDistributionManagerIds() {
        HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>(this.getDistributionManagerIds());
        InternalDistributedMember me = this.getDistributionManagerId();
        result.remove(me);
        return result;
    }

    @Override
    public Set<InternalDistributedMember> getOtherNormalDistributionManagerIds() {
        HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>(this.getNormalDistributionManagerIds());
        InternalDistributedMember me = this.getDistributionManagerId();
        result.remove(me);
        return result;
    }

    @Override
    public InternalDistributedMember getCanonicalId(DistributedMember id) {
        InternalDistributedMember result = this.members.get(id);
        if (result == null) {
            return (InternalDistributedMember)id;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalDistributedMember> addMembershipListenerAndGetDistributionManagerIds(MembershipListener l) {
        Object object = this.membersLock;
        synchronized (object) {
            this.addMembershipListener(l);
            return this.members.keySet();
        }
    }

    private void addNewMember(InternalDistributedMember member) {
        int vmType = member.getVmKind();
        switch (vmType) {
            case 12: {
                this.handleConsoleStartup(member);
                break;
            }
            case 10: 
            case 11: {
                this.handleManagerStartup(member);
                break;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.DistributionManager_UNKNOWN_MEMBER_TYPE_0.toLocalizedString(vmType));
            }
        }
    }

    @Override
    public InternalDistributedMember getId() {
        return this.localAddress;
    }

    @Override
    public long getMembershipPort() {
        return this.localAddress.getPort();
    }

    @Override
    public Set<InternalDistributedMember> putOutgoing(DistributionMessage msg) {
        try {
            DistributionMessageObserver observer = DistributionMessageObserver.getInstance();
            if (observer != null) {
                observer.beforeSendMessage(this, msg);
            }
            return this.sendMessage(msg);
        }
        catch (NotSerializableException e) {
            throw new InternalGemFireException(e);
        }
    }

    public String toString() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        block21: {
            Object object = this.shutdownMutex;
            synchronized (object) {
                if (this.closeInProgress) {
                    return;
                }
                this.closeInProgress = true;
            }
            String exceptionStatus = this.exceptionInThreads() ? LocalizedStrings.DistributionManager_AT_LEAST_ONE_EXCEPTION_OCCURRED.toLocalizedString() : "";
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_SHUTTING_DOWN_DISTRIBUTIONMANAGER_0_1, new Object[]{this.localAddress, exceptionStatus}));
            long start = System.currentTimeMillis();
            try {
                if (this.rootCause instanceof ForcedDisconnectException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("inhibiting sending of shutdown message to other members due to forced-disconnect");
                    }
                    break block21;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConnectionTable.threadWantsSharedResources();
                            ClusterDistributionManager.this.sendShutdownMessage();
                        }
                        catch (CancelException e) {
                            logger.debug("Cancelled during shutdown message", (Throwable)e);
                        }
                    }
                };
                Thread t = new Thread(this.threadGroup, r, LocalizedStrings.DistributionManager_SHUTDOWN_MESSAGE_THREAD_FOR_0.toLocalizedString(this.localAddress));
                t.start();
                boolean interrupted = Thread.interrupted();
                try {
                    t.join(5000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    t.interrupt();
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_INTERRUPTED_SENDING_SHUTDOWN_MESSAGE_TO_PEERS), (Throwable)e);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (t.isAlive()) {
                    t.interrupt();
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_FAILED_SENDING_SHUTDOWN_MESSAGE_TO_PEERS_TIMEOUT));
                }
            }
            finally {
                this.shutdownMsgSent = true;
                try {
                    this.uncleanShutdown(false);
                }
                finally {
                    Long delta = System.currentTimeMillis() - start;
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_DISTRIBUTIONMANAGER_STOPPED_IN_0_MS, delta));
                }
            }
        }
    }

    private void askThreadsToStop() {
        Thread th;
        this.threadMonitor.close();
        ThreadPoolExecutor es = this.serialThread;
        if (es != null) {
            es.shutdown();
        }
        if ((es = this.viewThread) != null) {
            es.shutdown();
        }
        if (this.serialQueuedExecutorPool != null) {
            this.serialQueuedExecutorPool.shutdown();
        }
        if ((es = this.functionExecutionThread) != null) {
            es.shutdown();
        }
        if ((es = this.functionExecutionPool) != null) {
            es.shutdown();
        }
        if ((es = this.partitionedRegionThread) != null) {
            es.shutdown();
        }
        if ((es = this.partitionedRegionPool) != null) {
            es.shutdown();
        }
        if ((es = this.highPriorityPool) != null) {
            es.shutdown();
        }
        if ((es = this.waitingPool) != null) {
            es.shutdown();
        }
        if ((es = this.prMetaDataCleanupThreadPool) != null) {
            es.shutdown();
        }
        if ((es = this.threadPool) != null) {
            es.shutdown();
        }
        if ((th = this.memberEventThread) != null) {
            th.interrupt();
        }
    }

    private void waitForThreadsToStop(long timeInMillis) throws InterruptedException {
        ExecutorService[] allExecutors;
        long start = System.currentTimeMillis();
        long remaining = timeInMillis;
        for (ExecutorService es : allExecutors = new ExecutorService[]{this.serialThread, this.viewThread, this.functionExecutionThread, this.functionExecutionPool, this.partitionedRegionThread, this.partitionedRegionPool, this.highPriorityPool, this.waitingPool, this.prMetaDataCleanupThreadPool, this.threadPool}) {
            if (es != null) {
                es.awaitTermination(remaining, TimeUnit.MILLISECONDS);
            }
            if ((remaining = timeInMillis - (System.currentTimeMillis() - start)) > 0L) continue;
            return;
        }
        this.serialQueuedExecutorPool.awaitTermination(remaining, TimeUnit.MILLISECONDS);
        remaining = timeInMillis - (System.currentTimeMillis() - start);
        if (remaining <= 0L) {
            return;
        }
        Thread th = this.memberEventThread;
        if (th != null) {
            th.interrupt();
            th.join(remaining);
        }
    }

    private void clobberThread(Thread t) {
        if (t == null) {
            return;
        }
        if (t.isAlive()) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_FORCING_THREAD_STOP_ON__0_, t));
            t.interrupt();
            try {
                for (int i = 0; i < 10 && t.isAlive(); ++i) {
                    t.join(1000L);
                    t.interrupt();
                }
            }
            catch (InterruptedException ex) {
                logger.debug("Interrupted while attempting to terminate threads.");
                Thread.currentThread().interrupt();
            }
            if (t.isAlive()) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_CLOBBERTHREAD_THREAD_REFUSED_TO_DIE__0, t));
            }
        }
    }

    private boolean executorAlive(ThreadPoolExecutor tpe, String name) {
        if (tpe == null) {
            return false;
        }
        int ac = tpe.getActiveCount();
        if (ac > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Still waiting for {} threads in '{}' pool to exit", (Object)ac, (Object)name);
            }
            return true;
        }
        return false;
    }

    private void forceThreadsToStop() {
        Thread th;
        long endTime = System.currentTimeMillis() + 20000L;
        String culprits = "";
        while (true) {
            boolean stillAlive = false;
            culprits = "";
            if (this.executorAlive(this.serialThread, "serial thread")) {
                stillAlive = true;
                culprits = culprits + " serial thread;";
            }
            if (this.executorAlive(this.viewThread, "view thread")) {
                stillAlive = true;
                culprits = culprits + " view thread;";
            }
            if (this.executorAlive(this.partitionedRegionThread, "partitioned region thread")) {
                stillAlive = true;
                culprits = culprits + " partitioned region thread;";
            }
            if (this.executorAlive(this.partitionedRegionPool, "partitioned region pool")) {
                stillAlive = true;
                culprits = culprits + " partitioned region pool;";
            }
            if (this.executorAlive(this.highPriorityPool, "high priority pool")) {
                stillAlive = true;
                culprits = culprits + " high priority pool;";
            }
            if (this.executorAlive(this.waitingPool, "waiting pool")) {
                stillAlive = true;
                culprits = culprits + " waiting pool;";
            }
            if (this.executorAlive(this.prMetaDataCleanupThreadPool, "prMetaDataCleanupThreadPool")) {
                stillAlive = true;
                culprits = culprits + " special waiting pool;";
            }
            if (this.executorAlive(this.threadPool, "thread pool")) {
                stillAlive = true;
                culprits = culprits + " thread pool;";
            }
            if (!stillAlive) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now >= endTime) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_INTERRUPTED_DURING_SHUTDOWN), (Throwable)e);
                break;
            }
        }
        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_DAEMON_THREADS_ARE_SLOW_TO_STOP_CULPRITS_INCLUDE_0, culprits));
        if (this.serialThread != null) {
            this.serialThread.shutdownNow();
        }
        if (this.viewThread != null) {
            this.viewThread.shutdownNow();
        }
        if (this.functionExecutionThread != null) {
            this.functionExecutionThread.shutdownNow();
        }
        if (this.functionExecutionPool != null) {
            this.functionExecutionPool.shutdownNow();
        }
        if (this.partitionedRegionThread != null) {
            this.partitionedRegionThread.shutdownNow();
        }
        if (this.partitionedRegionPool != null) {
            this.partitionedRegionPool.shutdownNow();
        }
        if (this.highPriorityPool != null) {
            this.highPriorityPool.shutdownNow();
        }
        if (this.waitingPool != null) {
            this.waitingPool.shutdownNow();
        }
        if (this.prMetaDataCleanupThreadPool != null) {
            this.prMetaDataCleanupThreadPool.shutdownNow();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
        if ((th = this.memberEventThread) != null) {
            this.clobberThread(th);
        }
    }

    @Override
    public boolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    /*
     * Exception decompiling
     */
    private void uncleanShutdown(boolean beforeJoined) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.system;
    }

    RemoteTransportConfig getTransport() {
        return this.transport;
    }

    @Override
    public void addMembershipListener(MembershipListener l) {
        this.membershipListeners.putIfAbsent(l, Boolean.TRUE);
    }

    @Override
    public void removeMembershipListener(MembershipListener l) {
        this.membershipListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllMembershipListener(MembershipListener l) {
        Object object = this.allMembershipListenersLock;
        synchronized (object) {
            HashSet<MembershipListener> newAllMembershipListeners = new HashSet<MembershipListener>(this.allMembershipListeners);
            newAllMembershipListeners.add(l);
            this.allMembershipListeners = newAllMembershipListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMembershipListener(MembershipListener l) {
        Object object = this.allMembershipListenersLock;
        synchronized (object) {
            HashSet<MembershipListener> newAllMembershipListeners = new HashSet<MembershipListener>(this.allMembershipListeners);
            if (!newAllMembershipListeners.remove(l)) {
                // empty if block
            }
            this.allMembershipListeners = newAllMembershipListeners;
        }
    }

    private boolean isCloseInProgress() {
        if (this.closeInProgress) {
            return true;
        }
        InternalDistributedSystem ds = this.getSystem();
        return ds != null && ds.isDisconnecting();
    }

    public boolean isShutdownStarted() {
        return this.closeInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewInstalledEvent(ViewInstalledEvent ev) {
        Object object = this.membershipViewIdGuard;
        synchronized (object) {
            this.membershipViewIdAcknowledged = ev.getViewId();
            this.membershipViewIdGuard.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForViewInstallation(long id) throws InterruptedException {
        if (id <= this.membershipViewIdAcknowledged) {
            return;
        }
        Object object = this.membershipViewIdGuard;
        synchronized (object) {
            while (this.membershipViewIdAcknowledged < id && !this.stopper.isCancelInProgress()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("waiting for view {}.  Current DM view processed by all listeners is {}", (Object)id, (Object)this.membershipViewIdAcknowledged);
                }
                this.membershipViewIdGuard.wait();
            }
        }
    }

    private void handleMemberEvent(MemberEvent ev) {
        ev.handleEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemberEvent(MemberEvent ev) {
        if (SYNC_EVENTS) {
            this.handleMemberEvent(ev);
        } else {
            this.stopper.checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                this.membershipEventQueue.put(ev);
            }
            catch (InterruptedException ex) {
                interrupted = true;
                this.stopper.checkCancelInProgress(ex);
                this.handleMemberEvent(ev);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.shutdown();
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_MARKING_DISTRIBUTIONMANAGER_0_AS_CLOSED, this.localAddress));
            MembershipLogger.logShutdown(this.localAddress);
            this.closed = true;
        }
    }

    @Override
    public void throwIfDistributionStopped() {
        if (this.shutdownMsgSent) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.DistributionManager_MESSAGE_DISTRIBUTION_HAS_TERMINATED.toLocalizedString(), this.getRootCause());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAdminConsole(InternalDistributedMember theId) {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_NEW_ADMINISTRATION_MEMBER_DETECTED_AT_0, theId));
        Object object = this.adminConsolesLock;
        synchronized (object) {
            HashSet<InternalDistributedMember> tmp = new HashSet<InternalDistributedMember>(this.adminConsoles);
            tmp.add(theId);
            this.adminConsoles = Collections.unmodifiableSet(tmp);
        }
    }

    @Override
    public DMStats getStats() {
        return this.stats;
    }

    @Override
    public DistributionConfig getConfig() {
        DistributionConfig result = null;
        InternalDistributedSystem sys = this.getSystem();
        if (sys != null) {
            result = this.system.getConfig();
        }
        return result;
    }

    @Override
    public Set<InternalDistributedMember> getAllOtherMembers() {
        HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>(this.getDistributionManagerIdsIncludingAdmin());
        result.remove(this.getDistributionManagerId());
        return result;
    }

    @Override
    public void retainMembersWithSameOrNewerVersion(Collection<InternalDistributedMember> members, Version version) {
        members.removeIf(id -> id.getVersionObject().compareTo(version) < 0);
    }

    @Override
    public void removeMembersWithSameOrNewerVersion(Collection<InternalDistributedMember> members, Version version) {
        members.removeIf(id -> id.getVersionObject().compareTo(version) >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalDistributedMember> addAllMembershipListenerAndGetAllIds(MembershipListener l) {
        MembershipManager mgr = this.membershipManager;
        mgr.getViewLock().writeLock().lock();
        try {
            Object object = this.membersLock;
            synchronized (object) {
                this.addAllMembershipListener(l);
                Set<InternalDistributedMember> set = this.getDistributionManagerIdsIncludingAdmin();
                return set;
            }
        }
        finally {
            mgr.getViewLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendStartupMessage(StartupOperation startupOperation) throws InterruptedException {
        Set<InetAddress> equivs;
        boolean ok;
        block24: {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.receivedStartupResponse = false;
            ok = false;
            equivs = StartupMessage.getMyAddresses(this);
            if (equivs == null || equivs.size() == 0) {
                equivs = new HashSet<InetAddress>();
                try {
                    equivs.add(SocketCreator.getLocalHost());
                }
                catch (UnknownHostException e) {
                    if (this.getViewMembers().size() <= 1) break block24;
                    throw new SystemConnectException("Unable to examine network cards and other members exist");
                }
            }
        }
        this.setEquivalentHosts(equivs);
        this.setEnforceUniqueZone(this.getConfig().getEnforceUniqueHost());
        String redundancyZone = this.getConfig().getRedundancyZone();
        if (redundancyZone != null && !redundancyZone.equals("")) {
            this.setEnforceUniqueZone(true);
        }
        this.setRedundancyZone(this.getDistributionManagerId(), redundancyZone);
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Equivalent IPs for this host: ");
            Iterator<InetAddress> it = equivs.iterator();
            while (it.hasNext()) {
                InetAddress in = it.next();
                sb.append(in.toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            logger.debug((CharSequence)sb);
        }
        HashSet<InternalDistributedMember> allOthers = new HashSet<InternalDistributedMember>(this.getViewMembers());
        allOthers.remove(this.getDistributionManagerId());
        if (allOthers.isEmpty()) {
            return false;
        }
        try {
            ok = startupOperation.sendStartupMessage(allOthers, STARTUP_TIMEOUT, equivs, redundancyZone, this.enforceUniqueZone());
        }
        catch (Exception re) {
            throw new SystemConnectException(LocalizedStrings.DistributionManager_ONE_OR_MORE_PEERS_GENERATED_EXCEPTIONS_DURING_CONNECTION_ATTEMPT.toLocalizedString(), re);
        }
        if (this.rejectionMessage != null) {
            throw new IncompatibleSystemException(this.rejectionMessage);
        }
        boolean receivedAny = this.receivedStartupResponse;
        if (!ok) {
            Object object = this.unfinishedStartupsLock;
            synchronized (object) {
                int unresponsiveCount = this.unfinishedStartups == null ? 0 : this.unfinishedStartups.size();
                if (unresponsiveCount != 0 && Boolean.getBoolean("DistributionManager.requireAllStartupResponses")) {
                    throw new SystemConnectException(LocalizedStrings.DistributionManager_NO_STARTUP_REPLIES_FROM_0.toLocalizedString(this.unfinishedStartups));
                }
            }
            if (allOthers.size() != 0 && !receivedAny) {
                StringBuffer sb = new StringBuffer();
                Iterator itt = allOthers.iterator();
                while (itt.hasNext()) {
                    Object m = itt.next();
                    sb.append(m.toString());
                    if (!itt.hasNext()) continue;
                    sb.append(", ");
                }
                if (DEBUG_NO_ACKNOWLEDGEMENTS) {
                    this.printStacks(allOthers, false);
                }
                throw new SystemConnectException(LocalizedStrings.DistributionManager_RECEIVED_NO_CONNECTION_ACKNOWLEDGMENTS_FROM_ANY_OF_THE_0_SENIOR_CACHE_MEMBERS_1.toLocalizedString(Integer.toString(allOthers.size()), sb.toString()));
            }
            InternalDistributedMember e = this.getElderId();
            if (e != null) {
                boolean unresponsiveElder;
                Object object2 = this.unfinishedStartupsLock;
                synchronized (object2) {
                    unresponsiveElder = this.unfinishedStartups == null ? false : this.unfinishedStartups.contains(e);
                }
                if (unresponsiveElder) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_FORCING_AN_ELDER_JOIN_EVENT_SINCE_A_STARTUP_RESPONSE_WAS_NOT_RECEIVED_FROM_ELDER__0_, e));
                    this.handleManagerStartup(e);
                }
            }
        }
        return receivedAny;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnfinishedStartups(Collection<InternalDistributedMember> s) {
        Object object = this.unfinishedStartupsLock;
        synchronized (object) {
            Assert.assertTrue(this.unfinishedStartups == null, "Set unfinished startups twice");
            this.unfinishedStartups = new HashSet<InternalDistributedMember>(s);
            Iterator<InternalDistributedMember> it = this.unfinishedStartups.iterator();
            Object object2 = this.membersLock;
            synchronized (object2) {
                while (it.hasNext()) {
                    InternalDistributedMember m = it.next();
                    if (this.isCurrentMember(m)) continue;
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUnfinishedStartup(InternalDistributedMember m, boolean departed) {
        Object object = this.unfinishedStartupsLock;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug("removeUnfinishedStartup for {} wtih {}", (Object)m, this.unfinishedStartups);
            }
            if (this.unfinishedStartups == null) {
                return;
            }
            if (!this.unfinishedStartups.remove(m)) {
                return;
            }
            StringId msg = null;
            msg = departed ? LocalizedStrings.DistributionManager_STOPPED_WAITING_FOR_STARTUP_REPLY_FROM_0_BECAUSE_THE_PEER_DEPARTED_THE_VIEW : LocalizedStrings.DistributionManager_STOPPED_WAITING_FOR_STARTUP_REPLY_FROM_0_BECAUSE_THE_REPLY_WAS_FINALLY_RECEIVED;
            logger.info((Message)LocalizedMessage.create(msg, m));
            int numLeft = this.unfinishedStartups.size();
            if (numLeft != 0) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_STILL_AWAITING_0_RESPONSES_FROM_1, new Object[]{numLeft, this.unfinishedStartups}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStartupResponse(InternalDistributedMember sender, String theRejectionMessage) {
        this.removeUnfinishedStartup(sender, false);
        ClusterDistributionManager clusterDistributionManager = this;
        synchronized (clusterDistributionManager) {
            if (!this.receivedStartupResponse) {
                this.receivedStartupResponse = true;
            }
            if (theRejectionMessage != null && this.rejectionMessage == null) {
                this.rejectionMessage = theRejectionMessage;
            }
        }
    }

    private InternalDistributedMember getElderCandidate() {
        int managerType;
        InternalDistributedMember member2;
        List<InternalDistributedMember> theMembers = this.getViewMembers();
        int elderCandidates = 0;
        Iterator<InternalDistributedMember> it = theMembers.iterator();
        boolean anyPre80Members = false;
        while (it.hasNext()) {
            member2 = it.next();
            if (member2.getVersionObject().compareTo(Version.GFE_80) >= 0) continue;
            anyPre80Members = true;
        }
        if (!this.adam) {
            it = theMembers.iterator();
            while (it.hasNext() && ((managerType = (member2 = it.next()).getVmKind()) == 12 || managerType == 11 && anyPre80Members || this.getMembershipManager().isSurpriseMember(member2) || ++elderCandidates <= 1)) {
            }
        }
        for (InternalDistributedMember member2 : theMembers) {
            managerType = member2.getVmKind();
            if (managerType == 12 || managerType == 11 && anyPre80Members || this.getMembershipManager().isSurpriseMember(member2)) continue;
            if (member2.equals(this.localAddress)) {
                if (!this.adam && elderCandidates == 1) {
                    this.adam = true;
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_0_IS_THE_ELDER_AND_THE_ONLY_MEMBER, this.localAddress));
                } else {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_I_0_AM_THE_ELDER, this.localAddress));
                }
            }
            return member2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectElder() {
        this.getSystem().getCancelCriterion().checkCancelInProgress(null);
        if (this.localAddress.equals(this.elder)) {
            return;
        }
        InternalDistributedMember candidate = this.getElderCandidate();
        if (candidate == null) {
            this.changeElder(null);
            return;
        }
        Object object = this.elderMonitor;
        synchronized (object) {
            if (!candidate.equals(this.elder)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The elder is: {} (was {})", (Object)candidate, (Object)this.elder);
                }
                this.changeElder(candidate);
            }
        }
    }

    private String prettifyReason(String r) {
        String str = "java.io.IOException:";
        if (r.startsWith("java.io.IOException:")) {
            return r.substring("java.io.IOException:".length());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeManager(InternalDistributedMember theId, boolean crashed, String p_reason) {
        String reason = p_reason;
        boolean result = false;
        if (this.isCurrentMember(theId)) {
            reason = this.prettifyReason(reason);
            Object object = this.membersLock;
            synchronized (object) {
                Map<InternalDistributedMember, InternalDistributedMember> tmp;
                if (logger.isDebugEnabled()) {
                    logger.debug("DistributionManager: removing member <{}>; crashed {}; reason = {}", (Object)theId, (Object)crashed, (Object)reason);
                }
                if ((tmp = new HashMap<InternalDistributedMember, InternalDistributedMember>(this.members)).remove(theId) != null) {
                    tmp = tmp.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(tmp);
                    this.members = tmp;
                    result = true;
                } else {
                    result = false;
                }
                Set<InternalDistributedMember> tmp2 = new HashSet<InternalDistributedMember>(this.membersAndAdmin);
                if (tmp2.remove(theId)) {
                    tmp2 = tmp2.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(tmp2);
                    this.membersAndAdmin = tmp2;
                }
                this.removeHostedLocators(theId);
            }
        }
        if (!theId.equals(this.localAddress) && theId.equals(this.elder)) {
            try {
                this.selectElder();
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
            }
        }
        this.redundancyZones.remove(theId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleManagerStartup(InternalDistributedMember theId) {
        HashMap<InternalDistributedMember, InternalDistributedMember> tmp = null;
        Object object = this.membersLock;
        synchronized (object) {
            if (this.members.containsKey(theId)) {
                return;
            }
            tmp = new HashMap<InternalDistributedMember, InternalDistributedMember>(this.members);
            tmp.put(theId, theId);
            this.members = Collections.unmodifiableMap(tmp);
            HashSet<InternalDistributedMember> stmp = new HashSet<InternalDistributedMember>(this.membersAndAdmin);
            stmp.add(theId);
            this.membersAndAdmin = Collections.unmodifiableSet(stmp);
        }
        if (theId.getVmKind() != 11) {
            this.stats.incNodes(1);
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_ADMITTING_MEMBER_0_NOW_THERE_ARE_1_NONADMIN_MEMBERS, new Object[]{theId, tmp.size()}));
        this.addMemberEvent(new MemberJoinedEvent(theId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrentMember(DistributedMember id) {
        Set<InternalDistributedMember> m;
        Object object = this.membersLock;
        synchronized (object) {
            m = this.membersAndAdmin;
        }
        return m.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConsoleStartup(InternalDistributedMember theId) {
        HashSet<InternalDistributedMember> tmp = null;
        Iterator<MembershipListener> iterator = this.membersLock;
        synchronized (iterator) {
            if (this.membersAndAdmin.contains(theId)) {
                return;
            }
            tmp = new HashSet<InternalDistributedMember>(this.membersAndAdmin);
            tmp.add(theId);
            this.membersAndAdmin = Collections.unmodifiableSet(tmp);
        }
        for (MembershipListener listener : this.allMembershipListeners) {
            listener.memberJoined(this, theId);
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_DMMEMBERSHIP_ADMITTING_NEW_ADMINISTRATION_MEMBER__0_, theId));
    }

    private void handleIncomingDMsg(DistributionMessage message) {
        this.stats.incReceivedMessages(1L);
        this.stats.incReceivedBytes(message.getBytesRead());
        this.stats.incMessageChannelTime(message.resetTimestamp());
        if (logger.isDebugEnabled()) {
            logger.debug("Received message '{}' from <{}>", (Object)message, (Object)message.getSender());
        }
        this.scheduleIncomingMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConsoleShutdown(InternalDistributedMember theId, boolean crashed, String reason) {
        Set<InternalDistributedMember> tmp;
        boolean removedConsole = false;
        boolean removedMember = false;
        Iterator<MembershipListener> iterator = this.membersLock;
        synchronized (iterator) {
            if (!this.members.containsKey(theId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DistributionManager: removing admin member <{}>; crashed = {}; reason = {}", (Object)theId, (Object)crashed, (Object)reason);
                }
                if ((tmp = new HashSet<InternalDistributedMember>(this.membersAndAdmin)).remove(theId)) {
                    tmp = tmp.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(tmp);
                    this.membersAndAdmin = tmp;
                    removedMember = true;
                }
            }
            this.removeHostedLocators(theId);
        }
        iterator = this.adminConsolesLock;
        synchronized (iterator) {
            if (this.adminConsoles.contains(theId)) {
                removedConsole = true;
                tmp = new HashSet<InternalDistributedMember>(this.adminConsoles);
                tmp.remove(theId);
                tmp = tmp.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(tmp);
                this.adminConsoles = tmp;
            }
        }
        if (removedMember) {
            for (MembershipListener listener : this.allMembershipListeners) {
                listener.memberDeparted(this, theId, crashed);
            }
        }
        if (removedConsole) {
            StringId msg = null;
            msg = crashed ? LocalizedStrings.DistributionManager_ADMINISTRATION_MEMBER_AT_0_CRASHED_1 : LocalizedStrings.DistributionManager_ADMINISTRATION_MEMBER_AT_0_CLOSED_1;
            logger.info((Message)LocalizedMessage.create(msg, new Object[]{theId, reason}));
        }
        this.redundancyZones.remove(theId);
    }

    void shutdownMessageReceived(InternalDistributedMember theId, String reason) {
        this.membershipManager.shutdownMessageReceived(theId, reason);
        this.handleManagerDeparture(theId, false, LocalizedStrings.ShutdownMessage_SHUTDOWN_MESSAGE_RECEIVED.toLocalizedString());
    }

    @Override
    public void handleManagerDeparture(InternalDistributedMember theId, boolean p_crashed, String p_reason) {
        AlertAppender.getInstance().removeAlertListener(theId);
        try {
            this.selectElder();
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
        int vmType = theId.getVmKind();
        if (vmType == 12) {
            this.removeUnfinishedStartup(theId, true);
            this.handleConsoleShutdown(theId, p_crashed, p_reason);
            return;
        }
        if (!this.isCurrentMember(theId)) {
            return;
        }
        this.removeUnfinishedStartup(theId, true);
        if (this.removeManager(theId, p_crashed, p_reason)) {
            StringId msg;
            if (theId.getVmKind() != 11) {
                this.stats.incNodes(-1);
            }
            if (p_crashed && !this.isCloseInProgress()) {
                msg = LocalizedStrings.DistributionManager_MEMBER_AT_0_UNEXPECTEDLY_LEFT_THE_DISTRIBUTED_CACHE_1;
                this.addMemberEvent(new MemberCrashedEvent(theId, p_reason));
            } else {
                msg = LocalizedStrings.DistributionManager_MEMBER_AT_0_GRACEFULLY_LEFT_THE_DISTRIBUTED_CACHE_1;
                this.addMemberEvent(new MemberDepartedEvent(theId, p_reason));
            }
            logger.info((Message)LocalizedMessage.create(msg, new Object[]{theId, this.prettifyReason(p_reason)}));
            if (this.serialQueuedExecutorPool != null) {
                this.serialQueuedExecutorPool.handleMemberDeparture(theId);
            }
        }
    }

    private void handleManagerSuspect(InternalDistributedMember suspect, InternalDistributedMember whoSuspected, String reason) {
        if (!this.isCurrentMember(suspect)) {
            return;
        }
        int vmType = suspect.getVmKind();
        if (vmType == 12) {
            return;
        }
        this.addMemberEvent(new MemberSuspectEvent(suspect, whoSuspected, reason));
    }

    private void handleViewInstalled(NetView view) {
        this.addMemberEvent(new ViewInstalledEvent(view));
    }

    private void handleQuorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        this.addMemberEvent(new QuorumLostEvent(failures, remaining));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendShutdownMessage() {
        if (this.getDMType() == 12 && Locator.getLocators().size() == 0) {
            return;
        }
        ShutdownMessage m = new ShutdownMessage();
        InternalDistributedMember theId = this.getDistributionManagerId();
        m.setDistributionManagerId(theId);
        HashSet<InternalDistributedMember> allOthers = new HashSet<InternalDistributedMember>(this.getViewMembers());
        allOthers.remove(this.getDistributionManagerId());
        m.setRecipients(allOthers);
        if (logger.isTraceEnabled()) {
            logger.trace("{} Sending {} to {}", (Object)this.getDistributionManagerId(), (Object)m, (Object)m.getRecipientsDescription());
        }
        try {
            long startTime = DistributionStats.getStatTime();
            this.sendViaMembershipManager(m.getRecipients(), m, this, this.stats);
            this.stats.incSentMessages(1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incSentMessagesTime(DistributionStats.getStatTime() - startTime);
            }
        }
        catch (CancelException e) {
            logger.debug("CancelException caught sending shutdown: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception ex2) {
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_WHILE_SENDING_SHUTDOWN_MESSAGE), (Throwable)ex2);
        }
        finally {
            this.shutdownMsgSent = true;
        }
    }

    public Executor getExecutor(int processorType, InternalDistributedMember sender) {
        switch (processorType) {
            case 73: {
                return this.getThreadPool();
            }
            case 74: {
                return this.getSerialExecutor(sender);
            }
            case 79: {
                return this.viewThread;
            }
            case 75: {
                return this.getHighPriorityThreadPool();
            }
            case 77: {
                return this.getWaitingThreadPool();
            }
            case 78: {
                return this.getPartitionedRegionExcecutor();
            }
            case 80: {
                return this.getFunctionExecutor();
            }
        }
        throw new InternalGemFireError(LocalizedStrings.DistributionManager_UNKNOWN_PROCESSOR_TYPE.toLocalizedString(processorType));
    }

    Set<InternalDistributedMember> sendOutgoing(DistributionMessage message) throws NotSerializableException {
        boolean sentToAll;
        long startTime = DistributionStats.getStatTime();
        Set<InternalDistributedMember> result = this.sendViaMembershipManager(message.getRecipients(), message, this, this.stats);
        long endTime = 0L;
        if (DistributionStats.enableClockStats) {
            endTime = NanoTimer.getTime();
        }
        if (sentToAll = message.forAll()) {
            this.stats.incBroadcastMessages(1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incBroadcastMessagesTime(endTime - startTime);
            }
        }
        this.stats.incSentMessages(1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incSentMessagesTime(endTime - startTime);
            this.stats.incDistributeMessageTime(endTime - message.getTimestamp());
        }
        return result;
    }

    private Set<InternalDistributedMember> sendMessage(DistributionMessage message) throws NotSerializableException {
        Set<InternalDistributedMember> result = null;
        try {
            this.stopper.checkCancelInProgress(null);
            this.waitUntilReadyToSendMsgs(message);
            result = this.sendOutgoing(message);
        }
        catch (NotSerializableException | CancelException | InvalidDeltaException | ToDataException | ReenteredConnectException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.exceptionInThreads = true;
            String receiver = "NULL";
            if (message != null) {
                receiver = message.getRecipientsDescription();
            }
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_WHILE_PUSHING_MESSAGE_0_TO_1, new Object[]{message, receiver}), (Throwable)ex);
            if (message == null || message.forAll()) {
                return null;
            }
            result = new HashSet<InternalDistributedMember>();
            for (int i = 0; i < message.getRecipients().length; ++i) {
                result.add(message.getRecipients()[i]);
            }
            return result;
        }
        return result;
    }

    private Set<InternalDistributedMember> sendViaMembershipManager(InternalDistributedMember[] destinations, DistributionMessage content, ClusterDistributionManager dm, DistributionStats stats) throws NotSerializableException {
        if (this.membershipManager == null) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionChannel_ATTEMPTING_A_SEND_TO_A_DISCONNECTED_DISTRIBUTIONMANAGER));
            if (destinations.length == 1 && destinations[0] == DistributionMessage.ALL_RECIPIENTS) {
                return null;
            }
            HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>();
            Collections.addAll(result, destinations);
            return result;
        }
        return this.membershipManager.send(destinations, content, stats);
    }

    private void scheduleIncomingMessage(DistributionMessage message) {
        this.waitUntilReadyForMessages();
        message.schedule(this);
    }

    @Override
    public boolean isAdam() {
        return this.adam;
    }

    @Override
    public InternalDistributedMember getElderId() throws DistributedSystemDisconnectedException {
        if (this.closeInProgress) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.DistributionManager_NO_VALID_ELDER_WHEN_SYSTEM_IS_SHUTTING_DOWN.toLocalizedString(), this.getRootCause());
        }
        this.getSystem().getCancelCriterion().checkCancelInProgress(null);
        InternalDistributedMember result = this.elder;
        if (result != null && this.membershipManager.memberExists(result)) {
            return result;
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_ELDER__0__IS_NOT_CURRENTLY_AN_ACTIVE_MEMBER_SELECTING_NEW_ELDER, this.elder));
        this.selectElder();
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_NEWLY_SELECTED_ELDER_IS_NOW__0_, this.elder));
        return this.elder;
    }

    @Override
    public boolean isElder() {
        return this.getId().equals(this.elder);
    }

    @Override
    public boolean isLoner() {
        return false;
    }

    @Override
    public ElderState getElderState(boolean force, boolean useTryLock) {
        if (force) {
            if (logger.isDebugEnabled() && !this.localAddress.equals(this.elder)) {
                logger.debug("Forcing myself, {}, to be the elder.", (Object)this.localAddress);
            }
            this.changeElder(this.localAddress);
        }
        if (force || this.localAddress.equals(this.elder)) {
            if (this.elderStateInitialized) {
                return this.elderState;
            }
            return this.getElderStateWithTryLock(useTryLock);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElderState getElderStateWithTryLock(boolean useTryLock) {
        boolean locked = false;
        if (useTryLock) {
            boolean interrupted = Thread.interrupted();
            try {
                locked = this.elderLock.tryLock(2000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.getCancelCriterion().checkCancelInProgress(e);
                locked = this.elderLock.tryLock();
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            locked = true;
            this.elderLock.lock();
        }
        if (!locked) {
            throw new IllegalStateException(LocalizedStrings.DistributionManager_POSSIBLE_DEADLOCK_DETECTED.toLocalizedString());
        }
        try {
            if (this.elderState == null) {
                this.elderState = new ElderState(this);
            }
        }
        finally {
            this.elderLock.unlock();
        }
        this.elderStateInitialized = true;
        return this.elderState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean waitForElder(final InternalDistributedMember desiredElder) {
        boolean bl;
        InternalDistributedMember currentElder;
        MembershipListener l = null;
        try {
            Object object = this.elderMonitor;
            // MONITORENTER : object
            while (true) {
                if (this.closeInProgress) {
                    boolean bl2 = false;
                    // MONITOREXIT : object
                    if (l == null) return bl2;
                    this.removeMembershipListener(l);
                    return bl2;
                }
                currentElder = this.elder;
                if (!desiredElder.equals(currentElder)) break block14;
                bl = true;
                break;
            }
        }
        catch (Throwable throwable) {
            if (l == null) throw throwable;
            this.removeMembershipListener(l);
            throw throwable;
        }
        {
            block14: {
                // MONITOREXIT : object
                if (l == null) return bl;
                this.removeMembershipListener(l);
                return bl;
            }
            if (!this.isCurrentMember(desiredElder)) {
                boolean bl3 = false;
                // MONITOREXIT : object
                if (l == null) return bl3;
                this.removeMembershipListener(l);
                return bl3;
            }
            if (this.localAddress.equals(currentElder)) {
                boolean bl4 = false;
                // MONITOREXIT : object
                if (l == null) return bl4;
                this.removeMembershipListener(l);
                return bl4;
            }
            if (l == null) {
                l = new MembershipListener(){

                    @Override
                    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember theId) {
                    }

                    @Override
                    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember theId, boolean crashed) {
                        if (desiredElder.equals(theId)) {
                            ClusterDistributionManager.this.notifyElderChangeWaiters();
                        }
                    }

                    @Override
                    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
                    }

                    @Override
                    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
                    }
                };
                this.addMembershipListener(l);
            }
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_CHANGING_ELDER_FROM_0_TO_1, new Object[]{currentElder, desiredElder}));
            this.elderChangeWait();
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeElder(InternalDistributedMember newElder) {
        Object object = this.elderMonitor;
        synchronized (object) {
            if (newElder != null && this.localAddress != null && !this.localAddress.equals(newElder) && this.localAddress.equals(this.elder)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("changeElder found this VM to be the elder and is taking an early out");
                }
                return;
            }
            this.elder = newElder;
            if (this.waitingForElderChange) {
                this.waitingForElderChange = false;
                this.elderMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyElderChangeWaiters() {
        Object object = this.elderMonitor;
        synchronized (object) {
            if (this.waitingForElderChange) {
                this.waitingForElderChange = false;
                this.elderMonitor.notifyAll();
            }
        }
    }

    private void elderChangeWait() {
        this.waitingForElderChange = true;
        while (this.waitingForElderChange) {
            this.stopper.checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                this.elderMonitor.wait();
                break;
            }
            catch (InterruptedException ignore) {
                interrupted = true;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    @Override
    public ExecutorService getHighPriorityThreadPool() {
        return this.highPriorityPool;
    }

    @Override
    public ExecutorService getWaitingThreadPool() {
        return this.waitingPool;
    }

    @Override
    public ExecutorService getPrMetaDataCleanupThreadPool() {
        return this.prMetaDataCleanupThreadPool;
    }

    private Executor getPartitionedRegionExcecutor() {
        if (this.partitionedRegionThread != null) {
            return this.partitionedRegionThread;
        }
        return this.partitionedRegionPool;
    }

    @Override
    public Executor getFunctionExecutor() {
        if (this.functionExecutionThread != null) {
            return this.functionExecutionThread;
        }
        return this.functionExecutionPool;
    }

    private Executor getSerialExecutor(InternalDistributedMember sender) {
        if (MULTI_SERIAL_EXECUTORS) {
            return this.serialQueuedExecutorPool.getThrottledSerialExecutor(sender);
        }
        return this.serialThread;
    }

    public OverflowQueueWithDMStats<Runnable> getSerialQueue(InternalDistributedMember sender) {
        if (MULTI_SERIAL_EXECUTORS) {
            return this.serialQueuedExecutorPool.getSerialQueue(sender);
        }
        return this.serialQueue;
    }

    @Override
    public ThreadsMonitoring getThreadMonitoring() {
        return this.threadMonitor;
    }

    public void setAgent(RemoteGfManagerAgent agent) {
        if (agent != null) {
            if (this.agent != null) {
                throw new IllegalStateException(LocalizedStrings.DistributionManager_THERE_IS_ALREADY_AN_ADMIN_AGENT_ASSOCIATED_WITH_THIS_DISTRIBUTION_MANAGER.toLocalizedString());
            }
        } else if (this.agent == null) {
            throw new IllegalStateException(LocalizedStrings.DistributionManager_THERE_WAS_NEVER_AN_ADMIN_AGENT_ASSOCIATED_WITH_THIS_DISTRIBUTION_MANAGER.toLocalizedString());
        }
        this.agent = agent;
    }

    public RemoteGfManagerAgent getAgent() {
        return this.agent;
    }

    public String getDistributionConfigDescription() {
        if (this.agent == null) {
            return null;
        }
        return this.agent.getTransport().toString();
    }

    @Override
    public HealthMonitor getHealthMonitor(InternalDistributedMember owner) {
        return (HealthMonitor)this.hmMap.get(owner);
    }

    @Override
    public void createHealthMonitor(InternalDistributedMember owner, GemFireHealthConfig cfg) {
        if (this.closeInProgress) {
            return;
        }
        HealthMonitor hm = this.getHealthMonitor(owner);
        if (hm != null) {
            hm.stop();
            this.hmMap.remove(owner);
        }
        HealthMonitorImpl newHm = new HealthMonitorImpl(owner, cfg, this);
        newHm.start();
        this.hmMap.put(owner, newHm);
    }

    @Override
    public void removeHealthMonitor(InternalDistributedMember owner, int theId) {
        HealthMonitor hm = this.getHealthMonitor(owner);
        if (hm != null && hm.getId() == theId) {
            hm.stop();
            this.hmMap.remove(owner);
        }
    }

    private void removeAllHealthMonitors() {
        Iterator it = this.hmMap.values().iterator();
        while (it.hasNext()) {
            HealthMonitor hm = (HealthMonitor)it.next();
            hm.stop();
            it.remove();
        }
    }

    @Override
    public Set<InternalDistributedMember> getAdminMemberSet() {
        return this.adminConsoles;
    }

    @Override
    public int getRoleCount(Role role) {
        int count = 0;
        Set<InternalDistributedMember> mbrs = this.getDistributionManagerIds();
        block0: for (InternalDistributedMember mbr : mbrs) {
            Set<Role> roles = mbr.getRoles();
            for (Role mbrRole : roles) {
                if (!mbrRole.equals(role)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    @Override
    public boolean isRolePresent(Role role) {
        Set<InternalDistributedMember> mbrs = this.getDistributionManagerIds();
        for (InternalDistributedMember mbr : mbrs) {
            Set<Role> roles = mbr.getRoles();
            for (Role mbrRole : roles) {
                if (!mbrRole.equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Role> getAllRoles() {
        HashSet<Role> allRoles = new HashSet<Role>();
        Set<InternalDistributedMember> mbrs = this.getDistributionManagerIds();
        for (InternalDistributedMember mbr : mbrs) {
            allRoles.addAll(mbr.getRoles());
        }
        return allRoles;
    }

    @Override
    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    @Override
    public Throwable getRootCause() {
        return this.rootCause;
    }

    @Override
    public void setRootCause(Throwable t) {
        this.rootCause = t;
    }

    @Override
    public Set<InternalDistributedMember> getMembersInThisZone() {
        return this.getMembersInSameZone(this.getDistributionManagerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalDistributedMember> getMembersInSameZone(InternalDistributedMember targetMember) {
        HashSet<InternalDistributedMember> buddyMembers = new HashSet<InternalDistributedMember>();
        if (!this.redundancyZones.isEmpty()) {
            Map<InternalDistributedMember, String> map = this.redundancyZones;
            synchronized (map) {
                String targetZone = this.redundancyZones.get(targetMember);
                for (Map.Entry<InternalDistributedMember, String> entry : this.redundancyZones.entrySet()) {
                    if (!entry.getValue().equals(targetZone)) continue;
                    buddyMembers.add(entry.getKey());
                }
            }
        } else {
            buddyMembers.add(targetMember);
            Set<InetAddress> targetAddrs = this.getEquivalents(targetMember.getInetAddress());
            for (InternalDistributedMember o : this.getDistributionManagerIds()) {
                if (!SetUtils.intersectsWith(targetAddrs, this.getEquivalents(o.getInetAddress()))) continue;
                buddyMembers.add(o);
            }
        }
        return buddyMembers;
    }

    @Override
    public boolean areInSameZone(InternalDistributedMember member1, InternalDistributedMember member2) {
        if (!this.redundancyZones.isEmpty()) {
            String zone1 = this.redundancyZones.get(member1);
            String zone2 = this.redundancyZones.get(member2);
            return zone1 != null && zone1.equals(zone2);
        }
        return this.areOnEquivalentHost(member1, member2);
    }

    @Override
    public void acquireGIIPermitUninterruptibly() {
        this.parallelGIIs.acquireUninterruptibly();
        this.stats.incInitialImageRequestsInProgress(1);
    }

    @Override
    public void releaseGIIPermit() {
        this.stats.incInitialImageRequestsInProgress(-1);
        this.parallelGIIs.release();
    }

    public void setDistributedSystemId(int distributedSystemId) {
        if (distributedSystemId != -1) {
            this.distributedSystemId = distributedSystemId;
        }
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void printStacks(Collection<InternalDistributedMember> ids, boolean useNative) {
        HashSet<InternalDistributedMember> requiresMessage = new HashSet<InternalDistributedMember>();
        if (ids.contains(this.localAddress)) {
            OSProcess.printStacks(0, useNative);
        }
        if (useNative) {
            requiresMessage.addAll(ids);
            ids.remove(this.localAddress);
        } else {
            for (InternalDistributedMember mbr : ids) {
                if (mbr.getProcessId() > 0 && mbr.getInetAddress().equals(this.localAddress.getInetAddress())) {
                    if (mbr.equals(this.localAddress) || OSProcess.printStacks(mbr.getProcessId(), false)) continue;
                    requiresMessage.add(mbr);
                    continue;
                }
                requiresMessage.add(mbr);
            }
        }
        if (requiresMessage.size() > 0) {
            HighPriorityAckedMessage msg = new HighPriorityAckedMessage();
            msg.dumpStacks(requiresMessage, useNative, false);
        }
    }

    @Override
    public Set<DistributedMember> getGroupMembers(String group) {
        HashSet<DistributedMember> result = null;
        for (DistributedMember distributedMember : this.getDistributionManagerIdsIncludingAdmin()) {
            if (!distributedMember.getGroups().contains(group)) continue;
            if (result == null) {
                result = new HashSet<DistributedMember>();
            }
            result.add(distributedMember);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalDistributedMember> getNormalDistributionManagerIds() {
        Object object = this.membersLock;
        synchronized (object) {
            HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>();
            for (InternalDistributedMember m : this.members.keySet()) {
                if (m.getVmKind() == 11) continue;
                result.add(m);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InternalDistributedMember> getLocatorDistributionManagerIds() {
        Object object = this.membersLock;
        synchronized (object) {
            HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>();
            for (InternalDistributedMember m : this.members.keySet()) {
                if (m.getVmKind() != 11) continue;
                result.add(m);
            }
            return result;
        }
    }

    @Override
    public void setCache(InternalCache instance) {
        this.cache = instance;
    }

    @Override
    public InternalCache getCache() {
        return this.cache;
    }

    @Override
    public InternalCache getExistingCache() {
        InternalCache result = this.cache;
        if (result == null) {
            throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString());
        }
        result.getCancelCriterion().checkCancelInProgress(null);
        if (result.isClosed()) {
            throw result.getCacheClosedException(LocalizedStrings.CacheFactory_THE_CACHE_HAS_BEEN_CLOSED.toLocalizedString(), null);
        }
        return result;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    private static class Stopper
    extends CancelCriterion {
        private ClusterDistributionManager dm;

        Stopper(ClusterDistributionManager dm) {
            this.dm = dm;
        }

        @Override
        public String cancelInProgress() {
            this.checkFailure();
            if (this.dm.shutdownMsgSent) {
                return LocalizedStrings.DistributionManager__0_MESSAGE_DISTRIBUTION_HAS_TERMINATED.toLocalizedString(this.dm.toString());
            }
            if (this.dm.rootCause != null) {
                return this.dm.toString() + ": " + this.dm.rootCause.getMessage();
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            Throwable rc = this.dm.rootCause;
            if (rc == null) {
                return new DistributedSystemDisconnectedException(reason, e);
            }
            if (e == null) {
                return new DistributedSystemDisconnectedException(reason, rc);
            }
            Throwable nt = e;
            while (nt.getCause() != null) {
                nt = nt.getCause();
            }
            if (nt == rc) {
                return new DistributedSystemDisconnectedException(reason, e);
            }
            try {
                nt.initCause(rc);
                return new DistributedSystemDisconnectedException(reason, e);
            }
            catch (IllegalStateException e2) {
                return new DistributedSystemDisconnectedException(reason, rc);
            }
        }
    }

    private static class QuorumLostEvent
    extends MemberEvent {
        Set<InternalDistributedMember> failures;
        List<InternalDistributedMember> remaining;

        QuorumLostEvent(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            super(null);
            this.failures = failures;
            this.remaining = remaining;
        }

        public Set<InternalDistributedMember> getFailures() {
            return this.failures;
        }

        public List<InternalDistributedMember> getRemaining() {
            return this.remaining;
        }

        public String toString() {
            return "quorum lost.  failures=" + this.failures + "; remaining=" + this.remaining;
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.quorumLost(manager, this.getFailures(), this.getRemaining());
        }
    }

    private static class ViewInstalledEvent
    extends MemberEvent {
        NetView view;

        ViewInstalledEvent(NetView view) {
            super(null);
            this.view = view;
        }

        public long getViewId() {
            return this.view.getViewId();
        }

        public String toString() {
            return "view installed: " + this.view;
        }

        @Override
        public void handleEvent(ClusterDistributionManager manager) {
            manager.handleViewInstalledEvent(this);
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MemberSuspectEvent
    extends MemberEvent {
        InternalDistributedMember whoSuspected;
        String reason;

        MemberSuspectEvent(InternalDistributedMember suspect, InternalDistributedMember whoSuspected, String reason) {
            super(suspect);
            this.whoSuspected = whoSuspected;
            this.reason = reason;
        }

        public InternalDistributedMember whoSuspected() {
            return this.whoSuspected;
        }

        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "member " + this.getId() + " suspected by: " + this.whoSuspected + " reason: " + this.reason;
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.memberSuspect(manager, this.getId(), this.whoSuspected(), this.reason);
        }
    }

    private static class MemberCrashedEvent
    extends MemberEvent {
        String reason;

        MemberCrashedEvent(InternalDistributedMember id, String r) {
            super(id);
            this.reason = r;
        }

        public String toString() {
            return "member " + this.getId() + " crashed: " + this.reason;
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.memberDeparted(manager, this.getId(), true);
        }
    }

    private static class MemberDepartedEvent
    extends MemberEvent {
        String reason;

        MemberDepartedEvent(InternalDistributedMember id, String r) {
            super(id);
            this.reason = r;
        }

        public String toString() {
            return "member " + this.getId() + " departed (" + this.reason + ")";
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.memberDeparted(manager, this.getId(), false);
        }
    }

    private static class MemberJoinedEvent
    extends MemberEvent {
        MemberJoinedEvent(InternalDistributedMember id) {
            super(id);
        }

        public String toString() {
            return "member " + this.getId() + " joined";
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.memberJoined(manager, this.getId());
        }
    }

    private static abstract class MemberEvent {
        private InternalDistributedMember id;

        MemberEvent(InternalDistributedMember id) {
            this.id = id;
        }

        public InternalDistributedMember getId() {
            return this.id;
        }

        void handleEvent(ClusterDistributionManager manager) {
            this.handleEvent(manager, manager.membershipListeners.keySet());
            this.handleEvent(manager, manager.allMembershipListeners);
        }

        protected abstract void handleEvent(ClusterDistributionManager var1, MembershipListener var2);

        private void handleEvent(ClusterDistributionManager manager, Set<MembershipListener> membershipListeners) {
            for (MembershipListener listener : membershipListeners) {
                try {
                    this.handleEvent(manager, listener);
                }
                catch (CancelException e) {
                    if (manager.isCloseInProgress()) {
                        if (!logger.isTraceEnabled()) break;
                        logger.trace("MemberEventInvoker: cancelled");
                        break;
                    }
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                    break;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_EXCEPTION_WHILE_CALLING_MEMBERSHIP_LISTENER_FOR_EVENT__0, this), t);
                }
            }
        }
    }

    private class DMListener
    implements DistributedMembershipListener {
        ClusterDistributionManager dm;

        public DMListener(ClusterDistributionManager dm) {
            this.dm = dm;
        }

        @Override
        public boolean isShutdownMsgSent() {
            return ClusterDistributionManager.this.shutdownMsgSent;
        }

        @Override
        public void membershipFailure(String reason, Throwable t) {
            ClusterDistributionManager.this.exceptionInThreads = true;
            ClusterDistributionManager.this.rootCause = t;
            ClusterDistributionManager.this.getSystem().disconnect(reason, t, true);
        }

        @Override
        public void messageReceived(DistributionMessage message) {
            ClusterDistributionManager.this.handleIncomingDMsg(message);
        }

        @Override
        public void newMemberConnected(InternalDistributedMember member) {
            this.dm.addNewMember(member);
        }

        @Override
        public void memberDeparted(InternalDistributedMember theId, boolean crashed, String reason) {
            boolean wasAdmin = ClusterDistributionManager.this.getAdminMemberSet().contains(theId);
            if (wasAdmin) {
                AdminConsoleDisconnectMessage message = new AdminConsoleDisconnectMessage();
                message.setSender(theId);
                message.setCrashed(crashed);
                message.setAlertListenerExpected(true);
                message.setIgnoreAlertListenerRemovalFailure(true);
                message.setRecipient(ClusterDistributionManager.this.localAddress);
                message.setReason(reason);
                ClusterDistributionManager.this.handleIncomingDMsg(message);
            }
            this.dm.handleManagerDeparture(theId, crashed, reason);
        }

        @Override
        public void memberSuspect(InternalDistributedMember suspect, InternalDistributedMember whoSuspected, String reason) {
            this.dm.handleManagerSuspect(suspect, whoSuspected, reason);
        }

        @Override
        public void viewInstalled(NetView view) {
            this.processElderSelection();
            this.dm.handleViewInstalled(view);
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            this.dm.handleQuorumLost(failures, remaining);
        }

        @Override
        public ClusterDistributionManager getDM() {
            return this.dm;
        }

        private void processElderSelection() {
            try {
                this.dm.selectElder();
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
            }
        }
    }

    private static class SerialQueuedExecutorPool {
        final ConcurrentMap<Integer, SerialQueuedExecutorWithDMStats> serialQueuedExecutorMap = new ConcurrentHashMap<Integer, SerialQueuedExecutorWithDMStats>(MAX_SERIAL_QUEUE_THREAD);
        final Map<Integer, OverflowQueueWithDMStats<Runnable>> serialQueuedMap = new HashMap<Integer, OverflowQueueWithDMStats<Runnable>>(MAX_SERIAL_QUEUE_THREAD);
        final Map<InternalDistributedMember, Integer> senderToSerialQueueIdMap = new HashMap<InternalDistributedMember, Integer>();
        final ArrayList<Integer> threadMarkedForUse = new ArrayList();
        final DistributionStats stats;
        final ThreadGroup threadGroup;
        final boolean throttlingDisabled;
        final ThreadsMonitoring threadMonitoring;

        SerialQueuedExecutorPool(ThreadGroup group, DistributionStats stats, boolean throttlingDisabled, ThreadsMonitoring tMonitoring) {
            this.threadGroup = group;
            this.stats = stats;
            this.throttlingDisabled = throttlingDisabled;
            this.threadMonitoring = tMonitoring;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer getQueueId(InternalDistributedMember sender, boolean createNew) {
            Integer queueId;
            Map<InternalDistributedMember, Integer> map = this.senderToSerialQueueIdMap;
            synchronized (map) {
                queueId = this.senderToSerialQueueIdMap.get(sender);
                if (!createNew || queueId != null) {
                    return queueId;
                }
                if (!this.threadMarkedForUse.isEmpty()) {
                    queueId = this.threadMarkedForUse.remove(0);
                }
                if (queueId == null) {
                    queueId = (this.serialQueuedExecutorMap.size() + 1) % MAX_SERIAL_QUEUE_THREAD;
                }
                this.senderToSerialQueueIdMap.put(sender, queueId);
            }
            return queueId;
        }

        OverflowQueueWithDMStats<Runnable> getSerialQueue(InternalDistributedMember sender) {
            Integer queueId = this.getQueueId(sender, false);
            if (queueId == null) {
                return null;
            }
            return this.serialQueuedMap.get(queueId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SerialQueuedExecutorWithDMStats getThrottledSerialExecutor(InternalDistributedMember sender) {
            SerialQueuedExecutorWithDMStats executor = this.getSerialExecutor(sender);
            int totalSerialQueueMemSize = this.stats.getSerialQueueBytes();
            if (this.stats.getSerialQueueBytes() > TOTAL_SERIAL_QUEUE_THROTTLE && !DistributionMessage.isPreciousThread()) {
                do {
                    boolean interrupted = Thread.interrupted();
                    try {
                        float throttlePercent = (float)(totalSerialQueueMemSize - TOTAL_SERIAL_QUEUE_THROTTLE) / (float)(TOTAL_SERIAL_QUEUE_BYTE_LIMIT - TOTAL_SERIAL_QUEUE_THROTTLE);
                        int sleep = (int)(100.0 * (double)throttlePercent);
                        sleep = Math.max(sleep, 1);
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.stats.getSerialQueueHelper().incThrottleCount();
                } while (this.stats.getSerialQueueBytes() >= TOTAL_SERIAL_QUEUE_BYTE_LIMIT);
            }
            return executor;
        }

        SerialQueuedExecutorWithDMStats getSerialExecutor(InternalDistributedMember sender) {
            SerialQueuedExecutorWithDMStats executor = null;
            Integer queueId = this.getQueueId(sender, true);
            executor = (SerialQueuedExecutorWithDMStats)this.serialQueuedExecutorMap.get(queueId);
            if (executor != null) {
                return executor;
            }
            executor = this.createSerialExecutor(queueId);
            this.serialQueuedExecutorMap.put(queueId, executor);
            if (logger.isDebugEnabled()) {
                logger.debug("Created Serial Queued Executor With queueId {}. Total number of live Serial Threads :{}", (Object)queueId, (Object)this.serialQueuedExecutorMap.size());
            }
            this.stats.incSerialPooledThread();
            return executor;
        }

        private SerialQueuedExecutorWithDMStats createSerialExecutor(final Integer id) {
            OverflowQueueWithDMStats poolQueue = SERIAL_QUEUE_BYTE_LIMIT == 0 || this.throttlingDisabled ? new OverflowQueueWithDMStats(this.stats.getSerialQueueHelper()) : new ThrottlingMemLinkedQueueWithDMStats(SERIAL_QUEUE_BYTE_LIMIT, SERIAL_QUEUE_THROTTLE, SERIAL_QUEUE_SIZE_LIMIT, SERIAL_QUEUE_SIZE_THROTTLE, this.stats.getSerialQueueHelper());
            this.serialQueuedMap.put(id, poolQueue);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable command) {
                    stats.incSerialPooledThreadStarts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ConnectionTable.threadWantsSharedResources();
                            Connection.makeReaderThread();
                            try {
                                command.run();
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                            }
                        }
                    };
                    Thread thread = new Thread(threadGroup, r, "Pooled Serial Message Processor " + id);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            return new SerialQueuedExecutorWithDMStats(poolQueue, this.stats.getSerialPooledProcessorHelper(), tf, this.threadMonitoring);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMemberDeparture(InternalDistributedMember member) {
            Integer queueId = this.getQueueId(member, false);
            if (queueId == null) {
                return;
            }
            boolean isUsed = false;
            Map<InternalDistributedMember, Integer> map = this.senderToSerialQueueIdMap;
            synchronized (map) {
                this.senderToSerialQueueIdMap.remove(member);
                for (Integer value : this.senderToSerialQueueIdMap.values()) {
                    if (!value.equals(queueId)) continue;
                    isUsed = true;
                    break;
                }
                if (!isUsed) {
                    if (logger.isInfoEnabled(LogMarker.DM_MARKER)) {
                        logger.info(LogMarker.DM_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_MARKING_THE_SERIALQUEUEDEXECUTOR_WITH_ID__0__USED_BY_THE_MEMBER__1__TO_BE_UNUSED, new Object[]{queueId, member}));
                    }
                    this.threadMarkedForUse.add(queueId);
                }
            }
        }

        private void awaitTermination(long time, TimeUnit unit) throws InterruptedException {
            long timeNanos;
            long remainingNanos = timeNanos = unit.toNanos(time);
            long start = System.nanoTime();
            for (ExecutorService executor : this.serialQueuedExecutorMap.values()) {
                executor.awaitTermination(remainingNanos, TimeUnit.NANOSECONDS);
                timeNanos = System.nanoTime() - start;
                remainingNanos = timeNanos;
                if (remainingNanos > 0L) continue;
                return;
            }
        }

        private void shutdown() {
            for (ExecutorService executor : this.serialQueuedExecutorMap.values()) {
                executor.shutdown();
            }
        }
    }

    protected class MemberEventInvoker
    implements Runnable {
        protected MemberEventInvoker() {
        }

        @Override
        public void run() {
            while (true) {
                SystemFailure.checkFailure();
                if (!((ClusterDistributionManager)ClusterDistributionManager.this).system.isConnected && ClusterDistributionManager.this.isClosed()) break;
                try {
                    MemberEvent ev = (MemberEvent)ClusterDistributionManager.this.membershipEventQueue.take();
                    ClusterDistributionManager.this.handleMemberEvent(ev);
                    continue;
                }
                catch (InterruptedException e) {
                    if (ClusterDistributionManager.this.isCloseInProgress()) {
                        if (!logger.isTraceEnabled()) break;
                        logger.trace("MemberEventInvoker: InterruptedException during shutdown");
                        break;
                    }
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_INTERRUPTEDEXCEPTION), (Throwable)e);
                }
                catch (DistributedSystemDisconnectedException e) {
                }
                catch (CancelException e) {
                    if (ClusterDistributionManager.this.isCloseInProgress()) {
                        if (!logger.isTraceEnabled()) break;
                        logger.trace("MemberEventInvoker: cancelled");
                        break;
                    }
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                }
                catch (Exception e) {
                    logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.DistributionManager_UNCAUGHT_EXCEPTION_PROCESSING_MEMBER_EVENT), (Throwable)e);
                    continue;
                }
                break;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("MemberEventInvoker on {} stopped", (Object)ClusterDistributionManager.this);
            }
        }
    }
}

