/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.InvalidValueException;
import org.apache.geode.UnmodifiableException;
import org.apache.geode.distributed.internal.ConfigAttribute;
import org.apache.geode.distributed.internal.ConfigAttributeChecker;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.FlowControlParams;
import org.apache.geode.internal.AbstractConfig;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LogWriterImpl;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.memcached.GemFireMemcachedServer;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDistributionConfig
extends AbstractConfig
implements DistributionConfig {
    private static final Logger logger = LogService.getLogger();
    protected static final Map dcAttDescriptions;
    static final Map<String, Method> checkers;

    protected Object checkAttribute(String attName, Object value) {
        Method checker;
        if (!this.isAttributeModifiable(attName)) {
            throw new UnmodifiableException(this._getUnmodifiableMsg(attName));
        }
        ConfigAttribute attribute = (ConfigAttribute)attributes.get(attName);
        if (attribute == null) {
            return value;
        }
        if (attribute.type().equals(Integer.class)) {
            Integer intValue = (Integer)value;
            this.minMaxCheck(attName, intValue, attribute.min(), attribute.max());
        }
        if ((checker = checkers.get(attName)) == null) {
            return value;
        }
        try {
            return checker.invoke((Object)this, value);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalGemFireException("error invoking " + checker.getName() + " with value " + value);
        }
    }

    protected void minMaxCheck(String propName, int value, int minValue, int maxValue) {
        if (value < minValue) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString(propName, value, minValue));
        }
        if (value > maxValue) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString(propName, value, maxValue));
        }
    }

    @ConfigAttributeChecker(name="start-locator")
    protected String checkStartLocator(String value) {
        if (value != null && value.trim().length() > 0) {
            new DistributionLocatorId(value);
        }
        return value;
    }

    @ConfigAttributeChecker(name="tcp-port")
    protected int checkTcpPort(int value) {
        if (this.getClusterSSLEnabled() && value != 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_MUST_BE_0_WHEN_2_IS_TRUE.toLocalizedString("tcp-port", value, "cluster-ssl-enabled"));
        }
        return value;
    }

    @ConfigAttributeChecker(name="mcast-port")
    protected int checkMcastPort(int value) {
        if (this.getClusterSSLEnabled() && value != 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_MUST_BE_0_WHEN_2_IS_TRUE.toLocalizedString("mcast-port", value, "cluster-ssl-enabled"));
        }
        return value;
    }

    @ConfigAttributeChecker(name="mcast-address")
    protected InetAddress checkMcastAddress(InetAddress value) {
        if (!value.isMulticastAddress()) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_IT_WAS_NOT_A_MULTICAST_ADDRESS.toLocalizedString("mcast-address", value));
        }
        return value;
    }

    @ConfigAttributeChecker(name="bind-address")
    protected String checkBindAddress(String value) {
        if (value != null && value.length() > 0 && !SocketCreator.isLocalHost(value)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_BIND_ADDRESS_0_INVALID_MUST_BE_IN_1.toLocalizedString(value, SocketCreator.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="server-bind-address")
    protected String checkServerBindAddress(String value) {
        if (value != null && value.length() > 0 && !SocketCreator.isLocalHost(value)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_BIND_ADDRESS_0_INVALID_MUST_BE_IN_1.toLocalizedString(value, SocketCreator.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="cluster-ssl-enabled")
    protected Boolean checkClusterSSLEnabled(Boolean value) {
        if (value.booleanValue() && this.getMcastPort() != 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_MUST_BE_FALSE_WHEN_2_IS_NOT_0.toLocalizedString("cluster-ssl-enabled", value, "mcast-port"));
        }
        return value;
    }

    @ConfigAttributeChecker(name="http-service-bind-address")
    protected String checkHttpServiceBindAddress(String value) {
        if (value != null && value.length() > 0 && !SocketCreator.isLocalHost(value)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_BIND_ADDRESS_0_INVALID_MUST_BE_IN_1.toLocalizedString(value, SocketCreator.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="distributed-system-id")
    protected int checkDistributedSystemId(int value) {
        String distributedSystemListener = System.getProperty("gemfire.DistributedSystemListener");
        if (distributedSystemListener == null && value < -1) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("distributed-system-id", value, -1));
        }
        if (value > 255) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("distributed-system-id", value, 255));
        }
        return value;
    }

    @ConfigAttributeChecker(name="locators")
    protected String checkLocators(String value) {
        StringBuffer sb = new StringBuffer();
        HashSet<InetSocketAddress> locs = new HashSet<InetSocketAddress>();
        StringTokenizer st = new StringTokenizer(value, ",");
        boolean firstUniqueLocator = true;
        while (st.hasMoreTokens()) {
            int lastIndex;
            String host;
            String locator = st.nextToken();
            StringBuffer locatorsb = new StringBuffer();
            int portIndex = locator.indexOf(91);
            if (portIndex < 1) {
                portIndex = locator.lastIndexOf(58);
            }
            if (portIndex < 1) {
                throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_INVALID_LOCATOR_0_HOST_NAME_WAS_EMPTY.toLocalizedString(value));
            }
            int bindAddrIdx = locator.lastIndexOf(64, portIndex - 1);
            if (bindAddrIdx < 0) {
                bindAddrIdx = locator.lastIndexOf(58, portIndex - 1);
            }
            if ((host = locator.substring(0, bindAddrIdx > -1 ? bindAddrIdx : portIndex)).indexOf(58) >= 0) {
                bindAddrIdx = locator.lastIndexOf(64);
                host = locator.substring(0, bindAddrIdx > -1 ? bindAddrIdx : portIndex);
            }
            InetAddress hostAddress = null;
            try {
                hostAddress = InetAddress.getByName(host);
            }
            catch (UnknownHostException ex) {
                logger.warn("Unknown locator host: " + host);
            }
            locatorsb.append(host);
            if (bindAddrIdx > -1) {
                String bindAddr = locator.substring(bindAddrIdx + 1, portIndex);
                try {
                    hostAddress = InetAddress.getByName(bindAddr);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_UNKNOWN_LOCATOR_BIND_ADDRESS_0.toLocalizedString(bindAddr));
                }
                if (bindAddr.indexOf(58) >= 0) {
                    locatorsb.append('@');
                } else {
                    locatorsb.append(':');
                }
                locatorsb.append(bindAddr);
            }
            if ((lastIndex = locator.lastIndexOf(93)) == -1) {
                if (locator.indexOf(91) >= 0) {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_INVALID_LOCATOR_0.toLocalizedString(value));
                }
                lastIndex = locator.length();
            }
            String port = locator.substring(portIndex + 1, lastIndex);
            int portVal = 0;
            try {
                portVal = Integer.parseInt(port);
                if (0 == portVal) {
                    return "";
                }
                if (portVal < 1 || portVal > 65535) {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_INVALID_LOCATOR_0_THE_PORT_1_WAS_NOT_GREATER_THAN_ZERO_AND_LESS_THAN_65536.toLocalizedString(value, portVal));
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_INVALID_LOCATOR_0.toLocalizedString(value));
            }
            locatorsb.append('[');
            locatorsb.append(port);
            locatorsb.append(']');
            InetSocketAddress sockAddr = new InetSocketAddress(hostAddress, portVal);
            if (locs.contains(sockAddr)) continue;
            if (!firstUniqueLocator) {
                sb.append(',');
            } else {
                firstUniqueLocator = false;
            }
            locs.add(new InetSocketAddress(hostAddress, portVal));
            sb.append(locatorsb);
        }
        return sb.toString();
    }

    @ConfigAttributeChecker(name="mcast-flow-control")
    protected FlowControlParams checkMcastFlowControl(FlowControlParams params) {
        int value = params.getByteAllowance();
        if (value < 10000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_BYTEALLOWANCE_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("mcast-flow-control", value, 10000));
        }
        float fvalue = params.getRechargeThreshold();
        if (fvalue < 0.1f) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_RECHARGETHRESHOLD_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("mcast-flow-control", new Float(fvalue), new Float(0.1f)));
        }
        if (fvalue > 0.5f) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_RECHARGETHRESHOLD_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("mcast-flow-control", new Float(fvalue), new Float(0.5f)));
        }
        value = params.getRechargeBlockMs();
        if (value < 500) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_RECHARGEBLOCKMS_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("mcast-flow-control", value, 500));
        }
        if (value > 60000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_RECHARGEBLOCKMS_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("mcast-flow-control", value, 60000));
        }
        return params;
    }

    @ConfigAttributeChecker(name="membership-port-range")
    protected int[] checkMembershipPortRange(int[] value) {
        this.minMaxCheck("membership-port-range", value[0], DEFAULT_MEMBERSHIP_PORT_RANGE[0], value[1]);
        this.minMaxCheck("membership-port-range", value[1], value[0], DEFAULT_MEMBERSHIP_PORT_RANGE[1]);
        if (value[1] - value[0] < 2) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("membership-port-range", value[0] + "-" + value[1], 3));
        }
        return value;
    }

    @ConfigAttributeChecker(name="conflate-events")
    protected String checkClientConflation(String value) {
        if (!(value.equals("server") || value.equals("true") || value.equals("false"))) {
            throw new IllegalArgumentException("Could not set \"conflate-events\" to \"" + value + "\" because its value is not recognized");
        }
        return value;
    }

    @ConfigAttributeChecker(name="security-peer-auth-init")
    protected String checkSecurityPeerAuthInit(String value) {
        if (value != null && value.length() > 0 && this.getMcastPort() != 0) {
            String mcastInfo = "mcast-port[" + this.getMcastPort() + "]";
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_2_MUST_BE_0_WHEN_SECURITY_IS_ENABLED.toLocalizedString("security-peer-auth-init", value, mcastInfo));
        }
        return value;
    }

    @ConfigAttributeChecker(name="security-peer-authenticator")
    protected String checkSecurityPeerAuthenticator(String value) {
        if (value != null && value.length() > 0 && this.getMcastPort() != 0) {
            String mcastInfo = "mcast-port[" + this.getMcastPort() + "]";
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_2_MUST_BE_0_WHEN_SECURITY_IS_ENABLED.toLocalizedString("security-peer-authenticator", value, mcastInfo));
        }
        return value;
    }

    @ConfigAttributeChecker(name="security-log-level")
    protected int checkSecurityLogLevel(int value) {
        if (value < Integer.MIN_VALUE) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("security-log-level", LogWriterImpl.levelToString(value), LogWriterImpl.levelToString(Integer.MIN_VALUE)));
        }
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("security-log-level", LogWriterImpl.levelToString(value), LogWriterImpl.levelToString(Integer.MAX_VALUE)));
        }
        return value;
    }

    @ConfigAttributeChecker(name="memcached-protocol")
    protected String checkMemcachedProtocol(String protocol) {
        if (protocol == null || !protocol.equalsIgnoreCase(GemFireMemcachedServer.Protocol.ASCII.name()) && !protocol.equalsIgnoreCase(GemFireMemcachedServer.Protocol.BINARY.name())) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_MEMCACHED_PROTOCOL_MUST_BE_ASCII_OR_BINARY.toLocalizedString());
        }
        return protocol;
    }

    public boolean isMemcachedProtocolModifiable() {
        return false;
    }

    @ConfigAttributeChecker(name="memcached-bind-address")
    protected String checkMemcachedBindAddress(String value) {
        if (value != null && value.length() > 0 && !SocketCreator.isLocalHost(value)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_MEMCACHED_BIND_ADDRESS_0_INVALID_MUST_BE_IN_1.toLocalizedString(value, SocketCreator.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="redis-bind-address")
    protected String checkRedisBindAddress(String value) {
        if (value != null && value.length() > 0 && !SocketCreator.isLocalHost(value)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_REDIS_BIND_ADDRESS_0_INVALID_MUST_BE_IN_1.toLocalizedString(value, SocketCreator.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="ssl-enabled-components")
    protected SecurableCommunicationChannel[] checkLegacySSLWhenSSLEnabledComponentsSet(SecurableCommunicationChannel[] value) {
        block3: for (SecurableCommunicationChannel component : value) {
            switch (component) {
                case ALL: 
                case CLUSTER: 
                case SERVER: 
                case GATEWAY: 
                case JMX: 
                case WEB: 
                case LOCATOR: {
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_SSL_ENABLED_COMPONENTS_0_INVALID_TRY_1.toLocalizedString(new Object[]{value, StringUtils.join((Object[])new String[]{SecurableCommunicationChannel.ALL.getConstant(), SecurableCommunicationChannel.CLUSTER.getConstant(), SecurableCommunicationChannel.SERVER.getConstant(), SecurableCommunicationChannel.GATEWAY.getConstant(), SecurableCommunicationChannel.JMX.getConstant(), SecurableCommunicationChannel.WEB.getConstant(), SecurableCommunicationChannel.LOCATOR.getConstant()}, (String)",")}));
                }
            }
        }
        if (value.length > 0 && (this.getClusterSSLEnabled() || this.getJmxManagerSSLEnabled() || this.getHttpServiceSSLEnabled() || this.getServerSSLEnabled() || this.getGatewaySSLEnabled())) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_SSL_ENABLED_COMPONENTS_SET_INVALID_DEPRECATED_SSL_SET.toLocalizedString());
        }
        return value;
    }

    @Override
    protected void checkAttributeName(String attName) {
        if (!(attName.startsWith("security-") || attName.startsWith("custom-") || attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-"))) {
            super.checkAttributeName(attName);
        }
    }

    public static boolean isWellKnownAttribute(String attName) {
        return Arrays.binarySearch(dcValidAttributeNames, attName) >= 0;
    }

    @Override
    public void setAttributeObject(String attName, Object attValue, ConfigSource source) {
        Method setter;
        Class validValueClass = this.getAttributeType(attName);
        if (attValue != null && !validValueClass.isInstance(attValue)) {
            throw new InvalidValueException(LocalizedStrings.AbstractDistributionConfig_0_VALUE_1_MUST_BE_OF_TYPE_2.toLocalizedString(attName, attValue, validValueClass.getName()));
        }
        if (attName.startsWith("custom-")) {
            return;
        }
        if ((attName.equalsIgnoreCase("log-level") || attName.equalsIgnoreCase("security-log-level")) && attValue instanceof String) {
            attValue = LogLevel.getLogWriterLevel((String)attValue);
        }
        if (attName.startsWith("security-")) {
            this.setSecurity(attName, attValue.toString());
        }
        if (attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-")) {
            this.setSSLProperty(attName, attValue.toString());
        }
        if ((setter = (Method)setters.get(attName)) == null) {
            if (attName.startsWith("security-") || attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-")) {
                this.getAttSourceMap().put(attName, source);
                return;
            }
            throw new InternalGemFireException(LocalizedStrings.AbstractDistributionConfig_UNHANDLED_ATTRIBUTE_NAME_0.toLocalizedString(attName));
        }
        Class<?>[] pTypes = setter.getParameterTypes();
        if (pTypes.length != 1) {
            throw new InternalGemFireException("the attribute setter must have one and only one parametter");
        }
        this.checkAttribute(attName, attValue);
        try {
            setter.invoke((Object)this, attValue);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalGemFireException("error invoking " + setter.getName() + " with " + attValue, e);
        }
        this.getAttSourceMap().put(attName, source);
    }

    @Override
    public Object getAttributeObject(String attName) {
        this.checkAttributeName(attName);
        if (attName.equalsIgnoreCase("log-level")) {
            return LogWriterImpl.levelToString(this.getLogLevel());
        }
        if (attName.equalsIgnoreCase("security-log-level")) {
            return LogWriterImpl.levelToString(this.getSecurityLogLevel());
        }
        Method getter = (Method)getters.get(attName);
        if (getter == null) {
            if (attName.startsWith("security-")) {
                return this.getSecurity(attName);
            }
            throw new InternalGemFireException(LocalizedStrings.AbstractDistributionConfig_UNHANDLED_ATTRIBUTE_NAME_0.toLocalizedString(attName));
        }
        try {
            return getter.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalGemFireException("error invoking " + getter.getName(), e);
        }
    }

    @Override
    public boolean isAttributeModifiable(String attName) {
        this.checkAttributeName(attName);
        if (this.getModifiableAttributes().contains(attName)) {
            return true;
        }
        if (this.getUnModifiableAttributes().contains(attName)) {
            return false;
        }
        return this._modifiableDefault();
    }

    public List<String> getModifiableAttributes() {
        String[] modifiables = new String[]{"http-service-port", "jmx-manager-http-port"};
        return Arrays.asList(modifiables);
    }

    public List<String> getUnModifiableAttributes() {
        return new ArrayList<String>();
    }

    @Override
    public Class getAttributeType(String attName) {
        this.checkAttributeName(attName);
        return AbstractDistributionConfig._getAttributeType(attName);
    }

    public static Class _getAttributeType(String attName) {
        ConfigAttribute ca = (ConfigAttribute)attributes.get(attName);
        if (ca == null) {
            if (attName.startsWith("security-") || attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-")) {
                return String.class;
            }
            throw new InternalGemFireException(LocalizedStrings.AbstractDistributionConfig_UNHANDLED_ATTRIBUTE_NAME_0.toLocalizedString(attName));
        }
        return ca.type();
    }

    public static String[] _getAttNames() {
        return dcValidAttributeNames;
    }

    @Override
    public String[] getAttributeNames() {
        return dcValidAttributeNames;
    }

    @Override
    public String[] getSpecificAttributeNames() {
        return dcValidAttributeNames;
    }

    @Override
    protected Map getAttDescMap() {
        return dcAttDescriptions;
    }

    public static InetAddress _getDefaultMcastAddress() {
        String ipLiteral = "239.192.81.1";
        try {
            return InetAddress.getByName(ipLiteral);
        }
        catch (UnknownHostException ex) {
            throw new Error(LocalizedStrings.AbstractDistributionConfig_UNEXPECTED_PROBLEM_GETTING_INETADDRESS_0.toLocalizedString(ex), ex);
        }
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("ack-wait-threshold", LocalizedStrings.AbstractDistributionConfig_DEFAULT_ACK_WAIT_THRESHOLD_0_1_2.toLocalizedString(15, 1, 1));
        m.put("archive-file-size-limit", LocalizedStrings.AbstractDistributionConfig_ARCHIVE_FILE_SIZE_LIMIT_NAME.toLocalizedString());
        m.put("ack-severe-alert-threshold", LocalizedStrings.AbstractDistributionConfig_ACK_SEVERE_ALERT_THRESHOLD_NAME.toLocalizedString("ack-wait-threshold", 0, 0, Integer.MAX_VALUE));
        m.put("archive-disk-space-limit", LocalizedStrings.AbstractDistributionConfig_ARCHIVE_DISK_SPACE_LIMIT_NAME.toLocalizedString());
        m.put("cache-xml-file", LocalizedStrings.AbstractDistributionConfig_CACHE_XML_FILE_NAME_0.toLocalizedString(DEFAULT_CACHE_XML_FILE));
        m.put("disable-tcp", LocalizedStrings.AbstractDistributionConfig_DISABLE_TCP_NAME_0.toLocalizedString(false));
        m.put("enable-time-statistics", LocalizedStrings.AbstractDistributionConfig_ENABLE_TIME_STATISTICS_NAME.toLocalizedString());
        m.put("deploy-working-dir", LocalizedStrings.AbstractDistributionConfig_DEPLOY_WORKING_DIR_0.toLocalizedString(DEFAULT_DEPLOY_WORKING_DIR));
        m.put("log-file", LocalizedStrings.AbstractDistributionConfig_LOG_FILE_NAME_0.toLocalizedString(DEFAULT_LOG_FILE));
        m.put("log-level", LocalizedStrings.AbstractDistributionConfig_LOG_LEVEL_NAME_0_1.toLocalizedString(LogWriterImpl.levelToString(700), LogWriterImpl.allowedLogLevels()));
        m.put("log-file-size-limit", LocalizedStrings.AbstractDistributionConfig_LOG_FILE_SIZE_LIMIT_NAME.toLocalizedString());
        m.put("log-disk-space-limit", LocalizedStrings.AbstractDistributionConfig_LOG_DISK_SPACE_LIMIT_NAME.toLocalizedString());
        m.put("locators", LocalizedStrings.AbstractDistributionConfig_LOCATORS_NAME_0.toLocalizedString(""));
        m.put("locator-wait-time", LocalizedStrings.AbstractDistributionConfig_LOCATOR_WAIT_TIME_NAME_0.toLocalizedString(0));
        m.put("tcp-port", LocalizedStrings.AbstractDistributionConfig_TCP_PORT_NAME_0_1_2.toLocalizedString(0, 0, 65535));
        m.put("mcast-port", LocalizedStrings.AbstractDistributionConfig_MCAST_PORT_NAME_0_1_2.toLocalizedString(0, 0, 65535));
        m.put("mcast-address", LocalizedStrings.AbstractDistributionConfig_MCAST_ADDRESS_NAME_0_1.toLocalizedString(0, DEFAULT_MCAST_ADDRESS));
        m.put("mcast-ttl", LocalizedStrings.AbstractDistributionConfig_MCAST_TTL_NAME_0_1_2.toLocalizedString(32, 0, 255));
        m.put("mcast-send-buffer-size", LocalizedStrings.AbstractDistributionConfig_MCAST_SEND_BUFFER_SIZE_NAME_0.toLocalizedString(65535));
        m.put("mcast-recv-buffer-size", LocalizedStrings.AbstractDistributionConfig_MCAST_RECV_BUFFER_SIZE_NAME_0.toLocalizedString(0x100000));
        m.put("mcast-flow-control", LocalizedStrings.AbstractDistributionConfig_MCAST_FLOW_CONTROL_NAME_0.toLocalizedString(DEFAULT_MCAST_FLOW_CONTROL));
        m.put("member-timeout", LocalizedStrings.AbstractDistributionConfig_MEMBER_TIMEOUT_NAME_0.toLocalizedString(5000));
        int[] range = DEFAULT_MEMBERSHIP_PORT_RANGE;
        String srange = range == null ? "not available" : "" + range[0] + "-" + range[1];
        String msg = LocalizedStrings.AbstractDistributionConfig_MEMBERSHIP_PORT_RANGE_NAME_0.toLocalizedString(srange);
        m.put("membership-port-range", msg);
        m.put("udp-send-buffer-size", LocalizedStrings.AbstractDistributionConfig_UDP_SEND_BUFFER_SIZE_NAME_0.toLocalizedString(65535));
        m.put("udp-recv-buffer-size", LocalizedStrings.AbstractDistributionConfig_UDP_RECV_BUFFER_SIZE_NAME_0.toLocalizedString(0x100000));
        m.put("udp-fragment-size", LocalizedStrings.AbstractDistributionConfig_UDP_FRAGMENT_SIZE_NAME_0.toLocalizedString(60000));
        m.put("socket-lease-time", LocalizedStrings.AbstractDistributionConfig_SOCKET_LEASE_TIME_NAME_0_1_2.toLocalizedString(60000, 0, 600000));
        m.put("socket-buffer-size", LocalizedStrings.AbstractDistributionConfig_SOCKET_BUFFER_SIZE_NAME_0_1_2.toLocalizedString(32768, 1024, 0xFFFFFF));
        m.put("conserve-sockets", LocalizedStrings.AbstractDistributionConfig_CONSERVE_SOCKETS_NAME_0.toLocalizedString(true));
        m.put("roles", LocalizedStrings.AbstractDistributionConfig_ROLES_NAME_0.toLocalizedString(""));
        m.put("bind-address", LocalizedStrings.AbstractDistributionConfig_BIND_ADDRESS_NAME_0.toLocalizedString(""));
        m.put("server-bind-address", LocalizedStrings.AbstractDistributionConfig_SERVER_BIND_ADDRESS_NAME_0.toLocalizedString(""));
        m.put("name", "A name that uniquely identifies a member in its distributed system. Multiple members in the same distributed system can not have the same name. Defaults to \"\".");
        m.put("statistic-archive-file", LocalizedStrings.AbstractDistributionConfig_STATISTIC_ARCHIVE_FILE_NAME_0.toLocalizedString(DEFAULT_STATISTIC_ARCHIVE_FILE));
        m.put("statistic-sample-rate", LocalizedStrings.AbstractDistributionConfig_STATISTIC_SAMPLE_RATE_NAME_0_1_2.toLocalizedString(1000, 100, 60000));
        m.put("statistic-sampling-enabled", LocalizedStrings.AbstractDistributionConfig_STATISTIC_SAMPLING_ENABLED_NAME_0.toLocalizedString(true));
        m.put("ssl-cluster-alias", LocalizedStrings.AbstractDistributionConfig_CLUSTER_SSL_ALIAS_0.toLocalizedString(Boolean.valueOf("")));
        m.put("cluster-ssl-enabled", LocalizedStrings.AbstractDistributionConfig_SSL_ENABLED_NAME_0.toLocalizedString(false));
        m.put("cluster-ssl-protocols", LocalizedStrings.AbstractDistributionConfig_SSL_PROTOCOLS_NAME_0.toLocalizedString("any"));
        m.put("cluster-ssl-ciphers", LocalizedStrings.AbstractDistributionConfig_SSL_CIPHERS_NAME_0.toLocalizedString("any"));
        m.put("cluster-ssl-require-authentication", LocalizedStrings.AbstractDistributionConfig_SSL_REQUIRE_AUTHENTICATION_NAME.toLocalizedString(true));
        m.put("cluster-ssl-keystore", "Location of the Java keystore file containing an distributed member's own certificate and private key.");
        m.put("cluster-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("cluster-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore.");
        m.put("cluster-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by distributed member (trust store).");
        m.put("cluster-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("max-wait-time-reconnect", LocalizedStrings.AbstractDistributionConfig_MAX_WAIT_TIME_FOR_RECONNECT.toLocalizedString());
        m.put("max-num-reconnect-tries", LocalizedStrings.AbstractDistributionConfig_MAX_NUM_RECONNECT_TRIES.toLocalizedString());
        m.put("async-distribution-timeout", LocalizedStrings.AbstractDistributionConfig_ASYNC_DISTRIBUTION_TIMEOUT_NAME_0_1_2.toLocalizedString(0, 0, 60000));
        m.put("async-queue-timeout", LocalizedStrings.AbstractDistributionConfig_ASYNC_QUEUE_TIMEOUT_NAME_0_1_2.toLocalizedString(60000, 0, 86400000));
        m.put("async-max-queue-size", LocalizedStrings.AbstractDistributionConfig_ASYNC_MAX_QUEUE_SIZE_NAME_0_1_2.toLocalizedString(8, 0, 1024));
        m.put("start-locator", LocalizedStrings.AbstractDistributionConfig_START_LOCATOR_NAME.toLocalizedString());
        m.put("durable-client-id", LocalizedStrings.AbstractDistributionConfig_DURABLE_CLIENT_ID_NAME_0.toLocalizedString(""));
        m.put("conflate-events", LocalizedStrings.AbstractDistributionConfig_CLIENT_CONFLATION_PROP_NAME.toLocalizedString());
        m.put("durable-client-timeout", LocalizedStrings.AbstractDistributionConfig_DURABLE_CLIENT_TIMEOUT_NAME_0.toLocalizedString(300));
        m.put("security-client-auth-init", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_AUTH_INIT_NAME_0.toLocalizedString(""));
        m.put("enable-network-partition-detection", "Whether network partitioning detection is enabled");
        m.put("disable-auto-reconnect", "Whether auto reconnect is attempted after a network partition");
        m.put("security-client-authenticator", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_AUTHENTICATOR_NAME_0.toLocalizedString(""));
        m.put("security-client-dhalgo", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_DHALGO_NAME_0.toLocalizedString(""));
        m.put("security-udp-dhalgo", LocalizedStrings.AbstractDistributionConfig_SECURITY_UDP_DHALGO_NAME_0.toLocalizedString(""));
        m.put("security-peer-auth-init", LocalizedStrings.AbstractDistributionConfig_SECURITY_PEER_AUTH_INIT_NAME_0.toLocalizedString(""));
        m.put("security-peer-authenticator", LocalizedStrings.AbstractDistributionConfig_SECURITY_PEER_AUTHENTICATOR_NAME_0.toLocalizedString(""));
        m.put("security-client-accessor", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_ACCESSOR_NAME_0.toLocalizedString(""));
        m.put("security-client-accessor-pp", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_ACCESSOR_PP_NAME_0.toLocalizedString(""));
        m.put("security-log-level", LocalizedStrings.AbstractDistributionConfig_SECURITY_LOG_LEVEL_NAME_0_1.toLocalizedString(LogWriterImpl.levelToString(700), LogWriterImpl.allowedLogLevels()));
        m.put("security-log-file", LocalizedStrings.AbstractDistributionConfig_SECURITY_LOG_FILE_NAME_0.toLocalizedString(DEFAULT_SECURITY_LOG_FILE));
        m.put("security-peer-verifymember-timeout", LocalizedStrings.AbstractDistributionConfig_SECURITY_PEER_VERIFYMEMBER_TIMEOUT_NAME_0.toLocalizedString(1000));
        m.put("security-", LocalizedStrings.AbstractDistributionConfig_SECURITY_PREFIX_NAME.toLocalizedString());
        m.put("custom-", LocalizedStrings.AbstractDistributionConfig_USERDEFINED_PREFIX_NAME.toLocalizedString());
        m.put("remove-unresponsive-client", LocalizedStrings.AbstractDistributionConfig_REMOVE_UNRESPONSIVE_CLIENT_PROP_NAME_0.toLocalizedString(false));
        m.put("delta-propagation", "Whether delta propagation is enabled");
        m.put("remote-locators", LocalizedStrings.AbstractDistributionConfig_REMOTE_DISTRIBUTED_SYSTEMS_NAME_0.toLocalizedString(""));
        m.put("distributed-system-id", "An id that uniquely idenitifies this distributed system. Required when using portable data exchange objects and the WAN.Must be the same on each member in this distributed system if set.");
        m.put("enforce-unique-host", "Whether to require partitioned regions to put redundant copies of data on different physical machines");
        m.put("redundancy-zone", "The zone that this member is in. When this is set, partitioned regions will not put two copies of the same data in the same zone.");
        m.put("groups", "A comma separated list of all the groups this member belongs to. Defaults to \"\".");
        m.put("user-command-packages", "A comma separated list of the names of the packages containing classes that implement user commands.");
        m.put("jmx-manager", "If true then this member is willing to be a jmx manager. Defaults to false except on a locator.");
        m.put("jmx-manager-start", "If true then the jmx manager will be started when the cache is created. Defaults to false.");
        m.put("jmx-manager-ssl-enabled", "If true then the jmx manager will only allow SSL clients to connect. Defaults to false. This property is ignored if jmx-manager-port is \"0\".");
        m.put("ssl-jmx-alias", LocalizedStrings.AbstractDistributionConfig_JMX_MANAGER_SSL_ALIAS_0.toLocalizedString(Boolean.valueOf("")));
        m.put("jmx-manager-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for JMX Manager. Defaults to \"any\" meaning your provider''s defaults.");
        m.put("jmx-manager-ssl-protocols", "List of available SSL protocols that are to be enabled for JMX Manager. Defaults to \"any\" meaning defaults of your provider.");
        m.put("jmx-manager-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous JMX Clients are allowed. Defaults to \"true\".");
        m.put("jmx-manager-ssl-keystore", "Location of the Java keystore file containing jmx manager's own certificate and private key.");
        m.put("jmx-manager-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("jmx-manager-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore. ");
        m.put("jmx-manager-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by jmx manager.");
        m.put("jmx-manager-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("jmx-manager-port", "The port the jmx manager will listen on. Default is \"1099\". Set to zero to disable GemFire's creation of a jmx listening port.");
        m.put("jmx-manager-bind-address", "The address the jmx manager will listen on for remote connections. Default is \"\" which causes the jmx manager to listen on the host's default address. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-hostname-for-clients", "The hostname that will be given to clients when they ask a locator for the location of this jmx manager. Default is \"\" which causes the locator to report the jmx manager's actual ip address as its location. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-password-file", "The name of the file the jmx manager will use to only allow authenticated clients to connect. Default is \"\" which causes the jmx manager to allow all clients to connect. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-access-file", "The name of the file the jmx manager will use to define the access level of authenticated clients. Default is \"\" which causes the jmx manager to allow all clients all access. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-http-port", "By default when a jmx-manager is started it will also start an http server on this port. This server is used by the GemFire Pulse application. Setting this property to zero disables the http server. It defaults to 8080. Ignored if jmx-manager is false.");
        m.put("jmx-manager-update-rate", "The rate in milliseconds at which this member will send updates to each jmx manager. Default is 2000. Values must be in the range 1000..300000.");
        m.put("ssl-locator-alias", LocalizedStrings.AbstractDistributionConfig_LOCATOR_SSL_ALIAS_0.toLocalizedString(Boolean.valueOf("")));
        m.put("memcached-port", "The port GemFireMemcachedServer will listen on. Default is 0. Set to zero to disable GemFireMemcachedServer.");
        m.put("memcached-protocol", "The protocol that GemFireMemcachedServer understands. Default is ASCII. Values may be ASCII or BINARY");
        m.put("memcached-bind-address", "The address the GemFireMemcachedServer will listen on for remote connections. Default is \"\" which causes the GemFireMemcachedServer to listen on the host's default address. This property is ignored if memcached-port is \"0\".");
        m.put("redis-port", "The port GeodeRedisServer will listen on. Default is 0. Set to zero to disable GeodeRedisServer.");
        m.put("redis-bind-address", "The address the GeodeRedisServer will listen on for remote connections. Default is \"\" which causes the GeodeRedisServer to listen on the host's default address. This property is ignored if redis-port is \"0\".");
        m.put("redis-password", "The password which client of GeodeRedisServer must use to authenticate themselves. The default is none and no authentication will be required.");
        m.put("enable-cluster-configuration", LocalizedStrings.AbstractDistributionConfig_ENABLE_SHARED_CONFIGURATION.toLocalizedString());
        m.put("use-cluster-configuration", LocalizedStrings.AbstractDistributionConfig_USE_SHARED_CONFIGURATION.toLocalizedString());
        m.put("load-cluster-configuration-from-dir", LocalizedStrings.AbstractDistributionConfig_LOAD_SHARED_CONFIGURATION_FROM_DIR.toLocalizedString("cluster_config"));
        m.put("cluster-configuration-dir", LocalizedStrings.AbstractDistributionConfig_CLUSTER_CONFIGURATION_DIR.toLocalizedString());
        m.put("ssl-server-alias", LocalizedStrings.AbstractDistributionConfig_SERVER_SSL_ALIAS_0.toLocalizedString(Boolean.valueOf("")));
        m.put("server-ssl-enabled", "If true then the cache server will only allow SSL clients to connect. Defaults to false.");
        m.put("server-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for CacheServer. Defaults to \"any\" meaning your provider''s defaults.");
        m.put("server-ssl-protocols", "List of available SSL protocols that are to be enabled for CacheServer. Defaults to \"any\" meaning defaults of your provider.");
        m.put("server-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous Clients are allowed. Defaults to \"true\".");
        m.put("server-ssl-keystore", "Location of the Java keystore file containing server's or client's own certificate and private key.");
        m.put("server-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("server-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore. ");
        m.put("server-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by server or client(trust store).");
        m.put("server-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("ssl-gateway-alias", LocalizedStrings.AbstractDistributionConfig_GATEWAY_SSL_ALIAS_0.toLocalizedString(Boolean.valueOf("")));
        m.put("gateway-ssl-enabled", "If true then the gateway receiver will only allow SSL gateway sender to connect. Defaults to false.");
        m.put("gateway-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for Gateway Receiver. Defaults to \"any\" meaning your provider''s defaults.");
        m.put("gateway-ssl-protocols", "List of available SSL protocols that are to be enabled for Gateway Receiver. Defaults to \"any\" meaning defaults of your provider.");
        m.put("gateway-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous gateway senders are allowed. Defaults to \"true\".");
        m.put("gateway-ssl-keystore", "Location of the Java keystore file containing gateway's own certificate and private key.");
        m.put("gateway-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("gateway-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore.");
        m.put("gateway-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by gateway.");
        m.put("gateway-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("ssl-web-alias", LocalizedStrings.AbstractDistributionConfig_HTTP_SERVICE_SSL_ALIAS_0.toLocalizedString(Boolean.valueOf("")));
        m.put("http-service-port", "If non zero, then the gemfire developer REST service will be deployed and started when the cache is created. Default value is 0.");
        m.put("http-service-bind-address", "The address where gemfire developer REST service will listen for remote REST connections. Default is \"\" which causes the Rest service to listen on the host's default address.");
        m.put("http-service-ssl-enabled", "If true then the http service like REST dev api and Pulse will only allow SSL enabled clients to connect. Defaults to false.");
        m.put("http-service-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for Http Service. Defaults to \"any\" meaning your provider''s defaults.");
        m.put("http-service-ssl-protocols", "List of available SSL protocols that are to be enabled for Http Service. Defaults to \"any\" meaning defaults of your provider.");
        m.put("http-service-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous http clients are allowed. Defaults to \"false\".");
        m.put("http-service-ssl-keystore", "Location of the Java keystore file containing Http Service's own certificate and private key.");
        m.put("http-service-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("http-service-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore.");
        m.put("http-service-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by Http Service.");
        m.put("http-service-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("start-dev-rest-api", "If true then the developer(API) REST service will be started when the cache is created. Defaults to false.");
        m.put("off-heap-memory-size", LocalizedStrings.AbstractDistributionConfig_OFF_HEAP_MEMORY_SIZE_0.toLocalizedString(""));
        m.put("lock-memory", LocalizedStrings.AbstractDistributionConfig_LOCK_MEMORY.toLocalizedString(false));
        m.put("distributed-transactions", "Flag to indicate whether all transactions including JTA should be distributed transactions.  Default is false, meaning colocated transactions.");
        m.put("security-shiro-init", "The name of the shiro configuration file in the classpath, e.g. shiro.ini");
        m.put("security-manager", "User defined fully qualified class name implementing SecurityManager interface for integrated security. Defaults to \"{0}\". Legal values can be any \"class name\" implementing SecurityManager that is present in the classpath.");
        m.put("security-post-processor", "User defined fully qualified class name implementing PostProcessor interface for integrated security. Defaults to \"{0}\". Legal values can be any \"class name\" implementing PostProcessor that is present in the classpath.");
        m.put("ssl-endpoint-identification-enabled", "If true, clients validate server hostname using server certificate during SSL handshake.");
        m.put("ssl-enabled-components", "A comma delimited list of components that require SSL communications");
        m.put("ssl-ciphers", "List of available SSL cipher suites that are to be enabled. Defaults to \"any\" meaning your provider''s defaults.");
        m.put("ssl-protocols", "List of available SSL protocols that are to be enabled. Defaults to \"any\" meaning defaults of your provider.");
        m.put("ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous clients are allowed. Defaults to \"true\".");
        m.put("ssl-keystore", "Location of the Java keystore file containing the certificate and private key.");
        m.put("ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("ssl-keystore-password", "Password to access the private key from the keystore.");
        m.put("ssl-truststore", "Location of the Java keystore file containing the collection of trusted certificates.");
        m.put("ssl-truststore-password", "Password to unlock the truststore.");
        m.put("ssl-truststore-type", "For Java truststore file format, this property has the value jks (or JKS).");
        m.put("ssl-default-alias", "The default certificate alias to be used in a multi-key keystore");
        m.put("ssl-web-require-authentication", "This property determines is the HTTP service with use mutual ssl authentication.");
        m.put("validate-serializable-objects", "If true checks incoming java serializable objects against a filter");
        m.put("serializable-object-filter", "The filter to check incoming java serializables against");
        m.put("thread-monitor-interval-ms", LocalizedStrings.AbstractDistributionConfig_THREAD_MONITOR_INTERVAL.toLocalizedString());
        m.put("thread-monitor-enabled", LocalizedStrings.AbstractDistributionConfig_THREAD_MONITOR_ENABLED.toLocalizedString());
        m.put("thread-monitor-time-limit-ms", LocalizedStrings.AbstractDistributionConfig_THREAD_MONITOR_TIME_LIMIT.toLocalizedString());
        dcAttDescriptions = Collections.unmodifiableMap(m);
        checkers = new HashMap<String, Method>();
        for (Method method : AbstractDistributionConfig.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ConfigAttributeChecker.class)) continue;
            ConfigAttributeChecker checker = method.getAnnotation(ConfigAttributeChecker.class);
            checkers.put(checker.name(), method);
        }
    }
}

