/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.MapType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;

public class MapTypeImpl
extends CollectionTypeImpl
implements MapType {
    private static final long serialVersionUID = -705688605389537058L;
    private ObjectType keyType;

    public MapTypeImpl() {
    }

    public MapTypeImpl(Class clazz, ObjectType keyType, ObjectType valueType) {
        super(clazz, valueType);
        this.keyType = keyType;
    }

    public MapTypeImpl(String className, ObjectType keyType, ObjectType valueType) throws ClassNotFoundException {
        super(className, valueType);
        this.keyType = keyType;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof MapTypeImpl && this.keyType.equals(((MapTypeImpl)obj).keyType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.keyType.hashCode();
    }

    @Override
    public String toString() {
        return this.resolveClass().getName() + "<key:" + this.keyType.resolveClass().getName() + ",value:" + this.getElementType().resolveClass().getName() + ">";
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public ObjectType getKeyType() {
        return this.keyType;
    }

    @Override
    public StructType getEntryType() {
        ObjectType[] fieldTypes = new ObjectType[]{this.keyType, this.getElementType()};
        return new StructTypeImpl(new String[]{"key", "value"}, fieldTypes);
    }

    @Override
    public int getDSFID() {
        return -55;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.keyType = (ObjectType)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.keyType, out);
    }
}

