/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.StructBag;
import org.apache.geode.cache.query.internal.StructFields;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class StructSet
implements Set,
SelectResults,
DataSerializableFixedID,
StructFields {
    private static final long serialVersionUID = -1228835506930611510L;
    protected StructType structType;
    private boolean modifiable = true;
    private ObjectOpenCustomHashSet contents;

    public StructSet() {
    }

    public StructSet(StructType structType) {
        this.contents = new ObjectOpenCustomHashSet((Hash.Strategy)new ObjectArrayHashingStrategy());
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    public StructSet(Collection c, StructType structType) {
        this.contents = new ObjectOpenCustomHashSet(c, (Hash.Strategy)new ObjectArrayHashingStrategy());
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    StructSet(StructBag bag) {
        this.contents = new ObjectOpenCustomHashSet((Hash.Strategy)new ObjectArrayHashingStrategy());
        this.structType = (StructType)bag.elementType;
        if (bag.hasLimitIterator) {
            Iterator itr = bag.fieldValuesIterator();
            while (itr.hasNext()) {
                this.addFieldValues((Object[])itr.next());
            }
        } else {
            Set<Object> keys = bag.map.keySet();
            for (Object key : keys) {
                this.addFieldValues((Object[])key);
            }
        }
    }

    public StructSet(int initialCapacity, StructType structType) {
        this.contents = new ObjectOpenCustomHashSet(initialCapacity, (Hash.Strategy)new ObjectArrayHashingStrategy());
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    public StructSet(int initialCapacity, float loadFactor, StructType structType) {
        this.contents = new ObjectOpenCustomHashSet(initialCapacity, loadFactor, (Hash.Strategy)new ObjectArrayHashingStrategy());
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof StructSet)) {
            return false;
        }
        if (!this.structType.equals(((StructSet)other).structType)) {
            return false;
        }
        if (other.getClass() == StructSet.class) {
            return this.contents.equals((Object)((StructSet)other).contents);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.structType.hashCode();
    }

    @Override
    public boolean add(Object obj) {
        if (!(obj instanceof StructImpl)) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_THIS_SET_ONLY_ACCEPTS_STRUCTIMPL.toLocalizedString());
        }
        StructImpl s = (StructImpl)obj;
        if (!s.getStructType().equals(this.structType)) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_OBJ_DOES_NOT_HAVE_THE_SAME_STRUCTTYPE_REQUIRED_0_ACTUAL_1.toLocalizedString(this.structType, s.getStructType()));
        }
        return this.addFieldValues(s.getFieldValues());
    }

    @Override
    public boolean addFieldValues(Object[] fieldValues) {
        return this.contents.add((Object)fieldValues);
    }

    @Override
    public boolean contains(Object obj) {
        if (!(obj instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)obj;
        if (!this.structType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.containsFieldValues(s.getFieldValues());
    }

    @Override
    public boolean containsFieldValues(Object[] fieldValues) {
        return this.contents.contains((Object)fieldValues);
    }

    public boolean removeEntry(Object o) {
        if (!(o instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)o;
        if (!this.structType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.removeFieldValues(s.getFieldValues());
    }

    @Override
    public boolean removeFieldValues(Object[] fieldValues) {
        return this.contents.remove((Object)fieldValues);
    }

    @Override
    public boolean addAll(Collection c) {
        if (c instanceof StructSet) {
            return this.addAll((StructSet)c);
        }
        boolean modified = false;
        for (Object o : c) {
            modified |= this.add(o);
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c instanceof StructSet) {
            return this.removeAll((StructSet)c);
        }
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection c) {
        if (c instanceof StructSet) {
            return this.retainAll((StructSet)c);
        }
        return this.contents.retainAll(c);
    }

    public boolean addAll(StructSet ss) {
        boolean modified = false;
        if (!this.structType.equals(ss.structType)) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_TYPES_DONT_MATCH.toLocalizedString());
        }
        Iterator itr = ss.fieldValuesIterator();
        while (itr.hasNext()) {
            Object[] vals = (Object[])itr.next();
            if (!this.contents.add((Object)vals)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(StructSet ss) {
        boolean modified = false;
        if (!this.structType.equals(ss.structType)) {
            return false;
        }
        Iterator itr = ss.fieldValuesIterator();
        while (itr.hasNext()) {
            Object[] vals = (Object[])itr.next();
            if (!this.contents.remove((Object)vals)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(StructSet ss) {
        if (!this.structType.equals(ss.structType)) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        boolean changed = false;
        int size = this.size();
        Iterator it = this.fieldValuesIterator();
        while (size-- > 0) {
            Object[] vals = (Object[])it.next();
            if (ss.containsFieldValues(vals)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    public ObjectIterator iterator() {
        return new StructIterator(this.fieldValuesIterator());
    }

    @Override
    public Iterator fieldValuesIterator() {
        return this.contents.iterator();
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(StructSet.class, (ObjectType)this.structType);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (!(elementType instanceof StructTypeImpl)) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_ELEMENT_TYPE_MUST_BE_STRUCT.toLocalizedString());
        }
        this.structType = (StructType)elementType;
    }

    public List asList() {
        return new ArrayList(this);
    }

    public Set asSet() {
        return this;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public int occurrences(Object element) {
        return this.contains(element) ? 1 : 0;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        ObjectIterator i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object o = i.next();
            buf.append(o == this ? "(this Collection)" : String.valueOf(o));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public int getDSFID() {
        return 33;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.contents = new ObjectOpenCustomHashSet((Hash.Strategy)new ObjectArrayHashingStrategy());
        int size = in.readInt();
        this.structType = (StructTypeImpl)DataSerializer.readObject(in);
        for (int j = size; j > 0; --j) {
            this.add(DataSerializer.readObject(in));
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.size());
        DataSerializer.writeObject(this.structType, out);
        ObjectIterator i = this.iterator();
        while (i.hasNext()) {
            DataSerializer.writeObject(i.next(), out);
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public Object[] toArray() {
        Object[] structs = new Struct[this.contents.size()];
        int i = 0;
        ObjectIterator iter = this.iterator();
        while (iter.hasNext()) {
            structs[i++] = (Struct)iter.next();
        }
        return structs;
    }

    @Override
    public Object[] toArray(Object[] a) {
        Object[] array = this.contents.toArray(a);
        int i = 0;
        for (Object o : array) {
            array[i++] = new StructImpl((StructTypeImpl)this.structType, (Object[])o);
        }
        return array;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Struct) {
            o = ((Struct)o).getFieldValues();
        }
        return this.contents.remove((Object)o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.contents.containsAll(c);
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    private class StructIterator
    extends AbstractObjectIterator {
        private final Iterator itr;

        StructIterator(Iterator itr) {
            this.itr = itr;
        }

        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            return new StructImpl((StructTypeImpl)StructSet.this.structType, (Object[])this.itr.next());
        }

        public void remove() {
            this.itr.remove();
        }
    }

    protected static class ObjectArrayHashingStrategy
    implements Hash.Strategy {
        private static final long serialVersionUID = -6407549977968716071L;

        protected ObjectArrayHashingStrategy() {
        }

        public int hashCode(Object o) {
            Object[] oa = (Object[])o;
            int h = 0;
            for (int i = 0; i < oa.length; ++i) {
                Object obj = oa[i];
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (!(o1 instanceof Object[]) || !(o2 instanceof Object[])) {
                return o1.equals(o2);
            }
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
    }
}

